/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestNode;
import org.springframework.data.neo4j.rest.RestRelationship;
import org.springframework.data.neo4j.rest.SimplePath;

public class RestPathParser {
    public static Path parse(Map path, final RestGraphDatabase restGraphDatabase) {
        Collection nodesData = (Collection)path.get("nodes");
        Collection relationshipsData = (Collection)path.get("relationships");
        Map<?, ?> lastRelationshipData = RestPathParser.lastElement(relationshipsData);
        Map startData = (Map)path.get("start");
        Map endData = (Map)path.get("end");
        Integer length = (Integer)path.get("length");
        return new SimplePath(new RestNode(startData, restGraphDatabase), new RestNode(endData, restGraphDatabase), new RestRelationship(lastRelationshipData, restGraphDatabase), length, (Iterable<Node>)new IterableWrapper<Node, Map<?, ?>>(nodesData){

            protected Node underlyingObjectToObject(Map<?, ?> data) {
                return new RestNode(data, restGraphDatabase);
            }
        }, (Iterable<Relationship>)new IterableWrapper<Relationship, Map<?, ?>>(relationshipsData){

            protected Relationship underlyingObjectToObject(Map<?, ?> data) {
                return new RestRelationship(data, restGraphDatabase);
            }
        });
    }

    private static Map<?, ?> lastElement(Collection<Map<?, ?>> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (Map)list.get(list.size() - 1);
        }
        Map<?, ?> result = null;
        Iterator<Map<?, ?>> i$ = collection.iterator();
        while (i$.hasNext()) {
            Map<?, ?> value;
            result = value = i$.next();
        }
        return result;
    }
}

