/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestEntity;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestNode;
import org.springframework.data.neo4j.rest.RestRequest;

public class RestRelationship
extends RestEntity
implements Relationship {
    RestRelationship(URI uri, RestGraphDatabase graphDatabaseService) {
        super(uri, graphDatabaseService);
    }

    RestRelationship(String uri, RestGraphDatabase graphDatabase) {
        super(uri, graphDatabase);
    }

    public RestRelationship(Map<?, ?> data, RestGraphDatabase graphDatabase) {
        super(data, graphDatabase);
    }

    public Node getEndNode() {
        return this.node((String)this.getStructuralData().get("end"));
    }

    public Node[] getNodes() {
        return new Node[]{this.node((String)this.getStructuralData().get("start")), this.node((String)this.getStructuralData().get("end"))};
    }

    public Node getOtherNode(Node node) {
        long nodeId = node.getId();
        String startNodeUri = (String)this.getStructuralData().get("start");
        String endNodeUri = (String)this.getStructuralData().get("end");
        if (RestRelationship.getEntityId(startNodeUri) == nodeId) {
            return this.node(endNodeUri);
        }
        if (RestRelationship.getEntityId(endNodeUri) == nodeId) {
            return this.node(startNodeUri);
        }
        throw new NotFoundException(node + " isn't one of start/end for " + this);
    }

    private RestNode node(String uri) {
        return new RestNode(uri, this.getRestGraphDatabase());
    }

    public Node getStartNode() {
        return this.node((String)this.getStructuralData().get("start"));
    }

    public RelationshipType getType() {
        return DynamicRelationshipType.withName((String)((String)this.getStructuralData().get("type")));
    }

    public boolean isType(RelationshipType type) {
        return type.name().equals(this.getStructuralData().get("type"));
    }

    public static Relationship create(RestNode startNode, RestNode endNode, RelationshipType type, Map<String, Object> props) {
        RequestResult requestResult;
        RestRequest restRequest = startNode.getRestRequest();
        Map data = MapUtil.map((Object[])new Object[]{"to", endNode.getUri(), "type", type.name()});
        if (props != null && props.size() > 0) {
            data.put("data", props);
        }
        if (restRequest.statusOtherThan(requestResult = restRequest.post("relationships", JsonHelper.createJsonFrom(data)), (Response.StatusType)Response.Status.CREATED)) {
            int status = requestResult.getStatus();
            throw new RuntimeException("" + status);
        }
        URI location = requestResult.getLocation();
        return new RestRelationship(location, startNode.getRestGraphDatabase());
    }
}

