/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.RequestResult;

public class RestRequest {
    public static final int CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    public static final int READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    private final URI baseUri;
    private final Client client;

    public RestRequest(URI baseUri) {
        this(baseUri, null, null);
    }

    public RestRequest(URI baseUri, String username, String password) {
        this.baseUri = this.uriWithoutSlash(baseUri);
        this.client = this.createClient();
        this.addAuthFilter(username, password);
    }

    private void addAuthFilter(String username, String password) {
        if (username == null) {
            return;
        }
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
    }

    private Client createClient() {
        Client client = Client.create();
        client.setConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        client.setReadTimeout(Integer.valueOf(READ_TIMEOUT));
        return client;
    }

    private RestRequest(URI uri, Client client) {
        this.baseUri = this.uriWithoutSlash(uri);
        this.client = client;
    }

    private URI uriWithoutSlash(URI uri) {
        String uriString = uri.toString();
        return uriString.endsWith("/") ? this.uri(uriString.substring(0, uriString.length() - 1)) : uri;
    }

    public static String encode(Object value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value.toString(), "utf-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private WebResource.Builder builder(String path) {
        WebResource resource = this.client.resource(this.uri(this.pathOrAbsolute(path)));
        return resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    private String pathOrAbsolute(String path) {
        if (path.startsWith("http://")) {
            return path;
        }
        return this.baseUri + "/" + path;
    }

    public RequestResult get(String path) {
        return RequestResult.extractFrom((ClientResponse)this.builder(path).get(ClientResponse.class));
    }

    public RequestResult get(String path, String data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)data, MediaType.APPLICATION_JSON_TYPE);
        }
        return RequestResult.extractFrom((ClientResponse)builder.get(ClientResponse.class));
    }

    public RequestResult delete(String path) {
        return RequestResult.extractFrom((ClientResponse)this.builder(path).delete(ClientResponse.class));
    }

    public RequestResult post(String path, String data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)data, MediaType.APPLICATION_JSON_TYPE);
        }
        return RequestResult.extractFrom((ClientResponse)builder.post(ClientResponse.class));
    }

    public void put(String path, String data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)data, MediaType.APPLICATION_JSON_TYPE);
        }
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class);
        response.close();
    }

    public Object toEntity(RequestResult requestResult) {
        return JsonHelper.jsonToSingleValue(this.entityString(requestResult));
    }

    public Map<?, ?> toMap(RequestResult requestResult) {
        String json = this.entityString(requestResult);
        return JsonHelper.jsonToMap(json);
    }

    private String entityString(RequestResult requestResult) {
        return requestResult.getEntity();
    }

    public boolean statusIs(RequestResult requestResult, Response.StatusType status) {
        return requestResult.getStatus() == status.getStatusCode();
    }

    public boolean statusOtherThan(RequestResult requestResult, Response.StatusType status) {
        return !this.statusIs(requestResult, status);
    }

    public RestRequest with(String uri) {
        return new RestRequest(this.uri(uri), this.client);
    }

    private URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getUri() {
        return this.baseUri;
    }
}

