/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestNode;
import org.springframework.data.neo4j.rest.RestRequest;
import org.springframework.data.neo4j.rest.RestTraversalDescription;
import org.springframework.data.neo4j.rest.RestTraverser;

public class RestTraversal
implements RestTraversalDescription {
    private static final String FULLPATH = "fullpath";
    private final Map<String, Object> description = new HashMap<String, Object>();

    public String toString() {
        return this.description.toString();
    }

    @Override
    public RestTraversalDescription uniqueness(UniquenessFactory uniquenessFactory) {
        return this.uniqueness(uniquenessFactory, null);
    }

    @Override
    public RestTraversalDescription uniqueness(UniquenessFactory uniquenessFactory, Object value) {
        String uniqueness = this.restify(uniquenessFactory);
        this.add("uniqueness", value == null ? uniqueness : this.toMap("name", uniqueness, "value", value));
        return null;
    }

    private String restify(UniquenessFactory uniquenessFactory) {
        if (uniquenessFactory instanceof Uniqueness) {
            return ((Uniqueness)uniquenessFactory).name().toLowerCase().replace("_", " ");
        }
        throw new UnsupportedOperationException("Only values of " + Uniqueness.class + " are supported");
    }

    @Override
    public RestTraversalDescription prune(PruneEvaluator pruneEvaluator) {
        if (pruneEvaluator == PruneEvaluator.NONE) {
            return this.add("prune_evaluator", this.toMap("language", "builtin", "name", "none"));
        }
        Integer maxDepth = this.getMaxDepthValueOrNull(pruneEvaluator);
        if (maxDepth != null) {
            return this.maxDepth(maxDepth);
        }
        throw new UnsupportedOperationException("Only max depth supported");
    }

    private Integer getMaxDepthValueOrNull(PruneEvaluator pruneEvaluator) {
        try {
            Field depthField = pruneEvaluator.getClass().getDeclaredField("val$depth");
            depthField.setAccessible(true);
            return (Integer)depthField.get(pruneEvaluator);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public RestTraversalDescription filter(Predicate<Path> pathPredicate) {
        if (pathPredicate == Traversal.returnAll()) {
            return this.add("return_filter", this.toMap("language", "builtin", "name", "all"));
        }
        if (pathPredicate == Traversal.returnAllButStartNode()) {
            return this.add("return_filter", this.toMap("language", "builtin", "name", "all but start node"));
        }
        throw new UnsupportedOperationException("Only builtin paths supported");
    }

    @Override
    public RestTraversalDescription evaluator(Evaluator evaluator) {
        throw new UnsupportedOperationException("Evaluators not yet supported");
    }

    @Override
    public RestTraversalDescription prune(RestTraversalDescription.ScriptLanguage language, String code) {
        return this.add("prune_evaluator", this.toMap("language", language.name().toLowerCase(), "body", code));
    }

    @Override
    public RestTraversalDescription filter(RestTraversalDescription.ScriptLanguage language, String code) {
        return this.add("return_filter", this.toMap("language", language.name().toLowerCase(), "body", code));
    }

    @Override
    public RestTraversalDescription maxDepth(int depth) {
        return this.add("max_depth", depth);
    }

    @Override
    public RestTraversalDescription order(BranchOrderingPolicy branchOrderingPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestTraversalDescription depthFirst() {
        return this.add("order", "depth_first");
    }

    @Override
    public RestTraversalDescription breadthFirst() {
        return this.add("order", "breadth_first");
    }

    private RestTraversalDescription add(String key, Object value) {
        this.description.put(key, value);
        return this;
    }

    @Override
    public RestTraversalDescription relationships(RelationshipType relationshipType) {
        return this.relationships(relationshipType, null);
    }

    @Override
    public RestTraversalDescription relationships(RelationshipType relationshipType, Direction direction) {
        if (!this.description.containsKey("relationships")) {
            this.description.put("relationships", new HashSet());
        }
        Set relationships = (Set)this.description.get("relationships");
        relationships.add(this.toMap("type", relationshipType, "direction", this.directionString(direction)));
        return this;
    }

    private Map<String, Object> toMap(Object ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("toMap needs an even number of arguments, but was " + Arrays.toString(params));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < params.length; i += 2) {
            if (params[i + 1] == null) continue;
            result.put(params[i].toString(), params[i + 1].toString());
        }
        return result;
    }

    private String directionString(Direction direction) {
        switch (direction) {
            case INCOMING: {
                return "in";
            }
            case OUTGOING: {
                return "out";
            }
        }
        return null;
    }

    @Override
    public RestTraversalDescription expand(RelationshipExpander relationshipExpander) {
        return null;
    }

    @Override
    public RestTraverser traverse(Node node) {
        String traversalJson;
        RequestResult requestResult;
        RestNode restNode = (RestNode)node;
        RestRequest request = restNode.getRestRequest();
        if (request.statusOtherThan(requestResult = request.post("traverse/fullpath", traversalJson = JsonHelper.createJsonFrom(this.description)), (Response.StatusType)Response.Status.OK)) {
            throw new RuntimeException(String.format("Error executing traversal: %d %s", requestResult.getStatus(), traversalJson));
        }
        Object col = request.toEntity(requestResult);
        if (!(col instanceof Collection)) {
            throw new RuntimeException(String.format("Unexpected traversal response, %s instead of collection", col != null ? col.getClass() : null));
        }
        return new RestTraverser((Collection)col, restNode.getRestGraphDatabase());
    }

    public static RestTraversalDescription description() {
        return new RestTraversal();
    }

    public Map<String, Object> getPostData() {
        return this.description;
    }
}

