/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestEntity;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestRequest;

public abstract class RestIndex<T extends PropertyContainer>
implements Index<T> {
    protected final RestRequest restRequest;
    private final String indexName;
    protected final RestGraphDatabase restGraphDatabase;

    RestIndex(RestRequest restRequest, String indexName, RestGraphDatabase restGraphDatabase) {
        this.restRequest = restRequest;
        this.indexName = indexName;
        this.restGraphDatabase = restGraphDatabase;
    }

    public String getName() {
        return this.indexName;
    }

    private String getTypeName() {
        return this.getEntityType().getSimpleName().toLowerCase();
    }

    public void add(T entity, String key, Object value) {
        String uri = ((RestEntity)entity).getUri();
        this.restRequest.post(this.indexPath(key, value), JsonHelper.createJsonFrom(uri));
    }

    protected String indexPath() {
        return "index/" + this.getTypeName() + "/" + this.indexName;
    }

    protected String indexPath(String key) {
        return this.indexPath() + "/" + RestRequest.encode(key);
    }

    protected String indexPath(String key, Object value) {
        return this.indexPath(key) + "/" + RestRequest.encode(value);
    }

    public void remove(T entity, String key, Object value) {
        this.restRequest.delete(this.entityIndexPath(this.indexPath(key, value), entity));
    }

    public void remove(T entity) {
        this.restRequest.delete(this.entityIndexPath(this.indexPath(), entity));
    }

    public void remove(T entity, String key) {
        this.restRequest.delete(this.entityIndexPath(this.indexPath(key), entity));
    }

    private String entityIndexPath(String indexPath, T entity) {
        return indexPath + "/" + ((RestEntity)entity).getId();
    }

    public void delete() {
        this.restRequest.delete(this.indexPath());
    }

    public IndexHits<T> get(String key, Object value) {
        return this.query(key, value);
    }

    public IndexHits<T> query(String key, Object value) {
        String indexPath = key != null ? this.indexPath(key) : this.indexPath("null");
        RequestResult requestResult = this.restRequest.get(indexPath + "?query=" + RestRequest.encode(value));
        if (this.restRequest.statusIs(requestResult, (Response.StatusType)Response.Status.OK)) {
            Collection hits = (Collection)this.restRequest.toEntity(requestResult);
            return new SimpleIndexHits(hits, hits.size());
        }
        return new SimpleIndexHits(Collections.<Object>emptyList(), 0);
    }

    protected abstract T createEntity(Map<?, ?> var1);

    public IndexHits<T> query(Object value) {
        return this.query(null, value);
    }

    private class SimpleIndexHits<T extends PropertyContainer>
    implements IndexHits<T> {
        private Collection<Object> hits;
        private int size;
        private Iterator<Object> iterator;

        public SimpleIndexHits(Collection<Object> hits, int size) {
            this.hits = hits;
            this.iterator = this.hits.iterator();
            this.size = size;
        }

        public int size() {
            return this.size;
        }

        public void close() {
        }

        public T getSingle() {
            Iterator<Object> it = this.hits.iterator();
            return it.hasNext() ? (T)this.transform(it.next()) : null;
        }

        public float currentScore() {
            return 0.0f;
        }

        public Iterator<T> iterator() {
            return this;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            Object value = this.iterator.next();
            return this.transform(value);
        }

        private T transform(Object value) {
            return RestIndex.this.createEntity((Map)value);
        }

        public void remove() {
        }
    }
}

