/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.index;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestRequest;
import org.springframework.data.neo4j.rest.index.RestNodeIndex;
import org.springframework.data.neo4j.rest.index.RestRelationshipIndex;

public class RestIndexManager
implements IndexManager {
    private RestRequest restRequest;
    private RestGraphDatabase restGraphDatabase;

    public RestIndexManager(RestRequest restRequest, RestGraphDatabase restGraphDatabase) {
        this.restRequest = restRequest;
        this.restGraphDatabase = restGraphDatabase;
    }

    public boolean existsForNodes(String indexName) {
        return this.indexInfo("node").containsKey(indexName);
    }

    private Map<String, ?> indexInfo(String indexType) {
        RequestResult requestResult = this.restRequest.get("index/" + indexType);
        if (this.restRequest.statusIs(requestResult, (Response.StatusType)Response.Status.NO_CONTENT)) {
            return Collections.emptyMap();
        }
        return this.restRequest.toMap(requestResult);
    }

    public Index<Node> forNodes(String indexName) {
        return new RestNodeIndex(this.restRequest, indexName, this.restGraphDatabase);
    }

    public Index<Node> forNodes(String indexName, Map<String, String> config) {
        return new RestNodeIndex(this.restRequest, indexName, this.restGraphDatabase);
    }

    public String[] nodeIndexNames() {
        Set<String> keys = this.indexInfo("node").keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public boolean existsForRelationships(String indexName) {
        return this.indexInfo("relationship").containsKey(indexName);
    }

    public RelationshipIndex forRelationships(String indexName) {
        return new RestRelationshipIndex(this.restRequest, indexName, this.restGraphDatabase);
    }

    public RelationshipIndex forRelationships(String indexName, Map<String, String> config) {
        return new RestRelationshipIndex(this.restRequest, indexName, this.restGraphDatabase);
    }

    public String[] relationshipIndexNames() {
        Set<String> keys = this.indexInfo("relationship").keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        return null;
    }

    public String setConfiguration(Index<? extends PropertyContainer> index, String name, String value) {
        throw new UnsupportedOperationException();
    }

    public String removeConfiguration(Index<? extends PropertyContainer> index, String name) {
        throw new UnsupportedOperationException();
    }

    public AutoIndexer<Node> getNodeAutoIndexer() {
        throw new UnsupportedOperationException();
    }

    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        throw new UnsupportedOperationException();
    }
}

