/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.util;

import java.lang.reflect.Array;
import java.util.Collection;

public class ArrayConverter {
    public Object toArray(Collection col) {
        Object entry = this.getNonNullEntry(col);
        if (entry == null) {
            return null;
        }
        Class<? extends Object> elementClass = this.getArrayElementClass(entry);
        Object array = Array.newInstance(elementClass, col.size());
        if (Object.class.isAssignableFrom(elementClass)) {
            col.toArray((Object[])array);
        } else {
            int i = 0;
            for (Object value : col) {
                this.setArrayValue(array, i, value, elementClass);
                ++i;
            }
        }
        return array;
    }

    private void setArrayValue(Object array, int i, Object value, Class<? extends Object> type) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (type.equals(Integer.TYPE)) {
                Array.setInt(array, i, number.intValue());
                return;
            }
            if (type.equals(Long.TYPE)) {
                Array.setLong(array, i, number.longValue());
                return;
            }
            if (type.equals(Double.TYPE)) {
                Array.setDouble(array, i, number.doubleValue());
                return;
            }
            if (type.equals(Float.TYPE)) {
                Array.setFloat(array, i, number.floatValue());
                return;
            }
            if (type.equals(Byte.TYPE)) {
                Array.setByte(array, i, number.byteValue());
                return;
            }
            if (type.equals(Short.TYPE)) {
                Array.setShort(array, i, number.shortValue());
                return;
            }
        }
        if (type.equals(Character.TYPE)) {
            Array.setChar(array, i, ((Character)value).charValue());
            return;
        }
        if (type.equals(Boolean.TYPE)) {
            Array.setBoolean(array, i, (Boolean)value);
            return;
        }
    }

    private Class<? extends Object> getArrayElementClass(Object entry) {
        Class<?> type = entry.getClass();
        if (type.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (type.equals(Long.class)) {
            return Long.TYPE;
        }
        if (type.equals(Double.class)) {
            return Double.TYPE;
        }
        if (type.equals(Float.class)) {
            return Float.TYPE;
        }
        if (type.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (type.equals(Short.class)) {
            return Short.TYPE;
        }
        if (type.equals(Character.class)) {
            return Character.TYPE;
        }
        if (type.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        return type;
    }

    private Object getNonNullEntry(Collection col) {
        for (Object entry : col) {
            if (entry == null) continue;
            return entry;
        }
        return null;
    }
}

