/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.r2dbc.core.BindParameterSource;
import org.springframework.data.r2dbc.core.NamedParameterUtils;
import org.springframework.data.r2dbc.core.ParsedSql;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;

public class NamedParameterExpander {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private volatile int cacheLimit = 256;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, ParsedSql> parsedSqlCache = new LinkedHashMap<String, ParsedSql>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ParsedSql> eldest) {
            return this.size() > NamedParameterExpander.this.getCacheLimit();
        }
    };

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsedSql getParsedSql(String sql) {
        if (this.getCacheLimit() <= 0) {
            return NamedParameterUtils.parseSqlStatement(sql);
        }
        Map<String, ParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            ParsedSql parsedSql = this.parsedSqlCache.get(sql);
            if (parsedSql == null) {
                parsedSql = NamedParameterUtils.parseSqlStatement(sql);
                this.parsedSqlCache.put(sql, parsedSql);
            }
            return parsedSql;
        }
    }

    public PreparedOperation<String> expand(String sql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
        ParsedSql parsedSql = this.getParsedSql(sql);
        PreparedOperation<String> expanded = NamedParameterUtils.substituteNamedParameters(parsedSql, bindMarkersFactory, paramSource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Expanding SQL statement [%s] to [%s]", sql, expanded.toQuery()));
        }
        return expanded;
    }

    public List<String> getParameterNames(String sql) {
        return this.getParsedSql(sql).getParameterNames();
    }
}

