/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.mapping;

import org.springframework.core.KotlinDetector;
import org.springframework.data.r2dbc.mapping.R2dbcSimpleTypeHolder;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.data.util.TypeInformation;

public class R2dbcMappingContext
extends RelationalMappingContext {
    public R2dbcMappingContext() {
        this.setForceQuote(false);
    }

    public R2dbcMappingContext(NamingStrategy namingStrategy) {
        super(namingStrategy);
        this.setForceQuote(false);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        if (R2dbcSimpleTypeHolder.HOLDER.isSimpleType(type.getType())) {
            return false;
        }
        return !KotlinDetector.isKotlinType((Class)type.getType()) || KotlinReflectionUtils.isSupportedKotlinClass((Class)type.getType());
    }
}

