/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.dialect.BindTarget;
import org.springframework.data.r2dbc.repository.query.BindableQuery;
import org.springframework.util.Assert;

class PreparedOperationBindableQuery
implements BindableQuery {
    private final PreparedOperation<?> preparedQuery;

    PreparedOperationBindableQuery(PreparedOperation<?> preparedQuery) {
        Assert.notNull(preparedQuery, (String)"Prepared query must not be null!");
        this.preparedQuery = preparedQuery;
    }

    @Override
    public <T extends DatabaseClient.BindSpec<T>> T bind(T bindSpec) {
        BindSpecBindTargetAdapter bindTargetAdapter = new BindSpecBindTargetAdapter(bindSpec);
        this.preparedQuery.bindTo(bindTargetAdapter);
        return (T)bindTargetAdapter.bindSpec;
    }

    @Override
    public String get() {
        return this.preparedQuery.get();
    }

    private static class BindSpecBindTargetAdapter<T extends DatabaseClient.BindSpec<T>>
    implements BindTarget {
        DatabaseClient.BindSpec<T> bindSpec;

        private BindSpecBindTargetAdapter(DatabaseClient.BindSpec<T> bindSpec) {
            this.bindSpec = bindSpec;
        }

        @Override
        public void bind(String identifier, Object value) {
            this.bindSpec = this.bindSpec.bind(identifier, value);
        }

        @Override
        public void bind(int index, Object value) {
            this.bindSpec = this.bindSpec.bind(index, value);
        }

        @Override
        public void bindNull(String identifier, Class<?> type) {
            this.bindSpec = this.bindSpec.bindNull(identifier, type);
        }

        @Override
        public void bindNull(int index, Class<?> type) {
            this.bindSpec = this.bindSpec.bind(index, type);
        }
    }
}

