/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.support;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.springframework.util.Assert;

public abstract class ArrayUtils {
    public static int getDimensionDepth(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return ArrayUtils.getDimensionDepth(value.getClass());
    }

    public static int getDimensionDepth(Class<?> arrayClass) {
        Assert.isTrue((arrayClass != null && arrayClass.isArray() ? 1 : 0) != 0, (String)"Array class must be an array");
        int result = 0;
        Class<?> type = arrayClass;
        while (type.isArray()) {
            ++result;
            type = type.getComponentType();
        }
        return result;
    }

    public static Class<?> getArrayClass(Class<?> componentType, int dimensions) {
        Assert.notNull(componentType, (String)"Component type must not be null");
        int[] lengths = new int[dimensions];
        Arrays.fill(lengths, 0);
        return Array.newInstance(componentType, lengths).getClass();
    }

    private ArrayUtils() {
    }
}

