/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.integration.http.AbstractHttpRequestExecutor;
import org.springframework.integration.http.HttpRequest;
import org.springframework.integration.http.HttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsHttpRequestExecutor
extends AbstractHttpRequestExecutor {
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private HttpClient httpClient;

    public CommonsHttpRequestExecutor() {
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.setReadTimeout(60000);
    }

    public CommonsHttpRequestExecutor(HttpClient httpClient) {
        this.setHttpClient(httpClient);
    }

    public void setHttpClient(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
    }

    @Override
    protected HttpResponse doExecuteRequest(HttpRequest request) throws Exception {
        HttpMethod httpMethod = this.createHttpMethod(request);
        try {
            if (httpMethod instanceof EntityEnclosingMethod) {
                this.setRequestBody((EntityEnclosingMethod)httpMethod, request.getBody(), request.getContentType());
            }
            this.executeHttpMethod(this.getHttpClient(), httpMethod);
            this.validateResponse(httpMethod);
            AbstractHttpRequestExecutor.DefaultHttpResponse defaultHttpResponse = new AbstractHttpRequestExecutor.DefaultHttpResponse(this.readResponseBody(httpMethod), this.getResponseHeaders(httpMethod));
            return defaultHttpResponse;
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    private HttpMethod createHttpMethod(HttpRequest request) {
        String contentType;
        String url = request.getTargetUrl().toString();
        String methodName = request.getRequestMethod();
        GetMethod httpMethod = null;
        if ("GET".equals(methodName)) {
            httpMethod = new GetMethod(url);
        } else if ("POST".equals(methodName)) {
            httpMethod = new PostMethod(url);
        } else if ("PUT".equals(methodName)) {
            httpMethod = new PutMethod(url);
        } else if ("DELETE".equals(methodName)) {
            httpMethod = new DeleteMethod(url);
        } else if ("TRACE".equals(methodName)) {
            httpMethod = new TraceMethod(url);
        } else if ("HEAD".equals(methodName)) {
            httpMethod = new HeadMethod(url);
        } else if ("OPTIONS".equals(methodName)) {
            httpMethod = new OptionsMethod(url);
        } else {
            throw new UnsupportedOperationException("unsupported request method '" + methodName + "'");
        }
        LocaleContext locale = LocaleContextHolder.getLocaleContext();
        if (locale != null) {
            httpMethod.addRequestHeader("Accept-Language", StringUtils.toLanguageTag((Locale)locale.getLocale()));
        }
        if (this.isAcceptGzipEncoding()) {
            httpMethod.addRequestHeader("Accept-Encoding", "gzip");
        }
        if (httpMethod instanceof EntityEnclosingMethod && (contentType = request.getContentType()) != null) {
            httpMethod.addRequestHeader("Content-Type", contentType);
        }
        return httpMethod;
    }

    private void setRequestBody(EntityEnclosingMethod httpMethod, ByteArrayOutputStream baos, String contentType) throws IOException {
        httpMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(baos.toByteArray(), contentType));
    }

    private void executeHttpMethod(HttpClient httpClient, HttpMethod httpMethod) throws IOException {
        httpClient.executeMethod(httpMethod);
    }

    private void validateResponse(HttpMethod httpMethod) throws IOException {
        if (httpMethod.getStatusCode() >= 300) {
            throw new HttpException("Did not receive successful HTTP response: status code = " + httpMethod.getStatusCode() + ", status message = [" + httpMethod.getStatusText() + "]");
        }
    }

    private InputStream readResponseBody(HttpMethod httpMethod) throws IOException {
        byte[] responseBody = httpMethod.getResponseBody();
        InputStream responseStream = null;
        if (responseBody != null) {
            responseStream = new ByteArrayInputStream(responseBody);
            if (this.isGzipResponse(httpMethod)) {
                responseStream = new GZIPInputStream(responseStream);
            }
        }
        return responseStream;
    }

    private Map<String, List<String>> getResponseHeaders(HttpMethod httpMethod) {
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        Header[] headerArray = httpMethod.getResponseHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String name = header.getName();
            String value = header.getValue();
            ArrayList<String> values = (ArrayList<String>)headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(value);
            headers.put(name, values);
            ++n2;
        }
        return Collections.unmodifiableMap(headers);
    }

    private boolean isGzipResponse(HttpMethod httpMethod) {
        Header encodingHeader = httpMethod.getResponseHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.getValue() != null && encodingHeader.getValue().toLowerCase().indexOf("gzip") != -1;
    }
}

