/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.api.web;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Principal;
import java.util.Map;
import org.cloudfoundry.identity.api.web.ApiController;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.View;

@Controller
public class ApiController {
    private String infoResource;
    private String loginUrl = "http://localhost:8080/uaa";
    private String uaaUrl = "http://localhost:8080/uaa";

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setUaaUrl(String uaaUrl) {
        this.uaaUrl = uaaUrl;
    }

    public void setInfo(Resource info) {
        try {
            this.infoResource = FileCopyUtils.copyToString((Reader)new InputStreamReader(info.getInputStream()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load template", e);
        }
    }

    @RequestMapping(value={"/info"})
    public View info(Map<String, Object> model, Principal principal) throws Exception {
        model.put("loginUrl", this.loginUrl);
        model.put("uaaUrl", this.uaaUrl);
        if (principal != null) {
            model.put("user", principal.getName());
        } else {
            model.put("user", null);
        }
        return new SpelView(this.infoResource);
    }
}

