/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.oauth2showcase;

import org.cloudfoundry.identity.oauth2showcase.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.security.oauth2.sso.EnableOAuth2Sso;
import org.springframework.cloud.security.oauth2.sso.OAuth2SsoConfigurer;
import org.springframework.cloud.security.oauth2.sso.OAuth2SsoConfigurerAdapter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AuthorizationCode {
    @Value(value="${uaa.location}")
    private String uaaLocation;
    @Autowired
    @Qualifier(value="oauth2RestTemplate")
    private OAuth2RestTemplate authcodeRestTemplate;

    @RequestMapping(value={"/authorization_code"})
    public String authCode(Model model) {
        String response = (String)this.authcodeRestTemplate.getForObject("{uaa}/userinfo", String.class, new Object[]{this.uaaLocation});
        model.addAttribute("response", (Object)Utils.toPrettyJsonString(response));
        model.addAttribute("token", (Object)Utils.getToken(this.authcodeRestTemplate.getOAuth2ClientContext()));
        return "authorization_code";
    }

    @Configuration
    @EnableOAuth2Sso
    public static class Config {
        @Bean
        OAuth2SsoConfigurerAdapter oAuth2SsoConfigurerAdapter() {
            return new OAuth2SsoConfigurerAdapter(){

                public void match(OAuth2SsoConfigurer.RequestMatchers matchers) {
                    matchers.antMatchers(new String[]{"/authorization_code/**"});
                }

                public void configure(HttpSecurity http) throws Exception {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/"})).permitAll();
                }
            };
        }
    }
}

