/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.rabbitmq.http.client.ClientCreationContext;
import com.rabbitmq.http.client.ClientParameters;
import com.rabbitmq.http.client.GetAckMode;
import com.rabbitmq.http.client.GetEncoding;
import com.rabbitmq.http.client.HttpClientBuilderConfigurator;
import com.rabbitmq.http.client.HttpComponentsRestTemplateConfigurator;
import com.rabbitmq.http.client.RestTemplateConfigurator;
import com.rabbitmq.http.client.SimpleRestTemplateConfigurator;
import com.rabbitmq.http.client.Utils;
import com.rabbitmq.http.client.domain.AlivenessTestResult;
import com.rabbitmq.http.client.domain.BindingInfo;
import com.rabbitmq.http.client.domain.ChannelInfo;
import com.rabbitmq.http.client.domain.ClusterId;
import com.rabbitmq.http.client.domain.ConnectionInfo;
import com.rabbitmq.http.client.domain.CurrentUserDetails;
import com.rabbitmq.http.client.domain.Definitions;
import com.rabbitmq.http.client.domain.DeleteQueueParameters;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import com.rabbitmq.http.client.domain.InboundMessage;
import com.rabbitmq.http.client.domain.NodeInfo;
import com.rabbitmq.http.client.domain.OutboundMessage;
import com.rabbitmq.http.client.domain.OverviewResponse;
import com.rabbitmq.http.client.domain.PolicyInfo;
import com.rabbitmq.http.client.domain.QueueInfo;
import com.rabbitmq.http.client.domain.ShovelInfo;
import com.rabbitmq.http.client.domain.ShovelStatus;
import com.rabbitmq.http.client.domain.TopicPermissions;
import com.rabbitmq.http.client.domain.UpstreamDetails;
import com.rabbitmq.http.client.domain.UpstreamInfo;
import com.rabbitmq.http.client.domain.UpstreamSetDetails;
import com.rabbitmq.http.client.domain.UpstreamSetInfo;
import com.rabbitmq.http.client.domain.UserInfo;
import com.rabbitmq.http.client.domain.UserPermissions;
import com.rabbitmq.http.client.domain.VhostInfo;
import com.rabbitmq.http.client.domain.VhostLimits;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriUtils;

public class Client {
    protected final RestTemplate rt;
    protected final URI rootUri;

    public Client(String url, String username, String password) throws MalformedURLException, URISyntaxException {
        this(new URL(url), username, password);
    }

    public Client(String url, String username, String password, HttpClientBuilderConfigurator configurator) throws MalformedURLException, URISyntaxException {
        this(new URL(url), username, password, configurator);
    }

    public Client(URL url, String username, String password) throws MalformedURLException, URISyntaxException {
        this(url, username, password, null, null);
    }

    public Client(URL url, String username, String password, HttpClientBuilderConfigurator configurator) throws MalformedURLException, URISyntaxException {
        this(url, username, password, null, null, configurator);
    }

    private Client(URL url, String username, String password, SSLConnectionSocketFactory sslConnectionSocketFactory, SSLContext sslContext) throws MalformedURLException, URISyntaxException {
        this(new ClientParameters().url(url).username(username).password(password).restTemplateConfigurator(new HttpComponentsRestTemplateConfigurator(sslConnectionSocketFactory, sslContext)));
    }

    public Client(URL url, String username, String password, SSLContext sslContext) throws MalformedURLException, URISyntaxException {
        this(url, username, password, null, sslContext);
    }

    private Client(URL url, String username, String password, SSLConnectionSocketFactory sslConnectionSocketFactory) throws MalformedURLException, URISyntaxException {
        this(url, username, password, sslConnectionSocketFactory, null);
    }

    public Client(String url) throws MalformedURLException, URISyntaxException {
        this(new ClientParameters().url(url).restTemplateConfigurator(new HttpComponentsRestTemplateConfigurator()));
    }

    public Client(String url, HttpClientBuilderConfigurator configurator) throws MalformedURLException, URISyntaxException {
        this(Utils.urlWithoutCredentials(url), Utils.extractUsernamePassword(url)[0], Utils.extractUsernamePassword(url)[1], configurator);
    }

    public Client(URL url) throws MalformedURLException, URISyntaxException {
        this(url, null, null);
    }

    private Client(URL url, String username, String password, SSLConnectionSocketFactory sslConnectionSocketFactory, SSLContext sslContext, HttpClientBuilderConfigurator configurator) throws MalformedURLException, URISyntaxException {
        this(new ClientParameters().url(url).username(username).password(password).restTemplateConfigurator(new HttpComponentsRestTemplateConfigurator(sslConnectionSocketFactory, sslContext, configurator)));
    }

    public Client(ClientParameters parameters) throws URISyntaxException, MalformedURLException {
        parameters.validate();
        URL url = parameters.getUrl();
        this.rootUri = url.toString().endsWith("/") ? url.toURI() : new URL(url.toString() + "/").toURI();
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setMessageConverters(this.getMessageConverters());
        RestTemplateConfigurator restTemplateConfigurator = parameters.getRestTemplateConfigurator() == null ? new SimpleRestTemplateConfigurator() : parameters.getRestTemplateConfigurator();
        this.rt = restTemplateConfigurator.configure(new ClientCreationContext(restTemplate, parameters, this.rootUri));
    }

    public OverviewResponse getOverview() {
        return (OverviewResponse)this.rt.getForObject(this.uriWithPath("./overview"), OverviewResponse.class);
    }

    public boolean alivenessTest(String vhost) {
        URI uri = this.uriWithPath("./aliveness-test/" + this.encodePathSegment(vhost));
        return ((AlivenessTestResult)this.rt.getForObject(uri, AlivenessTestResult.class)).isSuccessful();
    }

    public CurrentUserDetails whoAmI() {
        URI uri = this.uriWithPath("./whoami/");
        return (CurrentUserDetails)this.rt.getForObject(uri, CurrentUserDetails.class);
    }

    public List<NodeInfo> getNodes() {
        URI uri = this.uriWithPath("./nodes/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, NodeInfo[].class));
    }

    public NodeInfo getNode(String name) {
        URI uri = this.uriWithPath("./nodes/" + this.encodePathSegment(name));
        return (NodeInfo)this.rt.getForObject(uri, NodeInfo.class);
    }

    public List<ConnectionInfo> getConnections() {
        URI uri = this.uriWithPath("./connections/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ConnectionInfo[].class));
    }

    public ConnectionInfo getConnection(String name) {
        URI uri = this.uriWithPath("./connections/" + this.encodePathSegment(name));
        return (ConnectionInfo)this.rt.getForObject(uri, ConnectionInfo.class);
    }

    public void closeConnection(String name) {
        URI uri = this.uriWithPath("./connections/" + this.encodePathSegment(name));
        this.deleteIgnoring404(uri);
    }

    public void closeConnection(String name, String reason) {
        URI uri = this.uriWithPath("./connections/" + this.encodePathSegment(name));
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.put((Object)"X-Reason", Collections.singletonList(reason));
        this.deleteIgnoring404(uri, (MultiValueMap<String, String>)headers);
    }

    public List<ChannelInfo> getChannels() {
        URI uri = this.uriWithPath("./channels/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ChannelInfo[].class));
    }

    public List<ChannelInfo> getChannels(String connectionName) {
        URI uri = this.uriWithPath("./connections/" + this.encodePathSegment(connectionName) + "/channels/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ChannelInfo[].class));
    }

    public ChannelInfo getChannel(String name) {
        URI uri = this.uriWithPath("./channels/" + this.encodePathSegment(name));
        return (ChannelInfo)this.rt.getForObject(uri, ChannelInfo.class);
    }

    public List<VhostInfo> getVhosts() {
        URI uri = this.uriWithPath("./vhosts/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, VhostInfo[].class));
    }

    public VhostInfo getVhost(String name) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(name));
        return this.getForObjectReturningNullOn404(uri, VhostInfo.class);
    }

    public void createVhost(String name, boolean tracing, String description, String ... tags) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tracing", tracing);
        if (description != null && !description.isEmpty()) {
            body.put("description", description);
        }
        if (tags != null && tags.length > 0) {
            body.put("tags", String.join((CharSequence)",", tags));
        }
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(name));
        this.rt.put(uri, body);
    }

    public void createVhost(String name, String description, String ... tags) {
        this.createVhost(name, false, description, tags);
    }

    public void createVhost(String name, boolean tracing) {
        this.createVhost(name, tracing, null, new String[0]);
    }

    public void createVhost(String name) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(name));
        this.rt.put(uri, null);
    }

    public void deleteVhost(String name) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(name));
        this.deleteIgnoring404(uri);
    }

    public List<UserPermissions> getPermissionsIn(String vhost) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(vhost) + "/permissions");
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<UserPermissions> getPermissionsOf(String username) {
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username) + "/permissions");
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<UserPermissions> getPermissions() {
        URI uri = this.uriWithPath("./permissions");
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public UserPermissions getPermissions(String vhost, String username) {
        URI uri = this.uriWithPath("./permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        return this.getForObjectReturningNullOn404(uri, UserPermissions.class);
    }

    public List<TopicPermissions> getTopicPermissionsIn(String vhost) {
        URI uri = this.uriWithPath("./vhosts/" + this.encodePathSegment(vhost) + "/topic-permissions");
        TopicPermissions[] result = this.getForObjectReturningNullOn404(uri, TopicPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<TopicPermissions> getTopicPermissionsOf(String username) {
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username) + "/topic-permissions");
        TopicPermissions[] result = this.getForObjectReturningNullOn404(uri, TopicPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<TopicPermissions> getTopicPermissions() {
        URI uri = this.uriWithPath("./topic-permissions");
        TopicPermissions[] result = this.getForObjectReturningNullOn404(uri, TopicPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<TopicPermissions> getTopicPermissions(String vhost, String username) {
        URI uri = this.uriWithPath("./topic-permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        return this.asListOrNull((Object[])this.getForObjectReturningNullOn404(uri, TopicPermissions[].class));
    }

    public List<ExchangeInfo> getExchanges() {
        URI uri = this.uriWithPath("./exchanges/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ExchangeInfo[].class));
    }

    public List<ExchangeInfo> getExchanges(String vhost) {
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost));
        ExchangeInfo[] result = this.getForObjectReturningNullOn404(uri, ExchangeInfo[].class);
        return this.asListOrNull(result);
    }

    public ExchangeInfo getExchange(String vhost, String name) {
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        return this.getForObjectReturningNullOn404(uri, ExchangeInfo.class);
    }

    public void declareExchange(String vhost, String name, ExchangeInfo info) {
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        this.rt.put(uri, (Object)info);
    }

    public void deleteExchange(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name)));
    }

    public boolean publish(String vhost, String exchange, String routingKey, OutboundMessage outboundMessage) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        Map<String, Object> body = Utils.bodyForPublish(routingKey, outboundMessage);
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(exchange) + "/publish");
        Map response = (Map)this.rt.postForObject(uri, body, Map.class);
        Boolean routed = (Boolean)response.get("routed");
        if (routed == null) {
            return false;
        }
        return routed;
    }

    public List<QueueInfo> getQueues() {
        URI uri = this.uriWithPath("./queues/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, QueueInfo[].class));
    }

    public List<QueueInfo> getQueues(String vhost) {
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost));
        QueueInfo[] result = this.getForObjectReturningNullOn404(uri, QueueInfo[].class);
        return this.asListOrNull(result);
    }

    public QueueInfo getQueue(String vhost, String name) {
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        return this.getForObjectReturningNullOn404(uri, QueueInfo.class);
    }

    public void declarePolicy(String vhost, String name, PolicyInfo info) {
        URI uri = this.uriWithPath("./policies/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        this.rt.put(uri, (Object)info);
    }

    public void declareQueue(String vhost, String name, QueueInfo info) {
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        this.rt.put(uri, (Object)info);
    }

    public void purgeQueue(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name) + "/contents/"));
    }

    public void deleteQueue(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name)));
    }

    public void deleteQueue(String vhost, String name, DeleteQueueParameters deleteInfo) {
        this.deleteIgnoring404(this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name), deleteInfo.getAsQueryParams()));
    }

    public List<InboundMessage> get(String vhost, String queue, int count, GetAckMode ackMode, GetEncoding encoding, int truncate) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        Map<String, Object> body = Utils.bodyForGet(count, ackMode, encoding, truncate);
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(queue) + "/get");
        return Arrays.asList((Object[])this.rt.postForObject(uri, body, InboundMessage[].class));
    }

    public List<InboundMessage> get(String vhost, String queue, int count, GetAckMode ackMode, GetEncoding encoding) {
        return this.get(vhost, queue, count, ackMode, encoding, -1);
    }

    public InboundMessage get(String vhost, String queue) {
        List<InboundMessage> inboundMessages = this.get(vhost, queue, 1, GetAckMode.NACK_REQUEUE_TRUE, GetEncoding.AUTO, 50000);
        if (inboundMessages != null && inboundMessages.size() == 1) {
            return inboundMessages.get(0);
        }
        return null;
    }

    public void deletePolicy(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./policies/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name)));
    }

    public List<UserInfo> getUsers() {
        URI uri = this.uriWithPath("./users/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, UserInfo[].class));
    }

    public UserInfo getUser(String username) {
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username));
        return this.getForObjectReturningNullOn404(uri, UserInfo.class);
    }

    public void createUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null or empty. If you need to create a user that will only authenticate using an x509 certificate, use createUserWithPasswordHash with a blank hash.");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password", new String(password));
        body.put("tags", String.join((CharSequence)",", tags));
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username));
        this.rt.put(uri, body);
    }

    public void createUserWithPasswordHash(String username, char[] passwordHash, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (passwordHash == null) {
            passwordHash = "".toCharArray();
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password_hash", String.valueOf(passwordHash));
        body.put("tags", String.join((CharSequence)",", tags));
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username));
        this.rt.put(uri, body);
    }

    public void updateUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        if (password != null) {
            body.put("password", new String(password));
        }
        body.put("tags", String.join((CharSequence)",", tags));
        URI uri = this.uriWithPath("./users/" + this.encodePathSegment(username));
        this.rt.put(uri, body);
    }

    public void deleteUser(String username) {
        this.deleteIgnoring404(this.uriWithPath("./users/" + this.encodePathSegment(username)));
    }

    public void updatePermissions(String vhost, String username, UserPermissions permissions) {
        URI uri = this.uriWithPath("./permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        this.rt.put(uri, (Object)permissions);
    }

    public void clearPermissions(String vhost, String username) {
        URI uri = this.uriWithPath("./permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        this.deleteIgnoring404(uri);
    }

    public void updateTopicPermissions(String vhost, String username, TopicPermissions permissions) {
        URI uri = this.uriWithPath("./topic-permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        this.rt.put(uri, (Object)permissions);
    }

    public void clearTopicPermissions(String vhost, String username) {
        URI uri = this.uriWithPath("./topic-permissions/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(username));
        this.deleteIgnoring404(uri);
    }

    public List<PolicyInfo> getPolicies() {
        URI uri = this.uriWithPath("./policies/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, PolicyInfo[].class));
    }

    public List<PolicyInfo> getPolicies(String vhost) {
        URI uri = this.uriWithPath("./policies/" + this.encodePathSegment(vhost));
        PolicyInfo[] result = this.getForObjectReturningNullOn404(uri, PolicyInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getBindings() {
        URI uri = this.uriWithPath("./bindings/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getBindings(String vhost) {
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost));
        return Arrays.asList((Object[])this.rt.getForObject(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getBindingsBySource(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(x) + "/bindings/source");
        return Arrays.asList((Object[])this.rt.getForObject(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getExchangeBindingsByDestination(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        URI uri = this.uriWithPath("./exchanges/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(x) + "/bindings/destination");
        BindingInfo[] result = (BindingInfo[])this.rt.getForObject(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getQueueBindings(String vhost, String queue) {
        URI uri = this.uriWithPath("./queues/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(queue) + "/bindings");
        BindingInfo[] result = (BindingInfo[])this.rt.getForObject(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getQueueBindingsBetween(String vhost, String exchange, String queue) {
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(exchange) + "/q/" + this.encodePathSegment(queue));
        BindingInfo[] result = (BindingInfo[])this.rt.getForObject(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getExchangeBindingsBetween(String vhost, String source, String destination) {
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(source) + "/e/" + this.encodePathSegment(destination));
        BindingInfo[] result = (BindingInfo[])this.rt.getForObject(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public void bindQueue(String vhost, String queue, String exchange, String routingKey) {
        this.bindQueue(vhost, queue, exchange, routingKey, new HashMap<String, Object>());
    }

    public void bindQueue(String vhost, String queue, String exchange, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("arguments", args);
        }
        body.put("routing_key", routingKey);
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(exchange) + "/q/" + this.encodePathSegment(queue));
        this.rt.postForLocation(uri, body);
    }

    public void unbindQueue(String vhost, String queue, String exchange, String routingKey) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        this.deleteIgnoring404(this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(exchange) + "/q/" + this.encodePathSegment(queue) + '/' + this.encodePathSegment(routingKey)));
    }

    public void bindExchange(String vhost, String destination, String source, String routingKey) {
        this.bindExchange(vhost, destination, source, routingKey, new HashMap<String, Object>());
    }

    public void bindExchange(String vhost, String destination, String source, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination cannot be null or blank");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("arguments", args);
        }
        body.put("routing_key", routingKey);
        URI uri = this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(source) + "/e/" + this.encodePathSegment(destination));
        this.rt.postForLocation(uri, body);
    }

    public void unbindExchange(String vhost, String destination, String source, String routingKey) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination cannot be null or blank");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be null or blank");
        }
        this.deleteIgnoring404(this.uriWithPath("./bindings/" + this.encodePathSegment(vhost) + "/e/" + this.encodePathSegment(source) + "/e/" + this.encodePathSegment(destination) + '/' + this.encodePathSegment(routingKey)));
    }

    public ClusterId getClusterName() {
        return (ClusterId)this.rt.getForObject(this.uriWithPath("./cluster-name"), ClusterId.class);
    }

    public void setClusterName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        URI uri = this.uriWithPath("./cluster-name");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("name", name);
        this.rt.put(uri, m);
    }

    public List<Map> getExtensions() {
        URI uri = this.uriWithPath("./extensions/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, Map[].class));
    }

    public Definitions getDefinitions() {
        URI uri = this.uriWithPath("./definitions/");
        return (Definitions)this.rt.getForObject(uri, Definitions.class);
    }

    public void declareShovel(String vhost, ShovelInfo info) {
        Map<String, Object> props = info.getDetails().getPublishProperties();
        if (props != null && props.isEmpty()) {
            throw new IllegalArgumentException("Shovel publish properties must be a non-empty map or null");
        }
        URI uri = this.uriWithPath("./parameters/shovel/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(info.getName()));
        this.rt.put(uri, (Object)info);
    }

    public List<ShovelInfo> getShovels() {
        URI uri = this.uriWithPath("./parameters/shovel/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ShovelInfo[].class));
    }

    public List<ShovelInfo> getShovels(String vhost) {
        URI uri = this.uriWithPath("./parameters/shovel/" + this.encodePathSegment(vhost));
        ShovelInfo[] result = this.getForObjectReturningNullOn404(uri, ShovelInfo[].class);
        return this.asListOrNull(result);
    }

    public List<ShovelStatus> getShovelsStatus() {
        URI uri = this.uriWithPath("./shovels/");
        return Arrays.asList((Object[])this.rt.getForObject(uri, ShovelStatus[].class));
    }

    public List<ShovelStatus> getShovelsStatus(String vhost) {
        URI uri = this.uriWithPath("./shovels/" + this.encodePathSegment(vhost));
        ShovelStatus[] result = this.getForObjectReturningNullOn404(uri, ShovelStatus[].class);
        return this.asListOrNull(result);
    }

    public void deleteShovel(String vhost, String shovelname) {
        this.deleteIgnoring404(this.uriWithPath("./parameters/shovel/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(shovelname)));
    }

    public void declareUpstream(String vhost, String name, UpstreamDetails details) {
        if (StringUtils.isEmpty((Object)details.getUri())) {
            throw new IllegalArgumentException("Upstream uri must not be null or empty");
        }
        URI uri = this.uriWithPath("./parameters/federation-upstream/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        UpstreamInfo body = new UpstreamInfo();
        body.setVhost(vhost);
        body.setName(name);
        body.setValue(details);
        this.rt.put(uri, (Object)body);
    }

    public void deleteUpstream(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./parameters/federation-upstream/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name)));
    }

    public List<UpstreamInfo> getUpstreams() {
        return this.getParameters("federation-upstream", new ParameterizedTypeReference<List<UpstreamInfo>>(){});
    }

    public List<UpstreamInfo> getUpstreams(String vhost) {
        return this.getParameters(vhost, "federation-upstream", new ParameterizedTypeReference<List<UpstreamInfo>>(){});
    }

    public void declareUpstreamSet(String vhost, String name, List<UpstreamSetDetails> details) {
        for (UpstreamSetDetails item : details) {
            if (!StringUtils.isEmpty((Object)item.getUpstream())) continue;
            throw new IllegalArgumentException("Each federation upstream set item must have a non-null and not empty upstream name");
        }
        URI uri = this.uriWithPath("./parameters/federation-upstream-set/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name));
        UpstreamSetInfo body = new UpstreamSetInfo();
        body.setVhost(vhost);
        body.setName(name);
        body.setValue(details);
        this.rt.put(uri, (Object)body);
    }

    public void deleteUpstreamSet(String vhost, String name) {
        this.deleteIgnoring404(this.uriWithPath("./parameters/federation-upstream-set/" + this.encodePathSegment(vhost) + "/" + this.encodePathSegment(name)));
    }

    public List<UpstreamSetInfo> getUpstreamSets() {
        return this.getParameters("federation-upstream-set", new ParameterizedTypeReference<List<UpstreamSetInfo>>(){});
    }

    public List<UpstreamSetInfo> getUpstreamSets(String vhost) {
        return this.getParameters(vhost, "federation-upstream-set", new ParameterizedTypeReference<List<UpstreamSetInfo>>(){});
    }

    public List<VhostLimits> getVhostLimits() {
        URI uri = this.uriWithPath("./vhost-limits/");
        return this.asListOrNull((Object[])this.getForObjectReturningNullOn404(uri, VhostLimits[].class));
    }

    public VhostLimits getVhostLimits(String vhost) {
        URI uri = this.uriWithPath("./vhost-limits/" + this.encodePathSegment(vhost));
        try {
            VhostLimits limits = (VhostLimits)this.rt.getForObject(uri, VhostLimits.class);
            if (limits == null || limits.getVhost() == null) {
                limits = new VhostLimits(vhost, -1, -1);
            }
            return limits;
        }
        catch (HttpClientErrorException ce) {
            if (ce.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw ce;
        }
    }

    public void limitMaxNumberOfConnections(String vhost, int limit) {
        URI uri = this.uriWithPath("./vhost-limits/" + this.encodePathSegment(vhost) + "/max-connections");
        this.rt.put(uri, Collections.singletonMap("value", limit));
    }

    public void limitMaxNumberOfQueues(String vhost, int limit) {
        URI uri = this.uriWithPath("./vhost-limits/" + this.encodePathSegment(vhost) + "/max-queues");
        this.rt.put(uri, Collections.singletonMap("value", limit));
    }

    public void clearMaxConnectionsLimit(String vhost) {
        URI uri = this.uriWithPath("./vhost-limits/" + this.encodePathSegment(vhost) + "/max-connections");
        this.deleteIgnoring404(uri);
    }

    public void clearMaxQueuesLimit(String vhost) {
        URI uri = this.uriWithPath("./vhost-limits/" + this.encodePathSegment(vhost) + "/max-queues");
        this.deleteIgnoring404(uri);
    }

    private <T> List<T> getParameters(String component, ParameterizedTypeReference<List<T>> responseType) {
        URI uri = this.uriWithPath("./parameters/" + component + "/");
        return (List)this.rt.exchange(uri, HttpMethod.GET, null, responseType).getBody();
    }

    private <T> List<T> getParameters(String vhost, String component, ParameterizedTypeReference<List<T>> responseType) {
        URI uri = this.uriWithPath("./parameters/" + component + "/" + this.encodePathSegment(vhost));
        return this.getForObjectReturningNullOn404(uri, responseType);
    }

    private URI uriWithPath(String path) {
        return this.rootUri.resolve(path);
    }

    private URI uriWithPath(String path, Map<String, String> queryParams) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        queryParams.entrySet().forEach(arg_0 -> Client.lambda$uriWithPath$0((MultiValueMap)map, arg_0));
        DefaultUriBuilderFactory factory = new DefaultUriBuilderFactory();
        factory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        UriBuilder uriBuilder = factory.uriString(this.rootUri.resolve(path).toString());
        uriBuilder.queryParams((MultiValueMap)map);
        return uriBuilder.build(new Object[0]);
    }

    private String encodePathSegment(String pathSegment) {
        return UriUtils.encodePathSegment((String)pathSegment, (String)"UTF-8");
    }

    private List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList xs = new ArrayList();
        Jackson2ObjectMapperBuilder bldr = Jackson2ObjectMapperBuilder.json().serializationInclusion(JsonInclude.Include.NON_NULL).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT}).deserializerByType(VhostLimits.class, Utils.VHOST_LIMITS_JSON_DESERIALIZER);
        xs.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(bldr.build()));
        return xs;
    }

    private <T> T getForObjectReturningNullOn404(URI uri, Class<T> klass) {
        try {
            return (T)this.rt.getForObject(uri, klass);
        }
        catch (HttpClientErrorException ce) {
            if (ce.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw ce;
        }
    }

    private <T> T getForObjectReturningNullOn404(URI uri, ParameterizedTypeReference<T> responseType) {
        ResponseEntity response = this.rt.exchange(uri, HttpMethod.GET, null, responseType);
        if (HttpStatus.NOT_FOUND == response.getStatusCode()) {
            return null;
        }
        return (T)response.getBody();
    }

    private void deleteIgnoring404(URI uri) {
        block2: {
            try {
                this.rt.delete(uri);
            }
            catch (HttpClientErrorException ce) {
                if (ce.getStatusCode() == HttpStatus.NOT_FOUND) break block2;
                throw ce;
            }
        }
    }

    private void deleteIgnoring404(URI uri, MultiValueMap<String, String> headers) {
        block2: {
            try {
                HttpEntity entity = new HttpEntity(null, headers);
                this.rt.exchange(uri, HttpMethod.DELETE, entity, Object.class);
            }
            catch (HttpClientErrorException ce) {
                if (ce.getStatusCode() == HttpStatus.NOT_FOUND) break block2;
                throw ce;
            }
        }
    }

    private <T> List<T> asListOrNull(T[] result) {
        if (result == null) {
            return null;
        }
        return Arrays.asList(result);
    }

    private static /* synthetic */ void lambda$uriWithPath$0(MultiValueMap map, Map.Entry e) {
        map.add(e.getKey(), e.getValue());
    }
}

