/*
 * Decompiled with CFR 0.152.
 */
package reactor.alloc;

import reactor.alloc.Reference;
import reactor.core.support.Recyclable;
import reactor.fn.timer.TimeUtils;

public abstract class AbstractReference<T extends Recyclable>
implements Reference<T> {
    private volatile int refCnt = 0;
    private final long inception;
    private final T obj;

    protected AbstractReference(T obj) {
        this.obj = obj;
        this.inception = TimeUtils.approxCurrentTimeMillis();
    }

    @Override
    public long getAge() {
        return TimeUtils.approxCurrentTimeMillis() - this.inception;
    }

    @Override
    public int getReferenceCount() {
        return this.refCnt;
    }

    @Override
    public void retain() {
        this.retain(1);
    }

    @Override
    public void retain(int incr) {
        this.refCnt += incr;
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int decr) {
        this.refCnt -= Math.min(decr, this.refCnt);
        if (this.refCnt < 1) {
            this.obj.recycle();
        }
    }

    public T get() {
        return this.obj;
    }

    public String toString() {
        return "Reference{refCnt=" + this.refCnt + ", inception=" + this.inception + ", obj=" + this.obj + '}';
    }
}

