/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.generator.ProjectFailedEvent;
import io.spring.initializr.generator.ProjectGeneratedEvent;
import io.spring.initializr.generator.ProjectGenerationMetricsListener;
import io.spring.initializr.generator.ProjectRequest;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.test.InitializrMetadataTestBuilder;
import io.spring.initializr.test.MetricsAssert;
import io.spring.initializr.test.TestCounterService;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Before;
import org.junit.Test;

public class ProjectGenerationMetricsListenerTests
implements GroovyObject {
    private InitializrMetadata metadata;
    private ProjectGenerationMetricsListener listener;
    private MetricsAssert metricsAssert;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProjectGenerationMetricsListenerTests() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"spring-data"));
        this.metadata = (InitializrMetadata)ScriptBytecodeAdapter.castToType((Object)object, InitializrMetadata.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Before
    public void setup() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object counterService = callSiteArray[3].callConstructor(TestCounterService.class);
        Object object = callSiteArray[4].callConstructor(ProjectGenerationMetricsListener.class, counterService);
        this.listener = (ProjectGenerationMetricsListener)ScriptBytecodeAdapter.castToType((Object)object, ProjectGenerationMetricsListener.class);
        Object object2 = callSiteArray[5].callConstructor(MetricsAssert.class, counterService);
        this.metricsAssert = (MetricsAssert)ScriptBytecodeAdapter.castToType((Object)object2, MetricsAssert.class);
    }

    @Test
    public void projectGenerationCount() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[6].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[7].call(request, (Object)this.metadata);
        callSiteArray[8].callCurrent((GroovyObject)this, request);
        callSiteArray[9].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.requests");
    }

    @Test
    public void projectGenerationCountWithFailure() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[10].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[11].call(request, (Object)this.metadata);
        callSiteArray[12].callCurrent((GroovyObject)this, request);
        callSiteArray[13].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.requests");
        callSiteArray[14].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.failures");
    }

    @Test
    public void dependencies() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[15].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].callGetProperty(request), (Object)"security"), (Object)"spring-data");
        callSiteArray[19].call(request, (Object)this.metadata);
        callSiteArray[20].callCurrent((GroovyObject)this, request);
        callSiteArray[21].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.dependency.security", (Object)"initializr.dependency.spring-data");
    }

    @Test
    public void noDependencies() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[22].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[23].call(request, (Object)this.metadata);
        callSiteArray[24].callCurrent((GroovyObject)this, request);
        callSiteArray[25].call((Object)this.metricsAssert, (Object)"initializr.dependency.");
    }

    @Test
    public void resolvedWebDependency() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[26].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[27].call(callSiteArray[28].callGetProperty(request), (Object)"spring-data");
        String string = "war";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packaging");
        callSiteArray[29].call(request, (Object)this.metadata);
        callSiteArray[30].callCurrent((GroovyObject)this, request);
        callSiteArray[31].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.dependency.web", (Object)"initializr.dependency.spring-data");
    }

    @Test
    public void aliasedDependencyUseStandardId() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object dependency = callSiteArray[32].callConstructor(Dependency.class);
        String string = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"id");
        callSiteArray[33].call(callSiteArray[34].callGetProperty(dependency), (Object)"foo-old");
        Object metadata = callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(InitializrMetadataTestBuilder.class), (Object)"core", dependency));
        Object request = callSiteArray[38].callConstructor(ProjectRequest.class);
        callSiteArray[39].call(request, metadata);
        callSiteArray[40].call(callSiteArray[41].callGetProperty(request), (Object)"foo-old");
        callSiteArray[42].call(request, metadata);
        callSiteArray[43].callCurrent((GroovyObject)this, request);
        callSiteArray[44].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.dependency.foo");
    }

    @Test
    public void defaultType() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[45].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[46].call(request, (Object)this.metadata);
        callSiteArray[47].callCurrent((GroovyObject)this, request);
        callSiteArray[48].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.type.maven-project");
    }

    @Test
    public void explicitType() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[49].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        String string = "gradle-build";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        callSiteArray[50].call(request, (Object)this.metadata);
        callSiteArray[51].callCurrent((GroovyObject)this, request);
        callSiteArray[52].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.type.gradle-build");
    }

    @Test
    public void defaultPackaging() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[53].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[54].call(request, (Object)this.metadata);
        callSiteArray[55].callCurrent((GroovyObject)this, request);
        callSiteArray[56].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.packaging.jar");
    }

    @Test
    public void explicitPackaging() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[57].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        String string = "war";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packaging");
        callSiteArray[58].call(request, (Object)this.metadata);
        callSiteArray[59].callCurrent((GroovyObject)this, request);
        callSiteArray[60].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.packaging.war");
    }

    @Test
    public void defaultJavaVersion() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[61].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[62].call(request, (Object)this.metadata);
        callSiteArray[63].callCurrent((GroovyObject)this, request);
        callSiteArray[64].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.java_version.1_8");
    }

    @Test
    public void explicitJavaVersion() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[65].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        String string = "1.7";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"javaVersion");
        callSiteArray[66].call(request, (Object)this.metadata);
        callSiteArray[67].callCurrent((GroovyObject)this, request);
        callSiteArray[68].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.java_version.1_7");
    }

    @Test
    public void defaultLanguage() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[69].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[70].call(request, (Object)this.metadata);
        callSiteArray[71].callCurrent((GroovyObject)this, request);
        callSiteArray[72].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.language.java");
    }

    @Test
    public void explicitGroovyLanguage() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[73].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        String string = "groovy";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"language");
        callSiteArray[74].call(request, (Object)this.metadata);
        callSiteArray[75].callCurrent((GroovyObject)this, request);
        callSiteArray[76].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.language.groovy");
    }

    @Test
    public void explicitKotlinLanguage() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[77].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        String string = "kotlin";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"language");
        callSiteArray[78].call(request, (Object)this.metadata);
        callSiteArray[79].callCurrent((GroovyObject)this, request);
        callSiteArray[80].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.language.kotlin");
    }

    @Test
    public void defaultBootVersion() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[81].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[82].call(request, (Object)this.metadata);
        callSiteArray[83].callCurrent((GroovyObject)this, request);
        callSiteArray[84].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.boot_version.1_2_3_RELEASE");
    }

    @Test
    public void explicitBootVersion() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[85].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        String string = "1.0.2.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[86].call(request, (Object)this.metadata);
        callSiteArray[87].callCurrent((GroovyObject)this, request);
        callSiteArray[88].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.boot_version.1_0_2_RELEASE");
    }

    @Test
    public void userAgentAvailable() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[89].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        String string = "HTTPie/0.9.2";
        callSiteArray[90].call(callSiteArray[91].callGetProperty(request), (Object)"user-agent", (Object)string);
        callSiteArray[92].call(request, (Object)this.metadata);
        callSiteArray[93].callCurrent((GroovyObject)this, request);
        callSiteArray[94].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.client_id.httpie");
    }

    @Test
    public void collectAllMetrics() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[95].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].callGetProperty(request), (Object)"web"), (Object)"security");
        String string = "gradle-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        String string2 = "jar";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"packaging");
        String string3 = "1.6";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)request, (String)"javaVersion");
        String string4 = "groovy";
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)request, (String)"language");
        String string5 = "1.0.2.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)request, (String)"bootVersion");
        String string6 = "SpringBootCli/1.3.0.RELEASE";
        callSiteArray[99].call(callSiteArray[100].callGetProperty(request), (Object)"user-agent", (Object)string6);
        callSiteArray[101].call(request, (Object)this.metadata);
        callSiteArray[102].callCurrent((GroovyObject)this, request);
        callSiteArray[103].call(callSiteArray[104].call((Object)this.metricsAssert, ArrayUtil.createArray((Object)1, (Object)"initializr.requests", (Object)"initializr.dependency.web", (Object)"initializr.dependency.security", (Object)"initializr.type.gradle-project", (Object)"initializr.packaging.jar", (Object)"initializr.java_version.1_6", (Object)"initializr.language.groovy", (Object)"initializr.boot_version.1_0_2_RELEASE", (Object)"initializr.client_id.spring")), (Object)9);
    }

    @Test
    public void incrementMetrics() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[105].callCurrent((GroovyObject)this);
            request = object;
        } else {
            ProjectRequest projectRequest;
            request = projectRequest = this.initialize();
        }
        callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].callGetProperty(request), (Object)"security"), (Object)"spring-data");
        callSiteArray[109].call(request, (Object)this.metadata);
        callSiteArray[110].callCurrent((GroovyObject)this, request);
        callSiteArray[111].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.requests", (Object)"initializr.dependency.security", (Object)"initializr.dependency.spring-data");
        Object anotherRequest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[112].callCurrent((GroovyObject)this);
            anotherRequest = object;
        } else {
            ProjectRequest projectRequest;
            anotherRequest = projectRequest = this.initialize();
        }
        callSiteArray[113].call(callSiteArray[114].call(callSiteArray[115].callGetProperty(anotherRequest), (Object)"web"), (Object)"spring-data");
        callSiteArray[116].call(anotherRequest, (Object)this.metadata);
        callSiteArray[117].callCurrent((GroovyObject)this, anotherRequest);
        callSiteArray[118].call((Object)this.metricsAssert, (Object)2, (Object)"initializr.dependency.spring-data", (Object)"initializr.dependency.spring-data");
        callSiteArray[119].call((Object)this.metricsAssert, (Object)1, (Object)"initializr.dependency.web", (Object)"initializr.dependency.security");
    }

    private Object fireProjectGeneratedEvent(ProjectRequest projectRequest) {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        return callSiteArray[120].call((Object)this.listener, callSiteArray[121].callConstructor(ProjectGeneratedEvent.class, (Object)projectRequest));
    }

    private Object fireProjectFailedEvent(ProjectRequest projectRequest) {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        return callSiteArray[122].call((Object)this.listener, callSiteArray[123].callConstructor(ProjectFailedEvent.class, (Object)projectRequest, null));
    }

    private ProjectRequest initialize() {
        CallSite[] callSiteArray = ProjectGenerationMetricsListenerTests.$getCallSiteArray();
        Object request = callSiteArray[124].callConstructor(ProjectRequest.class);
        callSiteArray[125].call(request, (Object)this.metadata);
        return (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)request, ProjectRequest.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectGenerationMetricsListenerTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "build";
        stringArray[1] = "addDependencyGroup";
        stringArray[2] = "withDefaults";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "initialize";
        stringArray[7] = "resolve";
        stringArray[8] = "fireProjectGeneratedEvent";
        stringArray[9] = "hasValue";
        stringArray[10] = "initialize";
        stringArray[11] = "resolve";
        stringArray[12] = "fireProjectFailedEvent";
        stringArray[13] = "hasValue";
        stringArray[14] = "hasValue";
        stringArray[15] = "initialize";
        stringArray[16] = "leftShift";
        stringArray[17] = "leftShift";
        stringArray[18] = "style";
        stringArray[19] = "resolve";
        stringArray[20] = "fireProjectGeneratedEvent";
        stringArray[21] = "hasValue";
        stringArray[22] = "initialize";
        stringArray[23] = "resolve";
        stringArray[24] = "fireProjectGeneratedEvent";
        stringArray[25] = "hasNoValue";
        stringArray[26] = "initialize";
        stringArray[27] = "leftShift";
        stringArray[28] = "style";
        stringArray[29] = "resolve";
        stringArray[30] = "fireProjectGeneratedEvent";
        stringArray[31] = "hasValue";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "leftShift";
        stringArray[34] = "aliases";
        stringArray[35] = "build";
        stringArray[36] = "addDependencyGroup";
        stringArray[37] = "withDefaults";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "initialize";
        stringArray[40] = "leftShift";
        stringArray[41] = "style";
        stringArray[42] = "resolve";
        stringArray[43] = "fireProjectGeneratedEvent";
        stringArray[44] = "hasValue";
        stringArray[45] = "initialize";
        stringArray[46] = "resolve";
        stringArray[47] = "fireProjectGeneratedEvent";
        stringArray[48] = "hasValue";
        stringArray[49] = "initialize";
        stringArray[50] = "resolve";
        stringArray[51] = "fireProjectGeneratedEvent";
        stringArray[52] = "hasValue";
        stringArray[53] = "initialize";
        stringArray[54] = "resolve";
        stringArray[55] = "fireProjectGeneratedEvent";
        stringArray[56] = "hasValue";
        stringArray[57] = "initialize";
        stringArray[58] = "resolve";
        stringArray[59] = "fireProjectGeneratedEvent";
        stringArray[60] = "hasValue";
        stringArray[61] = "initialize";
        stringArray[62] = "resolve";
        stringArray[63] = "fireProjectGeneratedEvent";
        stringArray[64] = "hasValue";
        stringArray[65] = "initialize";
        stringArray[66] = "resolve";
        stringArray[67] = "fireProjectGeneratedEvent";
        stringArray[68] = "hasValue";
        stringArray[69] = "initialize";
        stringArray[70] = "resolve";
        stringArray[71] = "fireProjectGeneratedEvent";
        stringArray[72] = "hasValue";
        stringArray[73] = "initialize";
        stringArray[74] = "resolve";
        stringArray[75] = "fireProjectGeneratedEvent";
        stringArray[76] = "hasValue";
        stringArray[77] = "initialize";
        stringArray[78] = "resolve";
        stringArray[79] = "fireProjectGeneratedEvent";
        stringArray[80] = "hasValue";
        stringArray[81] = "initialize";
        stringArray[82] = "resolve";
        stringArray[83] = "fireProjectGeneratedEvent";
        stringArray[84] = "hasValue";
        stringArray[85] = "initialize";
        stringArray[86] = "resolve";
        stringArray[87] = "fireProjectGeneratedEvent";
        stringArray[88] = "hasValue";
        stringArray[89] = "initialize";
        stringArray[90] = "putAt";
        stringArray[91] = "parameters";
        stringArray[92] = "resolve";
        stringArray[93] = "fireProjectGeneratedEvent";
        stringArray[94] = "hasValue";
        stringArray[95] = "initialize";
        stringArray[96] = "leftShift";
        stringArray[97] = "leftShift";
        stringArray[98] = "style";
        stringArray[99] = "putAt";
        stringArray[100] = "parameters";
        stringArray[101] = "resolve";
        stringArray[102] = "fireProjectGeneratedEvent";
        stringArray[103] = "metricsCount";
        stringArray[104] = "hasValue";
        stringArray[105] = "initialize";
        stringArray[106] = "leftShift";
        stringArray[107] = "leftShift";
        stringArray[108] = "style";
        stringArray[109] = "resolve";
        stringArray[110] = "fireProjectGeneratedEvent";
        stringArray[111] = "hasValue";
        stringArray[112] = "initialize";
        stringArray[113] = "leftShift";
        stringArray[114] = "leftShift";
        stringArray[115] = "style";
        stringArray[116] = "resolve";
        stringArray[117] = "fireProjectGeneratedEvent";
        stringArray[118] = "hasValue";
        stringArray[119] = "hasValue";
        stringArray[120] = "onGeneratedProject";
        stringArray[121] = "<$constructor$>";
        stringArray[122] = "onFailedProject";
        stringArray[123] = "<$constructor$>";
        stringArray[124] = "<$constructor$>";
        stringArray[125] = "initialize";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[126];
        ProjectGenerationMetricsListenerTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProjectGenerationMetricsListenerTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProjectGenerationMetricsListenerTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

