/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.generator.InvalidProjectRequestException;
import io.spring.initializr.generator.ProjectRequest;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadataBuilder;
import io.spring.initializr.test.InitializrMetadataTestBuilder;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ProjectRequestTests
implements GroovyObject {
    @Rule
    public final ExpectedException thrown;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProjectRequestTests() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object object = callSiteArray[0].call(ExpectedException.class);
        this.thrown = (ExpectedException)ScriptBytecodeAdapter.castToType((Object)object, ExpectedException.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void initializeProjectRequest() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object metadata = callSiteArray[1].call(callSiteArray[2].call(InitializrMetadataBuilder.class));
        String string = "org.acme";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)callSiteArray[3].callGetProperty(metadata), (String)"content");
        String string2 = "my-project";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)callSiteArray[4].callGetProperty(metadata), (String)"content");
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callConstructor(ProjectRequest.class), ProjectRequest.class);
        callSiteArray[6].call((Object)request, metadata);
        callSiteArray[7].callStatic(Assert.class, (Object)"org.acme", callSiteArray[8].callGroovyObjectGetProperty((Object)request));
        callSiteArray[9].callStatic(Assert.class, (Object)"my-project", callSiteArray[10].callGroovyObjectGetProperty((Object)request));
    }

    @Test
    public void initializeProjectRequestWithDefaults() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object metadata = callSiteArray[11].call(callSiteArray[12].call(InitializrMetadataTestBuilder.class));
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callConstructor(ProjectRequest.class), ProjectRequest.class);
        callSiteArray[14].call((Object)request, metadata);
        callSiteArray[15].callStatic(Assert.class, callSiteArray[16].callGetProperty(callSiteArray[17].callGetProperty(metadata)), callSiteArray[18].callGroovyObjectGetProperty((Object)request));
        callSiteArray[19].callStatic(Assert.class, callSiteArray[20].callGetProperty(callSiteArray[21].callGetProperty(callSiteArray[22].callGetProperty(metadata))), callSiteArray[23].callGroovyObjectGetProperty((Object)request));
        callSiteArray[24].callStatic(Assert.class, callSiteArray[25].callGetProperty(callSiteArray[26].callGetProperty(metadata)), callSiteArray[27].callGroovyObjectGetProperty((Object)request));
        callSiteArray[28].callStatic(Assert.class, callSiteArray[29].callGetProperty(callSiteArray[30].callGetProperty(metadata)), callSiteArray[31].callGroovyObjectGetProperty((Object)request));
        callSiteArray[32].callStatic(Assert.class, callSiteArray[33].callGetProperty(callSiteArray[34].callGetProperty(metadata)), callSiteArray[35].callGroovyObjectGetProperty((Object)request));
        callSiteArray[36].callStatic(Assert.class, callSiteArray[37].callGetProperty(callSiteArray[38].callGetProperty(metadata)), callSiteArray[39].callGroovyObjectGetProperty((Object)request));
        callSiteArray[40].callStatic(Assert.class, callSiteArray[41].callGetProperty(callSiteArray[42].callGetProperty(callSiteArray[43].callGetProperty(metadata))), callSiteArray[44].callGroovyObjectGetProperty((Object)request));
        callSiteArray[45].callStatic(Assert.class, callSiteArray[46].callGetProperty(callSiteArray[47].callGetProperty(callSiteArray[48].callGetProperty(metadata))), callSiteArray[49].callGroovyObjectGetProperty((Object)request));
    }

    @Test
    public void resolve() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[50].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(InitializrMetadataTestBuilder.class), (Object)"code", (Object)"web", (Object)"security", (Object)"spring-data"));
        String string = "maven-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].callGetProperty(request), (Object)"web"), (Object)"spring-data");
        callSiteArray[57].call(request, metadata);
        callSiteArray[58].callStatic(Assert.class, (Object)"Build type not detected", (Object)"maven", callSiteArray[59].callGetProperty(request));
        callSiteArray[60].callStatic(ProjectRequestTests.class, callSiteArray[61].call(callSiteArray[62].callGetProperty(request), (Object)0), (Object)"web");
        callSiteArray[63].callStatic(ProjectRequestTests.class, callSiteArray[64].call(callSiteArray[65].callGetProperty(request), (Object)1), (Object)"spring-data");
    }

    @Test
    public void resolveWithDependencies() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[66].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[67].call(callSiteArray[68].call(callSiteArray[69].call(InitializrMetadataTestBuilder.class), (Object)"code", (Object)"web", (Object)"security", (Object)"spring-data"));
        String string = "maven-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        callSiteArray[70].call(callSiteArray[71].call(callSiteArray[72].callGetProperty(request), (Object)"web"), (Object)"spring-data");
        callSiteArray[73].call(request, metadata);
        callSiteArray[74].callStatic(Assert.class, (Object)"Build type not detected", (Object)"maven", callSiteArray[75].callGetProperty(request));
        callSiteArray[76].callStatic(ProjectRequestTests.class, callSiteArray[77].call(callSiteArray[78].callGetProperty(request), (Object)0), (Object)"web");
        callSiteArray[79].callStatic(ProjectRequestTests.class, callSiteArray[80].call(callSiteArray[81].callGetProperty(request), (Object)1), (Object)"spring-data");
    }

    @Test
    public void resolveFullMetadata() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[82].callConstructor(ProjectRequest.class);
        Object metadata = null;
        metadata = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call(InitializrMetadataTestBuilder.class), (Object)"code", callSiteArray[86].callStatic(ProjectRequestTests.class, (Object)"org.foo", (Object)"acme", (Object)"1.2.0")))) : (object = callSiteArray[87].call(callSiteArray[88].call(callSiteArray[89].call(InitializrMetadataTestBuilder.class), (Object)"code", (Object)ProjectRequestTests.createDependency("org.foo", "acme", "1.2.0"))));
        callSiteArray[90].call(callSiteArray[91].callGetProperty(request), (Object)"org.foo:acme");
        callSiteArray[92].call(request, metadata);
        callSiteArray[93].callStatic(ProjectRequestTests.class, callSiteArray[94].call(callSiteArray[95].callGetProperty(request), (Object)0), (Object)"org.foo", (Object)"acme", (Object)"1.2.0");
    }

    @Test
    public void resolveUnknownSimpleIdAsSpringBootStarter() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[96].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call(InitializrMetadataTestBuilder.class), (Object)"code", (Object)"org.foo:bar"));
        callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].callGetProperty(request), (Object)"org.foo:bar"), (Object)"foo-bar");
        callSiteArray[103].call(request, metadata);
        callSiteArray[104].callStatic(ProjectRequestTests.class, callSiteArray[105].call(callSiteArray[106].callGetProperty(request), (Object)0), (Object)"org.foo", (Object)"bar", null);
        callSiteArray[107].callStatic(ProjectRequestTests.class, callSiteArray[108].call(callSiteArray[109].callGetProperty(request), (Object)1), (Object)"foo-bar");
    }

    @Test
    public void resolveUnknownDependency() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[110].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(InitializrMetadataTestBuilder.class), (Object)"code", (Object)"org.foo:bar"));
        callSiteArray[114].call(callSiteArray[115].callGetProperty(request), (Object)"org.foo:acme");
        callSiteArray[116].call((Object)this.thrown, InvalidProjectRequestException.class);
        callSiteArray[117].call((Object)this.thrown, (Object)"org.foo:acme");
        callSiteArray[118].call(request, metadata);
        callSiteArray[119].callStatic(Assert.class, (Object)1, callSiteArray[120].call(callSiteArray[121].callGetProperty(request)));
    }

    @Test
    public void resolveDependencyInRange() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[122].callConstructor(ProjectRequest.class);
        Object dependency = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[123].callStatic(ProjectRequestTests.class, (Object)"org.foo", (Object)"bar", (Object)"1.2.0.RELEASE");
            dependency = object;
        } else {
            Dependency dependency2;
            dependency = dependency2 = ProjectRequestTests.createDependency("org.foo", "bar", "1.2.0.RELEASE");
        }
        String string = "[1.0.1.RELEASE, 1.2.0.RELEASE)";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"versionRange");
        Object metadata = callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].call(InitializrMetadataTestBuilder.class), (Object)"code", dependency));
        callSiteArray[127].call(callSiteArray[128].callGetProperty(request), (Object)"org.foo:bar");
        String string2 = "1.1.2.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"bootVersion");
        callSiteArray[129].call(request, metadata);
    }

    @Test
    public void resolveDependencyNotInRange() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[130].callConstructor(ProjectRequest.class);
        Object dependency = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[131].callStatic(ProjectRequestTests.class, (Object)"org.foo", (Object)"bar", (Object)"1.2.0.RELEASE");
            dependency = object;
        } else {
            Dependency dependency2;
            dependency = dependency2 = ProjectRequestTests.createDependency("org.foo", "bar", "1.2.0.RELEASE");
        }
        String string = "[1.0.1.RELEASE, 1.2.0.RELEASE)";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"versionRange");
        Object metadata = callSiteArray[132].call(callSiteArray[133].call(callSiteArray[134].call(InitializrMetadataTestBuilder.class), (Object)"code", dependency));
        callSiteArray[135].call(callSiteArray[136].callGetProperty(request), (Object)"org.foo:bar");
        String string2 = "0.9.9.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"bootVersion");
        callSiteArray[137].call((Object)this.thrown, InvalidProjectRequestException.class);
        callSiteArray[138].call((Object)this.thrown, (Object)"org.foo:bar");
        callSiteArray[139].call((Object)this.thrown, (Object)"0.9.9.RELEASE");
        callSiteArray[140].call(request, metadata);
    }

    @Test
    public void resolveDependencyVersion() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object dependency = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[141].callStatic(ProjectRequestTests.class, (Object)"org.foo", (Object)"bar", (Object)"1.2.0.RELEASE");
            dependency = object;
        } else {
            Dependency dependency2;
            dependency = dependency2 = ProjectRequestTests.createDependency("org.foo", "bar", "1.2.0.RELEASE");
        }
        callSiteArray[142].call(callSiteArray[143].callGetProperty(dependency), callSiteArray[144].callConstructor(Dependency.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"version", "0.1.0.RELEASE", "versionRange", "[1.0.0.RELEASE, 1.1.0.RELEASE)"})));
        callSiteArray[145].call(callSiteArray[146].callGetProperty(dependency), callSiteArray[147].callConstructor(Dependency.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"version", "0.2.0.RELEASE", "versionRange", "1.1.0.RELEASE"})));
        Object metadata = callSiteArray[148].call(callSiteArray[149].call(callSiteArray[150].call(InitializrMetadataTestBuilder.class), (Object)"code", dependency));
        Object request = callSiteArray[151].callConstructor(ProjectRequest.class);
        String string = "1.0.5.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[152].call(callSiteArray[153].callGetProperty(request), (Object)"org.foo:bar");
        callSiteArray[154].call(request, metadata);
        callSiteArray[155].callStatic(ProjectRequestTests.class, callSiteArray[156].call(callSiteArray[157].callGetProperty(request), (Object)0), (Object)"org.foo", (Object)"bar", (Object)"0.1.0.RELEASE");
        Object anotherRequest = callSiteArray[158].callConstructor(ProjectRequest.class);
        String string2 = "1.1.0.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)anotherRequest, (String)"bootVersion");
        callSiteArray[159].call(callSiteArray[160].callGetProperty(anotherRequest), (Object)"org.foo:bar");
        callSiteArray[161].call(anotherRequest, metadata);
        callSiteArray[162].callStatic(ProjectRequestTests.class, callSiteArray[163].call(callSiteArray[164].callGetProperty(anotherRequest), (Object)0), (Object)"org.foo", (Object)"bar", (Object)"0.2.0.RELEASE");
    }

    @Test
    public void resolveBuild() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[165].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[166].call(callSiteArray[167].call(InitializrMetadataTestBuilder.class));
        String string = "gradle-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        callSiteArray[168].call(request, metadata);
        callSiteArray[169].callStatic(Assert.class, (Object)"gradle", callSiteArray[170].callGetProperty(request));
    }

    @Test
    public void resolveBuildNoTag() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[171].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[172].call(callSiteArray[173].call(callSiteArray[174].call(InitializrMetadataTestBuilder.class), ArrayUtil.createArray((Object)"foo", (Object)false, (Object)"/foo.zip", null, null)));
        String string = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        callSiteArray[175].call(request, metadata);
        callSiteArray[176].callStatic(Assert.class, callSiteArray[177].callGetProperty(request));
    }

    @Test
    public void resolveUnknownType() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[178].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[179].call(callSiteArray[180].call(InitializrMetadataTestBuilder.class));
        String string = "foo-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        callSiteArray[181].call((Object)this.thrown, InvalidProjectRequestException.class);
        callSiteArray[182].call((Object)this.thrown, (Object)"foo-project");
        callSiteArray[183].call(request, metadata);
    }

    @Test
    public void resolveApplicationNameWithNoName() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[184].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[185].call(callSiteArray[186].call(InitializrMetadataTestBuilder.class));
        callSiteArray[187].call(request, metadata);
        callSiteArray[188].callStatic(Assert.class, callSiteArray[189].callGetProperty(callSiteArray[190].callGetProperty(callSiteArray[191].callGetProperty(metadata))), callSiteArray[192].callGetProperty(request));
    }

    @Test
    public void resolveApplicationName() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[193].callConstructor(ProjectRequest.class);
        String string = "Foo2";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"name");
        Object metadata = callSiteArray[194].call(callSiteArray[195].call(InitializrMetadataTestBuilder.class));
        callSiteArray[196].call(request, metadata);
        callSiteArray[197].callStatic(Assert.class, (Object)"Foo2Application", callSiteArray[198].callGetProperty(request));
    }

    @Test
    public void resolveApplicationNameWithApplicationNameSet() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[199].callConstructor(ProjectRequest.class);
        String string = "Foo2";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"name");
        String string2 = "MyApplicationName";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"applicationName");
        Object metadata = callSiteArray[200].call(callSiteArray[201].call(InitializrMetadataTestBuilder.class));
        callSiteArray[202].call(request, metadata);
        callSiteArray[203].callStatic(Assert.class, (Object)"MyApplicationName", callSiteArray[204].callGetProperty(request));
    }

    @Test
    public void cleanPackageNameWithNoName() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[205].callConstructor(ProjectRequest.class);
        Object metadata = callSiteArray[206].call(callSiteArray[207].call(InitializrMetadataTestBuilder.class));
        callSiteArray[208].call(request, metadata);
        callSiteArray[209].callStatic(Assert.class, callSiteArray[210].callGetProperty(callSiteArray[211].callGetProperty(metadata)), callSiteArray[212].callGetProperty(request));
    }

    @Test
    public void cleanPackageName() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[213].callConstructor(ProjectRequest.class);
        String string = "com:foo  bar";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packageName");
        Object metadata = callSiteArray[214].call(callSiteArray[215].call(InitializrMetadataTestBuilder.class));
        callSiteArray[216].call(request, metadata);
        callSiteArray[217].callStatic(Assert.class, (Object)"com.foo.bar", callSiteArray[218].callGetProperty(request));
    }

    @Test
    public void resolveAdditionalBoms() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[219].callConstructor(ProjectRequest.class);
        Object dependency = callSiteArray[220].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "bom", "foo-bom"}));
        Object bom = callSiteArray[221].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "com.example", "artifactId", "foo-bom", "version", "1.0.0", "additionalBoms", ScriptBytecodeAdapter.createList((Object[])new Object[]{"bar-bom"})}));
        Object additionalBom = callSiteArray[222].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "com.example", "artifactId", "bar-bom", "version", "1.1.0"}));
        Object metadata = callSiteArray[223].call(callSiteArray[224].call(callSiteArray[225].call(callSiteArray[226].call(callSiteArray[227].call(InitializrMetadataTestBuilder.class), (Object)"foo-bom", bom), (Object)"bar-bom", additionalBom), (Object)"test", dependency));
        callSiteArray[228].call(callSiteArray[229].callGetProperty(request), (Object)"foo");
        callSiteArray[230].call(request, metadata);
        callSiteArray[231].callStatic(Assert.class, (Object)1, callSiteArray[232].call(callSiteArray[233].callGetProperty(request)));
        callSiteArray[234].callStatic(Assert.class, (Object)2, callSiteArray[235].call(callSiteArray[236].callGetProperty(request)));
        callSiteArray[237].callStatic(Assert.class, bom, callSiteArray[238].call(callSiteArray[239].callGetProperty(request), (Object)"foo-bom"));
        callSiteArray[240].callStatic(Assert.class, additionalBom, callSiteArray[241].call(callSiteArray[242].callGetProperty(request), (Object)"bar-bom"));
    }

    @Test
    public void resolveAdditionalBomsDuplicates() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[243].callConstructor(ProjectRequest.class);
        Object dependency = callSiteArray[244].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "bom", "foo-bom"}));
        Object anotherDependency = callSiteArray[245].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "bar", "bom", "bar-bom"}));
        Object bom = callSiteArray[246].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "com.example", "artifactId", "foo-bom", "version", "1.0.0", "additionalBoms", ScriptBytecodeAdapter.createList((Object[])new Object[]{"bar-bom"})}));
        Object additionalBom = callSiteArray[247].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "com.example", "artifactId", "bar-bom", "version", "1.1.0"}));
        Object metadata = callSiteArray[248].call(callSiteArray[249].call(callSiteArray[250].call(callSiteArray[251].call(callSiteArray[252].call(InitializrMetadataTestBuilder.class), (Object)"foo-bom", bom), (Object)"bar-bom", additionalBom), (Object)"test", dependency, anotherDependency));
        callSiteArray[253].call(callSiteArray[254].call(callSiteArray[255].callGetProperty(request), (Object)"foo"), (Object)"bar");
        callSiteArray[256].call(request, metadata);
        callSiteArray[257].callStatic(Assert.class, (Object)2, callSiteArray[258].call(callSiteArray[259].callGetProperty(request)));
        callSiteArray[260].callStatic(Assert.class, (Object)2, callSiteArray[261].call(callSiteArray[262].callGetProperty(request)));
        callSiteArray[263].callStatic(Assert.class, bom, callSiteArray[264].call(callSiteArray[265].callGetProperty(request), (Object)"foo-bom"));
        callSiteArray[266].callStatic(Assert.class, additionalBom, callSiteArray[267].call(callSiteArray[268].callGetProperty(request), (Object)"bar-bom"));
    }

    @Test
    public void resolveAdditionalRepositories() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[269].callConstructor(ProjectRequest.class);
        Object dependency = callSiteArray[270].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "bom", "foo-bom", "repository", "foo-repo"}));
        Object bom = callSiteArray[271].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "com.example", "artifactId", "foo-bom", "version", "1.0.0", "repositories", ScriptBytecodeAdapter.createList((Object[])new Object[]{"bar-repo"})}));
        Object metadata = callSiteArray[272].call(callSiteArray[273].call(callSiteArray[274].call(callSiteArray[275].call(callSiteArray[276].call(callSiteArray[277].call(InitializrMetadataTestBuilder.class), (Object)"foo-bom", bom), (Object)"foo-repo", (Object)"foo-repo", (Object)"http://example.com/foo", (Object)false), (Object)"bar-repo", (Object)"bar-repo", (Object)"http://example.com/bar", (Object)false), (Object)"test", dependency));
        callSiteArray[278].call(callSiteArray[279].callGetProperty(request), (Object)"foo");
        callSiteArray[280].call(request, metadata);
        callSiteArray[281].callStatic(Assert.class, (Object)1, callSiteArray[282].call(callSiteArray[283].callGetProperty(request)));
        callSiteArray[284].callStatic(Assert.class, (Object)1, callSiteArray[285].call(callSiteArray[286].callGetProperty(request)));
        callSiteArray[287].callStatic(Assert.class, (Object)2, callSiteArray[288].call(callSiteArray[289].callGetProperty(request)));
        callSiteArray[290].callStatic(Assert.class, callSiteArray[291].call(callSiteArray[292].callGetProperty(callSiteArray[293].callGetProperty(callSiteArray[294].callGetProperty(metadata))), (Object)"foo-repo"), callSiteArray[295].call(callSiteArray[296].callGetProperty(request), (Object)"foo-repo"));
        callSiteArray[297].callStatic(Assert.class, callSiteArray[298].call(callSiteArray[299].callGetProperty(callSiteArray[300].callGetProperty(callSiteArray[301].callGetProperty(metadata))), (Object)"bar-repo"), callSiteArray[302].call(callSiteArray[303].callGetProperty(request), (Object)"bar-repo"));
    }

    @Test
    public void resolveAdditionalRepositoriesDuplicates() {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object request = callSiteArray[304].callConstructor(ProjectRequest.class);
        Object dependency = callSiteArray[305].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "bom", "foo-bom", "repository", "foo-repo"}));
        Object anotherDependency = callSiteArray[306].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "bar", "repository", "bar-repo"}));
        Object bom = callSiteArray[307].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "com.example", "artifactId", "foo-bom", "version", "1.0.0", "repositories", ScriptBytecodeAdapter.createList((Object[])new Object[]{"bar-repo"})}));
        Object metadata = callSiteArray[308].call(callSiteArray[309].call(callSiteArray[310].call(callSiteArray[311].call(callSiteArray[312].call(callSiteArray[313].call(InitializrMetadataTestBuilder.class), (Object)"foo-bom", bom), (Object)"foo-repo", (Object)"foo-repo", (Object)"http://example.com/foo", (Object)false), (Object)"bar-repo", (Object)"bar-repo", (Object)"http://example.com/bar", (Object)false), (Object)"test", dependency, anotherDependency));
        callSiteArray[314].call(callSiteArray[315].call(callSiteArray[316].callGetProperty(request), (Object)"foo"), (Object)"bar");
        callSiteArray[317].call(request, metadata);
        callSiteArray[318].callStatic(Assert.class, (Object)2, callSiteArray[319].call(callSiteArray[320].callGetProperty(request)));
        callSiteArray[321].callStatic(Assert.class, (Object)1, callSiteArray[322].call(callSiteArray[323].callGetProperty(request)));
        callSiteArray[324].callStatic(Assert.class, (Object)2, callSiteArray[325].call(callSiteArray[326].callGetProperty(request)));
        callSiteArray[327].callStatic(Assert.class, callSiteArray[328].call(callSiteArray[329].callGetProperty(callSiteArray[330].callGetProperty(callSiteArray[331].callGetProperty(metadata))), (Object)"foo-repo"), callSiteArray[332].call(callSiteArray[333].callGetProperty(request), (Object)"foo-repo"));
        callSiteArray[334].callStatic(Assert.class, callSiteArray[335].call(callSiteArray[336].callGetProperty(callSiteArray[337].callGetProperty(callSiteArray[338].callGetProperty(metadata))), (Object)"bar-repo"), callSiteArray[339].call(callSiteArray[340].callGetProperty(request), (Object)"bar-repo"));
    }

    private static void assertBootStarter(Dependency actual, String name) {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        Object expected = callSiteArray[341].callConstructor(Dependency.class);
        callSiteArray[342].call(expected, (Object)name);
        callSiteArray[343].callStatic(ProjectRequestTests.class, (Object)actual, callSiteArray[344].callGetProperty(expected), callSiteArray[345].callGetProperty(expected), callSiteArray[346].callGetProperty(expected));
        callSiteArray[347].callStatic(Assert.class, (Object)name, callSiteArray[348].callGroovyObjectGetProperty((Object)actual));
    }

    private static Dependency createDependency(String groupId, String artifactId, String version) {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        return (Dependency)ScriptBytecodeAdapter.castToType((Object)callSiteArray[349].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", groupId, "artifactId", artifactId, "version", version})), Dependency.class);
    }

    private static void assertDependency(Dependency actual, String groupId, String artifactId, String version) {
        CallSite[] callSiteArray = ProjectRequestTests.$getCallSiteArray();
        callSiteArray[350].callStatic(Assert.class, (Object)groupId, callSiteArray[351].callGroovyObjectGetProperty((Object)actual));
        callSiteArray[352].callStatic(Assert.class, (Object)artifactId, callSiteArray[353].callGroovyObjectGetProperty((Object)actual));
        callSiteArray[354].callStatic(Assert.class, (Object)version, callSiteArray[355].callGroovyObjectGetProperty((Object)actual));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectRequestTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "none";
        stringArray[1] = "build";
        stringArray[2] = "create";
        stringArray[3] = "groupId";
        stringArray[4] = "artifactId";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "initialize";
        stringArray[7] = "assertEquals";
        stringArray[8] = "groupId";
        stringArray[9] = "assertEquals";
        stringArray[10] = "artifactId";
        stringArray[11] = "build";
        stringArray[12] = "withDefaults";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "initialize";
        stringArray[15] = "assertEquals";
        stringArray[16] = "content";
        stringArray[17] = "name";
        stringArray[18] = "name";
        stringArray[19] = "assertEquals";
        stringArray[20] = "id";
        stringArray[21] = "default";
        stringArray[22] = "types";
        stringArray[23] = "type";
        stringArray[24] = "assertEquals";
        stringArray[25] = "content";
        stringArray[26] = "description";
        stringArray[27] = "description";
        stringArray[28] = "assertEquals";
        stringArray[29] = "content";
        stringArray[30] = "groupId";
        stringArray[31] = "groupId";
        stringArray[32] = "assertEquals";
        stringArray[33] = "content";
        stringArray[34] = "artifactId";
        stringArray[35] = "artifactId";
        stringArray[36] = "assertEquals";
        stringArray[37] = "content";
        stringArray[38] = "version";
        stringArray[39] = "version";
        stringArray[40] = "assertEquals";
        stringArray[41] = "id";
        stringArray[42] = "default";
        stringArray[43] = "bootVersions";
        stringArray[44] = "bootVersion";
        stringArray[45] = "assertEquals";
        stringArray[46] = "id";
        stringArray[47] = "default";
        stringArray[48] = "packagings";
        stringArray[49] = "packaging";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "build";
        stringArray[52] = "addDependencyGroup";
        stringArray[53] = "withDefaults";
        stringArray[54] = "leftShift";
        stringArray[55] = "leftShift";
        stringArray[56] = "style";
        stringArray[57] = "resolve";
        stringArray[58] = "assertEquals";
        stringArray[59] = "build";
        stringArray[60] = "assertBootStarter";
        stringArray[61] = "getAt";
        stringArray[62] = "resolvedDependencies";
        stringArray[63] = "assertBootStarter";
        stringArray[64] = "getAt";
        stringArray[65] = "resolvedDependencies";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "build";
        stringArray[68] = "addDependencyGroup";
        stringArray[69] = "withDefaults";
        stringArray[70] = "leftShift";
        stringArray[71] = "leftShift";
        stringArray[72] = "dependencies";
        stringArray[73] = "resolve";
        stringArray[74] = "assertEquals";
        stringArray[75] = "build";
        stringArray[76] = "assertBootStarter";
        stringArray[77] = "getAt";
        stringArray[78] = "resolvedDependencies";
        stringArray[79] = "assertBootStarter";
        stringArray[80] = "getAt";
        stringArray[81] = "resolvedDependencies";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "build";
        stringArray[84] = "addDependencyGroup";
        stringArray[85] = "withDefaults";
        stringArray[86] = "createDependency";
        stringArray[87] = "build";
        stringArray[88] = "addDependencyGroup";
        stringArray[89] = "withDefaults";
        stringArray[90] = "leftShift";
        stringArray[91] = "style";
        stringArray[92] = "resolve";
        stringArray[93] = "assertDependency";
        stringArray[94] = "getAt";
        stringArray[95] = "resolvedDependencies";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "build";
        stringArray[98] = "addDependencyGroup";
        stringArray[99] = "withDefaults";
        stringArray[100] = "leftShift";
        stringArray[101] = "leftShift";
        stringArray[102] = "style";
        stringArray[103] = "resolve";
        stringArray[104] = "assertDependency";
        stringArray[105] = "getAt";
        stringArray[106] = "resolvedDependencies";
        stringArray[107] = "assertBootStarter";
        stringArray[108] = "getAt";
        stringArray[109] = "resolvedDependencies";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "build";
        stringArray[112] = "addDependencyGroup";
        stringArray[113] = "withDefaults";
        stringArray[114] = "leftShift";
        stringArray[115] = "style";
        stringArray[116] = "expect";
        stringArray[117] = "expectMessage";
        stringArray[118] = "resolve";
        stringArray[119] = "assertEquals";
        stringArray[120] = "size";
        stringArray[121] = "resolvedDependencies";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "createDependency";
        stringArray[124] = "build";
        stringArray[125] = "addDependencyGroup";
        stringArray[126] = "withDefaults";
        stringArray[127] = "leftShift";
        stringArray[128] = "style";
        stringArray[129] = "resolve";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "createDependency";
        stringArray[132] = "build";
        stringArray[133] = "addDependencyGroup";
        stringArray[134] = "withDefaults";
        stringArray[135] = "leftShift";
        stringArray[136] = "style";
        stringArray[137] = "expect";
        stringArray[138] = "expectMessage";
        stringArray[139] = "expectMessage";
        stringArray[140] = "resolve";
        stringArray[141] = "createDependency";
        stringArray[142] = "leftShift";
        stringArray[143] = "versions";
        stringArray[144] = "<$constructor$>";
        stringArray[145] = "leftShift";
        stringArray[146] = "versions";
        stringArray[147] = "<$constructor$>";
        stringArray[148] = "build";
        stringArray[149] = "addDependencyGroup";
        stringArray[150] = "withDefaults";
        stringArray[151] = "<$constructor$>";
        stringArray[152] = "leftShift";
        stringArray[153] = "style";
        stringArray[154] = "resolve";
        stringArray[155] = "assertDependency";
        stringArray[156] = "getAt";
        stringArray[157] = "resolvedDependencies";
        stringArray[158] = "<$constructor$>";
        stringArray[159] = "leftShift";
        stringArray[160] = "style";
        stringArray[161] = "resolve";
        stringArray[162] = "assertDependency";
        stringArray[163] = "getAt";
        stringArray[164] = "resolvedDependencies";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "build";
        stringArray[167] = "withDefaults";
        stringArray[168] = "resolve";
        stringArray[169] = "assertEquals";
        stringArray[170] = "build";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "build";
        stringArray[173] = "addType";
        stringArray[174] = "withDefaults";
        stringArray[175] = "resolve";
        stringArray[176] = "assertNull";
        stringArray[177] = "build";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "build";
        stringArray[180] = "withDefaults";
        stringArray[181] = "expect";
        stringArray[182] = "expectMessage";
        stringArray[183] = "resolve";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "build";
        stringArray[186] = "withDefaults";
        stringArray[187] = "resolve";
        stringArray[188] = "assertEquals";
        stringArray[189] = "fallbackApplicationName";
        stringArray[190] = "env";
        stringArray[191] = "configuration";
        stringArray[192] = "applicationName";
        stringArray[193] = "<$constructor$>";
        stringArray[194] = "build";
        stringArray[195] = "withDefaults";
        stringArray[196] = "resolve";
        stringArray[197] = "assertEquals";
        stringArray[198] = "applicationName";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "build";
        stringArray[201] = "withDefaults";
        stringArray[202] = "resolve";
        stringArray[203] = "assertEquals";
        stringArray[204] = "applicationName";
        stringArray[205] = "<$constructor$>";
        stringArray[206] = "build";
        stringArray[207] = "withDefaults";
        stringArray[208] = "resolve";
        stringArray[209] = "assertEquals";
        stringArray[210] = "content";
        stringArray[211] = "packageName";
        stringArray[212] = "packageName";
        stringArray[213] = "<$constructor$>";
        stringArray[214] = "build";
        stringArray[215] = "withDefaults";
        stringArray[216] = "resolve";
        stringArray[217] = "assertEquals";
        stringArray[218] = "packageName";
        stringArray[219] = "<$constructor$>";
        stringArray[220] = "<$constructor$>";
        stringArray[221] = "<$constructor$>";
        stringArray[222] = "<$constructor$>";
        stringArray[223] = "build";
        stringArray[224] = "addDependencyGroup";
        stringArray[225] = "addBom";
        stringArray[226] = "addBom";
        stringArray[227] = "withDefaults";
        stringArray[228] = "leftShift";
        stringArray[229] = "style";
        stringArray[230] = "resolve";
        stringArray[231] = "assertEquals";
        stringArray[232] = "size";
        stringArray[233] = "resolvedDependencies";
        stringArray[234] = "assertEquals";
        stringArray[235] = "size";
        stringArray[236] = "boms";
        stringArray[237] = "assertEquals";
        stringArray[238] = "getAt";
        stringArray[239] = "boms";
        stringArray[240] = "assertEquals";
        stringArray[241] = "getAt";
        stringArray[242] = "boms";
        stringArray[243] = "<$constructor$>";
        stringArray[244] = "<$constructor$>";
        stringArray[245] = "<$constructor$>";
        stringArray[246] = "<$constructor$>";
        stringArray[247] = "<$constructor$>";
        stringArray[248] = "build";
        stringArray[249] = "addDependencyGroup";
        stringArray[250] = "addBom";
        stringArray[251] = "addBom";
        stringArray[252] = "withDefaults";
        stringArray[253] = "leftShift";
        stringArray[254] = "leftShift";
        stringArray[255] = "style";
        stringArray[256] = "resolve";
        stringArray[257] = "assertEquals";
        stringArray[258] = "size";
        stringArray[259] = "resolvedDependencies";
        stringArray[260] = "assertEquals";
        stringArray[261] = "size";
        stringArray[262] = "boms";
        stringArray[263] = "assertEquals";
        stringArray[264] = "getAt";
        stringArray[265] = "boms";
        stringArray[266] = "assertEquals";
        stringArray[267] = "getAt";
        stringArray[268] = "boms";
        stringArray[269] = "<$constructor$>";
        stringArray[270] = "<$constructor$>";
        stringArray[271] = "<$constructor$>";
        stringArray[272] = "build";
        stringArray[273] = "addDependencyGroup";
        stringArray[274] = "addRepository";
        stringArray[275] = "addRepository";
        stringArray[276] = "addBom";
        stringArray[277] = "withDefaults";
        stringArray[278] = "leftShift";
        stringArray[279] = "style";
        stringArray[280] = "resolve";
        stringArray[281] = "assertEquals";
        stringArray[282] = "size";
        stringArray[283] = "resolvedDependencies";
        stringArray[284] = "assertEquals";
        stringArray[285] = "size";
        stringArray[286] = "boms";
        stringArray[287] = "assertEquals";
        stringArray[288] = "size";
        stringArray[289] = "repositories";
        stringArray[290] = "assertEquals";
        stringArray[291] = "getAt";
        stringArray[292] = "repositories";
        stringArray[293] = "env";
        stringArray[294] = "configuration";
        stringArray[295] = "getAt";
        stringArray[296] = "repositories";
        stringArray[297] = "assertEquals";
        stringArray[298] = "getAt";
        stringArray[299] = "repositories";
        stringArray[300] = "env";
        stringArray[301] = "configuration";
        stringArray[302] = "getAt";
        stringArray[303] = "repositories";
        stringArray[304] = "<$constructor$>";
        stringArray[305] = "<$constructor$>";
        stringArray[306] = "<$constructor$>";
        stringArray[307] = "<$constructor$>";
        stringArray[308] = "build";
        stringArray[309] = "addDependencyGroup";
        stringArray[310] = "addRepository";
        stringArray[311] = "addRepository";
        stringArray[312] = "addBom";
        stringArray[313] = "withDefaults";
        stringArray[314] = "leftShift";
        stringArray[315] = "leftShift";
        stringArray[316] = "style";
        stringArray[317] = "resolve";
        stringArray[318] = "assertEquals";
        stringArray[319] = "size";
        stringArray[320] = "resolvedDependencies";
        stringArray[321] = "assertEquals";
        stringArray[322] = "size";
        stringArray[323] = "boms";
        stringArray[324] = "assertEquals";
        stringArray[325] = "size";
        stringArray[326] = "repositories";
        stringArray[327] = "assertEquals";
        stringArray[328] = "getAt";
        stringArray[329] = "repositories";
        stringArray[330] = "env";
        stringArray[331] = "configuration";
        stringArray[332] = "getAt";
        stringArray[333] = "repositories";
        stringArray[334] = "assertEquals";
        stringArray[335] = "getAt";
        stringArray[336] = "repositories";
        stringArray[337] = "env";
        stringArray[338] = "configuration";
        stringArray[339] = "getAt";
        stringArray[340] = "repositories";
        stringArray[341] = "<$constructor$>";
        stringArray[342] = "asSpringBootStarter";
        stringArray[343] = "assertDependency";
        stringArray[344] = "groupId";
        stringArray[345] = "artifactId";
        stringArray[346] = "version";
        stringArray[347] = "assertEquals";
        stringArray[348] = "id";
        stringArray[349] = "<$constructor$>";
        stringArray[350] = "assertEquals";
        stringArray[351] = "groupId";
        stringArray[352] = "assertEquals";
        stringArray[353] = "artifactId";
        stringArray[354] = "assertEquals";
        stringArray[355] = "version";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[356];
        ProjectRequestTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProjectRequestTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProjectRequestTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

