/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.metadata.DependenciesCapability;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.DependencyGroup;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DependenciesCapabilityTests
implements GroovyObject {
    @Rule
    public final ExpectedException thrown;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DependenciesCapabilityTests() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object object = callSiteArray[0].call(ExpectedException.class);
        this.thrown = (ExpectedException)ScriptBytecodeAdapter.castToType((Object)object, ExpectedException.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void indexedDependencies() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object dependency = callSiteArray[1].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first"}));
        Object dependency2 = callSiteArray[2].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second"}));
        Object capability = callSiteArray[3].callStatic(DependenciesCapabilityTests.class, (Object)"foo", dependency, dependency2);
        callSiteArray[4].call(capability);
        callSiteArray[5].callStatic(Assert.class, dependency, callSiteArray[6].call(capability, (Object)"first"));
        callSiteArray[7].callStatic(Assert.class, dependency2, callSiteArray[8].call(capability, (Object)"second"));
        callSiteArray[9].callStatic(Assert.class, callSiteArray[10].call(capability, (Object)"anotherId"));
    }

    @Test
    public void addTwoDependenciesWithSameId() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object dependency = callSiteArray[11].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "conflict"}));
        Object dependency2 = callSiteArray[12].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "conflict"}));
        Object capability = callSiteArray[13].callStatic(DependenciesCapabilityTests.class, (Object)"foo", dependency, dependency2);
        callSiteArray[14].call((Object)this.thrown, IllegalArgumentException.class);
        callSiteArray[15].call((Object)this.thrown, (Object)"conflict");
        callSiteArray[16].call(capability);
    }

    @Test
    public void addDependencyWithAliases() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object dependency = callSiteArray[17].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first"}));
        callSiteArray[18].call(callSiteArray[19].callGetProperty(dependency), (Object)"alias1");
        callSiteArray[20].call(callSiteArray[21].callGetProperty(dependency), (Object)"alias2");
        Object capability = callSiteArray[22].callStatic(DependenciesCapabilityTests.class, (Object)"foo", dependency);
        callSiteArray[23].call(capability);
        callSiteArray[24].callStatic(Assert.class, dependency, callSiteArray[25].call(capability, (Object)"first"));
        callSiteArray[26].callStatic(Assert.class, dependency, callSiteArray[27].call(capability, (Object)"alias1"));
        callSiteArray[28].callStatic(Assert.class, dependency, callSiteArray[29].call(capability, (Object)"alias2"));
    }

    @Test
    public void aliasClashWithAnotherDependency() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object dependency = callSiteArray[30].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first"}));
        callSiteArray[31].call(callSiteArray[32].callGetProperty(dependency), (Object)"alias1");
        callSiteArray[33].call(callSiteArray[34].callGetProperty(dependency), (Object)"alias2");
        Object dependency2 = callSiteArray[35].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "alias2"}));
        Object capability = callSiteArray[36].callConstructor(DependenciesCapability.class);
        callSiteArray[37].call(callSiteArray[38].callGetProperty(capability), callSiteArray[39].callStatic(DependenciesCapabilityTests.class, (Object)"foo", dependency));
        callSiteArray[40].call(callSiteArray[41].callGetProperty(capability), callSiteArray[42].callStatic(DependenciesCapabilityTests.class, (Object)"bar", dependency2));
        callSiteArray[43].call((Object)this.thrown, IllegalArgumentException.class);
        callSiteArray[44].call((Object)this.thrown, (Object)"alias2");
        callSiteArray[45].call(capability);
    }

    @Test
    public void mergeAddEntry() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        DependenciesCapability capability = (DependenciesCapability)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callStatic(DependenciesCapabilityTests.class, (Object)"foo", callSiteArray[47].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first"})), callSiteArray[48].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second"}))), DependenciesCapability.class);
        DependenciesCapability anotherCapability = (DependenciesCapability)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callStatic(DependenciesCapabilityTests.class, (Object)"foo", callSiteArray[50].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "bar"})), callSiteArray[51].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "biz"}))), DependenciesCapability.class);
        callSiteArray[52].call(callSiteArray[53].callGroovyObjectGetProperty((Object)anotherCapability), callSiteArray[54].callStatic(DependenciesCapabilityTests.class, (Object)"bar", callSiteArray[55].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "third"}))));
        callSiteArray[56].call((Object)capability, (Object)anotherCapability);
        callSiteArray[57].callStatic(Assert.class, (Object)2, callSiteArray[58].call(callSiteArray[59].callGroovyObjectGetProperty((Object)capability)));
        callSiteArray[60].callStatic(Assert.class, callSiteArray[61].call((Object)capability, (Object)"first"));
        callSiteArray[62].callStatic(Assert.class, callSiteArray[63].call((Object)capability, (Object)"second"));
        callSiteArray[64].callStatic(Assert.class, callSiteArray[65].call((Object)capability, (Object)"third"));
    }

    @Test
    public void addDefaultVersionRange() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object first = callSiteArray[66].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first"}));
        Object second = callSiteArray[67].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "versionRange", "1.2.3.RELEASE"}));
        Object group = callSiteArray[68].callStatic(DependenciesCapabilityTests.class, (Object)"test", first, second);
        String string = "1.2.0.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)group, (String)"versionRange");
        DependenciesCapability capability = (DependenciesCapability)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(DependenciesCapability.class), DependenciesCapability.class);
        callSiteArray[70].call(callSiteArray[71].callGroovyObjectGetProperty((Object)capability), group);
        callSiteArray[72].call((Object)capability);
        callSiteArray[73].callStatic(Assert.class, (Object)"1.2.0.RELEASE", callSiteArray[74].callGetProperty(callSiteArray[75].call((Object)capability, (Object)"first")));
        callSiteArray[76].callStatic(Assert.class, (Object)"1.2.3.RELEASE", callSiteArray[77].callGetProperty(callSiteArray[78].call((Object)capability, (Object)"second")));
    }

    @Test
    public void addDefaultBom() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object first = callSiteArray[79].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first"}));
        Object second = callSiteArray[80].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "bom", "da-bom"}));
        Object group = callSiteArray[81].callStatic(DependenciesCapabilityTests.class, (Object)"test", first, second);
        String string = "test-bom";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)group, (String)"bom");
        DependenciesCapability capability = (DependenciesCapability)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callConstructor(DependenciesCapability.class), DependenciesCapability.class);
        callSiteArray[83].call(callSiteArray[84].callGroovyObjectGetProperty((Object)capability), group);
        callSiteArray[85].call((Object)capability);
        callSiteArray[86].callStatic(Assert.class, (Object)"test-bom", callSiteArray[87].callGetProperty(callSiteArray[88].call((Object)capability, (Object)"first")));
        callSiteArray[89].callStatic(Assert.class, (Object)"da-bom", callSiteArray[90].callGetProperty(callSiteArray[91].call((Object)capability, (Object)"second")));
    }

    @Test
    public void addDefaultRepository() {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        Object first = callSiteArray[92].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first"}));
        Object second = callSiteArray[93].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "repository", "da-repo"}));
        Object group = callSiteArray[94].callStatic(DependenciesCapabilityTests.class, (Object)"test", first, second);
        String string = "test-repo";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)group, (String)"repository");
        DependenciesCapability capability = (DependenciesCapability)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].callConstructor(DependenciesCapability.class), DependenciesCapability.class);
        callSiteArray[96].call(callSiteArray[97].callGroovyObjectGetProperty((Object)capability), group);
        callSiteArray[98].call((Object)capability);
        callSiteArray[99].callStatic(Assert.class, (Object)"test-repo", callSiteArray[100].callGetProperty(callSiteArray[101].call((Object)capability, (Object)"first")));
        callSiteArray[102].callStatic(Assert.class, (Object)"da-repo", callSiteArray[103].callGetProperty(callSiteArray[104].call((Object)capability, (Object)"second")));
    }

    private static DependenciesCapability createDependenciesCapability(String groupName, Dependency ... dependencies) {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        DependenciesCapability capability = (DependenciesCapability)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callConstructor(DependenciesCapability.class), DependenciesCapability.class);
        DependencyGroup group = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[106].callStatic(DependenciesCapabilityTests.class, (Object)groupName, (Object)dependencies);
            group = (DependencyGroup)ScriptBytecodeAdapter.castToType((Object)object, DependencyGroup.class);
        } else {
            DependencyGroup dependencyGroup;
            group = dependencyGroup = DependenciesCapabilityTests.createDependencyGroup(groupName, dependencies);
        }
        callSiteArray[107].call(callSiteArray[108].callGroovyObjectGetProperty((Object)capability), (Object)group);
        return capability;
    }

    private static DependencyGroup createDependencyGroup(String groupName, Dependency ... dependencies) {
        CallSite[] callSiteArray = DependenciesCapabilityTests.$getCallSiteArray();
        DependencyGroup group = (DependencyGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[109].callConstructor(DependencyGroup.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", groupName})), DependencyGroup.class);
        Dependency dependency = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].call((Object)dependencies), Iterator.class);
        while (iterator.hasNext()) {
            dependency = (Dependency)ScriptBytecodeAdapter.castToType(iterator.next(), Dependency.class);
            callSiteArray[111].call(callSiteArray[112].callGroovyObjectGetProperty((Object)group), (Object)dependency);
        }
        return group;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DependenciesCapabilityTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "none";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "createDependenciesCapability";
        stringArray[4] = "validate";
        stringArray[5] = "assertSame";
        stringArray[6] = "get";
        stringArray[7] = "assertSame";
        stringArray[8] = "get";
        stringArray[9] = "assertNull";
        stringArray[10] = "get";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "createDependenciesCapability";
        stringArray[14] = "expect";
        stringArray[15] = "expectMessage";
        stringArray[16] = "validate";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "add";
        stringArray[19] = "aliases";
        stringArray[20] = "add";
        stringArray[21] = "aliases";
        stringArray[22] = "createDependenciesCapability";
        stringArray[23] = "validate";
        stringArray[24] = "assertSame";
        stringArray[25] = "get";
        stringArray[26] = "assertSame";
        stringArray[27] = "get";
        stringArray[28] = "assertSame";
        stringArray[29] = "get";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "add";
        stringArray[32] = "aliases";
        stringArray[33] = "add";
        stringArray[34] = "aliases";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "leftShift";
        stringArray[38] = "content";
        stringArray[39] = "createDependencyGroup";
        stringArray[40] = "leftShift";
        stringArray[41] = "content";
        stringArray[42] = "createDependencyGroup";
        stringArray[43] = "expect";
        stringArray[44] = "expectMessage";
        stringArray[45] = "validate";
        stringArray[46] = "createDependenciesCapability";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "createDependenciesCapability";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "leftShift";
        stringArray[53] = "content";
        stringArray[54] = "createDependencyGroup";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "merge";
        stringArray[57] = "assertEquals";
        stringArray[58] = "size";
        stringArray[59] = "content";
        stringArray[60] = "assertNotNull";
        stringArray[61] = "get";
        stringArray[62] = "assertNotNull";
        stringArray[63] = "get";
        stringArray[64] = "assertNotNull";
        stringArray[65] = "get";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "createDependencyGroup";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "leftShift";
        stringArray[71] = "content";
        stringArray[72] = "validate";
        stringArray[73] = "assertEquals";
        stringArray[74] = "versionRange";
        stringArray[75] = "get";
        stringArray[76] = "assertEquals";
        stringArray[77] = "versionRange";
        stringArray[78] = "get";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "createDependencyGroup";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "leftShift";
        stringArray[84] = "content";
        stringArray[85] = "validate";
        stringArray[86] = "assertEquals";
        stringArray[87] = "bom";
        stringArray[88] = "get";
        stringArray[89] = "assertEquals";
        stringArray[90] = "bom";
        stringArray[91] = "get";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "createDependencyGroup";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "leftShift";
        stringArray[97] = "content";
        stringArray[98] = "validate";
        stringArray[99] = "assertEquals";
        stringArray[100] = "repository";
        stringArray[101] = "get";
        stringArray[102] = "assertEquals";
        stringArray[103] = "repository";
        stringArray[104] = "get";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "createDependencyGroup";
        stringArray[107] = "leftShift";
        stringArray[108] = "content";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "iterator";
        stringArray[111] = "leftShift";
        stringArray[112] = "content";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[113];
        DependenciesCapabilityTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DependenciesCapabilityTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DependenciesCapabilityTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

