/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InvalidInitializrMetadataException;
import io.spring.initializr.util.Version;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DependencyTests
implements GroovyObject {
    @Rule
    public final ExpectedException thrown;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DependencyTests() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object object = callSiteArray[0].call(ExpectedException.class);
        this.thrown = (ExpectedException)ScriptBytecodeAdapter.castToType((Object)object, ExpectedException.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void createRootSpringBootStarter() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Dependency d = (Dependency)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(Dependency.class), Dependency.class);
        callSiteArray[2].call((Object)d, (Object)"");
        callSiteArray[3].callStatic(Assert.class, (Object)"org.springframework.boot", callSiteArray[4].callGroovyObjectGetProperty((Object)d));
        callSiteArray[5].callStatic(Assert.class, (Object)"spring-boot-starter", callSiteArray[6].callGroovyObjectGetProperty((Object)d));
    }

    @Test
    public void setCoordinatesFromId() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[7].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "org.foo:bar:1.2.3"}));
        callSiteArray[8].call(dependency);
        callSiteArray[9].callStatic(Assert.class, (Object)"org.foo", callSiteArray[10].callGetProperty(dependency));
        callSiteArray[11].callStatic(Assert.class, (Object)"bar", callSiteArray[12].callGetProperty(dependency));
        callSiteArray[13].callStatic(Assert.class, (Object)"1.2.3", callSiteArray[14].callGetProperty(dependency));
        callSiteArray[15].callStatic(Assert.class, (Object)"org.foo:bar:1.2.3", callSiteArray[16].callGetProperty(dependency));
    }

    @Test
    public void setCoordinatesFromIdNoVersion() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[17].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "org.foo:bar"}));
        callSiteArray[18].call(dependency);
        callSiteArray[19].callStatic(Assert.class, (Object)"org.foo", callSiteArray[20].callGetProperty(dependency));
        callSiteArray[21].callStatic(Assert.class, (Object)"bar", callSiteArray[22].callGetProperty(dependency));
        callSiteArray[23].callStatic(Assert.class, callSiteArray[24].callGetProperty(dependency));
        callSiteArray[25].callStatic(Assert.class, (Object)"org.foo:bar", callSiteArray[26].callGetProperty(dependency));
    }

    @Test
    public void setIdFromCoordinates() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[27].callConstructor(Dependency.class);
        String string = "org.foo";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"groupId");
        String string2 = "bar";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)dependency, (String)"artifactId");
        String string3 = "1.0";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)dependency, (String)"version");
        callSiteArray[28].call(dependency);
        callSiteArray[29].callStatic(Assert.class, (Object)"org.foo:bar", callSiteArray[30].callGetProperty(dependency));
    }

    @Test
    public void setIdFromCoordinatesNoVersion() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[31].callConstructor(Dependency.class);
        String string = "org.foo";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"groupId");
        String string2 = "bar";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)dependency, (String)"artifactId");
        callSiteArray[32].call(dependency);
        callSiteArray[33].callStatic(Assert.class, (Object)"org.foo:bar", callSiteArray[34].callGetProperty(dependency));
    }

    @Test
    public void setIdFromSimpleName() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[35].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "web"}));
        callSiteArray[36].call(dependency);
        callSiteArray[37].callStatic(Assert.class, (Object)"org.springframework.boot", callSiteArray[38].callGetProperty(dependency));
        callSiteArray[39].callStatic(Assert.class, (Object)"spring-boot-starter-web", callSiteArray[40].callGetProperty(dependency));
        callSiteArray[41].callStatic(Assert.class, callSiteArray[42].callGetProperty(dependency));
        callSiteArray[43].callStatic(Assert.class, (Object)"web", callSiteArray[44].callGetProperty(dependency));
    }

    @Test
    public void invalidDependency() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        callSiteArray[45].call((Object)this.thrown, InvalidInitializrMetadataException.class);
        callSiteArray[46].call(callSiteArray[47].callConstructor(Dependency.class));
    }

    @Test
    public void invalidDependencyScope() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[48].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "web"}));
        callSiteArray[49].call((Object)this.thrown, InvalidInitializrMetadataException.class);
        callSiteArray[50].call(dependency, (Object)"whatever");
    }

    @Test
    public void invalidSpringBootRange() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[51].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "web"}));
        String string = "A.B.C";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"versionRange");
        callSiteArray[52].call((Object)this.thrown, InvalidInitializrMetadataException.class);
        callSiteArray[53].call((Object)this.thrown, (Object)"A.B.C");
        callSiteArray[54].call(dependency);
    }

    @Test
    public void invalidIdFormatTooManyColons() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[55].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "org.foo:bar:1.0:test:external"}));
        callSiteArray[56].call((Object)this.thrown, InvalidInitializrMetadataException.class);
        callSiteArray[57].call(dependency);
    }

    @Test
    public void generateIdWithNoGroupId() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[58].callConstructor(Dependency.class);
        String string = "bar";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"artifactId");
        callSiteArray[59].call((Object)this.thrown, IllegalArgumentException.class);
        callSiteArray[60].call(dependency);
    }

    @Test
    public void generateIdWithNoArtifactId() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[61].callConstructor(Dependency.class);
        String string = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)dependency, (String)"groupId");
        callSiteArray[62].call((Object)this.thrown, IllegalArgumentException.class);
        callSiteArray[63].call(dependency);
    }

    @Test
    public void resolveNoMapping() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[64].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "web"}));
        callSiteArray[65].call(dependency);
        callSiteArray[66].callStatic(Assert.class, dependency, callSiteArray[67].call(dependency, callSiteArray[68].call(Version.class, (Object)"1.2.0.RELEASE")));
    }

    @Test
    public void resolveInvalidMapping() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[69].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "web"}));
        callSiteArray[70].call(callSiteArray[71].callGetProperty(dependency), callSiteArray[72].callConstructor(Dependency.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "foo-bar", "version", "0.1.0.RELEASE"})));
        callSiteArray[73].call((Object)this.thrown, InvalidInitializrMetadataException.class);
        callSiteArray[74].call((Object)this.thrown, (Object)"foo-bar");
        callSiteArray[75].call(dependency);
    }

    @Test
    public void resolveMatchingMapping() {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        Object dependency = callSiteArray[76].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "web", "description", "A web dependency", "version", "0.3.0.RELEASE", "keywords", ScriptBytecodeAdapter.createList((Object[])new Object[]{"foo", "bar"}), "aliases", ScriptBytecodeAdapter.createList((Object[])new Object[]{"the-web"}), "facets", ScriptBytecodeAdapter.createList((Object[])new Object[]{"web"})}));
        callSiteArray[77].call(callSiteArray[78].callGetProperty(dependency), callSiteArray[79].callConstructor(Dependency.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "[1.1.0.RELEASE, 1.2.0.RELEASE)", "version", "0.1.0.RELEASE"})));
        callSiteArray[80].call(callSiteArray[81].callGetProperty(dependency), callSiteArray[82].callConstructor(Dependency.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "[1.2.0.RELEASE, 1.3.0.RELEASE)", "version", "0.2.0.RELEASE"})));
        callSiteArray[83].call(dependency);
        callSiteArray[84].callStatic(DependencyTests.class, callSiteArray[85].call(dependency, callSiteArray[86].call(Version.class, (Object)"1.1.5.RELEASE")), (Object)"0.1.0.RELEASE");
        callSiteArray[87].callStatic(DependencyTests.class, callSiteArray[88].call(dependency, callSiteArray[89].call(Version.class, (Object)"1.2.0.RELEASE")), (Object)"0.2.0.RELEASE");
        callSiteArray[90].callStatic(DependencyTests.class, callSiteArray[91].call(dependency, callSiteArray[92].call(Version.class, (Object)"2.1.3.M1")), (Object)"0.3.0.RELEASE");
    }

    public static void validateResolvedWebDependency(Object dependency, Object expectedVersion) {
        CallSite[] callSiteArray = DependencyTests.$getCallSiteArray();
        callSiteArray[93].callStatic(Assert.class, expectedVersion, callSiteArray[94].callGetProperty(dependency));
        callSiteArray[95].callStatic(Assert.class, (Object)"web", callSiteArray[96].callGetProperty(dependency));
        callSiteArray[97].callStatic(Assert.class, (Object)"org.springframework.boot", callSiteArray[98].callGetProperty(dependency));
        callSiteArray[99].callStatic(Assert.class, (Object)"spring-boot-starter-web", callSiteArray[100].callGetProperty(dependency));
        callSiteArray[101].callStatic(Assert.class, (Object)2, callSiteArray[102].call(callSiteArray[103].callGetProperty(dependency)));
        callSiteArray[104].callStatic(Assert.class, (Object)1, callSiteArray[105].call(callSiteArray[106].callGetProperty(dependency)));
        callSiteArray[107].callStatic(Assert.class, (Object)1, callSiteArray[108].call(callSiteArray[109].callGetProperty(dependency)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DependencyTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "none";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "asSpringBootStarter";
        stringArray[3] = "assertEquals";
        stringArray[4] = "groupId";
        stringArray[5] = "assertEquals";
        stringArray[6] = "artifactId";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "resolve";
        stringArray[9] = "assertEquals";
        stringArray[10] = "groupId";
        stringArray[11] = "assertEquals";
        stringArray[12] = "artifactId";
        stringArray[13] = "assertEquals";
        stringArray[14] = "version";
        stringArray[15] = "assertEquals";
        stringArray[16] = "id";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "resolve";
        stringArray[19] = "assertEquals";
        stringArray[20] = "groupId";
        stringArray[21] = "assertEquals";
        stringArray[22] = "artifactId";
        stringArray[23] = "assertNull";
        stringArray[24] = "version";
        stringArray[25] = "assertEquals";
        stringArray[26] = "id";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "resolve";
        stringArray[29] = "assertEquals";
        stringArray[30] = "id";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "resolve";
        stringArray[33] = "assertEquals";
        stringArray[34] = "id";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "resolve";
        stringArray[37] = "assertEquals";
        stringArray[38] = "groupId";
        stringArray[39] = "assertEquals";
        stringArray[40] = "artifactId";
        stringArray[41] = "assertNull";
        stringArray[42] = "version";
        stringArray[43] = "assertEquals";
        stringArray[44] = "id";
        stringArray[45] = "expect";
        stringArray[46] = "resolve";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "expect";
        stringArray[50] = "setScope";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "expect";
        stringArray[53] = "expectMessage";
        stringArray[54] = "resolve";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "expect";
        stringArray[57] = "resolve";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "expect";
        stringArray[60] = "generateId";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "expect";
        stringArray[63] = "generateId";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "resolve";
        stringArray[66] = "assertSame";
        stringArray[67] = "resolve";
        stringArray[68] = "parse";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "leftShift";
        stringArray[71] = "versions";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "expect";
        stringArray[74] = "expectMessage";
        stringArray[75] = "resolve";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "leftShift";
        stringArray[78] = "versions";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "leftShift";
        stringArray[81] = "versions";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "resolve";
        stringArray[84] = "validateResolvedWebDependency";
        stringArray[85] = "resolve";
        stringArray[86] = "parse";
        stringArray[87] = "validateResolvedWebDependency";
        stringArray[88] = "resolve";
        stringArray[89] = "parse";
        stringArray[90] = "validateResolvedWebDependency";
        stringArray[91] = "resolve";
        stringArray[92] = "parse";
        stringArray[93] = "assertEquals";
        stringArray[94] = "version";
        stringArray[95] = "assertEquals";
        stringArray[96] = "id";
        stringArray[97] = "assertEquals";
        stringArray[98] = "groupId";
        stringArray[99] = "assertEquals";
        stringArray[100] = "artifactId";
        stringArray[101] = "assertEquals";
        stringArray[102] = "size";
        stringArray[103] = "keywords";
        stringArray[104] = "assertEquals";
        stringArray[105] = "size";
        stringArray[106] = "aliases";
        stringArray[107] = "assertEquals";
        stringArray[108] = "size";
        stringArray[109] = "facets";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[110];
        DependencyTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DependencyTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DependencyTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

