/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.stat;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.generator.ProjectFailedEvent;
import io.spring.initializr.generator.ProjectGeneratedEvent;
import io.spring.initializr.generator.ProjectRequest;
import io.spring.initializr.stat.AbstractInitializrStatTests;
import io.spring.initializr.stat.ProjectRequestDocument;
import io.spring.initializr.stat.ProjectRequestDocumentFactory;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Assert;
import org.junit.Test;

public class ProjectRequestDocumentFactoryTests
extends AbstractInitializrStatTests {
    private final ProjectRequestDocumentFactory factory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProjectRequestDocumentFactoryTests() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(ProjectRequestDocumentFactory.class, callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].callGroovyObjectGetProperty((Object)this)));
        this.factory = (ProjectRequestDocumentFactory)ScriptBytecodeAdapter.castToType((Object)object, ProjectRequestDocumentFactory.class);
    }

    @Test
    public void createDocumentForSimpleProject() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this), ProjectRequest.class);
        Object event = callSiteArray[4].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[5].call((Object)this.factory, event);
        callSiteArray[6].callStatic(Assert.class, callSiteArray[7].callGetProperty(event), callSiteArray[8].callGetProperty(document));
        callSiteArray[9].callStatic(Assert.class, null, callSiteArray[10].callGetProperty(document));
        callSiteArray[11].callStatic(Assert.class, (Object)"com.example", callSiteArray[12].callGetProperty(document));
        callSiteArray[13].callStatic(Assert.class, (Object)"demo", callSiteArray[14].callGetProperty(document));
        callSiteArray[15].callStatic(Assert.class, (Object)"com.example", callSiteArray[16].callGetProperty(document));
        callSiteArray[17].callStatic(Assert.class, (Object)"1.2.3.RELEASE", callSiteArray[18].callGetProperty(document));
        callSiteArray[19].callStatic(Assert.class, (Object)"1.8", callSiteArray[20].callGetProperty(document));
        callSiteArray[21].callStatic(Assert.class, (Object)"java", callSiteArray[22].callGetProperty(document));
        callSiteArray[23].callStatic(Assert.class, (Object)"jar", callSiteArray[24].callGetProperty(document));
        callSiteArray[25].callStatic(Assert.class, (Object)"maven-project", callSiteArray[26].callGetProperty(document));
        callSiteArray[27].callStatic(Assert.class, (Object)0, callSiteArray[28].call(callSiteArray[29].callGetProperty(document)));
        callSiteArray[30].callStatic(ProjectRequestDocumentFactoryTests.class, document);
    }

    @Test
    public void createDocumentWithRequestIp() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "10.0.0.123";
        callSiteArray[32].call(callSiteArray[33].callGroovyObjectGetProperty((Object)request), (Object)"x-forwarded-for", (Object)string);
        Object event = callSiteArray[34].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[35].call((Object)this.factory, event);
        callSiteArray[36].callStatic(Assert.class, (Object)"10.0.0.123", callSiteArray[37].callGetProperty(document));
        callSiteArray[38].callStatic(Assert.class, (Object)"10.0.0.123", callSiteArray[39].callGetProperty(document));
        callSiteArray[40].callStatic(Assert.class, callSiteArray[41].callGetProperty(document));
    }

    @Test
    public void createDocumentWithRequestIpv6() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "2001:db8:a0b:12f0::1";
        callSiteArray[43].call(callSiteArray[44].callGroovyObjectGetProperty((Object)request), (Object)"x-forwarded-for", (Object)string);
        Object event = callSiteArray[45].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[46].call((Object)this.factory, event);
        callSiteArray[47].callStatic(Assert.class, (Object)"2001:db8:a0b:12f0::1", callSiteArray[48].callGetProperty(document));
        callSiteArray[49].callStatic(Assert.class, callSiteArray[50].callGetProperty(document));
        callSiteArray[51].callStatic(Assert.class, callSiteArray[52].callGetProperty(document));
    }

    @Test
    public void createDocumentWithCloudFlareHeaders() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "10.0.0.123";
        callSiteArray[54].call(callSiteArray[55].callGroovyObjectGetProperty((Object)request), (Object)"cf-connecting-ip", (Object)string);
        String string2 = "BE";
        callSiteArray[56].call(callSiteArray[57].callGroovyObjectGetProperty((Object)request), (Object)"cf-ipcountry", (Object)string2);
        Object event = callSiteArray[58].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[59].call((Object)this.factory, event);
        callSiteArray[60].callStatic(Assert.class, (Object)"10.0.0.123", callSiteArray[61].callGetProperty(document));
        callSiteArray[62].callStatic(Assert.class, (Object)"10.0.0.123", callSiteArray[63].callGetProperty(document));
        callSiteArray[64].callStatic(Assert.class, (Object)"BE", callSiteArray[65].callGetProperty(document));
    }

    @Test
    public void createDocumentWithCloudFlareIpv6() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "2001:db8:a0b:12f0::1";
        callSiteArray[67].call(callSiteArray[68].callGroovyObjectGetProperty((Object)request), (Object)"cf-connecting-ip", (Object)string);
        Object event = callSiteArray[69].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[70].call((Object)this.factory, event);
        callSiteArray[71].callStatic(Assert.class, (Object)"2001:db8:a0b:12f0::1", callSiteArray[72].callGetProperty(document));
        callSiteArray[73].callStatic(Assert.class, callSiteArray[74].callGetProperty(document));
        callSiteArray[75].callStatic(Assert.class, callSiteArray[76].callGetProperty(document));
    }

    @Test
    public void createDocumentWithCloudFlareHeadersAndOtherHeaders() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "10.0.0.123";
        callSiteArray[78].call(callSiteArray[79].callGroovyObjectGetProperty((Object)request), (Object)"cf-connecting-ip", (Object)string);
        String string2 = "192.168.1.101";
        callSiteArray[80].call(callSiteArray[81].callGroovyObjectGetProperty((Object)request), (Object)"x-forwarded-for", (Object)string2);
        Object event = callSiteArray[82].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[83].call((Object)this.factory, event);
        callSiteArray[84].callStatic(Assert.class, (Object)"10.0.0.123", callSiteArray[85].callGetProperty(document));
        callSiteArray[86].callStatic(Assert.class, (Object)"10.0.0.123", callSiteArray[87].callGetProperty(document));
        callSiteArray[88].callStatic(Assert.class, callSiteArray[89].callGetProperty(document));
    }

    @Test
    public void createDocumentWithCloudFlareCountrySetToXX() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "Xx";
        callSiteArray[91].call(callSiteArray[92].callGroovyObjectGetProperty((Object)request), (Object)"cf-connecting-ip", (Object)string);
        Object event = callSiteArray[93].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[94].call((Object)this.factory, event);
        callSiteArray[95].callStatic(Assert.class, callSiteArray[96].callGetProperty(document));
    }

    @Test
    public void createDocumentWithUserAgent() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "HTTPie/0.8.0";
        callSiteArray[98].call(callSiteArray[99].callGroovyObjectGetProperty((Object)request), (Object)"user-agent", (Object)string);
        Object event = callSiteArray[100].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[101].call((Object)this.factory, event);
        callSiteArray[102].callStatic(Assert.class, (Object)"httpie", callSiteArray[103].callGetProperty(document));
        callSiteArray[104].callStatic(Assert.class, (Object)"0.8.0", callSiteArray[105].callGetProperty(document));
    }

    @Test
    public void createDocumentWithUserAgentNoVersion() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "IntelliJ IDEA";
        callSiteArray[107].call(callSiteArray[108].callGroovyObjectGetProperty((Object)request), (Object)"user-agent", (Object)string);
        Object event = callSiteArray[109].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[110].call((Object)this.factory, event);
        callSiteArray[111].callStatic(Assert.class, (Object)"intellijidea", callSiteArray[112].callGetProperty(document));
        callSiteArray[113].callStatic(Assert.class, null, callSiteArray[114].callGetProperty(document));
    }

    @Test
    public void createDocumentInvalidJavaVersion() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[115].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "1.2";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProjectRequestDocumentFactoryTests.class, (GroovyObject)request, (String)"javaVersion");
        Object event = callSiteArray[116].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[117].call((Object)this.factory, event);
        callSiteArray[118].callStatic(Assert.class, (Object)"1.2", callSiteArray[119].callGetProperty(document));
        callSiteArray[120].callStatic(Assert.class, callSiteArray[121].callGetProperty(document));
        callSiteArray[122].callStatic(Assert.class, callSiteArray[123].callGetProperty(document));
    }

    @Test
    public void createDocumentInvalidLanguage() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[124].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "c++";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProjectRequestDocumentFactoryTests.class, (GroovyObject)request, (String)"language");
        Object event = callSiteArray[125].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[126].call((Object)this.factory, event);
        callSiteArray[127].callStatic(Assert.class, (Object)"c++", callSiteArray[128].callGetProperty(document));
        callSiteArray[129].callStatic(Assert.class, callSiteArray[130].callGetProperty(document));
        callSiteArray[131].callStatic(Assert.class, callSiteArray[132].callGetProperty(document));
    }

    @Test
    public void createDocumentInvalidPackaging() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "ear";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProjectRequestDocumentFactoryTests.class, (GroovyObject)request, (String)"packaging");
        Object event = callSiteArray[134].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[135].call((Object)this.factory, event);
        callSiteArray[136].callStatic(Assert.class, (Object)"ear", callSiteArray[137].callGetProperty(document));
        callSiteArray[138].callStatic(Assert.class, callSiteArray[139].callGetProperty(document));
        callSiteArray[140].callStatic(Assert.class, callSiteArray[141].callGetProperty(document));
    }

    @Test
    public void createDocumentInvalidType() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callCurrent((GroovyObject)this), ProjectRequest.class);
        String string = "ant-project";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProjectRequestDocumentFactoryTests.class, (GroovyObject)request, (String)"type");
        Object event = callSiteArray[143].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[144].call((Object)this.factory, event);
        callSiteArray[145].callStatic(Assert.class, (Object)"ant-project", callSiteArray[146].callGetProperty(document));
        callSiteArray[147].callStatic(Assert.class, callSiteArray[148].callGetProperty(document));
        callSiteArray[149].callStatic(Assert.class, callSiteArray[150].callGetProperty(document));
    }

    @Test
    public void createDocumentInvalidDependency() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].callCurrent((GroovyObject)this), ProjectRequest.class);
        callSiteArray[152].call(callSiteArray[153].call(callSiteArray[154].call(callSiteArray[155].call(callSiteArray[156].callGroovyObjectGetProperty((Object)request), (Object)"web"), (Object)"invalid"), (Object)"data-jpa"), (Object)"invalid-2");
        Object event = callSiteArray[157].callConstructor(ProjectGeneratedEvent.class, (Object)request);
        Object document = callSiteArray[158].call((Object)this.factory, event);
        callSiteArray[159].callStatic(Assert.class, (Object)"web", callSiteArray[160].call(callSiteArray[161].callGetProperty(document), (Object)0));
        callSiteArray[162].callStatic(Assert.class, (Object)"data-jpa", callSiteArray[163].call(callSiteArray[164].callGetProperty(document), (Object)1));
        callSiteArray[165].callStatic(Assert.class, (Object)2, callSiteArray[166].call(callSiteArray[167].callGetProperty(document)));
        callSiteArray[168].callStatic(Assert.class, callSiteArray[169].callGetProperty(document));
        callSiteArray[170].callStatic(Assert.class, (Object)"invalid", callSiteArray[171].call(callSiteArray[172].callGetProperty(document), (Object)0));
        callSiteArray[173].callStatic(Assert.class, (Object)"invalid-2", callSiteArray[174].call(callSiteArray[175].callGetProperty(document), (Object)1));
        callSiteArray[176].callStatic(Assert.class, (Object)2, callSiteArray[177].call(callSiteArray[178].callGetProperty(document)));
    }

    @Test
    public void createDocumentWithProjectFailedEvent() {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        ProjectRequest request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[179].callCurrent((GroovyObject)this), ProjectRequest.class);
        Object event = callSiteArray[180].callConstructor(ProjectFailedEvent.class, (Object)request, callSiteArray[181].callConstructor(IllegalStateException.class, (Object)"my test message"));
        Object document = callSiteArray[182].call((Object)this.factory, event);
        callSiteArray[183].callStatic(Assert.class, callSiteArray[184].callGetProperty(document));
        callSiteArray[185].callStatic(Assert.class, (Object)"my test message", callSiteArray[186].callGetProperty(document));
    }

    private static void assertValid(ProjectRequestDocument document) {
        CallSite[] callSiteArray = ProjectRequestDocumentFactoryTests.$getCallSiteArray();
        callSiteArray[187].callStatic(Assert.class, callSiteArray[188].callGroovyObjectGetProperty((Object)document));
        callSiteArray[189].callStatic(Assert.class, callSiteArray[190].callGroovyObjectGetProperty((Object)document));
        callSiteArray[191].callStatic(Assert.class, callSiteArray[192].callGroovyObjectGetProperty((Object)document));
        callSiteArray[193].callStatic(Assert.class, callSiteArray[194].callGroovyObjectGetProperty((Object)document));
        callSiteArray[195].callStatic(Assert.class, (Object)0, callSiteArray[196].call(callSiteArray[197].callGroovyObjectGetProperty((Object)document)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectRequestDocumentFactoryTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "createProvider";
        stringArray[2] = "metadata";
        stringArray[3] = "createProjectRequest";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "createDocument";
        stringArray[6] = "assertEquals";
        stringArray[7] = "timestamp";
        stringArray[8] = "generationTimestamp";
        stringArray[9] = "assertEquals";
        stringArray[10] = "requestIp";
        stringArray[11] = "assertEquals";
        stringArray[12] = "groupId";
        stringArray[13] = "assertEquals";
        stringArray[14] = "artifactId";
        stringArray[15] = "assertEquals";
        stringArray[16] = "packageName";
        stringArray[17] = "assertEquals";
        stringArray[18] = "bootVersion";
        stringArray[19] = "assertEquals";
        stringArray[20] = "javaVersion";
        stringArray[21] = "assertEquals";
        stringArray[22] = "language";
        stringArray[23] = "assertEquals";
        stringArray[24] = "packaging";
        stringArray[25] = "assertEquals";
        stringArray[26] = "type";
        stringArray[27] = "assertEquals";
        stringArray[28] = "size";
        stringArray[29] = "dependencies";
        stringArray[30] = "assertValid";
        stringArray[31] = "createProjectRequest";
        stringArray[32] = "putAt";
        stringArray[33] = "parameters";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "createDocument";
        stringArray[36] = "assertEquals";
        stringArray[37] = "requestIp";
        stringArray[38] = "assertEquals";
        stringArray[39] = "requestIpv4";
        stringArray[40] = "assertNull";
        stringArray[41] = "requestCountry";
        stringArray[42] = "createProjectRequest";
        stringArray[43] = "putAt";
        stringArray[44] = "parameters";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "createDocument";
        stringArray[47] = "assertEquals";
        stringArray[48] = "requestIp";
        stringArray[49] = "assertNull";
        stringArray[50] = "requestIpv4";
        stringArray[51] = "assertNull";
        stringArray[52] = "requestCountry";
        stringArray[53] = "createProjectRequest";
        stringArray[54] = "putAt";
        stringArray[55] = "parameters";
        stringArray[56] = "putAt";
        stringArray[57] = "parameters";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "createDocument";
        stringArray[60] = "assertEquals";
        stringArray[61] = "requestIp";
        stringArray[62] = "assertEquals";
        stringArray[63] = "requestIpv4";
        stringArray[64] = "assertEquals";
        stringArray[65] = "requestCountry";
        stringArray[66] = "createProjectRequest";
        stringArray[67] = "putAt";
        stringArray[68] = "parameters";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "createDocument";
        stringArray[71] = "assertEquals";
        stringArray[72] = "requestIp";
        stringArray[73] = "assertNull";
        stringArray[74] = "requestIpv4";
        stringArray[75] = "assertNull";
        stringArray[76] = "requestCountry";
        stringArray[77] = "createProjectRequest";
        stringArray[78] = "putAt";
        stringArray[79] = "parameters";
        stringArray[80] = "putAt";
        stringArray[81] = "parameters";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "createDocument";
        stringArray[84] = "assertEquals";
        stringArray[85] = "requestIp";
        stringArray[86] = "assertEquals";
        stringArray[87] = "requestIpv4";
        stringArray[88] = "assertNull";
        stringArray[89] = "requestCountry";
        stringArray[90] = "createProjectRequest";
        stringArray[91] = "putAt";
        stringArray[92] = "parameters";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "createDocument";
        stringArray[95] = "assertNull";
        stringArray[96] = "requestCountry";
        stringArray[97] = "createProjectRequest";
        stringArray[98] = "putAt";
        stringArray[99] = "parameters";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "createDocument";
        stringArray[102] = "assertEquals";
        stringArray[103] = "clientId";
        stringArray[104] = "assertEquals";
        stringArray[105] = "clientVersion";
        stringArray[106] = "createProjectRequest";
        stringArray[107] = "putAt";
        stringArray[108] = "parameters";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "createDocument";
        stringArray[111] = "assertEquals";
        stringArray[112] = "clientId";
        stringArray[113] = "assertEquals";
        stringArray[114] = "clientVersion";
        stringArray[115] = "createProjectRequest";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "createDocument";
        stringArray[118] = "assertEquals";
        stringArray[119] = "javaVersion";
        stringArray[120] = "assertTrue";
        stringArray[121] = "invalid";
        stringArray[122] = "assertTrue";
        stringArray[123] = "invalidJavaVersion";
        stringArray[124] = "createProjectRequest";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "createDocument";
        stringArray[127] = "assertEquals";
        stringArray[128] = "language";
        stringArray[129] = "assertTrue";
        stringArray[130] = "invalid";
        stringArray[131] = "assertTrue";
        stringArray[132] = "invalidLanguage";
        stringArray[133] = "createProjectRequest";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "createDocument";
        stringArray[136] = "assertEquals";
        stringArray[137] = "packaging";
        stringArray[138] = "assertTrue";
        stringArray[139] = "invalid";
        stringArray[140] = "assertTrue";
        stringArray[141] = "invalidPackaging";
        stringArray[142] = "createProjectRequest";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "createDocument";
        stringArray[145] = "assertEquals";
        stringArray[146] = "type";
        stringArray[147] = "assertTrue";
        stringArray[148] = "invalid";
        stringArray[149] = "assertTrue";
        stringArray[150] = "invalidType";
        stringArray[151] = "createProjectRequest";
        stringArray[152] = "leftShift";
        stringArray[153] = "leftShift";
        stringArray[154] = "leftShift";
        stringArray[155] = "leftShift";
        stringArray[156] = "dependencies";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "createDocument";
        stringArray[159] = "assertEquals";
        stringArray[160] = "getAt";
        stringArray[161] = "dependencies";
        stringArray[162] = "assertEquals";
        stringArray[163] = "getAt";
        stringArray[164] = "dependencies";
        stringArray[165] = "assertEquals";
        stringArray[166] = "size";
        stringArray[167] = "dependencies";
        stringArray[168] = "assertTrue";
        stringArray[169] = "invalid";
        stringArray[170] = "assertEquals";
        stringArray[171] = "getAt";
        stringArray[172] = "invalidDependencies";
        stringArray[173] = "assertEquals";
        stringArray[174] = "getAt";
        stringArray[175] = "invalidDependencies";
        stringArray[176] = "assertEquals";
        stringArray[177] = "size";
        stringArray[178] = "invalidDependencies";
        stringArray[179] = "createProjectRequest";
        stringArray[180] = "<$constructor$>";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "createDocument";
        stringArray[183] = "assertTrue";
        stringArray[184] = "invalid";
        stringArray[185] = "assertEquals";
        stringArray[186] = "errorMessage";
        stringArray[187] = "assertFalse";
        stringArray[188] = "invalid";
        stringArray[189] = "assertFalse";
        stringArray[190] = "invalidJavaVersion";
        stringArray[191] = "assertFalse";
        stringArray[192] = "invalidLanguage";
        stringArray[193] = "assertFalse";
        stringArray[194] = "invalidPackaging";
        stringArray[195] = "assertEquals";
        stringArray[196] = "size";
        stringArray[197] = "invalidDependencies";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[198];
        ProjectRequestDocumentFactoryTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProjectRequestDocumentFactoryTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProjectRequestDocumentFactoryTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

