/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.support;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.DependencyMetadata;
import io.spring.initializr.metadata.DependencyMetadataProvider;
import io.spring.initializr.support.DefaultDependencyMetadataProvider;
import io.spring.initializr.test.InitializrMetadataTestBuilder;
import io.spring.initializr.util.Version;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Assert;
import org.junit.Test;

public class DefaultDependencyMetadataProviderTests
implements GroovyObject {
    private final DependencyMetadataProvider provider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DefaultDependencyMetadataProviderTests() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(DefaultDependencyMetadataProvider.class);
        this.provider = (DependencyMetadataProvider)ScriptBytecodeAdapter.castToType((Object)object, DependencyMetadataProvider.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void filterDependencies() {
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object first = callSiteArray[1].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first", "groupId", "org.foo", "artifactId", "first", "versionRange", "1.1.4.RELEASE"}));
        Object second = callSiteArray[2].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "groupId", "org.foo", "artifactId", "second"}));
        Object third = callSiteArray[3].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "third", "groupId", "org.foo", "artifactId", "third", "versionRange", "1.1.8.RELEASE"}));
        Object metadata = callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(InitializrMetadataTestBuilder.class), (Object)"test", first, second, third));
        Object dependencyMetadata = callSiteArray[7].call((Object)this.provider, metadata, callSiteArray[8].call(Version.class, (Object)"1.1.5.RELEASE"));
        callSiteArray[9].callStatic(Assert.class, (Object)2, callSiteArray[10].call(callSiteArray[11].callGetProperty(dependencyMetadata)));
        callSiteArray[12].callStatic(Assert.class, (Object)0, callSiteArray[13].call(callSiteArray[14].callGetProperty(dependencyMetadata)));
        callSiteArray[15].callStatic(Assert.class, (Object)0, callSiteArray[16].call(callSiteArray[17].callGetProperty(dependencyMetadata)));
        callSiteArray[18].callStatic(Assert.class, first, callSiteArray[19].call(callSiteArray[20].callGetProperty(dependencyMetadata), (Object)"first"));
        callSiteArray[21].callStatic(Assert.class, second, callSiteArray[22].call(callSiteArray[23].callGetProperty(dependencyMetadata), (Object)"second"));
    }

    @Test
    public void resolveDependencies() {
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object first = callSiteArray[24].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first", "groupId", "org.foo", "artifactId", "first"}));
        callSiteArray[25].call(callSiteArray[26].callGetProperty(first), callSiteArray[27].callConstructor(Dependency.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "[1.0.0.RELEASE, 1.1.0.RELEASE)", "version", "0.1.0.RELEASE"})));
        callSiteArray[28].call(callSiteArray[29].callGetProperty(first), callSiteArray[30].callConstructor(Dependency.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "1.1.0.RELEASE", "version", "0.2.0.RELEASE"})));
        Object second = callSiteArray[31].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "groupId", "org.foo", "artifactId", "second"}));
        Object metadata = callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call(InitializrMetadataTestBuilder.class), (Object)"test", first, second));
        Object dependencyMetadata = callSiteArray[35].call((Object)this.provider, metadata, callSiteArray[36].call(Version.class, (Object)"1.0.5.RELEASE"));
        callSiteArray[37].callStatic(Assert.class, (Object)2, callSiteArray[38].call(callSiteArray[39].callGetProperty(dependencyMetadata)));
        callSiteArray[40].callStatic(Assert.class, (Object)"0.1.0.RELEASE", callSiteArray[41].callGetProperty(callSiteArray[42].call(callSiteArray[43].callGetProperty(dependencyMetadata), (Object)"first")));
        Object anotherDependencyMetadata = callSiteArray[44].call((Object)this.provider, metadata, callSiteArray[45].call(Version.class, (Object)"1.1.0.RELEASE"));
        callSiteArray[46].callStatic(Assert.class, (Object)2, callSiteArray[47].call(callSiteArray[48].callGetProperty(anotherDependencyMetadata)));
        callSiteArray[49].callStatic(Assert.class, (Object)"0.2.0.RELEASE", callSiteArray[50].callGetProperty(callSiteArray[51].call(callSiteArray[52].callGetProperty(anotherDependencyMetadata), (Object)"first")));
    }

    @Test
    public void addRepoAndRemoveDuplicates() {
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object first = callSiteArray[53].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first", "groupId", "org.foo", "artifactId", "first", "repository", "repo-foo"}));
        Object second = callSiteArray[54].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "groupId", "org.foo", "artifactId", "second"}));
        Object third = callSiteArray[55].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "third", "groupId", "org.foo", "artifactId", "third", "repository", "repo-foo"}));
        Object metadata = callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(InitializrMetadataTestBuilder.class), (Object)"repo-foo", (Object)"my-repo", (Object)"http://localhost", (Object)false), (Object)"test", first, second, third));
        Object dependencyMetadata = callSiteArray[60].call((Object)this.provider, metadata, callSiteArray[61].call(Version.class, (Object)"1.1.5.RELEASE"));
        callSiteArray[62].callStatic(Assert.class, (Object)3, callSiteArray[63].call(callSiteArray[64].callGetProperty(dependencyMetadata)));
        callSiteArray[65].callStatic(Assert.class, (Object)1, callSiteArray[66].call(callSiteArray[67].callGetProperty(dependencyMetadata)));
        callSiteArray[68].callStatic(Assert.class, (Object)0, callSiteArray[69].call(callSiteArray[70].callGetProperty(dependencyMetadata)));
        callSiteArray[71].callStatic(Assert.class, callSiteArray[72].call(callSiteArray[73].callGetProperty(callSiteArray[74].callGetProperty(callSiteArray[75].callGetProperty(metadata))), (Object)"repo-foo"), callSiteArray[76].call(callSiteArray[77].callGetProperty(dependencyMetadata), (Object)"repo-foo"));
    }

    @Test
    public void addBomAndRemoveDuplicates() {
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object first = callSiteArray[78].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first", "groupId", "org.foo", "artifactId", "first", "bom", "bom-foo"}));
        Object second = callSiteArray[79].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "groupId", "org.foo", "artifactId", "second"}));
        Object third = callSiteArray[80].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "third", "groupId", "org.foo", "artifactId", "third", "bom", "bom-foo"}));
        Object bom = callSiteArray[81].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "org.foo", "artifactId", "bom"}));
        callSiteArray[82].call(callSiteArray[83].callGetProperty(bom), callSiteArray[84].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "[1.0.0.RELEASE, 1.1.8.RELEASE)", "version", "1.0.0.RELEASE"})));
        callSiteArray[85].call(callSiteArray[86].callGetProperty(bom), callSiteArray[87].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "1.1.8.RELEASE", "version", "2.0.0.RELEASE"})));
        Object metadata = callSiteArray[88].call(callSiteArray[89].call(callSiteArray[90].call(callSiteArray[91].call(InitializrMetadataTestBuilder.class), (Object)"bom-foo", bom), (Object)"test", first, second, third));
        Object dependencyMetadata = callSiteArray[92].call((Object)this.provider, metadata, callSiteArray[93].call(Version.class, (Object)"1.1.5.RELEASE"));
        callSiteArray[94].callStatic(Assert.class, (Object)3, callSiteArray[95].call(callSiteArray[96].callGetProperty(dependencyMetadata)));
        callSiteArray[97].callStatic(Assert.class, (Object)0, callSiteArray[98].call(callSiteArray[99].callGetProperty(dependencyMetadata)));
        callSiteArray[100].callStatic(Assert.class, (Object)1, callSiteArray[101].call(callSiteArray[102].callGetProperty(dependencyMetadata)));
        callSiteArray[103].callStatic(Assert.class, (Object)"org.foo", callSiteArray[104].callGetProperty(callSiteArray[105].call(callSiteArray[106].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
        callSiteArray[107].callStatic(Assert.class, (Object)"bom", callSiteArray[108].callGetProperty(callSiteArray[109].call(callSiteArray[110].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
        callSiteArray[111].callStatic(Assert.class, (Object)"1.0.0.RELEASE", callSiteArray[112].callGetProperty(callSiteArray[113].call(callSiteArray[114].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
    }

    @Test
    public void repoFromBomAccordingToVersion() {
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object dependencyMetadata = callSiteArray[115].callCurrent((GroovyObject)this, (Object)"1.0.9.RELEASE");
        callSiteArray[116].callStatic(Assert.class, callSiteArray[117].call(Version.class, (Object)"1.0.9.RELEASE"), callSiteArray[118].callGetProperty(dependencyMetadata));
        callSiteArray[119].callStatic(Assert.class, (Object)3, callSiteArray[120].call(callSiteArray[121].callGetProperty(dependencyMetadata)));
        callSiteArray[122].callStatic(Assert.class, (Object)2, callSiteArray[123].call(callSiteArray[124].callGetProperty(dependencyMetadata)));
        callSiteArray[125].callStatic(Assert.class, (Object)1, callSiteArray[126].call(callSiteArray[127].callGetProperty(dependencyMetadata)));
        callSiteArray[128].callStatic(Assert.class, (Object)"foo", callSiteArray[129].callGetProperty(callSiteArray[130].call(callSiteArray[131].callGetProperty(dependencyMetadata), (Object)"repo-foo")));
        callSiteArray[132].callStatic(Assert.class, (Object)"bar", callSiteArray[133].callGetProperty(callSiteArray[134].call(callSiteArray[135].callGetProperty(dependencyMetadata), (Object)"repo-bar")));
        callSiteArray[136].callStatic(Assert.class, (Object)"org.foo", callSiteArray[137].callGetProperty(callSiteArray[138].call(callSiteArray[139].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
        callSiteArray[140].callStatic(Assert.class, (Object)"bom", callSiteArray[141].callGetProperty(callSiteArray[142].call(callSiteArray[143].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
        callSiteArray[144].callStatic(Assert.class, (Object)"2.0.0.RELEASE", callSiteArray[145].callGetProperty(callSiteArray[146].call(callSiteArray[147].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
    }

    @Test
    public void repoFromBomAccordingToAnotherVersion() {
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object dependencyMetadata = callSiteArray[148].callCurrent((GroovyObject)this, (Object)"1.1.5.RELEASE");
        callSiteArray[149].callStatic(Assert.class, callSiteArray[150].call(Version.class, (Object)"1.1.5.RELEASE"), callSiteArray[151].callGetProperty(dependencyMetadata));
        callSiteArray[152].callStatic(Assert.class, (Object)3, callSiteArray[153].call(callSiteArray[154].callGetProperty(dependencyMetadata)));
        callSiteArray[155].callStatic(Assert.class, (Object)2, callSiteArray[156].call(callSiteArray[157].callGetProperty(dependencyMetadata)));
        callSiteArray[158].callStatic(Assert.class, (Object)1, callSiteArray[159].call(callSiteArray[160].callGetProperty(dependencyMetadata)));
        callSiteArray[161].callStatic(Assert.class, (Object)"foo", callSiteArray[162].callGetProperty(callSiteArray[163].call(callSiteArray[164].callGetProperty(dependencyMetadata), (Object)"repo-foo")));
        callSiteArray[165].callStatic(Assert.class, (Object)"biz", callSiteArray[166].callGetProperty(callSiteArray[167].call(callSiteArray[168].callGetProperty(dependencyMetadata), (Object)"repo-biz")));
        callSiteArray[169].callStatic(Assert.class, (Object)"org.foo", callSiteArray[170].callGetProperty(callSiteArray[171].call(callSiteArray[172].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
        callSiteArray[173].callStatic(Assert.class, (Object)"bom", callSiteArray[174].callGetProperty(callSiteArray[175].call(callSiteArray[176].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
        callSiteArray[177].callStatic(Assert.class, (Object)"3.0.0.RELEASE", callSiteArray[178].callGetProperty(callSiteArray[179].call(callSiteArray[180].callGetProperty(dependencyMetadata), (Object)"bom-foo")));
    }

    private DependencyMetadata testRepoFromBomAccordingToVersion(Object bootVersion) {
        CallSite[] callSiteArray = DefaultDependencyMetadataProviderTests.$getCallSiteArray();
        Object first = callSiteArray[181].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "first", "groupId", "org.foo", "artifactId", "first", "repository", "repo-foo"}));
        Object second = callSiteArray[182].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "second", "groupId", "org.foo", "artifactId", "second"}));
        Object third = callSiteArray[183].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "third", "groupId", "org.foo", "artifactId", "third", "bom", "bom-foo"}));
        BillOfMaterials bom = (BillOfMaterials)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "org.foo", "artifactId", "bom"})), BillOfMaterials.class);
        callSiteArray[185].call(callSiteArray[186].callGroovyObjectGetProperty((Object)bom), callSiteArray[187].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "[1.0.0.RELEASE, 1.1.0.RELEASE)", "version", "2.0.0.RELEASE", "repositories", ScriptBytecodeAdapter.createList((Object[])new Object[]{"repo-foo", "repo-bar"})})));
        callSiteArray[188].call(callSiteArray[189].callGroovyObjectGetProperty((Object)bom), callSiteArray[190].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "1.1.0.RELEASE", "version", "3.0.0.RELEASE", "repositories", ScriptBytecodeAdapter.createList((Object[])new Object[]{"repo-biz"})})));
        Object metadata = callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].call(callSiteArray[194].call(callSiteArray[195].call(callSiteArray[196].call(callSiteArray[197].call(InitializrMetadataTestBuilder.class), (Object)"bom-foo", (Object)bom), (Object)"repo-foo", (Object)"foo", (Object)"http://localhost", (Object)false), (Object)"repo-bar", (Object)"bar", (Object)"http://localhost", (Object)false), (Object)"repo-biz", (Object)"biz", (Object)"http://localhost", (Object)false), (Object)"test", first, second, third));
        return (DependencyMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[198].call((Object)this.provider, metadata, callSiteArray[199].call(Version.class, bootVersion)), DependencyMetadata.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultDependencyMetadataProviderTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "build";
        stringArray[5] = "addDependencyGroup";
        stringArray[6] = "withDefaults";
        stringArray[7] = "get";
        stringArray[8] = "parse";
        stringArray[9] = "assertEquals";
        stringArray[10] = "size";
        stringArray[11] = "dependencies";
        stringArray[12] = "assertEquals";
        stringArray[13] = "size";
        stringArray[14] = "repositories";
        stringArray[15] = "assertEquals";
        stringArray[16] = "size";
        stringArray[17] = "boms";
        stringArray[18] = "assertSame";
        stringArray[19] = "getAt";
        stringArray[20] = "dependencies";
        stringArray[21] = "assertSame";
        stringArray[22] = "getAt";
        stringArray[23] = "dependencies";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "leftShift";
        stringArray[26] = "versions";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "leftShift";
        stringArray[29] = "versions";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "build";
        stringArray[33] = "addDependencyGroup";
        stringArray[34] = "withDefaults";
        stringArray[35] = "get";
        stringArray[36] = "parse";
        stringArray[37] = "assertEquals";
        stringArray[38] = "size";
        stringArray[39] = "dependencies";
        stringArray[40] = "assertEquals";
        stringArray[41] = "version";
        stringArray[42] = "getAt";
        stringArray[43] = "dependencies";
        stringArray[44] = "get";
        stringArray[45] = "parse";
        stringArray[46] = "assertEquals";
        stringArray[47] = "size";
        stringArray[48] = "dependencies";
        stringArray[49] = "assertEquals";
        stringArray[50] = "version";
        stringArray[51] = "getAt";
        stringArray[52] = "dependencies";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "build";
        stringArray[57] = "addDependencyGroup";
        stringArray[58] = "addRepository";
        stringArray[59] = "withDefaults";
        stringArray[60] = "get";
        stringArray[61] = "parse";
        stringArray[62] = "assertEquals";
        stringArray[63] = "size";
        stringArray[64] = "dependencies";
        stringArray[65] = "assertEquals";
        stringArray[66] = "size";
        stringArray[67] = "repositories";
        stringArray[68] = "assertEquals";
        stringArray[69] = "size";
        stringArray[70] = "boms";
        stringArray[71] = "assertSame";
        stringArray[72] = "get";
        stringArray[73] = "repositories";
        stringArray[74] = "env";
        stringArray[75] = "configuration";
        stringArray[76] = "getAt";
        stringArray[77] = "repositories";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "leftShift";
        stringArray[83] = "mappings";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "leftShift";
        stringArray[86] = "mappings";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "build";
        stringArray[89] = "addDependencyGroup";
        stringArray[90] = "addBom";
        stringArray[91] = "withDefaults";
        stringArray[92] = "get";
        stringArray[93] = "parse";
        stringArray[94] = "assertEquals";
        stringArray[95] = "size";
        stringArray[96] = "dependencies";
        stringArray[97] = "assertEquals";
        stringArray[98] = "size";
        stringArray[99] = "repositories";
        stringArray[100] = "assertEquals";
        stringArray[101] = "size";
        stringArray[102] = "boms";
        stringArray[103] = "assertEquals";
        stringArray[104] = "groupId";
        stringArray[105] = "getAt";
        stringArray[106] = "boms";
        stringArray[107] = "assertEquals";
        stringArray[108] = "artifactId";
        stringArray[109] = "getAt";
        stringArray[110] = "boms";
        stringArray[111] = "assertEquals";
        stringArray[112] = "version";
        stringArray[113] = "getAt";
        stringArray[114] = "boms";
        stringArray[115] = "testRepoFromBomAccordingToVersion";
        stringArray[116] = "assertEquals";
        stringArray[117] = "parse";
        stringArray[118] = "bootVersion";
        stringArray[119] = "assertEquals";
        stringArray[120] = "size";
        stringArray[121] = "dependencies";
        stringArray[122] = "assertEquals";
        stringArray[123] = "size";
        stringArray[124] = "repositories";
        stringArray[125] = "assertEquals";
        stringArray[126] = "size";
        stringArray[127] = "boms";
        stringArray[128] = "assertEquals";
        stringArray[129] = "name";
        stringArray[130] = "getAt";
        stringArray[131] = "repositories";
        stringArray[132] = "assertEquals";
        stringArray[133] = "name";
        stringArray[134] = "getAt";
        stringArray[135] = "repositories";
        stringArray[136] = "assertEquals";
        stringArray[137] = "groupId";
        stringArray[138] = "getAt";
        stringArray[139] = "boms";
        stringArray[140] = "assertEquals";
        stringArray[141] = "artifactId";
        stringArray[142] = "getAt";
        stringArray[143] = "boms";
        stringArray[144] = "assertEquals";
        stringArray[145] = "version";
        stringArray[146] = "getAt";
        stringArray[147] = "boms";
        stringArray[148] = "testRepoFromBomAccordingToVersion";
        stringArray[149] = "assertEquals";
        stringArray[150] = "parse";
        stringArray[151] = "bootVersion";
        stringArray[152] = "assertEquals";
        stringArray[153] = "size";
        stringArray[154] = "dependencies";
        stringArray[155] = "assertEquals";
        stringArray[156] = "size";
        stringArray[157] = "repositories";
        stringArray[158] = "assertEquals";
        stringArray[159] = "size";
        stringArray[160] = "boms";
        stringArray[161] = "assertEquals";
        stringArray[162] = "name";
        stringArray[163] = "getAt";
        stringArray[164] = "repositories";
        stringArray[165] = "assertEquals";
        stringArray[166] = "name";
        stringArray[167] = "getAt";
        stringArray[168] = "repositories";
        stringArray[169] = "assertEquals";
        stringArray[170] = "groupId";
        stringArray[171] = "getAt";
        stringArray[172] = "boms";
        stringArray[173] = "assertEquals";
        stringArray[174] = "artifactId";
        stringArray[175] = "getAt";
        stringArray[176] = "boms";
        stringArray[177] = "assertEquals";
        stringArray[178] = "version";
        stringArray[179] = "getAt";
        stringArray[180] = "boms";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "<$constructor$>";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "leftShift";
        stringArray[186] = "mappings";
        stringArray[187] = "<$constructor$>";
        stringArray[188] = "leftShift";
        stringArray[189] = "mappings";
        stringArray[190] = "<$constructor$>";
        stringArray[191] = "build";
        stringArray[192] = "addDependencyGroup";
        stringArray[193] = "addRepository";
        stringArray[194] = "addRepository";
        stringArray[195] = "addRepository";
        stringArray[196] = "addBom";
        stringArray[197] = "withDefaults";
        stringArray[198] = "get";
        stringArray[199] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[200];
        DefaultDependencyMetadataProviderTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DefaultDependencyMetadataProviderTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DefaultDependencyMetadataProviderTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

