/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.spring.initializr.generator.InvalidProjectRequestException;
import io.spring.initializr.generator.ProjectFailedEvent;
import io.spring.initializr.generator.ProjectGeneratedEvent;
import io.spring.initializr.generator.ProjectGenerator;
import io.spring.initializr.generator.ProjectRequest;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import io.spring.initializr.test.GradleBuildAssert;
import io.spring.initializr.test.InitializrMetadataTestBuilder;
import io.spring.initializr.test.PomAssert;
import io.spring.initializr.test.ProjectAssert;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

public class ProjectGeneratorTests
implements GroovyObject {
    @Rule
    public final TemporaryFolder folder;
    private final ProjectGenerator projectGenerator;
    private final ApplicationEventPublisher eventPublisher;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProjectGeneratorTests() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(TemporaryFolder.class);
        this.folder = (TemporaryFolder)ScriptBytecodeAdapter.castToType((Object)object, TemporaryFolder.class);
        Object object2 = callSiteArray[1].callConstructor(ProjectGenerator.class);
        this.projectGenerator = (ProjectGenerator)ScriptBytecodeAdapter.castToType((Object)object2, ProjectGenerator.class);
        Object object3 = callSiteArray[2].callStatic(Mockito.class, ApplicationEventPublisher.class);
        this.eventPublisher = (ApplicationEventPublisher)ScriptBytecodeAdapter.castToType((Object)object3, ApplicationEventPublisher.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Before
    public void setup() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object metadata = callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(InitializrMetadataTestBuilder.class), ArrayUtil.createArray((Object)"test", (Object)"web", (Object)"security", (Object)"data-jpa", (Object)"aop", (Object)"batch", (Object)"integration")));
        callSiteArray[6].callCurrent((GroovyObject)this, metadata);
        ApplicationEventPublisher applicationEventPublisher = this.eventPublisher;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)applicationEventPublisher, ProjectGeneratorTests.class, (GroovyObject)this.projectGenerator, (String)"eventPublisher");
        Object object = callSiteArray[7].callGetProperty(callSiteArray[8].call((Object)this.folder));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProjectGeneratorTests.class, (GroovyObject)this.projectGenerator, (String)"tmpdir");
    }

    @Test
    public void defaultMavenPom() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[9].callCurrent((GroovyObject)this, (Object)"web");
        callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].callCurrent((GroovyObject)this, request)), (Object)"web");
        callSiteArray[13].call(callSiteArray[14].callStatic(Mockito.class, (Object)this.eventPublisher, callSiteArray[15].callStatic(Mockito.class, (Object)1)), callSiteArray[16].callStatic(Matchers.class, callSiteArray[17].callConstructor(ProjectGeneratedEventMatcher.class, request)));
    }

    @Test
    public void defaultGradleBuild() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[18].callCurrent((GroovyObject)this, (Object)"web");
        callSiteArray[19].callCurrent((GroovyObject)this, request);
        callSiteArray[20].call(callSiteArray[21].callStatic(Mockito.class, (Object)this.eventPublisher, callSiteArray[22].callStatic(Mockito.class, (Object)1)), callSiteArray[23].callStatic(Matchers.class, callSiteArray[24].callConstructor(ProjectGeneratedEventMatcher.class, request)));
    }

    @Test
    public void defaultProject() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[25].callCurrent((GroovyObject)this, (Object)"web");
        callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].callCurrent((GroovyObject)this, request))))), (Object)"web");
        callSiteArray[32].call(callSiteArray[33].callStatic(Mockito.class, (Object)this.eventPublisher, callSiteArray[34].callStatic(Mockito.class, (Object)1)), callSiteArray[35].callStatic(Matchers.class, callSiteArray[36].callConstructor(ProjectGeneratedEventMatcher.class, request)));
    }

    @Test
    public void noDependencyAddsRootStarter() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[37].callCurrent((GroovyObject)this);
        callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].callCurrent((GroovyObject)this, request)))));
    }

    @Test
    public void mavenPomWithBootSnapshot() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[43].callCurrent((GroovyObject)this, (Object)"web");
        String string = "1.0.1.BUILD-SNAPSHOT";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].callCurrent((GroovyObject)this, request)), (Object)"web");
    }

    @Test
    public void mavenPomWithWebFacet() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object dependency = callSiteArray[47].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "thymeleaf", "groupId", "org.foo", "artifactId", "thymeleaf"}));
        callSiteArray[48].call(callSiteArray[49].callGetProperty(dependency), (Object)"web");
        Object metadata = callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"data-jpa"), (Object)"test", dependency));
        callSiteArray[54].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[55].callCurrent((GroovyObject)this, (Object)"thymeleaf");
        callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].callCurrent((GroovyObject)this, request), (Object)"org.foo", (Object)"thymeleaf"), (Object)2);
    }

    @Test
    public void mavenWarWithWebFacet() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object dependency = callSiteArray[59].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "thymeleaf", "groupId", "org.foo", "artifactId", "thymeleaf"}));
        callSiteArray[60].call(callSiteArray[61].callGetProperty(dependency), (Object)"web");
        Object metadata = callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"data-jpa"), (Object)"test", dependency));
        callSiteArray[66].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[67].callCurrent((GroovyObject)this, (Object)"thymeleaf");
        String string = "war";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packaging");
        callSiteArray[68].call(callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call(callSiteArray[75].callCurrent((GroovyObject)this, request))))), (Object)"org.foo", (Object)"thymeleaf")), (Object)3);
    }

    @Test
    public void mavenWarPomWithoutWebFacet() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[76].callCurrent((GroovyObject)this, (Object)"data-jpa");
        String string = "war";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packaging");
        callSiteArray[77].call(callSiteArray[78].call(callSiteArray[79].call(callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].callCurrent((GroovyObject)this, request)), (Object)"data-jpa"), (Object)"web")), (Object)4);
    }

    @Test
    public void gradleWarWithWebFacet() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object dependency = callSiteArray[83].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "thymeleaf", "groupId", "org.foo", "artifactId", "thymeleaf"}));
        callSiteArray[84].call(callSiteArray[85].callGetProperty(dependency), (Object)"web");
        Object metadata = callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].call(callSiteArray[89].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"data-jpa"), (Object)"test", dependency));
        callSiteArray[90].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[91].callCurrent((GroovyObject)this, (Object)"thymeleaf");
        String string = "war";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packaging");
        String string2 = "gradle-project";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"type");
        callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call(callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].callCurrent((GroovyObject)this, request)))), (Object)"compile('org.foo:thymeleaf')"), (Object)"compile('org.springframework.boot:spring-boot-starter-web')"), (Object)"testCompile('org.springframework.boot:spring-boot-starter-test')"), (Object)"configurations {"), (Object)"providedRuntime"), (Object)"providedRuntime('org.springframework.boot:spring-boot-starter-tomcat')");
    }

    @Test
    public void gradleWarPomWithoutWebFacet() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[102].callCurrent((GroovyObject)this, (Object)"data-jpa");
        String string = "war";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packaging");
        callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].callCurrent((GroovyObject)this, request), (Object)"compile('org.springframework.boot:spring-boot-starter-data-jpa')"), (Object)"compile('org.springframework.boot:spring-boot-starter-web')"), (Object)"testCompile('org.springframework.boot:spring-boot-starter-test')"), (Object)"configurations {"), (Object)"providedRuntime"), (Object)"providedRuntime('org.springframework.boot:spring-boot-starter-tomcat')");
    }

    @Test
    public void springBoot11UseEnableAutoConfigurationJava() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[110].callCurrent((GroovyObject)this, (Object)"web");
        String string = "1.1.9.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        String string2 = "MyDemo";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"name");
        String string3 = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)request, (String)"packageName");
        callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].callCurrent((GroovyObject)this, request), (Object)"src/main/java/foo/MyDemoApplication.java"), callSiteArray[117].callGetProperty(EnableAutoConfiguration.class), callSiteArray[118].callGetProperty(ComponentScan.class), callSiteArray[119].callGetProperty(Configuration.class)), callSiteArray[120].callGetProperty(SpringBootApplication.class)), (Object)"@EnableAutoConfiguration", (Object)"@Configuration", (Object)"@ComponentScan"), (Object)"@SpringBootApplication");
    }

    @Test
    public void springBootUseSpringBootApplicationJava() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[121].callCurrent((GroovyObject)this, (Object)"web");
        String string = "1.2.0.RC1";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        String string2 = "MyDemo";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"name");
        String string3 = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)request, (String)"packageName");
        callSiteArray[122].call(callSiteArray[123].call(callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].call(callSiteArray[127].callCurrent((GroovyObject)this, request), (Object)"src/main/java/foo/MyDemoApplication.java"), callSiteArray[128].callGetProperty(SpringBootApplication.class)), callSiteArray[129].callGetProperty(EnableAutoConfiguration.class), callSiteArray[130].callGetProperty(ComponentScan.class), callSiteArray[131].callGetProperty(Configuration.class)), (Object)"@SpringBootApplication"), (Object)"@EnableAutoConfiguration", (Object)"@Configuration", (Object)"@ComponentScan");
    }

    @Test
    public void springBoot11UseEnableAutoConfigurationGroovy() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[132].callCurrent((GroovyObject)this, (Object)"web");
        String string = "groovy";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"language");
        String string2 = "1.1.9.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"bootVersion");
        String string3 = "MyDemo";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)request, (String)"name");
        String string4 = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)request, (String)"packageName");
        callSiteArray[133].call(callSiteArray[134].call(callSiteArray[135].call(callSiteArray[136].call(callSiteArray[137].call(callSiteArray[138].callCurrent((GroovyObject)this, request), (Object)"src/main/groovy/foo/MyDemoApplication.groovy"), callSiteArray[139].callGetProperty(EnableAutoConfiguration.class), callSiteArray[140].callGetProperty(ComponentScan.class), callSiteArray[141].callGetProperty(Configuration.class)), callSiteArray[142].callGetProperty(SpringBootApplication.class)), (Object)"@EnableAutoConfiguration", (Object)"@Configuration", (Object)"@ComponentScan"), (Object)"@SpringBootApplication");
    }

    @Test
    public void springBootUseSpringBootApplicationGroovy() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[143].callCurrent((GroovyObject)this, (Object)"web");
        String string = "groovy";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"language");
        String string2 = "1.2.0.RC1";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"bootVersion");
        String string3 = "MyDemo";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)request, (String)"name");
        String string4 = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)request, (String)"packageName");
        callSiteArray[144].call(callSiteArray[145].call(callSiteArray[146].call(callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].callCurrent((GroovyObject)this, request), (Object)"src/main/groovy/foo/MyDemoApplication.groovy"), callSiteArray[150].callGetProperty(SpringBootApplication.class)), callSiteArray[151].callGetProperty(EnableAutoConfiguration.class), callSiteArray[152].callGetProperty(ComponentScan.class), callSiteArray[153].callGetProperty(Configuration.class)), (Object)"@SpringBootApplication"), (Object)"@EnableAutoConfiguration", (Object)"@Configuration", (Object)"@ComponentScan");
    }

    @Test
    public void springBoot11UseEnableAutoConfigurationKotlin() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[154].callCurrent((GroovyObject)this, (Object)"web");
        String string = "kotlin";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"language");
        String string2 = "1.1.9.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"bootVersion");
        String string3 = "MyDemo";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)request, (String)"name");
        String string4 = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)request, (String)"packageName");
        callSiteArray[155].call(callSiteArray[156].call(callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].callCurrent((GroovyObject)this, request), (Object)"src/main/kotlin/foo/MyDemoApplication.kt"), callSiteArray[161].callGetProperty(EnableAutoConfiguration.class), callSiteArray[162].callGetProperty(ComponentScan.class), callSiteArray[163].callGetProperty(Configuration.class)), callSiteArray[164].callGetProperty(SpringBootApplication.class)), (Object)"@EnableAutoConfiguration", (Object)"@Configuration", (Object)"@ComponentScan"), (Object)"@SpringBootApplication");
    }

    @Test
    public void springBootUseSpringBootApplicationKotlin() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[165].callCurrent((GroovyObject)this, (Object)"web");
        String string = "kotlin";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"language");
        String string2 = "1.2.0.RC1";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"bootVersion");
        String string3 = "MyDemo";
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)request, (String)"name");
        String string4 = "foo";
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)request, (String)"packageName");
        callSiteArray[166].call(callSiteArray[167].call(callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].call(callSiteArray[171].callCurrent((GroovyObject)this, request), (Object)"src/main/kotlin/foo/MyDemoApplication.kt"), callSiteArray[172].callGetProperty(SpringBootApplication.class)), callSiteArray[173].callGetProperty(EnableAutoConfiguration.class), callSiteArray[174].callGetProperty(ComponentScan.class), callSiteArray[175].callGetProperty(Configuration.class)), (Object)"@SpringBootApplication"), (Object)"@EnableAutoConfiguration", (Object)"@Configuration", (Object)"@ComponentScan");
    }

    @Test
    public void customBaseDirectory() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[176].callCurrent((GroovyObject)this);
        String string = "my-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"baseDir");
        callSiteArray[177].call(callSiteArray[178].call(callSiteArray[179].call(callSiteArray[180].callCurrent((GroovyObject)this, request), (Object)"my-project")));
    }

    @Test
    public void customBaseDirectoryNested() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[181].callCurrent((GroovyObject)this);
        String string = "foo-bar/my-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"baseDir");
        callSiteArray[182].call(callSiteArray[183].call(callSiteArray[184].call(callSiteArray[185].callCurrent((GroovyObject)this, request), (Object)"foo-bar/my-project")));
    }

    @Test
    public void groovyWithMavenUsesGroovyDir() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[186].callCurrent((GroovyObject)this, (Object)"web");
        String string = "maven-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        String string2 = "groovy";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"language");
        callSiteArray[187].call(callSiteArray[188].call(callSiteArray[189].callCurrent((GroovyObject)this, request)));
    }

    @Test
    public void groovyWithGradleUsesGroovyDir() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[190].callCurrent((GroovyObject)this, (Object)"web");
        String string = "gradle-project";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        String string2 = "groovy";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request, (String)"language");
        callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].callCurrent((GroovyObject)this, request)));
    }

    @Test
    public void mavenPomWithCustomVersion() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object whatever = callSiteArray[194].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "whatever", "groupId", "org.acme", "artifactId", "whatever", "version", "1.2.3"}));
        Object metadata = callSiteArray[195].call(callSiteArray[196].call(callSiteArray[197].call(callSiteArray[198].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"data-jpa"), (Object)"foo", whatever));
        callSiteArray[199].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[200].callCurrent((GroovyObject)this, (Object)"whatever", (Object)"data-jpa", (Object)"web");
        callSiteArray[201].call(callSiteArray[202].call(callSiteArray[203].call(callSiteArray[204].callCurrent((GroovyObject)this, request), whatever), (Object)"data-jpa"), (Object)"web");
    }

    @Test
    public void gradleBuildWithBootSnapshot() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[205].callCurrent((GroovyObject)this, (Object)"web");
        String string = "1.0.1.BUILD-SNAPSHOT";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[206].call(callSiteArray[207].callCurrent((GroovyObject)this, request));
    }

    @Test
    public void gradleBuildWithCustomVersion() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object whatever = callSiteArray[208].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "whatever", "groupId", "org.acme", "artifactId", "whatever", "version", "1.2.3"}));
        Object metadata = callSiteArray[209].call(callSiteArray[210].call(callSiteArray[211].call(callSiteArray[212].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"data-jpa"), (Object)"foo", whatever));
        callSiteArray[213].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[214].callCurrent((GroovyObject)this, (Object)"whatever", (Object)"data-jpa", (Object)"web");
        callSiteArray[215].call(callSiteArray[216].call(callSiteArray[217].call(callSiteArray[218].callCurrent((GroovyObject)this, request), (Object)"compile('org.springframework.boot:spring-boot-starter-web')"), (Object)"compile('org.springframework.boot:spring-boot-starter-data-jpa')"), (Object)"compile('org.acme:whatever:1.2.3')");
    }

    @Test
    public void mavenPomWithCustomScope() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object h2 = callSiteArray[219].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "h2", "groupId", "org.h2", "artifactId", "h2", "scope", "runtime"}));
        Object hamcrest = callSiteArray[220].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "hamcrest", "groupId", "org.hamcrest", "artifactId", "hamcrest", "scope", "test"}));
        Object servlet = callSiteArray[221].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "servlet-api", "groupId", "javax.servlet", "artifactId", "servlet-api", "scope", "provided"}));
        Object metadata = callSiteArray[222].call(callSiteArray[223].call(callSiteArray[224].call(callSiteArray[225].call(callSiteArray[226].call(callSiteArray[227].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"data-jpa"), (Object)"database", h2), (Object)"container", servlet), (Object)"test", hamcrest));
        callSiteArray[228].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[229].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)"hamcrest", (Object)"h2", (Object)"servlet-api", (Object)"data-jpa", (Object)"web"));
        callSiteArray[230].call(callSiteArray[231].call(callSiteArray[232].call(callSiteArray[233].call(callSiteArray[234].call(callSiteArray[235].callCurrent((GroovyObject)this, request), h2), hamcrest), servlet), (Object)"data-jpa"), (Object)"web");
    }

    @Test
    public void gradleBuildWithCustomScope() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object h2 = callSiteArray[236].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "h2", "groupId", "org.h2", "artifactId", "h2", "scope", "runtime"}));
        Object hamcrest = callSiteArray[237].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "hamcrest", "groupId", "org.hamcrest", "artifactId", "hamcrest", "scope", "test"}));
        Object servlet = callSiteArray[238].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "servlet-api", "groupId", "javax.servlet", "artifactId", "servlet-api", "scope", "provided"}));
        Object metadata = callSiteArray[239].call(callSiteArray[240].call(callSiteArray[241].call(callSiteArray[242].call(callSiteArray[243].call(callSiteArray[244].call(InitializrMetadataTestBuilder.class), (Object)"core", (Object)"web", (Object)"security", (Object)"data-jpa"), (Object)"database", h2), (Object)"container", servlet), (Object)"test", hamcrest));
        callSiteArray[245].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[246].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)"hamcrest", (Object)"h2", (Object)"servlet-api", (Object)"data-jpa", (Object)"web"));
        callSiteArray[247].call(callSiteArray[248].call(callSiteArray[249].call(callSiteArray[250].call(callSiteArray[251].call(callSiteArray[252].call(callSiteArray[253].call(callSiteArray[254].callCurrent((GroovyObject)this, request), (Object)"compile('org.springframework.boot:spring-boot-starter-web')"), (Object)"compile('org.springframework.boot:spring-boot-starter-data-jpa')"), (Object)"runtime('org.h2:h2')"), (Object)"configurations {"), (Object)"providedRuntime"), (Object)"providedRuntime('javax.servlet:servlet-api')"), (Object)"testCompile('org.hamcrest:hamcrest')");
    }

    @Test
    public void gradleBuildBeforeWithSpringBoot13() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[255].callCurrent((GroovyObject)this, (Object)"web");
        String string = "1.2.3.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[256].call(callSiteArray[257].call(callSiteArray[258].call(callSiteArray[259].call(callSiteArray[260].callCurrent((GroovyObject)this, request), (Object)"springBootVersion = '1.2.3.RELEASE'"), (Object)"classpath('io.spring.gradle:dependency-management-plugin:0.5.6.RELEASE')"), (Object)"apply plugin: 'spring-boot'"), (Object)"apply plugin: 'io.spring.dependency-management'");
    }

    @Test
    public void gradleBuildAsFromSpringBoot13() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[261].callCurrent((GroovyObject)this, (Object)"web");
        String string = "1.3.0.BUILD-SNAPSHOT";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[262].call(callSiteArray[263].call(callSiteArray[264].call(callSiteArray[265].call(callSiteArray[266].callCurrent((GroovyObject)this, request), (Object)"springBootVersion = '1.3.0.BUILD-SNAPSHOT'"), (Object)"apply plugin: 'spring-boot'"), (Object)"classpath('io.spring.gradle:dependency-management-plugin:0.5.6.RELEASE')"), (Object)"apply plugin: 'io.spring.dependency-management'");
    }

    @Test
    public void mavenBom() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[267].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "bom", "foo-bom"}));
        Object metadata = callSiteArray[268].call(callSiteArray[269].call(callSiteArray[270].call(callSiteArray[271].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo), (Object)"foo-bom", (Object)"org.acme", (Object)"foo-bom", (Object)"1.2.3"));
        callSiteArray[272].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[273].callCurrent((GroovyObject)this, (Object)"foo");
        callSiteArray[274].call(callSiteArray[275].call(callSiteArray[276].callCurrent((GroovyObject)this, request), foo), (Object)"org.acme", (Object)"foo-bom", (Object)"1.2.3");
    }

    @Test
    public void mavenBomWithSeveralDependenciesOnSameBom() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[277].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "bom", "the-bom"}));
        Object bar = callSiteArray[278].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "bar", "groupId", "org.acme", "artifactId", "bar", "bom", "the-bom"}));
        Object metadata = callSiteArray[279].call(callSiteArray[280].call(callSiteArray[281].call(callSiteArray[282].call(InitializrMetadataTestBuilder.class), (Object)"group", foo, bar), (Object)"the-bom", (Object)"org.acme", (Object)"the-bom", (Object)"1.2.3"));
        callSiteArray[283].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[284].callCurrent((GroovyObject)this, (Object)"foo", (Object)"bar");
        callSiteArray[285].call(callSiteArray[286].call(callSiteArray[287].call(callSiteArray[288].callCurrent((GroovyObject)this, request), foo), (Object)"org.acme", (Object)"the-bom", (Object)"1.2.3"), (Object)1);
    }

    @Test
    public void mavenBomWithVersionMapping() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[289].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "bom", "the-bom"}));
        Object bom = callSiteArray[290].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "org.acme", "artifactId", "foo-bom"}));
        callSiteArray[291].call(callSiteArray[292].callGetProperty(bom), callSiteArray[293].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "[1.2.0.RELEASE,1.3.0.M1)", "version", "1.0.0"})));
        callSiteArray[294].call(callSiteArray[295].callGetProperty(bom), callSiteArray[296].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "1.3.0.M1", "version", "1.2.0"})));
        Object metadata = callSiteArray[297].call(callSiteArray[298].call(callSiteArray[299].call(callSiteArray[300].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo), (Object)"the-bom", bom));
        callSiteArray[301].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[302].callCurrent((GroovyObject)this, (Object)"foo");
        String string = "1.2.5.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[303].call(callSiteArray[304].call(callSiteArray[305].callCurrent((GroovyObject)this, request), foo), (Object)"org.acme", (Object)"foo-bom", (Object)"1.0.0");
        Object request2 = callSiteArray[306].callCurrent((GroovyObject)this, (Object)"foo");
        String string2 = "1.3.0.M1";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)request2, (String)"bootVersion");
        callSiteArray[307].call(callSiteArray[308].call(callSiteArray[309].callCurrent((GroovyObject)this, request2), foo), (Object)"org.acme", (Object)"foo-bom", (Object)"1.2.0");
    }

    @Test
    public void mavenBomWithVersionMappingAndExtraRepositories() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[310].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "bom", "the-bom"}));
        Object bom = callSiteArray[311].callConstructor(BillOfMaterials.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", "org.acme", "artifactId", "foo-bom", "repositories", ScriptBytecodeAdapter.createList((Object[])new Object[]{"foo-repo"})}));
        callSiteArray[312].call(callSiteArray[313].callGetProperty(bom), callSiteArray[314].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "[1.2.0.RELEASE,1.3.0.M1)", "version", "1.0.0"})));
        callSiteArray[315].call(callSiteArray[316].callGetProperty(bom), callSiteArray[317].callConstructor(BillOfMaterials.Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionRange", "1.3.0.M1", "version", "1.2.0", "repositories", ScriptBytecodeAdapter.createList((Object[])new Object[]{"foo-repo", "bar-repo"})})));
        Object metadata = callSiteArray[318].call(callSiteArray[319].call(callSiteArray[320].call(callSiteArray[321].call(callSiteArray[322].call(callSiteArray[323].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo), (Object)"the-bom", bom), (Object)"foo-repo", (Object)"repo", (Object)"http://example.com/foo", (Object)true), (Object)"bar-repo", (Object)"repo", (Object)"http://example.com/bar", (Object)false));
        callSiteArray[324].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[325].callCurrent((GroovyObject)this, (Object)"foo");
        String string = "1.3.0.RELEASE";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"bootVersion");
        callSiteArray[326].call(callSiteArray[327].call(callSiteArray[328].call(callSiteArray[329].call(callSiteArray[330].call(callSiteArray[331].callCurrent((GroovyObject)this, request), foo), (Object)"org.acme", (Object)"foo-bom", (Object)"1.2.0"), (Object)"foo-repo", (Object)"repo", (Object)"http://example.com/foo", (Object)true), (Object)"bar-repo", (Object)"repo", (Object)"http://example.com/bar", (Object)false), (Object)2);
    }

    @Test
    public void gradleBom() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[332].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "bom", "foo-bom"}));
        Object metadata = callSiteArray[333].call(callSiteArray[334].call(callSiteArray[335].call(callSiteArray[336].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo), (Object)"foo-bom", (Object)"org.acme", (Object)"foo-bom", (Object)"1.2.3"));
        callSiteArray[337].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[338].callCurrent((GroovyObject)this, (Object)"foo");
        callSiteArray[339].call(callSiteArray[340].call(callSiteArray[341].call(callSiteArray[342].callCurrent((GroovyObject)this, request), (Object)"dependencyManagement {"), (Object)"imports {"), (Object)"mavenBom \"org.acme:foo-bom:1.2.3\"");
    }

    @Test
    public void mavenRepository() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[343].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "repository", "foo-repo"}));
        Object metadata = callSiteArray[344].call(callSiteArray[345].call(callSiteArray[346].call(callSiteArray[347].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo), (Object)"foo-repo", (Object)"foo", (Object)"http://example.com/repo", (Object)false));
        callSiteArray[348].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[349].callCurrent((GroovyObject)this, (Object)"foo");
        callSiteArray[350].call(callSiteArray[351].call(callSiteArray[352].callCurrent((GroovyObject)this, request), foo), (Object)"foo-repo", (Object)"foo", (Object)"http://example.com/repo", (Object)false);
    }

    @Test
    public void mavenRepositoryWithSeveralDependenciesOnSameRepository() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[353].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "repository", "the-repo"}));
        Object bar = callSiteArray[354].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "bar", "groupId", "org.acme", "artifactId", "bar", "repository", "the-repo"}));
        Object metadata = callSiteArray[355].call(callSiteArray[356].call(callSiteArray[357].call(callSiteArray[358].call(InitializrMetadataTestBuilder.class), (Object)"group", foo, bar), (Object)"the-repo", (Object)"repo", (Object)"http://example.com/repo", (Object)true));
        callSiteArray[359].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[360].callCurrent((GroovyObject)this, (Object)"foo", (Object)"bar");
        callSiteArray[361].call(callSiteArray[362].call(callSiteArray[363].call(callSiteArray[364].callCurrent((GroovyObject)this, request), foo), (Object)"the-repo", (Object)"repo", (Object)"http://example.com/repo", (Object)true), (Object)1);
    }

    @Test
    public void gradleRepository() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[365].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.acme", "artifactId", "foo", "repository", "foo-repo"}));
        Object metadata = callSiteArray[366].call(callSiteArray[367].call(callSiteArray[368].call(callSiteArray[369].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo), (Object)"foo-repo", (Object)"foo", (Object)"http://example.com/repo", (Object)false));
        callSiteArray[370].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[371].callCurrent((GroovyObject)this, (Object)"foo");
        callSiteArray[372].call(callSiteArray[373].callCurrent((GroovyObject)this, request), (Object)"http://example.com/repo");
    }

    @Test
    public void projectWithOnlyStarterDependency() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[374].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.foo", "artifactId", "custom-my-starter"}));
        Object metadata = callSiteArray[375].call(callSiteArray[376].call(callSiteArray[377].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo));
        callSiteArray[378].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[379].callCurrent((GroovyObject)this, (Object)"foo");
        callSiteArray[380].call(callSiteArray[381].call(callSiteArray[382].call(callSiteArray[383].callCurrent((GroovyObject)this, request), (Object)"org.foo", (Object)"custom-my-starter")), (Object)2);
    }

    @Test
    public void projectWithOnlyNonStarterDependency() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object foo = callSiteArray[384].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "foo", "groupId", "org.foo", "artifactId", "foo"}));
        boolean bl = false;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)foo, (String)"starter");
        Object metadata = callSiteArray[385].call(callSiteArray[386].call(callSiteArray[387].call(InitializrMetadataTestBuilder.class), (Object)"foo", foo));
        callSiteArray[388].callCurrent((GroovyObject)this, metadata);
        Object request = callSiteArray[389].callCurrent((GroovyObject)this, (Object)"foo");
        callSiteArray[390].call(callSiteArray[391].call(callSiteArray[392].call(callSiteArray[393].call(callSiteArray[394].callCurrent((GroovyObject)this, request), (Object)"org.foo", (Object)"foo"))), (Object)3);
    }

    @Test
    public void invalidType() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[395].callCurrent((GroovyObject)this, (Object)"web");
        String string = "foo-bar";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"type");
        try {
            callSiteArray[396].callCurrent((GroovyObject)this, request);
            callSiteArray[397].callStatic(Assert.class, (Object)"Should have failed to generate project");
        }
        catch (InvalidProjectRequestException ex) {
            callSiteArray[398].callStatic(Assert.class, callSiteArray[399].callGroovyObjectGetProperty((Object)ex), callSiteArray[400].callStatic(CoreMatchers.class, (Object)"foo-bar"));
            callSiteArray[401].call(callSiteArray[402].callStatic(Mockito.class, (Object)this.eventPublisher, callSiteArray[403].callStatic(Mockito.class, (Object)1)), callSiteArray[404].callStatic(Matchers.class, callSiteArray[405].callConstructor(ProjectFailedEventMatcher.class, request, (Object)ex)));
        }
    }

    @Test
    public void invalidPackaging() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[406].callCurrent((GroovyObject)this, (Object)"web");
        String string = "foo-bar";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"packaging");
        try {
            callSiteArray[407].callCurrent((GroovyObject)this, request);
            callSiteArray[408].callStatic(Assert.class, (Object)"Should have failed to generate project");
        }
        catch (InvalidProjectRequestException ex) {
            callSiteArray[409].callStatic(Assert.class, callSiteArray[410].callGroovyObjectGetProperty((Object)ex), callSiteArray[411].callStatic(CoreMatchers.class, (Object)"foo-bar"));
            callSiteArray[412].call(callSiteArray[413].callStatic(Mockito.class, (Object)this.eventPublisher, callSiteArray[414].callStatic(Mockito.class, (Object)1)), callSiteArray[415].callStatic(Matchers.class, callSiteArray[416].callConstructor(ProjectFailedEventMatcher.class, request, (Object)ex)));
        }
    }

    @Test
    public void invalidLanguage() {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[417].callCurrent((GroovyObject)this, (Object)"web");
        String string = "foo-bar";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"language");
        try {
            callSiteArray[418].callCurrent((GroovyObject)this, request);
            callSiteArray[419].callStatic(Assert.class, (Object)"Should have failed to generate project");
        }
        catch (InvalidProjectRequestException ex) {
            callSiteArray[420].callStatic(Assert.class, callSiteArray[421].callGroovyObjectGetProperty((Object)ex), callSiteArray[422].callStatic(CoreMatchers.class, (Object)"foo-bar"));
            callSiteArray[423].call(callSiteArray[424].callStatic(Mockito.class, (Object)this.eventPublisher, callSiteArray[425].callStatic(Mockito.class, (Object)1)), callSiteArray[426].callStatic(Matchers.class, callSiteArray[427].callConstructor(ProjectFailedEventMatcher.class, request, (Object)ex)));
        }
    }

    public PomAssert generateMavenPom(ProjectRequest request) {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object content = callSiteArray[428].callConstructor(String.class, callSiteArray[429].call((Object)this.projectGenerator, (Object)request));
        return (PomAssert)ScriptBytecodeAdapter.castToType((Object)callSiteArray[430].call(callSiteArray[431].callConstructor(PomAssert.class, content), (Object)request), PomAssert.class);
    }

    public GradleBuildAssert generateGradleBuild(ProjectRequest request) {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object content = callSiteArray[432].callConstructor(String.class, callSiteArray[433].call((Object)this.projectGenerator, (Object)request));
        return (GradleBuildAssert)ScriptBytecodeAdapter.castToType((Object)callSiteArray[434].call(callSiteArray[435].callConstructor(GradleBuildAssert.class, content), (Object)request), GradleBuildAssert.class);
    }

    public ProjectAssert generateProject(ProjectRequest request) {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object dir = callSiteArray[436].call((Object)this.projectGenerator, (Object)request);
        return (ProjectAssert)ScriptBytecodeAdapter.castToType((Object)callSiteArray[437].callConstructor(ProjectAssert.class, dir), ProjectAssert.class);
    }

    public ProjectRequest createProjectRequest(String ... styles) {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object request = callSiteArray[438].callConstructor(ProjectRequest.class);
        callSiteArray[439].call(request, callSiteArray[440].call(callSiteArray[441].callGroovyObjectGetProperty((Object)this.projectGenerator)));
        callSiteArray[442].call(callSiteArray[443].callGetProperty(request), callSiteArray[444].call(Arrays.class, (Object)styles));
        return (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)request, ProjectRequest.class);
    }

    private void applyMetadata(InitializrMetadata metadata) {
        Reference metadata2 = new Reference((Object)metadata);
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        InitializrMetadataProvider initializrMetadataProvider = new InitializrMetadataProvider(this, metadata2){
            public /* synthetic */ Reference metadata;
            public /* synthetic */ ProjectGeneratorTests this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                ProjectGeneratorTests projectGeneratorTests;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = projectGeneratorTests = p0;
                this.metadata = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public InitializrMetadata get() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (InitializrMetadata)ScriptBytecodeAdapter.castToType((Object)this.metadata.get(), InitializrMetadata.class);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)initializrMetadataProvider, ProjectGeneratorTests.class, (GroovyObject)this.projectGenerator, (String)"metadataProvider");
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProjectGeneratorTests.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProjectGeneratorTests.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ProjectGeneratorTests.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProjectGeneratorTests.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectGeneratorTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "mock";
        stringArray[3] = "build";
        stringArray[4] = "addDependencyGroup";
        stringArray[5] = "withDefaults";
        stringArray[6] = "applyMetadata";
        stringArray[7] = "absolutePath";
        stringArray[8] = "newFolder";
        stringArray[9] = "createProjectRequest";
        stringArray[10] = "hasSpringBootStarterDependency";
        stringArray[11] = "hasNoRepository";
        stringArray[12] = "generateMavenPom";
        stringArray[13] = "publishEvent";
        stringArray[14] = "verify";
        stringArray[15] = "times";
        stringArray[16] = "argThat";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "createProjectRequest";
        stringArray[19] = "generateGradleBuild";
        stringArray[20] = "publishEvent";
        stringArray[21] = "verify";
        stringArray[22] = "times";
        stringArray[23] = "argThat";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "createProjectRequest";
        stringArray[26] = "hasSpringBootStarterDependency";
        stringArray[27] = "hasNoRepository";
        stringArray[28] = "pomAssert";
        stringArray[29] = "isMavenProject";
        stringArray[30] = "isJavaProject";
        stringArray[31] = "generateProject";
        stringArray[32] = "publishEvent";
        stringArray[33] = "verify";
        stringArray[34] = "times";
        stringArray[35] = "argThat";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "createProjectRequest";
        stringArray[38] = "hasSpringBootStarterRootDependency";
        stringArray[39] = "pomAssert";
        stringArray[40] = "isMavenProject";
        stringArray[41] = "isJavaProject";
        stringArray[42] = "generateProject";
        stringArray[43] = "createProjectRequest";
        stringArray[44] = "hasSpringBootStarterDependency";
        stringArray[45] = "hasSnapshotRepository";
        stringArray[46] = "generateMavenPom";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "leftShift";
        stringArray[49] = "facets";
        stringArray[50] = "build";
        stringArray[51] = "addDependencyGroup";
        stringArray[52] = "addDependencyGroup";
        stringArray[53] = "withDefaults";
        stringArray[54] = "applyMetadata";
        stringArray[55] = "createProjectRequest";
        stringArray[56] = "hasDependenciesCount";
        stringArray[57] = "hasDependency";
        stringArray[58] = "generateMavenPom";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "leftShift";
        stringArray[61] = "facets";
        stringArray[62] = "build";
        stringArray[63] = "addDependencyGroup";
        stringArray[64] = "addDependencyGroup";
        stringArray[65] = "withDefaults";
        stringArray[66] = "applyMetadata";
        stringArray[67] = "createProjectRequest";
        stringArray[68] = "hasDependenciesCount";
        stringArray[69] = "hasSpringBootStarterTest";
        stringArray[70] = "hasDependency";
        stringArray[71] = "hasSpringBootStarterTomcat";
        stringArray[72] = "pomAssert";
        stringArray[73] = "isMavenProject";
        stringArray[74] = "isJavaWarProject";
        stringArray[75] = "generateProject";
        stringArray[76] = "createProjectRequest";
        stringArray[77] = "hasDependenciesCount";
        stringArray[78] = "hasSpringBootStarterTest";
        stringArray[79] = "hasSpringBootStarterDependency";
        stringArray[80] = "hasSpringBootStarterDependency";
        stringArray[81] = "hasSpringBootStarterTomcat";
        stringArray[82] = "generateMavenPom";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "leftShift";
        stringArray[85] = "facets";
        stringArray[86] = "build";
        stringArray[87] = "addDependencyGroup";
        stringArray[88] = "addDependencyGroup";
        stringArray[89] = "withDefaults";
        stringArray[90] = "applyMetadata";
        stringArray[91] = "createProjectRequest";
        stringArray[92] = "contains";
        stringArray[93] = "contains";
        stringArray[94] = "contains";
        stringArray[95] = "contains";
        stringArray[96] = "doesNotContain";
        stringArray[97] = "contains";
        stringArray[98] = "gradleBuildAssert";
        stringArray[99] = "isGradleProject";
        stringArray[100] = "isJavaWarProject";
        stringArray[101] = "generateProject";
        stringArray[102] = "createProjectRequest";
        stringArray[103] = "contains";
        stringArray[104] = "contains";
        stringArray[105] = "contains";
        stringArray[106] = "contains";
        stringArray[107] = "contains";
        stringArray[108] = "contains";
        stringArray[109] = "generateGradleBuild";
        stringArray[110] = "createProjectRequest";
        stringArray[111] = "doesNotContain";
        stringArray[112] = "contains";
        stringArray[113] = "doesNotHaveImports";
        stringArray[114] = "hasImports";
        stringArray[115] = "sourceCodeAssert";
        stringArray[116] = "generateProject";
        stringArray[117] = "name";
        stringArray[118] = "name";
        stringArray[119] = "name";
        stringArray[120] = "name";
        stringArray[121] = "createProjectRequest";
        stringArray[122] = "doesNotContain";
        stringArray[123] = "contains";
        stringArray[124] = "doesNotHaveImports";
        stringArray[125] = "hasImports";
        stringArray[126] = "sourceCodeAssert";
        stringArray[127] = "generateProject";
        stringArray[128] = "name";
        stringArray[129] = "name";
        stringArray[130] = "name";
        stringArray[131] = "name";
        stringArray[132] = "createProjectRequest";
        stringArray[133] = "doesNotContain";
        stringArray[134] = "contains";
        stringArray[135] = "doesNotHaveImports";
        stringArray[136] = "hasImports";
        stringArray[137] = "sourceCodeAssert";
        stringArray[138] = "generateProject";
        stringArray[139] = "name";
        stringArray[140] = "name";
        stringArray[141] = "name";
        stringArray[142] = "name";
        stringArray[143] = "createProjectRequest";
        stringArray[144] = "doesNotContain";
        stringArray[145] = "contains";
        stringArray[146] = "doesNotHaveImports";
        stringArray[147] = "hasImports";
        stringArray[148] = "sourceCodeAssert";
        stringArray[149] = "generateProject";
        stringArray[150] = "name";
        stringArray[151] = "name";
        stringArray[152] = "name";
        stringArray[153] = "name";
        stringArray[154] = "createProjectRequest";
        stringArray[155] = "doesNotContain";
        stringArray[156] = "contains";
        stringArray[157] = "doesNotHaveImports";
        stringArray[158] = "hasImports";
        stringArray[159] = "sourceCodeAssert";
        stringArray[160] = "generateProject";
        stringArray[161] = "name";
        stringArray[162] = "name";
        stringArray[163] = "name";
        stringArray[164] = "name";
        stringArray[165] = "createProjectRequest";
        stringArray[166] = "doesNotContain";
        stringArray[167] = "contains";
        stringArray[168] = "doesNotHaveImports";
        stringArray[169] = "hasImports";
        stringArray[170] = "sourceCodeAssert";
        stringArray[171] = "generateProject";
        stringArray[172] = "name";
        stringArray[173] = "name";
        stringArray[174] = "name";
        stringArray[175] = "name";
        stringArray[176] = "createProjectRequest";
        stringArray[177] = "isMavenProject";
        stringArray[178] = "isJavaProject";
        stringArray[179] = "hasBaseDir";
        stringArray[180] = "generateProject";
        stringArray[181] = "createProjectRequest";
        stringArray[182] = "isMavenProject";
        stringArray[183] = "isJavaProject";
        stringArray[184] = "hasBaseDir";
        stringArray[185] = "generateProject";
        stringArray[186] = "createProjectRequest";
        stringArray[187] = "isGroovyProject";
        stringArray[188] = "isMavenProject";
        stringArray[189] = "generateProject";
        stringArray[190] = "createProjectRequest";
        stringArray[191] = "isGroovyProject";
        stringArray[192] = "isGradleProject";
        stringArray[193] = "generateProject";
        stringArray[194] = "<$constructor$>";
        stringArray[195] = "build";
        stringArray[196] = "addDependencyGroup";
        stringArray[197] = "addDependencyGroup";
        stringArray[198] = "withDefaults";
        stringArray[199] = "applyMetadata";
        stringArray[200] = "createProjectRequest";
        stringArray[201] = "hasSpringBootStarterDependency";
        stringArray[202] = "hasSpringBootStarterDependency";
        stringArray[203] = "hasDependency";
        stringArray[204] = "generateMavenPom";
        stringArray[205] = "createProjectRequest";
        stringArray[206] = "hasSnapshotRepository";
        stringArray[207] = "generateGradleBuild";
        stringArray[208] = "<$constructor$>";
        stringArray[209] = "build";
        stringArray[210] = "addDependencyGroup";
        stringArray[211] = "addDependencyGroup";
        stringArray[212] = "withDefaults";
        stringArray[213] = "applyMetadata";
        stringArray[214] = "createProjectRequest";
        stringArray[215] = "contains";
        stringArray[216] = "contains";
        stringArray[217] = "contains";
        stringArray[218] = "generateGradleBuild";
        stringArray[219] = "<$constructor$>";
        stringArray[220] = "<$constructor$>";
        stringArray[221] = "<$constructor$>";
        stringArray[222] = "build";
        stringArray[223] = "addDependencyGroup";
        stringArray[224] = "addDependencyGroup";
        stringArray[225] = "addDependencyGroup";
        stringArray[226] = "addDependencyGroup";
        stringArray[227] = "withDefaults";
        stringArray[228] = "applyMetadata";
        stringArray[229] = "createProjectRequest";
        stringArray[230] = "hasSpringBootStarterDependency";
        stringArray[231] = "hasSpringBootStarterDependency";
        stringArray[232] = "hasDependency";
        stringArray[233] = "hasDependency";
        stringArray[234] = "hasDependency";
        stringArray[235] = "generateMavenPom";
        stringArray[236] = "<$constructor$>";
        stringArray[237] = "<$constructor$>";
        stringArray[238] = "<$constructor$>";
        stringArray[239] = "build";
        stringArray[240] = "addDependencyGroup";
        stringArray[241] = "addDependencyGroup";
        stringArray[242] = "addDependencyGroup";
        stringArray[243] = "addDependencyGroup";
        stringArray[244] = "withDefaults";
        stringArray[245] = "applyMetadata";
        stringArray[246] = "createProjectRequest";
        stringArray[247] = "contains";
        stringArray[248] = "contains";
        stringArray[249] = "contains";
        stringArray[250] = "contains";
        stringArray[251] = "contains";
        stringArray[252] = "contains";
        stringArray[253] = "contains";
        stringArray[254] = "generateGradleBuild";
        stringArray[255] = "createProjectRequest";
        stringArray[256] = "contains";
        stringArray[257] = "contains";
        stringArray[258] = "contains";
        stringArray[259] = "contains";
        stringArray[260] = "generateGradleBuild";
        stringArray[261] = "createProjectRequest";
        stringArray[262] = "doesNotContain";
        stringArray[263] = "doesNotContain";
        stringArray[264] = "contains";
        stringArray[265] = "contains";
        stringArray[266] = "generateGradleBuild";
        stringArray[267] = "<$constructor$>";
        stringArray[268] = "build";
        stringArray[269] = "addBom";
        stringArray[270] = "addDependencyGroup";
        stringArray[271] = "withDefaults";
        stringArray[272] = "applyMetadata";
        stringArray[273] = "createProjectRequest";
        stringArray[274] = "hasBom";
        stringArray[275] = "hasDependency";
        stringArray[276] = "generateMavenPom";
        stringArray[277] = "<$constructor$>";
        stringArray[278] = "<$constructor$>";
        stringArray[279] = "build";
        stringArray[280] = "addBom";
        stringArray[281] = "addDependencyGroup";
        stringArray[282] = "withDefaults";
        stringArray[283] = "applyMetadata";
        stringArray[284] = "createProjectRequest";
        stringArray[285] = "hasBomsCount";
        stringArray[286] = "hasBom";
        stringArray[287] = "hasDependency";
        stringArray[288] = "generateMavenPom";
        stringArray[289] = "<$constructor$>";
        stringArray[290] = "<$constructor$>";
        stringArray[291] = "leftShift";
        stringArray[292] = "mappings";
        stringArray[293] = "<$constructor$>";
        stringArray[294] = "leftShift";
        stringArray[295] = "mappings";
        stringArray[296] = "<$constructor$>";
        stringArray[297] = "build";
        stringArray[298] = "addBom";
        stringArray[299] = "addDependencyGroup";
        stringArray[300] = "withDefaults";
        stringArray[301] = "applyMetadata";
        stringArray[302] = "createProjectRequest";
        stringArray[303] = "hasBom";
        stringArray[304] = "hasDependency";
        stringArray[305] = "generateMavenPom";
        stringArray[306] = "createProjectRequest";
        stringArray[307] = "hasBom";
        stringArray[308] = "hasDependency";
        stringArray[309] = "generateMavenPom";
        stringArray[310] = "<$constructor$>";
        stringArray[311] = "<$constructor$>";
        stringArray[312] = "leftShift";
        stringArray[313] = "mappings";
        stringArray[314] = "<$constructor$>";
        stringArray[315] = "leftShift";
        stringArray[316] = "mappings";
        stringArray[317] = "<$constructor$>";
        stringArray[318] = "build";
        stringArray[319] = "addRepository";
        stringArray[320] = "addRepository";
        stringArray[321] = "addBom";
        stringArray[322] = "addDependencyGroup";
        stringArray[323] = "withDefaults";
        stringArray[324] = "applyMetadata";
        stringArray[325] = "createProjectRequest";
        stringArray[326] = "hasRepositoriesCount";
        stringArray[327] = "hasRepository";
        stringArray[328] = "hasRepository";
        stringArray[329] = "hasBom";
        stringArray[330] = "hasDependency";
        stringArray[331] = "generateMavenPom";
        stringArray[332] = "<$constructor$>";
        stringArray[333] = "build";
        stringArray[334] = "addBom";
        stringArray[335] = "addDependencyGroup";
        stringArray[336] = "withDefaults";
        stringArray[337] = "applyMetadata";
        stringArray[338] = "createProjectRequest";
        stringArray[339] = "contains";
        stringArray[340] = "contains";
        stringArray[341] = "contains";
        stringArray[342] = "generateGradleBuild";
        stringArray[343] = "<$constructor$>";
        stringArray[344] = "build";
        stringArray[345] = "addRepository";
        stringArray[346] = "addDependencyGroup";
        stringArray[347] = "withDefaults";
        stringArray[348] = "applyMetadata";
        stringArray[349] = "createProjectRequest";
        stringArray[350] = "hasRepository";
        stringArray[351] = "hasDependency";
        stringArray[352] = "generateMavenPom";
        stringArray[353] = "<$constructor$>";
        stringArray[354] = "<$constructor$>";
        stringArray[355] = "build";
        stringArray[356] = "addRepository";
        stringArray[357] = "addDependencyGroup";
        stringArray[358] = "withDefaults";
        stringArray[359] = "applyMetadata";
        stringArray[360] = "createProjectRequest";
        stringArray[361] = "hasRepositoriesCount";
        stringArray[362] = "hasRepository";
        stringArray[363] = "hasDependency";
        stringArray[364] = "generateMavenPom";
        stringArray[365] = "<$constructor$>";
        stringArray[366] = "build";
        stringArray[367] = "addRepository";
        stringArray[368] = "addDependencyGroup";
        stringArray[369] = "withDefaults";
        stringArray[370] = "applyMetadata";
        stringArray[371] = "createProjectRequest";
        stringArray[372] = "hasRepository";
        stringArray[373] = "generateGradleBuild";
        stringArray[374] = "<$constructor$>";
        stringArray[375] = "build";
        stringArray[376] = "addDependencyGroup";
        stringArray[377] = "withDefaults";
        stringArray[378] = "applyMetadata";
        stringArray[379] = "createProjectRequest";
        stringArray[380] = "hasDependenciesCount";
        stringArray[381] = "hasSpringBootStarterTest";
        stringArray[382] = "hasDependency";
        stringArray[383] = "generateMavenPom";
        stringArray[384] = "<$constructor$>";
        stringArray[385] = "build";
        stringArray[386] = "addDependencyGroup";
        stringArray[387] = "withDefaults";
        stringArray[388] = "applyMetadata";
        stringArray[389] = "createProjectRequest";
        stringArray[390] = "hasDependenciesCount";
        stringArray[391] = "hasSpringBootStarterTest";
        stringArray[392] = "hasSpringBootStarterRootDependency";
        stringArray[393] = "hasDependency";
        stringArray[394] = "generateMavenPom";
        stringArray[395] = "createProjectRequest";
        stringArray[396] = "generateMavenPom";
        stringArray[397] = "fail";
        stringArray[398] = "assertThat";
        stringArray[399] = "message";
        stringArray[400] = "containsString";
        stringArray[401] = "publishEvent";
        stringArray[402] = "verify";
        stringArray[403] = "times";
        stringArray[404] = "argThat";
        stringArray[405] = "<$constructor$>";
        stringArray[406] = "createProjectRequest";
        stringArray[407] = "generateGradleBuild";
        stringArray[408] = "fail";
        stringArray[409] = "assertThat";
        stringArray[410] = "message";
        stringArray[411] = "containsString";
        stringArray[412] = "publishEvent";
        stringArray[413] = "verify";
        stringArray[414] = "times";
        stringArray[415] = "argThat";
        stringArray[416] = "<$constructor$>";
        stringArray[417] = "createProjectRequest";
        stringArray[418] = "generateProject";
        stringArray[419] = "fail";
        stringArray[420] = "assertThat";
        stringArray[421] = "message";
        stringArray[422] = "containsString";
        stringArray[423] = "publishEvent";
        stringArray[424] = "verify";
        stringArray[425] = "times";
        stringArray[426] = "argThat";
        stringArray[427] = "<$constructor$>";
        stringArray[428] = "<$constructor$>";
        stringArray[429] = "generateMavenPom";
        stringArray[430] = "validateProjectRequest";
        stringArray[431] = "<$constructor$>";
        stringArray[432] = "<$constructor$>";
        stringArray[433] = "generateGradleBuild";
        stringArray[434] = "validateProjectRequest";
        stringArray[435] = "<$constructor$>";
        stringArray[436] = "generateProjectStructure";
        stringArray[437] = "<$constructor$>";
        stringArray[438] = "<$constructor$>";
        stringArray[439] = "initialize";
        stringArray[440] = "get";
        stringArray[441] = "metadataProvider";
        stringArray[442] = "addAll";
        stringArray[443] = "style";
        stringArray[444] = "asList";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[445];
        ProjectGeneratorTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProjectGeneratorTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProjectGeneratorTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectGeneratedEventMatcher
    extends ArgumentMatcher<ProjectGeneratedEvent>
    implements GroovyObject {
        private final ProjectRequest request;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public ProjectGeneratedEventMatcher(ProjectRequest projectRequest) {
            void request;
            MetaClass metaClass;
            CallSite[] callSiteArray = ProjectGeneratedEventMatcher.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            void var4_4 = request;
            this.request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)var4_4, ProjectRequest.class);
        }

        public boolean matches(Object argument) {
            CallSite[] callSiteArray = ProjectGeneratedEventMatcher.$getCallSiteArray();
            ProjectGeneratedEvent event = (ProjectGeneratedEvent)ScriptBytecodeAdapter.castToType((Object)argument, ProjectGeneratedEvent.class);
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)this.request, callSiteArray[1].callGroovyObjectGetProperty((Object)event)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ProjectGeneratedEventMatcher.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ProjectGeneratedEventMatcher.class, ProjectGeneratorTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ProjectGeneratedEventMatcher.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProjectGeneratorTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ProjectGeneratedEventMatcher.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ProjectGeneratedEventMatcher.class, ProjectGeneratorTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != ProjectGeneratedEventMatcher.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "equals";
            stringArray[1] = "projectRequest";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            ProjectGeneratedEventMatcher.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ProjectGeneratedEventMatcher.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ProjectGeneratedEventMatcher.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectFailedEventMatcher
    extends ArgumentMatcher<ProjectFailedEvent>
    implements GroovyObject {
        private final ProjectRequest request;
        private final Exception cause;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        /*
         * WARNING - void declaration
         */
        public ProjectFailedEventMatcher(ProjectRequest projectRequest, Exception exception) {
            void cause;
            void request;
            MetaClass metaClass;
            CallSite[] callSiteArray = ProjectFailedEventMatcher.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            void var5_5 = request;
            this.request = (ProjectRequest)ScriptBytecodeAdapter.castToType((Object)var5_5, ProjectRequest.class);
            void var6_6 = cause;
            this.cause = (Exception)ScriptBytecodeAdapter.castToType((Object)var6_6, Exception.class);
        }

        public boolean matches(Object argument) {
            CallSite[] callSiteArray = ProjectFailedEventMatcher.$getCallSiteArray();
            ProjectFailedEvent event = (ProjectFailedEvent)ScriptBytecodeAdapter.castToType((Object)argument, ProjectFailedEvent.class);
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)this.request, callSiteArray[1].callGroovyObjectGetProperty((Object)event))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)this.cause, callSiteArray[3].callGroovyObjectGetProperty((Object)event)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ProjectFailedEventMatcher.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ProjectFailedEventMatcher.class, ProjectGeneratorTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ProjectFailedEventMatcher.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProjectGeneratorTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ProjectFailedEventMatcher.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ProjectFailedEventMatcher.class, ProjectGeneratorTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != ProjectFailedEventMatcher.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "equals";
            stringArray[1] = "projectRequest";
            stringArray[2] = "equals";
            stringArray[3] = "cause";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            ProjectFailedEventMatcher.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ProjectFailedEventMatcher.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ProjectFailedEventMatcher.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

