/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.util.InvalidVersionException;
import io.spring.initializr.util.Version;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class VersionTests
implements GroovyObject {
    @Rule
    public final ExpectedException thrown;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public VersionTests() {
        MetaClass metaClass;
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        Object object = callSiteArray[0].call(ExpectedException.class);
        this.thrown = (ExpectedException)ScriptBytecodeAdapter.castToType((Object)object, ExpectedException.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void noQualifierString() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        Object version = callSiteArray[1].callStatic(Version.class, (Object)"1.2.0");
        callSiteArray[2].callStatic(MatcherAssert.class, callSiteArray[3].call(version), callSiteArray[4].callStatic(Matchers.class, (Object)"1.2.0"));
    }

    @Test
    public void withQualifierString() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        Object version = callSiteArray[5].callStatic(Version.class, (Object)"1.2.0.RELEASE");
        callSiteArray[6].callStatic(MatcherAssert.class, callSiteArray[7].call(version), callSiteArray[8].callStatic(Matchers.class, (Object)"1.2.0.RELEASE"));
    }

    @Test
    public void withQualifierAndVersionString() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        Object version = callSiteArray[9].callStatic(Version.class, (Object)"1.2.0.RC2");
        callSiteArray[10].callStatic(MatcherAssert.class, callSiteArray[11].call(version), callSiteArray[12].callStatic(Matchers.class, (Object)"1.2.0.RC2"));
    }

    @Test
    public void equalNoQualifier() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        Object first = callSiteArray[13].callStatic(Version.class, (Object)"1.2.0");
        Object second = callSiteArray[14].callStatic(Version.class, (Object)"1.2.0");
        callSiteArray[15].callStatic(MatcherAssert.class, first, callSiteArray[16].callStatic(Matchers.class, second));
        callSiteArray[17].callStatic(MatcherAssert.class, first, callSiteArray[18].callStatic(Matchers.class, second));
    }

    @Test
    public void equalQualifierNoVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        Object first = callSiteArray[19].callStatic(Version.class, (Object)"1.2.0.RELEASE");
        Object second = callSiteArray[20].callStatic(Version.class, (Object)"1.2.0.RELEASE");
        callSiteArray[21].callStatic(MatcherAssert.class, first, callSiteArray[22].callStatic(Matchers.class, second));
        callSiteArray[23].callStatic(MatcherAssert.class, first, callSiteArray[24].callStatic(Matchers.class, second));
    }

    @Test
    public void equalQualifierVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        Object first = callSiteArray[25].callStatic(Version.class, (Object)"1.2.0.RC1");
        Object second = callSiteArray[26].callStatic(Version.class, (Object)"1.2.0.RC1");
        callSiteArray[27].callStatic(MatcherAssert.class, first, callSiteArray[28].callStatic(Matchers.class, second));
        callSiteArray[29].callStatic(MatcherAssert.class, first, callSiteArray[30].callStatic(Matchers.class, second));
    }

    @Test
    public void compareMajorOnly() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[31].callStatic(MatcherAssert.class, callSiteArray[32].callStatic(Version.class, (Object)"2.2.0"), callSiteArray[33].callStatic(Matchers.class, callSiteArray[34].callStatic(Version.class, (Object)"1.8.0")));
    }

    @Test
    public void compareMinorOnly() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[35].callStatic(MatcherAssert.class, callSiteArray[36].callStatic(Version.class, (Object)"2.2.0"), callSiteArray[37].callStatic(Matchers.class, callSiteArray[38].callStatic(Version.class, (Object)"2.1.9")));
    }

    @Test
    public void comparePatchOnly() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[39].callStatic(MatcherAssert.class, callSiteArray[40].callStatic(Version.class, (Object)"2.2.4"), callSiteArray[41].callStatic(Matchers.class, callSiteArray[42].callStatic(Version.class, (Object)"2.2.3")));
    }

    @Test
    public void compareHigherVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[43].callStatic(MatcherAssert.class, callSiteArray[44].callStatic(Version.class, (Object)"1.2.0.RELEASE"), callSiteArray[45].callStatic(Matchers.class, callSiteArray[46].callStatic(Version.class, (Object)"1.1.9.RELEASE")));
    }

    @Test
    public void compareHigherQualifier() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[47].callStatic(MatcherAssert.class, callSiteArray[48].callStatic(Version.class, (Object)"1.2.0.RC1"), callSiteArray[49].callStatic(Matchers.class, callSiteArray[50].callStatic(Version.class, (Object)"1.2.0.M1")));
    }

    @Test
    public void compareHigherQualifierVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[51].callStatic(MatcherAssert.class, callSiteArray[52].callStatic(Version.class, (Object)"1.2.0.RC2"), callSiteArray[53].callStatic(Matchers.class, callSiteArray[54].callStatic(Version.class, (Object)"1.2.0.RC1")));
    }

    @Test
    public void compareLowerVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[55].callStatic(MatcherAssert.class, callSiteArray[56].callStatic(Version.class, (Object)"1.0.5.RELEASE"), callSiteArray[57].callStatic(Matchers.class, callSiteArray[58].callStatic(Version.class, (Object)"1.1.9.RELEASE")));
    }

    @Test
    public void compareLowerQualifier() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[59].callStatic(MatcherAssert.class, callSiteArray[60].callStatic(Version.class, (Object)"1.2.0.RC1"), callSiteArray[61].callStatic(Matchers.class, callSiteArray[62].callStatic(Version.class, (Object)"1.2.0.RELEASE")));
    }

    @Test
    public void compareLessQualifierVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[63].callStatic(MatcherAssert.class, callSiteArray[64].callStatic(Version.class, (Object)"1.2.0.RC2"), callSiteArray[65].callStatic(Matchers.class, callSiteArray[66].callStatic(Version.class, (Object)"1.2.0.RC3")));
    }

    @Test
    public void compareWithNull() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[67].callStatic(MatcherAssert.class, callSiteArray[68].callStatic(Version.class, (Object)"1.2.0.RC2"), callSiteArray[69].callStatic(Matchers.class, null));
    }

    @Test
    public void compareUnknownQualifier() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[70].callStatic(MatcherAssert.class, callSiteArray[71].callStatic(Version.class, (Object)"1.2.0.Beta"), callSiteArray[72].callStatic(Matchers.class, callSiteArray[73].callStatic(Version.class, (Object)"1.2.0.CR")));
    }

    @Test
    public void compareUnknownQualifierVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[74].callStatic(MatcherAssert.class, callSiteArray[75].callStatic(Version.class, (Object)"1.2.0.Beta1"), callSiteArray[76].callStatic(Matchers.class, callSiteArray[77].callStatic(Version.class, (Object)"1.2.0.Beta2")));
    }

    @Test
    public void snapshotGreaterThanRC() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[78].callStatic(MatcherAssert.class, callSiteArray[79].callStatic(Version.class, (Object)"1.2.0.BUILD-SNAPSHOT"), callSiteArray[80].callStatic(Matchers.class, callSiteArray[81].callStatic(Version.class, (Object)"1.2.0.RC1")));
    }

    @Test
    public void snapshotLowerThanRelease() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[82].callStatic(MatcherAssert.class, callSiteArray[83].callStatic(Version.class, (Object)"1.2.0.BUILD-SNAPSHOT"), callSiteArray[84].callStatic(Matchers.class, callSiteArray[85].callStatic(Version.class, (Object)"1.2.0.RELEASE")));
    }

    @Test
    public void parseInvalidVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[86].call((Object)this.thrown, InvalidVersionException.class);
        callSiteArray[87].callStatic(Version.class, (Object)"foo");
    }

    @Test
    public void safeParseInvalidVersion() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[88].callStatic(Assert.class, callSiteArray[89].callStatic(Version.class, (Object)"foo"));
    }

    @Test
    public void parseVersionWithSpaces() {
        CallSite[] callSiteArray = VersionTests.$getCallSiteArray();
        callSiteArray[90].callStatic(MatcherAssert.class, callSiteArray[91].callStatic(Version.class, (Object)"    1.2.0.RC3  "), callSiteArray[92].callStatic(Matchers.class, callSiteArray[93].callStatic(Version.class, (Object)"1.3.0.RELEASE")));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != VersionTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "none";
        stringArray[1] = "parse";
        stringArray[2] = "assertThat";
        stringArray[3] = "toString";
        stringArray[4] = "equalTo";
        stringArray[5] = "parse";
        stringArray[6] = "assertThat";
        stringArray[7] = "toString";
        stringArray[8] = "equalTo";
        stringArray[9] = "parse";
        stringArray[10] = "assertThat";
        stringArray[11] = "toString";
        stringArray[12] = "equalTo";
        stringArray[13] = "parse";
        stringArray[14] = "parse";
        stringArray[15] = "assertThat";
        stringArray[16] = "comparesEqualTo";
        stringArray[17] = "assertThat";
        stringArray[18] = "equalTo";
        stringArray[19] = "parse";
        stringArray[20] = "parse";
        stringArray[21] = "assertThat";
        stringArray[22] = "comparesEqualTo";
        stringArray[23] = "assertThat";
        stringArray[24] = "equalTo";
        stringArray[25] = "parse";
        stringArray[26] = "parse";
        stringArray[27] = "assertThat";
        stringArray[28] = "comparesEqualTo";
        stringArray[29] = "assertThat";
        stringArray[30] = "equalTo";
        stringArray[31] = "assertThat";
        stringArray[32] = "parse";
        stringArray[33] = "greaterThan";
        stringArray[34] = "parse";
        stringArray[35] = "assertThat";
        stringArray[36] = "parse";
        stringArray[37] = "greaterThan";
        stringArray[38] = "parse";
        stringArray[39] = "assertThat";
        stringArray[40] = "parse";
        stringArray[41] = "greaterThan";
        stringArray[42] = "parse";
        stringArray[43] = "assertThat";
        stringArray[44] = "parse";
        stringArray[45] = "greaterThan";
        stringArray[46] = "parse";
        stringArray[47] = "assertThat";
        stringArray[48] = "parse";
        stringArray[49] = "greaterThan";
        stringArray[50] = "parse";
        stringArray[51] = "assertThat";
        stringArray[52] = "parse";
        stringArray[53] = "greaterThan";
        stringArray[54] = "parse";
        stringArray[55] = "assertThat";
        stringArray[56] = "parse";
        stringArray[57] = "lessThan";
        stringArray[58] = "parse";
        stringArray[59] = "assertThat";
        stringArray[60] = "parse";
        stringArray[61] = "lessThan";
        stringArray[62] = "parse";
        stringArray[63] = "assertThat";
        stringArray[64] = "parse";
        stringArray[65] = "lessThan";
        stringArray[66] = "parse";
        stringArray[67] = "assertThat";
        stringArray[68] = "parse";
        stringArray[69] = "greaterThan";
        stringArray[70] = "assertThat";
        stringArray[71] = "parse";
        stringArray[72] = "lessThan";
        stringArray[73] = "parse";
        stringArray[74] = "assertThat";
        stringArray[75] = "parse";
        stringArray[76] = "lessThan";
        stringArray[77] = "parse";
        stringArray[78] = "assertThat";
        stringArray[79] = "parse";
        stringArray[80] = "greaterThan";
        stringArray[81] = "parse";
        stringArray[82] = "assertThat";
        stringArray[83] = "parse";
        stringArray[84] = "lessThan";
        stringArray[85] = "parse";
        stringArray[86] = "expect";
        stringArray[87] = "parse";
        stringArray[88] = "assertNull";
        stringArray[89] = "safeParse";
        stringArray[90] = "assertThat";
        stringArray[91] = "parse";
        stringArray[92] = "lessThan";
        stringArray[93] = "parse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[94];
        VersionTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(VersionTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = VersionTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

