/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web;

import groovy.json.JsonSlurper;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.mapper.InitializrMetadataVersion;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.web.AbstractInitializrControllerIntegrationTests;
import io.spring.initializr.web.MainController;
import java.lang.ref.SoftReference;
import java.net.URI;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hamcrest.CoreMatchers;
import org.hamcrest.core.IsNot;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.web.client.HttpClientErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ActiveProfiles(value={"test-default"})
public class MainControllerIntegrationTests
extends AbstractInitializrControllerIntegrationTests {
    private final Object slurper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MainControllerIntegrationTests() {
        Object object;
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        this.slurper = object = callSiteArray[0].callConstructor(JsonSlurper.class);
    }

    @Test
    public void simpleZipProject() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].callCurrent((GroovyObject)this, (Object)"/starter.zip?style=web&style=jpa"))), (Object)true)), (Object)3), (Object)"web"), (Object)"data-jpa"));
    }

    @Test
    public void simpleTgzProject() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].callCurrent((GroovyObject)this, (Object)"/starter.tgz?style=org.acme:foo"))), (Object)false)), (Object)2), (Object)"org.acme", (Object)"foo", (Object)"1.3.5");
    }

    @Test
    public void dependencyInRange() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object biz = callSiteArray[17].callConstructor(Dependency.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", "biz", "groupId", "org.acme", "artifactId", "biz", "version", "1.3.5", "scope", "runtime"}));
        callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].callCurrent((GroovyObject)this, (Object)"/starter.tgz?style=org.acme:biz&bootVersion=1.2.1.RELEASE"))), (Object)false)), (Object)2), biz);
    }

    @Test
    public void dependencyNotInRange() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        try {
            callSiteArray[25].callCurrent((GroovyObject)this, (Object)"/starter.tgz?style=org.acme:bur", byte[].class, null, null);
        }
        catch (HttpClientErrorException ex) {
            callSiteArray[26].callStatic(Assert.class, callSiteArray[27].callGetProperty(HttpStatus.class), callSiteArray[28].callGetProperty((Object)ex));
        }
    }

    @Test
    public void noDependencyProject() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].callCurrent((GroovyObject)this, (Object)"/starter.zip"))), (Object)false)), (Object)2)));
    }

    @Test
    public void dependenciesIsAnAliasOfStyle() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].callCurrent((GroovyObject)this, (Object)"/starter.zip?dependencies=web&dependencies=jpa"))), (Object)true)), (Object)3), (Object)"web"), (Object)"data-jpa"));
    }

    @Test
    public void dependenciesIsAnAliasOfStyleCommaSeparated() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].callCurrent((GroovyObject)this, (Object)"/starter.zip?dependencies=web,jpa"))), (Object)true)), (Object)3), (Object)"web"), (Object)"data-jpa"));
    }

    @Test
    public void gradleWarProject() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].callCurrent((GroovyObject)this, (Object)"/starter.zip?style=web&style=security&packaging=war&type=gradle.zip")));
    }

    @Test
    public void downloadCli() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[58].callCurrent((GroovyObject)this, (Object)"/spring", (Object)"zip");
        } else {
            this.assertSpringCliRedirect("/spring", "zip");
        }
    }

    @Test
    public void downloadCliAsZip() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[59].callCurrent((GroovyObject)this, (Object)"/spring.zip", (Object)"zip");
        } else {
            this.assertSpringCliRedirect("/spring.zip", "zip");
        }
    }

    @Test
    public void downloadCliAsTarGz() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[60].callCurrent((GroovyObject)this, (Object)"/spring.tar.gz", (Object)"tar.gz");
        } else {
            this.assertSpringCliRedirect("/spring.tar.gz", "tar.gz");
        }
    }

    @Test
    public void downloadCliAsTgz() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[61].callCurrent((GroovyObject)this, (Object)"/spring.tgz", (Object)"tar.gz");
        } else {
            this.assertSpringCliRedirect("/spring.tgz", "tar.gz");
        }
    }

    private void assertSpringCliRedirect(String context, String extension) {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object entity = callSiteArray[62].call(callSiteArray[63].callGroovyObjectGetProperty((Object)this), callSiteArray[64].callCurrent((GroovyObject)this, (Object)context), ResponseEntity.class);
        callSiteArray[65].callStatic(Assert.class, callSiteArray[66].callGetProperty(HttpStatus.class), callSiteArray[67].call(entity));
        GStringImpl expected = new GStringImpl(new Object[]{extension}, new String[]{"https://repo.spring.io/release/org/springframework/boot/spring-boot-cli/1.1.4.RELEASE/spring-boot-cli-1.1.4.RELEASE-bin.", ""});
        callSiteArray[68].callStatic(Assert.class, callSiteArray[69].callConstructor(URI.class, (Object)expected), callSiteArray[70].call(callSiteArray[71].call(entity)));
    }

    @Test
    public void metadataWithNoAcceptHeader() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callCurrent((GroovyObject)this, null, (Object)"*/*"), ResponseEntity.class);
        callSiteArray[73].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    @Ignore(value="Need a comparator that does not care about the number of elements in an array")
    public void currentMetadataCompatibleWithV2() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callCurrent((GroovyObject)this, null, (Object)"*/*"), ResponseEntity.class);
        callSiteArray[75].callCurrent((GroovyObject)this, (Object)response, callSiteArray[76].callGroovyObjectGetProperty((Object)this), (Object)"2.0.0", callSiteArray[77].callGetProperty(JSONCompareMode.class));
    }

    @Test
    public void metadataWithV2AcceptHeader() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callCurrent((GroovyObject)this, null, (Object)"application/vnd.initializr.v2+json"), ResponseEntity.class);
        callSiteArray[79].callCurrent((GroovyObject)this, (Object)response, callSiteArray[80].callGetProperty(callSiteArray[81].callGetProperty(InitializrMetadataVersion.class)), (Object)"2.0.0", callSiteArray[82].callGetProperty(JSONCompareMode.class));
    }

    @Test
    public void metadataWithCurrentAcceptHeader() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].callCurrent((GroovyObject)this, null, (Object)"application/vnd.initializr.v2.1+json"), ResponseEntity.class);
        callSiteArray[84].callStatic(Assert.class, callSiteArray[85].call(callSiteArray[86].call((Object)response), callSiteArray[87].callGetProperty(HttpHeaders.class)), callSiteArray[88].callStatic(IsNot.class, callSiteArray[89].callStatic(CoreMatchers.class)));
        callSiteArray[90].callCurrent((GroovyObject)this, (Object)response, callSiteArray[91].callGroovyObjectGetProperty((Object)this));
        callSiteArray[92].callCurrent((GroovyObject)this, callSiteArray[93].callConstructor(JSONObject.class, callSiteArray[94].callGetProperty((Object)response)));
    }

    @Test
    public void metadataWithSeveralAcceptHeader() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].callCurrent((GroovyObject)this, null, (Object)"application/vnd.initializr.v2.1+json", (Object)"application/vnd.initializr.v2+json"), ResponseEntity.class);
        callSiteArray[96].callCurrent((GroovyObject)this, (Object)response, callSiteArray[97].callGroovyObjectGetProperty((Object)this));
        callSiteArray[98].callCurrent((GroovyObject)this, callSiteArray[99].callConstructor(JSONObject.class, callSiteArray[100].callGetProperty((Object)response)));
    }

    @Test
    public void metadataWithHalAcceptHeader() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].callCurrent((GroovyObject)this, null, (Object)"application/hal+json"), ResponseEntity.class);
        callSiteArray[102].callStatic(Assert.class, callSiteArray[103].call(callSiteArray[104].call((Object)response), callSiteArray[105].callGetProperty(HttpHeaders.class)), callSiteArray[106].callStatic(IsNot.class, callSiteArray[107].callStatic(CoreMatchers.class)));
        callSiteArray[108].callCurrent((GroovyObject)this, (Object)response, callSiteArray[109].callGetProperty(MainController.class));
        callSiteArray[110].callCurrent((GroovyObject)this, callSiteArray[111].callConstructor(JSONObject.class, callSiteArray[112].callGetProperty((Object)response)));
    }

    @Test
    public void metadataWithUnknownAcceptHeader() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        try {
            callSiteArray[113].callCurrent((GroovyObject)this, null, (Object)"application/vnd.initializr.v5.4+json");
        }
        catch (HttpClientErrorException ex) {
            callSiteArray[114].callStatic(Assert.class, callSiteArray[115].callGetProperty(HttpStatus.class), callSiteArray[116].callGetProperty((Object)ex));
        }
    }

    @Test
    public void curlReceivesTextByDefault() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].callCurrent((GroovyObject)this, (Object)"curl/1.2.4", (Object)"*/*"), ResponseEntity.class);
        callSiteArray[118].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    public void curlCanStillDownloadZipArchive() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].callCurrent((GroovyObject)this, (Object)"/starter.zip", byte[].class, (Object)"curl/1.2.4", (Object)"*/*"), ResponseEntity.class);
        callSiteArray[120].call(callSiteArray[121].call(callSiteArray[122].callCurrent((GroovyObject)this, callSiteArray[123].callGetProperty((Object)response))));
    }

    @Test
    public void curlCanStillDownloadTgzArchive() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[124].callCurrent((GroovyObject)this, (Object)"/starter.tgz", byte[].class, (Object)"curl/1.2.4", (Object)"*/*"), ResponseEntity.class);
        callSiteArray[125].call(callSiteArray[126].call(callSiteArray[127].callCurrent((GroovyObject)this, callSiteArray[128].callGetProperty((Object)response))));
    }

    @Test
    public void curlWithAcceptHeaderJson() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].callCurrent((GroovyObject)this, (Object)"curl/1.2.4", (Object)"application/json"), ResponseEntity.class);
        callSiteArray[130].callCurrent((GroovyObject)this, (Object)response, callSiteArray[131].callGroovyObjectGetProperty((Object)this));
        callSiteArray[132].callCurrent((GroovyObject)this, callSiteArray[133].callConstructor(JSONObject.class, callSiteArray[134].callGetProperty((Object)response)));
    }

    @Test
    public void curlWithAcceptHeaderTextPlain() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].callCurrent((GroovyObject)this, (Object)"curl/1.2.4", (Object)"text/plain"), ResponseEntity.class);
        callSiteArray[136].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    public void unknownAgentReceivesJsonByDefault() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].callCurrent((GroovyObject)this, (Object)"foo/1.0", (Object)"*/*"), ResponseEntity.class);
        callSiteArray[138].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    public void httpieReceivesTextByDefault() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].callCurrent((GroovyObject)this, (Object)"HTTPie/0.8.0", (Object)"*/*"), ResponseEntity.class);
        callSiteArray[140].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    public void httpieWithAcceptHeaderJson() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callCurrent((GroovyObject)this, (Object)"HTTPie/0.8.0", (Object)"application/json"), ResponseEntity.class);
        callSiteArray[142].callCurrent((GroovyObject)this, (Object)response, callSiteArray[143].callGroovyObjectGetProperty((Object)this));
        callSiteArray[144].callCurrent((GroovyObject)this, callSiteArray[145].callConstructor(JSONObject.class, callSiteArray[146].callGetProperty((Object)response)));
    }

    @Test
    public void httpieWithAcceptHeaderTextPlain() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[147].callCurrent((GroovyObject)this, (Object)"HTTPie/0.8.0", (Object)"text/plain"), ResponseEntity.class);
        callSiteArray[148].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    public void unknownCliWithTextPlain() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].callCurrent((GroovyObject)this, null, (Object)"text/plain"), ResponseEntity.class);
        callSiteArray[150].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    public void springBootCliReceivesJsonByDefault() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].callCurrent((GroovyObject)this, (Object)"SpringBootCli/1.2.0", (Object)"*/*"), ResponseEntity.class);
        callSiteArray[152].callCurrent((GroovyObject)this, (Object)response, callSiteArray[153].callGroovyObjectGetProperty((Object)this));
        callSiteArray[154].callCurrent((GroovyObject)this, callSiteArray[155].callConstructor(JSONObject.class, callSiteArray[156].callGetProperty((Object)response)));
    }

    @Test
    public void springBootCliWithAcceptHeaderText() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        ResponseEntity response = (ResponseEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[157].callCurrent((GroovyObject)this, (Object)"SpringBootCli/1.2.0", (Object)"text/plain"), ResponseEntity.class);
        callSiteArray[158].callCurrent((GroovyObject)this, (Object)response);
    }

    @Test
    public void validateCurrentProjectMetadata() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object json = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[159].callCurrent((GroovyObject)this);
            json = object;
        } else {
            JSONObject jSONObject;
            json = jSONObject = this.getMetadataJson();
        }
        callSiteArray[160].callCurrent((GroovyObject)this, json);
    }

    private void validateCurlHelpContent(ResponseEntity<String> response) {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[161].callCurrent((GroovyObject)this, response, callSiteArray[162].callGetProperty(MediaType.class));
        callSiteArray[163].callStatic(Assert.class, callSiteArray[164].call(callSiteArray[165].call(response), callSiteArray[166].callGetProperty(HttpHeaders.class)), callSiteArray[167].callStatic(IsNot.class, callSiteArray[168].callStatic(CoreMatchers.class)));
        callSiteArray[169].callStatic(Assert.class, callSiteArray[170].callGetProperty(response), callSiteArray[171].callStatic(CoreMatchers.class, callSiteArray[172].callStatic(CoreMatchers.class, (Object)"Spring Initializr"), callSiteArray[173].callStatic(CoreMatchers.class, (Object)"Examples:"), callSiteArray[174].callStatic(CoreMatchers.class, (Object)"curl")));
    }

    private void validateHttpIeHelpContent(ResponseEntity<String> response) {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[175].callCurrent((GroovyObject)this, response, callSiteArray[176].callGetProperty(MediaType.class));
        callSiteArray[177].callStatic(Assert.class, callSiteArray[178].call(callSiteArray[179].call(response), callSiteArray[180].callGetProperty(HttpHeaders.class)), callSiteArray[181].callStatic(IsNot.class, callSiteArray[182].callStatic(CoreMatchers.class)));
        callSiteArray[183].callStatic(Assert.class, callSiteArray[184].callGetProperty(response), callSiteArray[185].callStatic(CoreMatchers.class, callSiteArray[186].callStatic(CoreMatchers.class, (Object)"Spring Initializr"), callSiteArray[187].callStatic(CoreMatchers.class, (Object)"Examples:"), callSiteArray[188].callStatic(IsNot.class, callSiteArray[189].callStatic(CoreMatchers.class, (Object)"curl")), callSiteArray[190].callStatic(CoreMatchers.class, (Object)"http")));
    }

    private void validateGenericHelpContent(ResponseEntity<String> response) {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[191].callCurrent((GroovyObject)this, response, callSiteArray[192].callGetProperty(MediaType.class));
        callSiteArray[193].callStatic(Assert.class, callSiteArray[194].call(callSiteArray[195].call(response), callSiteArray[196].callGetProperty(HttpHeaders.class)), callSiteArray[197].callStatic(IsNot.class, callSiteArray[198].callStatic(CoreMatchers.class)));
        callSiteArray[199].callStatic(Assert.class, callSiteArray[200].callGetProperty(response), callSiteArray[201].callStatic(CoreMatchers.class, callSiteArray[202].callStatic(CoreMatchers.class, (Object)"Spring Initializr"), callSiteArray[203].callStatic(IsNot.class, callSiteArray[204].callStatic(CoreMatchers.class, (Object)"Examples:")), callSiteArray[205].callStatic(IsNot.class, callSiteArray[206].callStatic(CoreMatchers.class, (Object)"curl"))));
    }

    private void validateSpringBootHelpContent(ResponseEntity<String> response) {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[207].callCurrent((GroovyObject)this, response, callSiteArray[208].callGetProperty(MediaType.class));
        callSiteArray[209].callStatic(Assert.class, callSiteArray[210].call(callSiteArray[211].call(response), callSiteArray[212].callGetProperty(HttpHeaders.class)), callSiteArray[213].callStatic(IsNot.class, callSiteArray[214].callStatic(CoreMatchers.class)));
        callSiteArray[215].callStatic(Assert.class, callSiteArray[216].callGetProperty(response), callSiteArray[217].callStatic(CoreMatchers.class, callSiteArray[218].callStatic(CoreMatchers.class, (Object)"Service capabilities"), callSiteArray[219].callStatic(CoreMatchers.class, (Object)"Supported dependencies"), callSiteArray[220].callStatic(IsNot.class, callSiteArray[221].callStatic(CoreMatchers.class, (Object)"Examples:")), callSiteArray[222].callStatic(IsNot.class, callSiteArray[223].callStatic(CoreMatchers.class, (Object)"curl"))));
    }

    @Test
    public void metricsAvailableByDefault() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[224].callCurrent((GroovyObject)this, (Object)"/starter.zip?packaging=jar&javaVersion=1.8&style=web&style=jpa");
        Object result = null;
        result = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object4 = callSiteArray[225].callCurrent((GroovyObject)this)) : (object3 = this.metricsEndpoint());
        Object requests = callSiteArray[226].call(result, (Object)"counter.initializr.requests");
        Object packaging = callSiteArray[227].call(result, (Object)"counter.initializr.packaging.jar");
        Object javaVersion = callSiteArray[228].call(result, (Object)"counter.initializr.java_version.1_8");
        Object webDependency = callSiteArray[229].call(result, (Object)"counter.initializr.dependency.web");
        Object jpaDependency = callSiteArray[230].call(result, (Object)"counter.initializr.dependency.jpa");
        callSiteArray[231].callCurrent((GroovyObject)this, (Object)"/starter.zip?packaging=jar&javaVersion=1.8&style=web");
        Object updatedResult = null;
        updatedResult = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[232].callCurrent((GroovyObject)this)) : (object = this.metricsEndpoint());
        callSiteArray[233].callStatic(Assert.class, (Object)"Number of request should have increased", callSiteArray[234].call(requests, (Object)1), callSiteArray[235].call(updatedResult, (Object)"counter.initializr.requests"));
        callSiteArray[236].callStatic(Assert.class, (Object)"jar packaging metric should have increased", callSiteArray[237].call(packaging, (Object)1), callSiteArray[238].call(updatedResult, (Object)"counter.initializr.packaging.jar"));
        callSiteArray[239].callStatic(Assert.class, (Object)"java version metric should have increased", callSiteArray[240].call(javaVersion, (Object)1), callSiteArray[241].call(updatedResult, (Object)"counter.initializr.java_version.1_8"));
        callSiteArray[242].callStatic(Assert.class, (Object)"web dependency metric should have increased", callSiteArray[243].call(webDependency, (Object)1), callSiteArray[244].call(updatedResult, (Object)"counter.initializr.dependency.web"));
        callSiteArray[245].callStatic(Assert.class, (Object)"jpa dependency metric should not have increased", jpaDependency, callSiteArray[246].call(updatedResult, (Object)"counter.initializr.dependency.jpa"));
    }

    private Object metricsEndpoint() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        return callSiteArray[247].callCurrent((GroovyObject)this, callSiteArray[248].call(callSiteArray[249].callGroovyObjectGetProperty((Object)this), callSiteArray[250].callCurrent((GroovyObject)this, (Object)"/metrics"), String.class));
    }

    @Test
    public void missingDependencyProperException() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        try {
            callSiteArray[251].callCurrent((GroovyObject)this, (Object)"/starter.zip?style=foo:bar");
        }
        catch (HttpClientErrorException ex) {
            Object error = callSiteArray[252].callCurrent((GroovyObject)this, callSiteArray[253].callGetProperty((Object)ex));
            callSiteArray[254].callStatic(Assert.class, callSiteArray[255].callGetProperty(HttpStatus.class), callSiteArray[256].call((Object)ex));
            callSiteArray[257].callStatic(Assert.class, (Object)"Dependency not in error message", callSiteArray[258].call(callSiteArray[259].callGetProperty(error), (Object)"foo:bar"));
        }
    }

    private Object parseJson(String content) {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        return callSiteArray[260].call(this.slurper, (Object)content);
    }

    @Test
    public void downloadWithUnknownSpringBootStarter() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        callSiteArray[261].call(callSiteArray[262].call(callSiteArray[263].callCurrent((GroovyObject)this, (Object)"/starter.zip?style=foo")), (Object)"foo");
    }

    @Test
    public void homeIsForm() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[264].callCurrent((GroovyObject)this);
        callSiteArray[265].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[266].call(body, (Object)"action=\"/starter.zip\""));
    }

    @Test
    public void homeIsJson() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[267].callGetProperty(callSiteArray[268].callCurrent((GroovyObject)this, null, null));
        callSiteArray[269].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[270].call(body, (Object)"\"dependencies\""));
    }

    @Test
    public void webIsAddedPom() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[271].call(callSiteArray[272].callGroovyObjectGetProperty((Object)this), callSiteArray[273].callCurrent((GroovyObject)this, (Object)"/pom.xml?packaging=war"), String.class);
        callSiteArray[274].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[275].call(body, (Object)"spring-boot-starter-web"));
        callSiteArray[276].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[277].call(body, (Object)"provided"));
    }

    @Test
    public void webIsAddedGradle() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[278].call(callSiteArray[279].callGroovyObjectGetProperty((Object)this), callSiteArray[280].callCurrent((GroovyObject)this, (Object)"/build.gradle?packaging=war"), String.class);
        callSiteArray[281].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[282].call(body, (Object)"spring-boot-starter-web"));
        callSiteArray[283].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[284].call(body, (Object)"providedRuntime"));
    }

    @Test
    public void infoHasExternalProperties() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[285].call(callSiteArray[286].callGroovyObjectGetProperty((Object)this), callSiteArray[287].callCurrent((GroovyObject)this, (Object)"/info"), String.class);
        callSiteArray[288].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[289].call(body, (Object)"\"spring-boot\""));
        callSiteArray[290].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[291].call(body, (Object)"\"version\":\"1.1.4.RELEASE\""));
    }

    @Test
    public void homeHasWebStyle() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[292].callCurrent((GroovyObject)this);
        callSiteArray[293].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[294].call(body, (Object)"name=\"style\" value=\"web\""));
    }

    @Test
    public void homeHasBootVersion() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[295].callCurrent((GroovyObject)this);
        callSiteArray[296].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[297].call(body, (Object)"name=\"bootVersion\""));
        callSiteArray[298].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{body}, new String[]{"Wrong body:\n", ""}), callSiteArray[299].call(body, (Object)"1.2.0.BUILD-SNAPSHOT\""));
    }

    @Test
    public void homeHasOnlyProjectFormatTypes() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[300].callCurrent((GroovyObject)this);
        callSiteArray[301].callStatic(Assert.class, (Object)"maven project not found", callSiteArray[302].call(body, (Object)"Maven Project"));
        callSiteArray[303].callStatic(Assert.class, (Object)"maven pom type should have been filtered", callSiteArray[304].call(body, (Object)"Maven POM"));
    }

    @Test
    public void downloadStarter() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[305].call(callSiteArray[306].callGroovyObjectGetProperty((Object)this), callSiteArray[307].callCurrent((GroovyObject)this, (Object)"starter.zip"), byte[].class);
        callSiteArray[308].callStatic(Assert.class, body);
        callSiteArray[309].callStatic(Assert.class, (Object)ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[310].callGetProperty(body), (Object)100));
    }

    @Test
    public void installer() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object response = callSiteArray[311].call(callSiteArray[312].callGroovyObjectGetProperty((Object)this), callSiteArray[313].callCurrent((GroovyObject)this, (Object)"install.sh"), String.class);
        callSiteArray[314].callStatic(Assert.class, callSiteArray[315].callGetProperty(HttpStatus.class), callSiteArray[316].call(response));
        callSiteArray[317].callStatic(Assert.class, callSiteArray[318].callGetProperty(response));
    }

    @Test
    public void googleAnalyticsDisabledByDefault() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        Object body = callSiteArray[319].callCurrent((GroovyObject)this);
        callSiteArray[320].callStatic(Assert.class, (Object)"google analytics should be disabled", callSiteArray[321].call(body, (Object)"GoogleAnalyticsObject"));
    }

    private JSONObject getMetadataJson() {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        return (JSONObject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[322].callCurrent((GroovyObject)this, null, null), JSONObject.class);
    }

    private JSONObject getMetadataJson(String userAgentHeader, String acceptHeader) {
        CallSite[] callSiteArray = MainControllerIntegrationTests.$getCallSiteArray();
        String json = ShortTypeHandling.castToString((Object)callSiteArray[323].callGetProperty(callSiteArray[324].callCurrent((GroovyObject)this, (Object)userAgentHeader, (Object)acceptHeader)));
        return (JSONObject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[325].callConstructor(JSONObject.class, (Object)json), JSONObject.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MainControllerIntegrationTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "hasSpringBootStarterTest";
        stringArray[2] = "hasSpringBootStarterDependency";
        stringArray[3] = "hasSpringBootStarterDependency";
        stringArray[4] = "hasDependenciesCount";
        stringArray[5] = "pomAssert";
        stringArray[6] = "hasStaticAndTemplatesResources";
        stringArray[7] = "isMavenProject";
        stringArray[8] = "isJavaProject";
        stringArray[9] = "downloadZip";
        stringArray[10] = "hasDependency";
        stringArray[11] = "hasDependenciesCount";
        stringArray[12] = "pomAssert";
        stringArray[13] = "hasStaticAndTemplatesResources";
        stringArray[14] = "isMavenProject";
        stringArray[15] = "isJavaProject";
        stringArray[16] = "downloadTgz";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "hasDependency";
        stringArray[19] = "hasDependenciesCount";
        stringArray[20] = "pomAssert";
        stringArray[21] = "hasStaticAndTemplatesResources";
        stringArray[22] = "isMavenProject";
        stringArray[23] = "isJavaProject";
        stringArray[24] = "downloadTgz";
        stringArray[25] = "execute";
        stringArray[26] = "assertEquals";
        stringArray[27] = "NOT_ACCEPTABLE";
        stringArray[28] = "statusCode";
        stringArray[29] = "hasSpringBootStarterTest";
        stringArray[30] = "hasSpringBootStarterRootDependency";
        stringArray[31] = "hasDependenciesCount";
        stringArray[32] = "pomAssert";
        stringArray[33] = "hasStaticAndTemplatesResources";
        stringArray[34] = "isMavenProject";
        stringArray[35] = "isJavaProject";
        stringArray[36] = "downloadZip";
        stringArray[37] = "hasSpringBootStarterTest";
        stringArray[38] = "hasSpringBootStarterDependency";
        stringArray[39] = "hasSpringBootStarterDependency";
        stringArray[40] = "hasDependenciesCount";
        stringArray[41] = "pomAssert";
        stringArray[42] = "hasStaticAndTemplatesResources";
        stringArray[43] = "isMavenProject";
        stringArray[44] = "isJavaProject";
        stringArray[45] = "downloadZip";
        stringArray[46] = "hasSpringBootStarterTest";
        stringArray[47] = "hasSpringBootStarterDependency";
        stringArray[48] = "hasSpringBootStarterDependency";
        stringArray[49] = "hasDependenciesCount";
        stringArray[50] = "pomAssert";
        stringArray[51] = "hasStaticAndTemplatesResources";
        stringArray[52] = "isMavenProject";
        stringArray[53] = "isJavaProject";
        stringArray[54] = "downloadZip";
        stringArray[55] = "isGradleProject";
        stringArray[56] = "isJavaWarProject";
        stringArray[57] = "downloadZip";
        stringArray[58] = "assertSpringCliRedirect";
        stringArray[59] = "assertSpringCliRedirect";
        stringArray[60] = "assertSpringCliRedirect";
        stringArray[61] = "assertSpringCliRedirect";
        stringArray[62] = "getForEntity";
        stringArray[63] = "restTemplate";
        stringArray[64] = "createUrl";
        stringArray[65] = "assertEquals";
        stringArray[66] = "FOUND";
        stringArray[67] = "getStatusCode";
        stringArray[68] = "assertEquals";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "getLocation";
        stringArray[71] = "getHeaders";
        stringArray[72] = "invokeHome";
        stringArray[73] = "validateCurrentMetadata";
        stringArray[74] = "invokeHome";
        stringArray[75] = "validateMetadata";
        stringArray[76] = "CURRENT_METADATA_MEDIA_TYPE";
        stringArray[77] = "LENIENT";
        stringArray[78] = "invokeHome";
        stringArray[79] = "validateMetadata";
        stringArray[80] = "mediaType";
        stringArray[81] = "V2";
        stringArray[82] = "STRICT";
        stringArray[83] = "invokeHome";
        stringArray[84] = "assertThat";
        stringArray[85] = "getFirst";
        stringArray[86] = "getHeaders";
        stringArray[87] = "ETAG";
        stringArray[88] = "not";
        stringArray[89] = "nullValue";
        stringArray[90] = "validateContentType";
        stringArray[91] = "CURRENT_METADATA_MEDIA_TYPE";
        stringArray[92] = "validateCurrentMetadata";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "body";
        stringArray[95] = "invokeHome";
        stringArray[96] = "validateContentType";
        stringArray[97] = "CURRENT_METADATA_MEDIA_TYPE";
        stringArray[98] = "validateCurrentMetadata";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "body";
        stringArray[101] = "invokeHome";
        stringArray[102] = "assertThat";
        stringArray[103] = "getFirst";
        stringArray[104] = "getHeaders";
        stringArray[105] = "ETAG";
        stringArray[106] = "not";
        stringArray[107] = "nullValue";
        stringArray[108] = "validateContentType";
        stringArray[109] = "HAL_JSON_CONTENT_TYPE";
        stringArray[110] = "validateCurrentMetadata";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "body";
        stringArray[113] = "invokeHome";
        stringArray[114] = "assertEquals";
        stringArray[115] = "NOT_ACCEPTABLE";
        stringArray[116] = "statusCode";
        stringArray[117] = "invokeHome";
        stringArray[118] = "validateCurlHelpContent";
        stringArray[119] = "execute";
        stringArray[120] = "isJavaProject";
        stringArray[121] = "isMavenProject";
        stringArray[122] = "zipProjectAssert";
        stringArray[123] = "body";
        stringArray[124] = "execute";
        stringArray[125] = "isJavaProject";
        stringArray[126] = "isMavenProject";
        stringArray[127] = "tgzProjectAssert";
        stringArray[128] = "body";
        stringArray[129] = "invokeHome";
        stringArray[130] = "validateContentType";
        stringArray[131] = "CURRENT_METADATA_MEDIA_TYPE";
        stringArray[132] = "validateCurrentMetadata";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "body";
        stringArray[135] = "invokeHome";
        stringArray[136] = "validateCurlHelpContent";
        stringArray[137] = "invokeHome";
        stringArray[138] = "validateCurrentMetadata";
        stringArray[139] = "invokeHome";
        stringArray[140] = "validateHttpIeHelpContent";
        stringArray[141] = "invokeHome";
        stringArray[142] = "validateContentType";
        stringArray[143] = "CURRENT_METADATA_MEDIA_TYPE";
        stringArray[144] = "validateCurrentMetadata";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "body";
        stringArray[147] = "invokeHome";
        stringArray[148] = "validateHttpIeHelpContent";
        stringArray[149] = "invokeHome";
        stringArray[150] = "validateGenericHelpContent";
        stringArray[151] = "invokeHome";
        stringArray[152] = "validateContentType";
        stringArray[153] = "CURRENT_METADATA_MEDIA_TYPE";
        stringArray[154] = "validateCurrentMetadata";
        stringArray[155] = "<$constructor$>";
        stringArray[156] = "body";
        stringArray[157] = "invokeHome";
        stringArray[158] = "validateSpringBootHelpContent";
        stringArray[159] = "getMetadataJson";
        stringArray[160] = "validateCurrentMetadata";
        stringArray[161] = "validateContentType";
        stringArray[162] = "TEXT_PLAIN";
        stringArray[163] = "assertThat";
        stringArray[164] = "getFirst";
        stringArray[165] = "getHeaders";
        stringArray[166] = "ETAG";
        stringArray[167] = "not";
        stringArray[168] = "nullValue";
        stringArray[169] = "assertThat";
        stringArray[170] = "body";
        stringArray[171] = "allOf";
        stringArray[172] = "containsString";
        stringArray[173] = "containsString";
        stringArray[174] = "containsString";
        stringArray[175] = "validateContentType";
        stringArray[176] = "TEXT_PLAIN";
        stringArray[177] = "assertThat";
        stringArray[178] = "getFirst";
        stringArray[179] = "getHeaders";
        stringArray[180] = "ETAG";
        stringArray[181] = "not";
        stringArray[182] = "nullValue";
        stringArray[183] = "assertThat";
        stringArray[184] = "body";
        stringArray[185] = "allOf";
        stringArray[186] = "containsString";
        stringArray[187] = "containsString";
        stringArray[188] = "not";
        stringArray[189] = "containsString";
        stringArray[190] = "containsString";
        stringArray[191] = "validateContentType";
        stringArray[192] = "TEXT_PLAIN";
        stringArray[193] = "assertThat";
        stringArray[194] = "getFirst";
        stringArray[195] = "getHeaders";
        stringArray[196] = "ETAG";
        stringArray[197] = "not";
        stringArray[198] = "nullValue";
        stringArray[199] = "assertThat";
        stringArray[200] = "body";
        stringArray[201] = "allOf";
        stringArray[202] = "containsString";
        stringArray[203] = "not";
        stringArray[204] = "containsString";
        stringArray[205] = "not";
        stringArray[206] = "containsString";
        stringArray[207] = "validateContentType";
        stringArray[208] = "TEXT_PLAIN";
        stringArray[209] = "assertThat";
        stringArray[210] = "getFirst";
        stringArray[211] = "getHeaders";
        stringArray[212] = "ETAG";
        stringArray[213] = "not";
        stringArray[214] = "nullValue";
        stringArray[215] = "assertThat";
        stringArray[216] = "body";
        stringArray[217] = "allOf";
        stringArray[218] = "containsString";
        stringArray[219] = "containsString";
        stringArray[220] = "not";
        stringArray[221] = "containsString";
        stringArray[222] = "not";
        stringArray[223] = "containsString";
        stringArray[224] = "downloadZip";
        stringArray[225] = "metricsEndpoint";
        stringArray[226] = "getAt";
        stringArray[227] = "getAt";
        stringArray[228] = "getAt";
        stringArray[229] = "getAt";
        stringArray[230] = "getAt";
        stringArray[231] = "downloadZip";
        stringArray[232] = "metricsEndpoint";
        stringArray[233] = "assertEquals";
        stringArray[234] = "plus";
        stringArray[235] = "getAt";
        stringArray[236] = "assertEquals";
        stringArray[237] = "plus";
        stringArray[238] = "getAt";
        stringArray[239] = "assertEquals";
        stringArray[240] = "plus";
        stringArray[241] = "getAt";
        stringArray[242] = "assertEquals";
        stringArray[243] = "plus";
        stringArray[244] = "getAt";
        stringArray[245] = "assertEquals";
        stringArray[246] = "getAt";
        stringArray[247] = "parseJson";
        stringArray[248] = "getForObject";
        stringArray[249] = "restTemplate";
        stringArray[250] = "createUrl";
        stringArray[251] = "downloadArchive";
        stringArray[252] = "parseJson";
        stringArray[253] = "responseBodyAsString";
        stringArray[254] = "assertEquals";
        stringArray[255] = "BAD_REQUEST";
        stringArray[256] = "getStatusCode";
        stringArray[257] = "assertTrue";
        stringArray[258] = "contains";
        stringArray[259] = "message";
        stringArray[260] = "parseText";
        stringArray[261] = "hasSpringBootStarterDependency";
        stringArray[262] = "pomAssert";
        stringArray[263] = "downloadZip";
        stringArray[264] = "htmlHome";
        stringArray[265] = "assertTrue";
        stringArray[266] = "contains";
        stringArray[267] = "body";
        stringArray[268] = "invokeHome";
        stringArray[269] = "assertTrue";
        stringArray[270] = "contains";
        stringArray[271] = "getForObject";
        stringArray[272] = "restTemplate";
        stringArray[273] = "createUrl";
        stringArray[274] = "assertTrue";
        stringArray[275] = "contains";
        stringArray[276] = "assertTrue";
        stringArray[277] = "contains";
        stringArray[278] = "getForObject";
        stringArray[279] = "restTemplate";
        stringArray[280] = "createUrl";
        stringArray[281] = "assertTrue";
        stringArray[282] = "contains";
        stringArray[283] = "assertTrue";
        stringArray[284] = "contains";
        stringArray[285] = "getForObject";
        stringArray[286] = "restTemplate";
        stringArray[287] = "createUrl";
        stringArray[288] = "assertTrue";
        stringArray[289] = "contains";
        stringArray[290] = "assertTrue";
        stringArray[291] = "contains";
        stringArray[292] = "htmlHome";
        stringArray[293] = "assertTrue";
        stringArray[294] = "contains";
        stringArray[295] = "htmlHome";
        stringArray[296] = "assertTrue";
        stringArray[297] = "contains";
        stringArray[298] = "assertTrue";
        stringArray[299] = "contains";
        stringArray[300] = "htmlHome";
        stringArray[301] = "assertTrue";
        stringArray[302] = "contains";
        stringArray[303] = "assertFalse";
        stringArray[304] = "contains";
        stringArray[305] = "getForObject";
        stringArray[306] = "restTemplate";
        stringArray[307] = "createUrl";
        stringArray[308] = "assertNotNull";
        stringArray[309] = "assertTrue";
        stringArray[310] = "length";
        stringArray[311] = "getForEntity";
        stringArray[312] = "restTemplate";
        stringArray[313] = "createUrl";
        stringArray[314] = "assertEquals";
        stringArray[315] = "OK";
        stringArray[316] = "getStatusCode";
        stringArray[317] = "assertNotNull";
        stringArray[318] = "body";
        stringArray[319] = "htmlHome";
        stringArray[320] = "assertFalse";
        stringArray[321] = "contains";
        stringArray[322] = "getMetadataJson";
        stringArray[323] = "body";
        stringArray[324] = "invokeHome";
        stringArray[325] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[326];
        MainControllerIntegrationTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MainControllerIntegrationTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MainControllerIntegrationTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

