/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web;

import groovy.json.JsonSlurper;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.spring.initializr.config.StatsProperties;
import io.spring.initializr.web.AbstractInitializrControllerIntegrationTests;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@SpringApplicationConfiguration(value={StatsMockController.class})
@ActiveProfiles(value={"test-default", "test-custom-stats"})
public class MainControllerStatsIntegrationTests
extends AbstractInitializrControllerIntegrationTests {
    @Autowired
    private StatsMockController statsMockController;
    @Autowired
    private StatsProperties statsProperties;
    private final JsonSlurper slurper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MainControllerStatsIntegrationTests() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(JsonSlurper.class);
        this.slurper = (JsonSlurper)ScriptBytecodeAdapter.castToType((Object)object, JsonSlurper.class);
    }

    @Before
    public void setup() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        callSiteArray[1].call(callSiteArray[2].callGetProperty((Object)this.statsMockController));
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[3].callGroovyObjectGetProperty((Object)this)}, new String[]{"http://localhost:", "/elastic"});
        ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, (Object)callSiteArray[4].callGetProperty((Object)this.statsProperties), (String)"uri");
    }

    @Test
    public void simpleProject() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        callSiteArray[5].callCurrent((GroovyObject)this, (Object)"/starter.zip?groupId=com.foo&artifactId=bar&dependencies=web");
        callSiteArray[6].callStatic(Assert.class, (Object)"No stat got generated", (Object)1, callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this.statsMockController)));
        Object content = callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this.statsMockController), (Object)0);
        Object json = callSiteArray[11].call((Object)this.slurper, callSiteArray[12].callGetProperty(content));
        callSiteArray[13].callStatic(Assert.class, (Object)"com.foo", callSiteArray[14].callGetProperty(json));
        callSiteArray[15].callStatic(Assert.class, (Object)"bar", callSiteArray[16].callGetProperty(json));
        callSiteArray[17].callStatic(Assert.class, (Object)1, callSiteArray[18].call(callSiteArray[19].callGetProperty(json)));
        callSiteArray[20].callStatic(Assert.class, (Object)"web", callSiteArray[21].call(callSiteArray[22].callGetProperty(json), (Object)0));
    }

    @Test
    public void authorizationHeaderIsSet() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        callSiteArray[23].callCurrent((GroovyObject)this, (Object)"/starter.zip");
        callSiteArray[24].callStatic(Assert.class, (Object)"No stat got generated", (Object)1, callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty((Object)this.statsMockController)));
        Object content = callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this.statsMockController), (Object)0);
        Object authorization = callSiteArray[29].callGetProperty(content);
        callSiteArray[30].callStatic(Assert.class, (Object)"Authorization header must be set", authorization);
        callSiteArray[31].callStatic(Assert.class, (Object)"Wrong value for authorization header", callSiteArray[32].call(authorization, (Object)"Basic "));
        Object token = callSiteArray[33].call(authorization, callSiteArray[34].call((Object)"Basic "), callSiteArray[35].call(authorization));
        Object data = callSiteArray[36].call(callSiteArray[37].callConstructor(String.class, callSiteArray[38].call(Base64Utils.class, token)), (Object)":");
        callSiteArray[39].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{token}, new String[]{"Wrong user from ", ""}), (Object)"test-user", callSiteArray[40].call(data, (Object)0));
        callSiteArray[41].callStatic(Assert.class, (Object)new GStringImpl(new Object[]{token}, new String[]{"Wrong password ", ""}), (Object)"test-password", callSiteArray[42].call(data, (Object)1));
    }

    @Test
    public void requestIpNotSetByDefault() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        callSiteArray[43].callCurrent((GroovyObject)this, (Object)"/starter.zip?groupId=com.foo&artifactId=bar&dependencies=web");
        callSiteArray[44].callStatic(Assert.class, (Object)"No stat got generated", (Object)1, callSiteArray[45].call(callSiteArray[46].callGroovyObjectGetProperty((Object)this.statsMockController)));
        Object content = callSiteArray[47].call(callSiteArray[48].callGroovyObjectGetProperty((Object)this.statsMockController), (Object)0);
        Object json = callSiteArray[49].call((Object)this.slurper, callSiteArray[50].callGetProperty(content));
        callSiteArray[51].callStatic(Assert.class, (Object)"requestIp property should not be set", callSiteArray[52].call(json, (Object)"requestIp"));
    }

    @Test
    public void requestIpIsSetWhenHeaderIsPresent() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        RequestEntity request = (RequestEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(RequestEntity.class, callSiteArray[56].callConstructor(URI.class, callSiteArray[57].callCurrent((GroovyObject)this, (Object)"/starter.zip"))), (Object)"X-FORWARDED-FOR", (Object)"10.0.0.123")), RequestEntity.class);
        callSiteArray[58].call(callSiteArray[59].callGroovyObjectGetProperty((Object)this), (Object)request, String.class);
        callSiteArray[60].callStatic(Assert.class, (Object)"No stat got generated", (Object)1, callSiteArray[61].call(callSiteArray[62].callGroovyObjectGetProperty((Object)this.statsMockController)));
        Object content = callSiteArray[63].call(callSiteArray[64].callGroovyObjectGetProperty((Object)this.statsMockController), (Object)0);
        Object json = callSiteArray[65].call((Object)this.slurper, callSiteArray[66].callGetProperty(content));
        callSiteArray[67].callStatic(Assert.class, (Object)"Wrong requestIp", (Object)"10.0.0.123", callSiteArray[68].callGetProperty(json));
    }

    @Test
    public void requestIpv4IsNotSetWhenHeaderHasGarbage() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        RequestEntity request = (RequestEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].call(RequestEntity.class, callSiteArray[72].callConstructor(URI.class, callSiteArray[73].callCurrent((GroovyObject)this, (Object)"/starter.zip"))), (Object)"x-forwarded-for", (Object)"foo-bar")), RequestEntity.class);
        callSiteArray[74].call(callSiteArray[75].callGroovyObjectGetProperty((Object)this), (Object)request, String.class);
        callSiteArray[76].callStatic(Assert.class, (Object)"No stat got generated", (Object)1, callSiteArray[77].call(callSiteArray[78].callGroovyObjectGetProperty((Object)this.statsMockController)));
        Object content = callSiteArray[79].call(callSiteArray[80].callGroovyObjectGetProperty((Object)this.statsMockController), (Object)0);
        Object json = callSiteArray[81].call((Object)this.slurper, callSiteArray[82].callGetProperty(content));
        callSiteArray[83].callStatic(Assert.class, (Object)"requestIpv4 property should not be set if value is not a valid IPv4", callSiteArray[84].call(json, (Object)"requestIpv4"));
    }

    @Test
    public void requestCountryIsNotSetWhenHeaderIsSetToXX() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        RequestEntity request = (RequestEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call(RequestEntity.class, callSiteArray[88].callConstructor(URI.class, callSiteArray[89].callCurrent((GroovyObject)this, (Object)"/starter.zip"))), (Object)"cf-ipcountry", (Object)"XX")), RequestEntity.class);
        callSiteArray[90].call(callSiteArray[91].callGroovyObjectGetProperty((Object)this), (Object)request, String.class);
        callSiteArray[92].callStatic(Assert.class, (Object)"No stat got generated", (Object)1, callSiteArray[93].call(callSiteArray[94].callGroovyObjectGetProperty((Object)this.statsMockController)));
        Object content = callSiteArray[95].call(callSiteArray[96].callGroovyObjectGetProperty((Object)this.statsMockController), (Object)0);
        Object json = callSiteArray[97].call((Object)this.slurper, callSiteArray[98].callGetProperty(content));
        callSiteArray[99].callStatic(Assert.class, (Object)"requestCountry property should not be set if value is set to xx", callSiteArray[100].call(json, (Object)"requestCountry"));
    }

    @Test
    public void invalidProjectSillHasStats() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        try {
            callSiteArray[101].callCurrent((GroovyObject)this, (Object)"/starter.zip?type=invalid-type");
            callSiteArray[102].callStatic(Assert.class, (Object)"Should have failed to generate project with invalid type");
        }
        catch (HttpClientErrorException ex) {
            callSiteArray[103].callStatic(Assert.class, callSiteArray[104].callGetProperty(HttpStatus.class), callSiteArray[105].callGetProperty((Object)ex));
        }
        callSiteArray[106].callStatic(Assert.class, (Object)"No stat got generated", (Object)1, callSiteArray[107].call(callSiteArray[108].callGroovyObjectGetProperty((Object)this.statsMockController)));
        Object content = callSiteArray[109].call(callSiteArray[110].callGroovyObjectGetProperty((Object)this.statsMockController), (Object)0);
        Object json = callSiteArray[111].call((Object)this.slurper, callSiteArray[112].callGetProperty(content));
        callSiteArray[113].callStatic(Assert.class, (Object)"com.example", callSiteArray[114].callGetProperty(json));
        callSiteArray[115].callStatic(Assert.class, (Object)"demo", callSiteArray[116].callGetProperty(json));
        callSiteArray[117].callStatic(Assert.class, (Object)true, callSiteArray[118].callGetProperty(json));
        callSiteArray[119].callStatic(Assert.class, (Object)true, callSiteArray[120].callGetProperty(json));
        callSiteArray[121].callStatic(Assert.class, callSiteArray[122].callGetProperty(json));
        callSiteArray[123].callStatic(Assert.class, callSiteArray[124].call(callSiteArray[125].callGetProperty(json), (Object)"invalid-type"));
    }

    @Test
    public void errorPublishingStatsDoesNotBubbleUp() {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[126].callGroovyObjectGetProperty((Object)this)}, new String[]{"http://localhost:", "/elastic-error"});
        ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, (Object)callSiteArray[127].callGetProperty((Object)this.statsProperties), (String)"uri");
        callSiteArray[128].callCurrent((GroovyObject)this, (Object)"/starter.zip");
        callSiteArray[129].callStatic(Assert.class, (Object)"No stat should be available", (Object)0, callSiteArray[130].call(callSiteArray[131].callGroovyObjectGetProperty((Object)this.statsMockController)));
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MainControllerStatsIntegrationTests.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, MainControllerStatsIntegrationTests.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = MainControllerStatsIntegrationTests.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(MainControllerStatsIntegrationTests.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MainControllerStatsIntegrationTests.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "clear";
        stringArray[2] = "stats";
        stringArray[3] = "port";
        stringArray[4] = "elastic";
        stringArray[5] = "downloadArchive";
        stringArray[6] = "assertEquals";
        stringArray[7] = "size";
        stringArray[8] = "stats";
        stringArray[9] = "getAt";
        stringArray[10] = "stats";
        stringArray[11] = "parseText";
        stringArray[12] = "json";
        stringArray[13] = "assertEquals";
        stringArray[14] = "groupId";
        stringArray[15] = "assertEquals";
        stringArray[16] = "artifactId";
        stringArray[17] = "assertEquals";
        stringArray[18] = "size";
        stringArray[19] = "dependencies";
        stringArray[20] = "assertEquals";
        stringArray[21] = "getAt";
        stringArray[22] = "dependencies";
        stringArray[23] = "downloadArchive";
        stringArray[24] = "assertEquals";
        stringArray[25] = "size";
        stringArray[26] = "stats";
        stringArray[27] = "getAt";
        stringArray[28] = "stats";
        stringArray[29] = "authorization";
        stringArray[30] = "assertNotNull";
        stringArray[31] = "assertTrue";
        stringArray[32] = "startsWith";
        stringArray[33] = "substring";
        stringArray[34] = "length";
        stringArray[35] = "size";
        stringArray[36] = "split";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "decodeFromString";
        stringArray[39] = "assertEquals";
        stringArray[40] = "getAt";
        stringArray[41] = "assertEquals";
        stringArray[42] = "getAt";
        stringArray[43] = "downloadArchive";
        stringArray[44] = "assertEquals";
        stringArray[45] = "size";
        stringArray[46] = "stats";
        stringArray[47] = "getAt";
        stringArray[48] = "stats";
        stringArray[49] = "parseText";
        stringArray[50] = "json";
        stringArray[51] = "assertFalse";
        stringArray[52] = "containsKey";
        stringArray[53] = "build";
        stringArray[54] = "header";
        stringArray[55] = "get";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "createUrl";
        stringArray[58] = "exchange";
        stringArray[59] = "restTemplate";
        stringArray[60] = "assertEquals";
        stringArray[61] = "size";
        stringArray[62] = "stats";
        stringArray[63] = "getAt";
        stringArray[64] = "stats";
        stringArray[65] = "parseText";
        stringArray[66] = "json";
        stringArray[67] = "assertEquals";
        stringArray[68] = "requestIp";
        stringArray[69] = "build";
        stringArray[70] = "header";
        stringArray[71] = "get";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "createUrl";
        stringArray[74] = "exchange";
        stringArray[75] = "restTemplate";
        stringArray[76] = "assertEquals";
        stringArray[77] = "size";
        stringArray[78] = "stats";
        stringArray[79] = "getAt";
        stringArray[80] = "stats";
        stringArray[81] = "parseText";
        stringArray[82] = "json";
        stringArray[83] = "assertFalse";
        stringArray[84] = "containsKey";
        stringArray[85] = "build";
        stringArray[86] = "header";
        stringArray[87] = "get";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "createUrl";
        stringArray[90] = "exchange";
        stringArray[91] = "restTemplate";
        stringArray[92] = "assertEquals";
        stringArray[93] = "size";
        stringArray[94] = "stats";
        stringArray[95] = "getAt";
        stringArray[96] = "stats";
        stringArray[97] = "parseText";
        stringArray[98] = "json";
        stringArray[99] = "assertFalse";
        stringArray[100] = "containsKey";
        stringArray[101] = "downloadArchive";
        stringArray[102] = "fail";
        stringArray[103] = "assertEquals";
        stringArray[104] = "BAD_REQUEST";
        stringArray[105] = "statusCode";
        stringArray[106] = "assertEquals";
        stringArray[107] = "size";
        stringArray[108] = "stats";
        stringArray[109] = "getAt";
        stringArray[110] = "stats";
        stringArray[111] = "parseText";
        stringArray[112] = "json";
        stringArray[113] = "assertEquals";
        stringArray[114] = "groupId";
        stringArray[115] = "assertEquals";
        stringArray[116] = "artifactId";
        stringArray[117] = "assertEquals";
        stringArray[118] = "invalid";
        stringArray[119] = "assertEquals";
        stringArray[120] = "invalidType";
        stringArray[121] = "assertNotNull";
        stringArray[122] = "errorMessage";
        stringArray[123] = "assertTrue";
        stringArray[124] = "contains";
        stringArray[125] = "errorMessage";
        stringArray[126] = "port";
        stringArray[127] = "elastic";
        stringArray[128] = "downloadArchive";
        stringArray[129] = "assertEquals";
        stringArray[130] = "size";
        stringArray[131] = "stats";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[132];
        MainControllerStatsIntegrationTests.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MainControllerStatsIntegrationTests.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MainControllerStatsIntegrationTests.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RestController
    public static class StatsMockController
    implements GroovyObject {
        private final List<Content> stats;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public StatsMockController() {
            MetaClass metaClass;
            List list;
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            this.stats = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @RequestMapping(path={"/elastic/test/my-entity"}, method={RequestMethod.POST})
        public void handleProjectRequestDocument(RequestEntity<String> input) {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            Object authorization = callSiteArray[0].call(callSiteArray[1].callGetProperty(input), callSiteArray[2].callGetProperty(HttpHeaders.class));
            Object content = callSiteArray[3].callConstructor(Content.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"authorization", authorization, "json", callSiteArray[4].callGetProperty(input)}));
            callSiteArray[5].call(this.stats, content);
        }

        @RequestMapping(path={"/elastic-error/test/my-entity"}, method={RequestMethod.POST})
        public void handleExpectedError() {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            throw (Throwable)callSiteArray[6].callConstructor(IllegalStateException.class, (Object)"Expected exception");
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StatsMockController.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, StatsMockController.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            return ScriptBytecodeAdapter.getGroovyObjectProperty(StatsMockController.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(StatsMockController.class, MainControllerStatsIntegrationTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, MainControllerStatsIntegrationTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = StatsMockController.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(StatsMockController.class, MainControllerStatsIntegrationTests.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StatsMockController.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "getFirst";
            stringArray[1] = "headers";
            stringArray[2] = "AUTHORIZATION";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "body";
            stringArray[5] = "leftShift";
            stringArray[6] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[7];
            StatsMockController.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(StatsMockController.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = StatsMockController.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        public static class Content
        implements GroovyObject {
            private String authorization;
            private String json;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Content() {
                MetaClass metaClass;
                CallSite[] callSiteArray = Content.$getCallSiteArray();
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = Content.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(Content.class, StatsMockController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = Content.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, StatsMockController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = Content.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(Content.class, StatsMockController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != Content.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public String getAuthorization() {
                return this.authorization;
            }

            public void setAuthorization(String string) {
                this.authorization = string;
            }

            public String getJson() {
                return this.json;
            }

            public void setJson(String string) {
                this.json = string;
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(Content.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = Content.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
    }
}

