package org.cloudfoundry.reactor.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications.ApplicationsV2;
import org.cloudfoundry.client.v2.applicationusageevents.ApplicationUsageEvents;
import org.cloudfoundry.client.v2.buildpacks.Buildpacks;
import org.cloudfoundry.client.v2.domains.Domains;
import org.cloudfoundry.client.v2.environmentvariablegroups.EnvironmentVariableGroups;
import org.cloudfoundry.client.v2.events.Events;
import org.cloudfoundry.client.v2.featureflags.FeatureFlags;
import org.cloudfoundry.client.v2.info.Info;
import org.cloudfoundry.client.v2.jobs.Jobs;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitions;
import org.cloudfoundry.client.v2.organizations.Organizations;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomains;
import org.cloudfoundry.client.v2.resourcematch.ResourceMatch;
import org.cloudfoundry.client.v2.routemappings.RouteMappings;
import org.cloudfoundry.client.v2.routes.Routes;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroups;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingsV2;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokers;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstances;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeys;
import org.cloudfoundry.client.v2.serviceplans.ServicePlans;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilities;
import org.cloudfoundry.client.v2.services.Services;
import org.cloudfoundry.client.v2.serviceusageevents.ServiceUsageEvents;
import org.cloudfoundry.client.v2.shareddomains.SharedDomains;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitions;
import org.cloudfoundry.client.v2.spaces.Spaces;
import org.cloudfoundry.client.v2.stacks.Stacks;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.UserProvidedServiceInstances;
import org.cloudfoundry.client.v2.users.Users;
import org.cloudfoundry.client.v3.applications.ApplicationsV3;
import org.cloudfoundry.client.v3.droplets.Droplets;
import org.cloudfoundry.client.v3.packages.Packages;
import org.cloudfoundry.client.v3.processes.Processes;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingsV3;
import org.cloudfoundry.client.v3.tasks.Tasks;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.HttpClient;

/**
 * Immutable implementation of {@link _ReactorCloudFoundryClient}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ReactorCloudFoundryClient.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ReactorCloudFoundryClient"})
public final class ReactorCloudFoundryClient
    extends org.cloudfoundry.reactor.client._ReactorCloudFoundryClient {
  private final ApplicationUsageEvents applicationUsageEvents;
  private final ApplicationsV2 applicationsV2;
  private final ApplicationsV3 applicationsV3;
  private final Buildpacks buildpacks;
  private final Domains domains;
  private final Droplets droplets;
  private final EnvironmentVariableGroups environmentVariableGroups;
  private final Events events;
  private final FeatureFlags featureFlags;
  private final Info info;
  private final Jobs jobs;
  private final OrganizationQuotaDefinitions organizationQuotaDefinitions;
  private final Organizations organizations;
  private final Packages packages;
  private final PrivateDomains privateDomains;
  private final Processes processes;
  private final ResourceMatch resourceMatch;
  private final RouteMappings routeMappings;
  private final Routes routes;
  private final SecurityGroups securityGroups;
  private final ServiceBindingsV2 serviceBindingsV2;
  private final ServiceBindingsV3 serviceBindingsV3;
  private final ServiceBrokers serviceBrokers;
  private final ServiceInstances serviceInstances;
  private final ServiceKeys serviceKeys;
  private final ServicePlanVisibilities servicePlanVisibilities;
  private final ServicePlans servicePlans;
  private final ServiceUsageEvents serviceUsageEvents;
  private final Services services;
  private final SharedDomains sharedDomains;
  private final SpaceQuotaDefinitions spaceQuotaDefinitions;
  private final Spaces spaces;
  private final Stacks stacks;
  private final Tasks tasks;
  private final UserProvidedServiceInstances userProvidedServiceInstances;
  private final Users users;
  private final @Nullable ConnectionContext connectionContext;
  private final HttpClient httpClient;
  private final ObjectMapper objectMapper;
  private final Mono<String> root;
  private final TokenProvider tokenProvider;

  private ReactorCloudFoundryClient(ReactorCloudFoundryClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.tokenProvider = builder.tokenProvider;
    if (builder.httpClient != null) {
      initShim.httpClient(builder.httpClient);
    }
    if (builder.objectMapper != null) {
      initShim.objectMapper(builder.objectMapper);
    }
    if (builder.root != null) {
      initShim.root(builder.root);
    }
    this.httpClient = initShim.getHttpClient();
    this.objectMapper = initShim.getObjectMapper();
    this.root = initShim.getRoot();
    this.applicationUsageEvents = initShim.applicationUsageEvents();
    this.applicationsV2 = initShim.applicationsV2();
    this.applicationsV3 = initShim.applicationsV3();
    this.buildpacks = initShim.buildpacks();
    this.domains = initShim.domains();
    this.droplets = initShim.droplets();
    this.environmentVariableGroups = initShim.environmentVariableGroups();
    this.events = initShim.events();
    this.featureFlags = initShim.featureFlags();
    this.info = initShim.info();
    this.jobs = initShim.jobs();
    this.organizationQuotaDefinitions = initShim.organizationQuotaDefinitions();
    this.organizations = initShim.organizations();
    this.packages = initShim.packages();
    this.privateDomains = initShim.privateDomains();
    this.processes = initShim.processes();
    this.resourceMatch = initShim.resourceMatch();
    this.routeMappings = initShim.routeMappings();
    this.routes = initShim.routes();
    this.securityGroups = initShim.securityGroups();
    this.serviceBindingsV2 = initShim.serviceBindingsV2();
    this.serviceBindingsV3 = initShim.serviceBindingsV3();
    this.serviceBrokers = initShim.serviceBrokers();
    this.serviceInstances = initShim.serviceInstances();
    this.serviceKeys = initShim.serviceKeys();
    this.servicePlanVisibilities = initShim.servicePlanVisibilities();
    this.servicePlans = initShim.servicePlans();
    this.serviceUsageEvents = initShim.serviceUsageEvents();
    this.services = initShim.services();
    this.sharedDomains = initShim.sharedDomains();
    this.spaceQuotaDefinitions = initShim.spaceQuotaDefinitions();
    this.spaces = initShim.spaces();
    this.stacks = initShim.stacks();
    this.tasks = initShim.tasks();
    this.userProvidedServiceInstances = initShim.userProvidedServiceInstances();
    this.users = initShim.users();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private ApplicationUsageEvents applicationUsageEvents;
    private int applicationUsageEventsStage;

    ApplicationUsageEvents applicationUsageEvents() {
      if (applicationUsageEventsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationUsageEventsStage == STAGE_UNINITIALIZED) {
        applicationUsageEventsStage = STAGE_INITIALIZING;
        this.applicationUsageEvents = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationUsageEvents(), "applicationUsageEvents");
        applicationUsageEventsStage = STAGE_INITIALIZED;
      }
      return this.applicationUsageEvents;
    }
    private ApplicationsV2 applicationsV2;
    private int applicationsV2Stage;

    ApplicationsV2 applicationsV2() {
      if (applicationsV2Stage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsV2Stage == STAGE_UNINITIALIZED) {
        applicationsV2Stage = STAGE_INITIALIZING;
        this.applicationsV2 = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationsV2(), "applicationsV2");
        applicationsV2Stage = STAGE_INITIALIZED;
      }
      return this.applicationsV2;
    }
    private ApplicationsV3 applicationsV3;
    private int applicationsV3Stage;

    ApplicationsV3 applicationsV3() {
      if (applicationsV3Stage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsV3Stage == STAGE_UNINITIALIZED) {
        applicationsV3Stage = STAGE_INITIALIZING;
        this.applicationsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationsV3(), "applicationsV3");
        applicationsV3Stage = STAGE_INITIALIZED;
      }
      return this.applicationsV3;
    }
    private Buildpacks buildpacks;
    private int buildpacksStage;

    Buildpacks buildpacks() {
      if (buildpacksStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildpacksStage == STAGE_UNINITIALIZED) {
        buildpacksStage = STAGE_INITIALIZING;
        this.buildpacks = Objects.requireNonNull(ReactorCloudFoundryClient.super.buildpacks(), "buildpacks");
        buildpacksStage = STAGE_INITIALIZED;
      }
      return this.buildpacks;
    }
    private Domains domains;
    private int domainsStage;

    Domains domains() {
      if (domainsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (domainsStage == STAGE_UNINITIALIZED) {
        domainsStage = STAGE_INITIALIZING;
        this.domains = Objects.requireNonNull(ReactorCloudFoundryClient.super.domains(), "domains");
        domainsStage = STAGE_INITIALIZED;
      }
      return this.domains;
    }
    private Droplets droplets;
    private int dropletsStage;

    Droplets droplets() {
      if (dropletsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dropletsStage == STAGE_UNINITIALIZED) {
        dropletsStage = STAGE_INITIALIZING;
        this.droplets = Objects.requireNonNull(ReactorCloudFoundryClient.super.droplets(), "droplets");
        dropletsStage = STAGE_INITIALIZED;
      }
      return this.droplets;
    }
    private EnvironmentVariableGroups environmentVariableGroups;
    private int environmentVariableGroupsStage;

    EnvironmentVariableGroups environmentVariableGroups() {
      if (environmentVariableGroupsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (environmentVariableGroupsStage == STAGE_UNINITIALIZED) {
        environmentVariableGroupsStage = STAGE_INITIALIZING;
        this.environmentVariableGroups = Objects.requireNonNull(ReactorCloudFoundryClient.super.environmentVariableGroups(), "environmentVariableGroups");
        environmentVariableGroupsStage = STAGE_INITIALIZED;
      }
      return this.environmentVariableGroups;
    }
    private Events events;
    private int eventsStage;

    Events events() {
      if (eventsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (eventsStage == STAGE_UNINITIALIZED) {
        eventsStage = STAGE_INITIALIZING;
        this.events = Objects.requireNonNull(ReactorCloudFoundryClient.super.events(), "events");
        eventsStage = STAGE_INITIALIZED;
      }
      return this.events;
    }
    private FeatureFlags featureFlags;
    private int featureFlagsStage;

    FeatureFlags featureFlags() {
      if (featureFlagsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (featureFlagsStage == STAGE_UNINITIALIZED) {
        featureFlagsStage = STAGE_INITIALIZING;
        this.featureFlags = Objects.requireNonNull(ReactorCloudFoundryClient.super.featureFlags(), "featureFlags");
        featureFlagsStage = STAGE_INITIALIZED;
      }
      return this.featureFlags;
    }
    private Info info;
    private int infoStage;

    Info info() {
      if (infoStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (infoStage == STAGE_UNINITIALIZED) {
        infoStage = STAGE_INITIALIZING;
        this.info = Objects.requireNonNull(ReactorCloudFoundryClient.super.info(), "info");
        infoStage = STAGE_INITIALIZED;
      }
      return this.info;
    }
    private Jobs jobs;
    private int jobsStage;

    Jobs jobs() {
      if (jobsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (jobsStage == STAGE_UNINITIALIZED) {
        jobsStage = STAGE_INITIALIZING;
        this.jobs = Objects.requireNonNull(ReactorCloudFoundryClient.super.jobs(), "jobs");
        jobsStage = STAGE_INITIALIZED;
      }
      return this.jobs;
    }
    private OrganizationQuotaDefinitions organizationQuotaDefinitions;
    private int organizationQuotaDefinitionsStage;

    OrganizationQuotaDefinitions organizationQuotaDefinitions() {
      if (organizationQuotaDefinitionsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationQuotaDefinitionsStage == STAGE_UNINITIALIZED) {
        organizationQuotaDefinitionsStage = STAGE_INITIALIZING;
        this.organizationQuotaDefinitions = Objects.requireNonNull(ReactorCloudFoundryClient.super.organizationQuotaDefinitions(), "organizationQuotaDefinitions");
        organizationQuotaDefinitionsStage = STAGE_INITIALIZED;
      }
      return this.organizationQuotaDefinitions;
    }
    private Organizations organizations;
    private int organizationsStage;

    Organizations organizations() {
      if (organizationsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationsStage == STAGE_UNINITIALIZED) {
        organizationsStage = STAGE_INITIALIZING;
        this.organizations = Objects.requireNonNull(ReactorCloudFoundryClient.super.organizations(), "organizations");
        organizationsStage = STAGE_INITIALIZED;
      }
      return this.organizations;
    }
    private Packages packages;
    private int packagesStage;

    Packages packages() {
      if (packagesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (packagesStage == STAGE_UNINITIALIZED) {
        packagesStage = STAGE_INITIALIZING;
        this.packages = Objects.requireNonNull(ReactorCloudFoundryClient.super.packages(), "packages");
        packagesStage = STAGE_INITIALIZED;
      }
      return this.packages;
    }
    private PrivateDomains privateDomains;
    private int privateDomainsStage;

    PrivateDomains privateDomains() {
      if (privateDomainsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (privateDomainsStage == STAGE_UNINITIALIZED) {
        privateDomainsStage = STAGE_INITIALIZING;
        this.privateDomains = Objects.requireNonNull(ReactorCloudFoundryClient.super.privateDomains(), "privateDomains");
        privateDomainsStage = STAGE_INITIALIZED;
      }
      return this.privateDomains;
    }
    private Processes processes;
    private int processesStage;

    Processes processes() {
      if (processesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processesStage == STAGE_UNINITIALIZED) {
        processesStage = STAGE_INITIALIZING;
        this.processes = Objects.requireNonNull(ReactorCloudFoundryClient.super.processes(), "processes");
        processesStage = STAGE_INITIALIZED;
      }
      return this.processes;
    }
    private ResourceMatch resourceMatch;
    private int resourceMatchStage;

    ResourceMatch resourceMatch() {
      if (resourceMatchStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (resourceMatchStage == STAGE_UNINITIALIZED) {
        resourceMatchStage = STAGE_INITIALIZING;
        this.resourceMatch = Objects.requireNonNull(ReactorCloudFoundryClient.super.resourceMatch(), "resourceMatch");
        resourceMatchStage = STAGE_INITIALIZED;
      }
      return this.resourceMatch;
    }
    private RouteMappings routeMappings;
    private int routeMappingsStage;

    RouteMappings routeMappings() {
      if (routeMappingsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routeMappingsStage == STAGE_UNINITIALIZED) {
        routeMappingsStage = STAGE_INITIALIZING;
        this.routeMappings = Objects.requireNonNull(ReactorCloudFoundryClient.super.routeMappings(), "routeMappings");
        routeMappingsStage = STAGE_INITIALIZED;
      }
      return this.routeMappings;
    }
    private Routes routes;
    private int routesStage;

    Routes routes() {
      if (routesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routesStage == STAGE_UNINITIALIZED) {
        routesStage = STAGE_INITIALIZING;
        this.routes = Objects.requireNonNull(ReactorCloudFoundryClient.super.routes(), "routes");
        routesStage = STAGE_INITIALIZED;
      }
      return this.routes;
    }
    private SecurityGroups securityGroups;
    private int securityGroupsStage;

    SecurityGroups securityGroups() {
      if (securityGroupsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (securityGroupsStage == STAGE_UNINITIALIZED) {
        securityGroupsStage = STAGE_INITIALIZING;
        this.securityGroups = Objects.requireNonNull(ReactorCloudFoundryClient.super.securityGroups(), "securityGroups");
        securityGroupsStage = STAGE_INITIALIZED;
      }
      return this.securityGroups;
    }
    private ServiceBindingsV2 serviceBindingsV2;
    private int serviceBindingsV2Stage;

    ServiceBindingsV2 serviceBindingsV2() {
      if (serviceBindingsV2Stage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBindingsV2Stage == STAGE_UNINITIALIZED) {
        serviceBindingsV2Stage = STAGE_INITIALIZING;
        this.serviceBindingsV2 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBindingsV2(), "serviceBindingsV2");
        serviceBindingsV2Stage = STAGE_INITIALIZED;
      }
      return this.serviceBindingsV2;
    }
    private ServiceBindingsV3 serviceBindingsV3;
    private int serviceBindingsV3Stage;

    ServiceBindingsV3 serviceBindingsV3() {
      if (serviceBindingsV3Stage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBindingsV3Stage == STAGE_UNINITIALIZED) {
        serviceBindingsV3Stage = STAGE_INITIALIZING;
        this.serviceBindingsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBindingsV3(), "serviceBindingsV3");
        serviceBindingsV3Stage = STAGE_INITIALIZED;
      }
      return this.serviceBindingsV3;
    }
    private ServiceBrokers serviceBrokers;
    private int serviceBrokersStage;

    ServiceBrokers serviceBrokers() {
      if (serviceBrokersStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBrokersStage == STAGE_UNINITIALIZED) {
        serviceBrokersStage = STAGE_INITIALIZING;
        this.serviceBrokers = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBrokers(), "serviceBrokers");
        serviceBrokersStage = STAGE_INITIALIZED;
      }
      return this.serviceBrokers;
    }
    private ServiceInstances serviceInstances;
    private int serviceInstancesStage;

    ServiceInstances serviceInstances() {
      if (serviceInstancesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceInstancesStage == STAGE_UNINITIALIZED) {
        serviceInstancesStage = STAGE_INITIALIZING;
        this.serviceInstances = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceInstances(), "serviceInstances");
        serviceInstancesStage = STAGE_INITIALIZED;
      }
      return this.serviceInstances;
    }
    private ServiceKeys serviceKeys;
    private int serviceKeysStage;

    ServiceKeys serviceKeys() {
      if (serviceKeysStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceKeysStage == STAGE_UNINITIALIZED) {
        serviceKeysStage = STAGE_INITIALIZING;
        this.serviceKeys = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceKeys(), "serviceKeys");
        serviceKeysStage = STAGE_INITIALIZED;
      }
      return this.serviceKeys;
    }
    private ServicePlanVisibilities servicePlanVisibilities;
    private int servicePlanVisibilitiesStage;

    ServicePlanVisibilities servicePlanVisibilities() {
      if (servicePlanVisibilitiesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicePlanVisibilitiesStage == STAGE_UNINITIALIZED) {
        servicePlanVisibilitiesStage = STAGE_INITIALIZING;
        this.servicePlanVisibilities = Objects.requireNonNull(ReactorCloudFoundryClient.super.servicePlanVisibilities(), "servicePlanVisibilities");
        servicePlanVisibilitiesStage = STAGE_INITIALIZED;
      }
      return this.servicePlanVisibilities;
    }
    private ServicePlans servicePlans;
    private int servicePlansStage;

    ServicePlans servicePlans() {
      if (servicePlansStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicePlansStage == STAGE_UNINITIALIZED) {
        servicePlansStage = STAGE_INITIALIZING;
        this.servicePlans = Objects.requireNonNull(ReactorCloudFoundryClient.super.servicePlans(), "servicePlans");
        servicePlansStage = STAGE_INITIALIZED;
      }
      return this.servicePlans;
    }
    private ServiceUsageEvents serviceUsageEvents;
    private int serviceUsageEventsStage;

    ServiceUsageEvents serviceUsageEvents() {
      if (serviceUsageEventsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceUsageEventsStage == STAGE_UNINITIALIZED) {
        serviceUsageEventsStage = STAGE_INITIALIZING;
        this.serviceUsageEvents = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceUsageEvents(), "serviceUsageEvents");
        serviceUsageEventsStage = STAGE_INITIALIZED;
      }
      return this.serviceUsageEvents;
    }
    private Services services;
    private int servicesStage;

    Services services() {
      if (servicesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicesStage == STAGE_UNINITIALIZED) {
        servicesStage = STAGE_INITIALIZING;
        this.services = Objects.requireNonNull(ReactorCloudFoundryClient.super.services(), "services");
        servicesStage = STAGE_INITIALIZED;
      }
      return this.services;
    }
    private SharedDomains sharedDomains;
    private int sharedDomainsStage;

    SharedDomains sharedDomains() {
      if (sharedDomainsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sharedDomainsStage == STAGE_UNINITIALIZED) {
        sharedDomainsStage = STAGE_INITIALIZING;
        this.sharedDomains = Objects.requireNonNull(ReactorCloudFoundryClient.super.sharedDomains(), "sharedDomains");
        sharedDomainsStage = STAGE_INITIALIZED;
      }
      return this.sharedDomains;
    }
    private SpaceQuotaDefinitions spaceQuotaDefinitions;
    private int spaceQuotaDefinitionsStage;

    SpaceQuotaDefinitions spaceQuotaDefinitions() {
      if (spaceQuotaDefinitionsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spaceQuotaDefinitionsStage == STAGE_UNINITIALIZED) {
        spaceQuotaDefinitionsStage = STAGE_INITIALIZING;
        this.spaceQuotaDefinitions = Objects.requireNonNull(ReactorCloudFoundryClient.super.spaceQuotaDefinitions(), "spaceQuotaDefinitions");
        spaceQuotaDefinitionsStage = STAGE_INITIALIZED;
      }
      return this.spaceQuotaDefinitions;
    }
    private Spaces spaces;
    private int spacesStage;

    Spaces spaces() {
      if (spacesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spacesStage == STAGE_UNINITIALIZED) {
        spacesStage = STAGE_INITIALIZING;
        this.spaces = Objects.requireNonNull(ReactorCloudFoundryClient.super.spaces(), "spaces");
        spacesStage = STAGE_INITIALIZED;
      }
      return this.spaces;
    }
    private Stacks stacks;
    private int stacksStage;

    Stacks stacks() {
      if (stacksStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stacksStage == STAGE_UNINITIALIZED) {
        stacksStage = STAGE_INITIALIZING;
        this.stacks = Objects.requireNonNull(ReactorCloudFoundryClient.super.stacks(), "stacks");
        stacksStage = STAGE_INITIALIZED;
      }
      return this.stacks;
    }
    private Tasks tasks;
    private int tasksStage;

    Tasks tasks() {
      if (tasksStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tasksStage == STAGE_UNINITIALIZED) {
        tasksStage = STAGE_INITIALIZING;
        this.tasks = Objects.requireNonNull(ReactorCloudFoundryClient.super.tasks(), "tasks");
        tasksStage = STAGE_INITIALIZED;
      }
      return this.tasks;
    }
    private UserProvidedServiceInstances userProvidedServiceInstances;
    private int userProvidedServiceInstancesStage;

    UserProvidedServiceInstances userProvidedServiceInstances() {
      if (userProvidedServiceInstancesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userProvidedServiceInstancesStage == STAGE_UNINITIALIZED) {
        userProvidedServiceInstancesStage = STAGE_INITIALIZING;
        this.userProvidedServiceInstances = Objects.requireNonNull(ReactorCloudFoundryClient.super.userProvidedServiceInstances(), "userProvidedServiceInstances");
        userProvidedServiceInstancesStage = STAGE_INITIALIZED;
      }
      return this.userProvidedServiceInstances;
    }
    private Users users;
    private int usersStage;

    Users users() {
      if (usersStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usersStage == STAGE_UNINITIALIZED) {
        usersStage = STAGE_INITIALIZING;
        this.users = Objects.requireNonNull(ReactorCloudFoundryClient.super.users(), "users");
        usersStage = STAGE_INITIALIZED;
      }
      return this.users;
    }
    private HttpClient httpClient;
    private int httpClientStage;

    HttpClient getHttpClient() {
      if (httpClientStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (httpClientStage == STAGE_UNINITIALIZED) {
        httpClientStage = STAGE_INITIALIZING;
        this.httpClient = Objects.requireNonNull(ReactorCloudFoundryClient.super.getHttpClient(), "httpClient");
        httpClientStage = STAGE_INITIALIZED;
      }
      return this.httpClient;
    }

    void httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      httpClientStage = STAGE_INITIALIZED;
    }
    private ObjectMapper objectMapper;
    private int objectMapperStage;

    ObjectMapper getObjectMapper() {
      if (objectMapperStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMapperStage == STAGE_UNINITIALIZED) {
        objectMapperStage = STAGE_INITIALIZING;
        this.objectMapper = Objects.requireNonNull(ReactorCloudFoundryClient.super.getObjectMapper(), "objectMapper");
        objectMapperStage = STAGE_INITIALIZED;
      }
      return this.objectMapper;
    }

    void objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = objectMapper;
      objectMapperStage = STAGE_INITIALIZED;
    }
    private Mono<String> root;
    private int rootStage;

    Mono<String> getRoot() {
      if (rootStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootStage == STAGE_UNINITIALIZED) {
        rootStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(ReactorCloudFoundryClient.super.getRoot(), "root");
        rootStage = STAGE_INITIALIZED;
      }
      return this.root;
    }

    void root(Mono<String> root) {
      this.root = root;
      rootStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (applicationUsageEventsStage == STAGE_INITIALIZING) attributes.add("applicationUsageEvents");
      if (applicationsV2Stage == STAGE_INITIALIZING) attributes.add("applicationsV2");
      if (applicationsV3Stage == STAGE_INITIALIZING) attributes.add("applicationsV3");
      if (buildpacksStage == STAGE_INITIALIZING) attributes.add("buildpacks");
      if (domainsStage == STAGE_INITIALIZING) attributes.add("domains");
      if (dropletsStage == STAGE_INITIALIZING) attributes.add("droplets");
      if (environmentVariableGroupsStage == STAGE_INITIALIZING) attributes.add("environmentVariableGroups");
      if (eventsStage == STAGE_INITIALIZING) attributes.add("events");
      if (featureFlagsStage == STAGE_INITIALIZING) attributes.add("featureFlags");
      if (infoStage == STAGE_INITIALIZING) attributes.add("info");
      if (jobsStage == STAGE_INITIALIZING) attributes.add("jobs");
      if (organizationQuotaDefinitionsStage == STAGE_INITIALIZING) attributes.add("organizationQuotaDefinitions");
      if (organizationsStage == STAGE_INITIALIZING) attributes.add("organizations");
      if (packagesStage == STAGE_INITIALIZING) attributes.add("packages");
      if (privateDomainsStage == STAGE_INITIALIZING) attributes.add("privateDomains");
      if (processesStage == STAGE_INITIALIZING) attributes.add("processes");
      if (resourceMatchStage == STAGE_INITIALIZING) attributes.add("resourceMatch");
      if (routeMappingsStage == STAGE_INITIALIZING) attributes.add("routeMappings");
      if (routesStage == STAGE_INITIALIZING) attributes.add("routes");
      if (securityGroupsStage == STAGE_INITIALIZING) attributes.add("securityGroups");
      if (serviceBindingsV2Stage == STAGE_INITIALIZING) attributes.add("serviceBindingsV2");
      if (serviceBindingsV3Stage == STAGE_INITIALIZING) attributes.add("serviceBindingsV3");
      if (serviceBrokersStage == STAGE_INITIALIZING) attributes.add("serviceBrokers");
      if (serviceInstancesStage == STAGE_INITIALIZING) attributes.add("serviceInstances");
      if (serviceKeysStage == STAGE_INITIALIZING) attributes.add("serviceKeys");
      if (servicePlanVisibilitiesStage == STAGE_INITIALIZING) attributes.add("servicePlanVisibilities");
      if (servicePlansStage == STAGE_INITIALIZING) attributes.add("servicePlans");
      if (serviceUsageEventsStage == STAGE_INITIALIZING) attributes.add("serviceUsageEvents");
      if (servicesStage == STAGE_INITIALIZING) attributes.add("services");
      if (sharedDomainsStage == STAGE_INITIALIZING) attributes.add("sharedDomains");
      if (spaceQuotaDefinitionsStage == STAGE_INITIALIZING) attributes.add("spaceQuotaDefinitions");
      if (spacesStage == STAGE_INITIALIZING) attributes.add("spaces");
      if (stacksStage == STAGE_INITIALIZING) attributes.add("stacks");
      if (tasksStage == STAGE_INITIALIZING) attributes.add("tasks");
      if (userProvidedServiceInstancesStage == STAGE_INITIALIZING) attributes.add("userProvidedServiceInstances");
      if (usersStage == STAGE_INITIALIZING) attributes.add("users");
      if (httpClientStage == STAGE_INITIALIZING) attributes.add("httpClient");
      if (objectMapperStage == STAGE_INITIALIZING) attributes.add("objectMapper");
      if (rootStage == STAGE_INITIALIZING) attributes.add("root");
      return "Cannot build ReactorCloudFoundryClient, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code applicationUsageEvents} attribute
   */
  @Override
  public ApplicationUsageEvents applicationUsageEvents() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationUsageEvents()
        : this.applicationUsageEvents;
  }

  /**
   * @return The computed-at-construction value of the {@code applicationsV2} attribute
   */
  @Override
  public ApplicationsV2 applicationsV2() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationsV2()
        : this.applicationsV2;
  }

  /**
   * @return The computed-at-construction value of the {@code applicationsV3} attribute
   */
  @Override
  public ApplicationsV3 applicationsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationsV3()
        : this.applicationsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code buildpacks} attribute
   */
  @Override
  public Buildpacks buildpacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.buildpacks()
        : this.buildpacks;
  }

  /**
   * @return The computed-at-construction value of the {@code domains} attribute
   */
  @Override
  public Domains domains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.domains()
        : this.domains;
  }

  /**
   * @return The computed-at-construction value of the {@code droplets} attribute
   */
  @Override
  public Droplets droplets() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.droplets()
        : this.droplets;
  }

  /**
   * @return The computed-at-construction value of the {@code environmentVariableGroups} attribute
   */
  @Override
  public EnvironmentVariableGroups environmentVariableGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.environmentVariableGroups()
        : this.environmentVariableGroups;
  }

  /**
   * @return The computed-at-construction value of the {@code events} attribute
   */
  @Override
  public Events events() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.events()
        : this.events;
  }

  /**
   * @return The computed-at-construction value of the {@code featureFlags} attribute
   */
  @Override
  public FeatureFlags featureFlags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.featureFlags()
        : this.featureFlags;
  }

  /**
   * @return The computed-at-construction value of the {@code info} attribute
   */
  @Override
  public Info info() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.info()
        : this.info;
  }

  /**
   * @return The computed-at-construction value of the {@code jobs} attribute
   */
  @Override
  public Jobs jobs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.jobs()
        : this.jobs;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationQuotaDefinitions} attribute
   */
  @Override
  public OrganizationQuotaDefinitions organizationQuotaDefinitions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizationQuotaDefinitions()
        : this.organizationQuotaDefinitions;
  }

  /**
   * @return The computed-at-construction value of the {@code organizations} attribute
   */
  @Override
  public Organizations organizations() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizations()
        : this.organizations;
  }

  /**
   * @return The computed-at-construction value of the {@code packages} attribute
   */
  @Override
  public Packages packages() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.packages()
        : this.packages;
  }

  /**
   * @return The computed-at-construction value of the {@code privateDomains} attribute
   */
  @Override
  public PrivateDomains privateDomains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.privateDomains()
        : this.privateDomains;
  }

  /**
   * @return The computed-at-construction value of the {@code processes} attribute
   */
  @Override
  public Processes processes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processes()
        : this.processes;
  }

  /**
   * @return The computed-at-construction value of the {@code resourceMatch} attribute
   */
  @Override
  public ResourceMatch resourceMatch() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.resourceMatch()
        : this.resourceMatch;
  }

  /**
   * @return The computed-at-construction value of the {@code routeMappings} attribute
   */
  @Override
  public RouteMappings routeMappings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routeMappings()
        : this.routeMappings;
  }

  /**
   * @return The computed-at-construction value of the {@code routes} attribute
   */
  @Override
  public Routes routes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routes()
        : this.routes;
  }

  /**
   * @return The computed-at-construction value of the {@code securityGroups} attribute
   */
  @Override
  public SecurityGroups securityGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.securityGroups()
        : this.securityGroups;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBindingsV2} attribute
   */
  @Override
  public ServiceBindingsV2 serviceBindingsV2() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBindingsV2()
        : this.serviceBindingsV2;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBindingsV3} attribute
   */
  @Override
  public ServiceBindingsV3 serviceBindingsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBindingsV3()
        : this.serviceBindingsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBrokers} attribute
   */
  @Override
  public ServiceBrokers serviceBrokers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBrokers()
        : this.serviceBrokers;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceInstances} attribute
   */
  @Override
  public ServiceInstances serviceInstances() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceInstances()
        : this.serviceInstances;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceKeys} attribute
   */
  @Override
  public ServiceKeys serviceKeys() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceKeys()
        : this.serviceKeys;
  }

  /**
   * @return The computed-at-construction value of the {@code servicePlanVisibilities} attribute
   */
  @Override
  public ServicePlanVisibilities servicePlanVisibilities() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.servicePlanVisibilities()
        : this.servicePlanVisibilities;
  }

  /**
   * @return The computed-at-construction value of the {@code servicePlans} attribute
   */
  @Override
  public ServicePlans servicePlans() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.servicePlans()
        : this.servicePlans;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceUsageEvents} attribute
   */
  @Override
  public ServiceUsageEvents serviceUsageEvents() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceUsageEvents()
        : this.serviceUsageEvents;
  }

  /**
   * @return The computed-at-construction value of the {@code services} attribute
   */
  @Override
  public Services services() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.services()
        : this.services;
  }

  /**
   * @return The computed-at-construction value of the {@code sharedDomains} attribute
   */
  @Override
  public SharedDomains sharedDomains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.sharedDomains()
        : this.sharedDomains;
  }

  /**
   * @return The computed-at-construction value of the {@code spaceQuotaDefinitions} attribute
   */
  @Override
  public SpaceQuotaDefinitions spaceQuotaDefinitions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaceQuotaDefinitions()
        : this.spaceQuotaDefinitions;
  }

  /**
   * @return The computed-at-construction value of the {@code spaces} attribute
   */
  @Override
  public Spaces spaces() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaces()
        : this.spaces;
  }

  /**
   * @return The computed-at-construction value of the {@code stacks} attribute
   */
  @Override
  public Stacks stacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stacks()
        : this.stacks;
  }

  /**
   * @return The computed-at-construction value of the {@code tasks} attribute
   */
  @Override
  public Tasks tasks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tasks()
        : this.tasks;
  }

  /**
   * @return The computed-at-construction value of the {@code userProvidedServiceInstances} attribute
   */
  @Override
  public UserProvidedServiceInstances userProvidedServiceInstances() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userProvidedServiceInstances()
        : this.userProvidedServiceInstances;
  }

  /**
   * @return The computed-at-construction value of the {@code users} attribute
   */
  @Override
  public Users users() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.users()
        : this.users;
  }

  /**
   * @return The value of the {@code connectionContext} attribute
   */
  @Override
  public @Nullable ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * @return The value of the {@code httpClient} attribute
   */
  @Override
  public HttpClient getHttpClient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHttpClient()
        : this.httpClient;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMapper()
        : this.objectMapper;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * @return The value of the {@code tokenProvider} attribute
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorCloudFoundryClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorCloudFoundryClient
        && equalTo((ReactorCloudFoundryClient) another);
  }

  private boolean equalTo(ReactorCloudFoundryClient another) {
    return applicationUsageEvents.equals(another.applicationUsageEvents)
        && applicationsV2.equals(another.applicationsV2)
        && applicationsV3.equals(another.applicationsV3)
        && buildpacks.equals(another.buildpacks)
        && domains.equals(another.domains)
        && droplets.equals(another.droplets)
        && environmentVariableGroups.equals(another.environmentVariableGroups)
        && events.equals(another.events)
        && featureFlags.equals(another.featureFlags)
        && info.equals(another.info)
        && jobs.equals(another.jobs)
        && organizationQuotaDefinitions.equals(another.organizationQuotaDefinitions)
        && organizations.equals(another.organizations)
        && packages.equals(another.packages)
        && privateDomains.equals(another.privateDomains)
        && processes.equals(another.processes)
        && resourceMatch.equals(another.resourceMatch)
        && routeMappings.equals(another.routeMappings)
        && routes.equals(another.routes)
        && securityGroups.equals(another.securityGroups)
        && serviceBindingsV2.equals(another.serviceBindingsV2)
        && serviceBindingsV3.equals(another.serviceBindingsV3)
        && serviceBrokers.equals(another.serviceBrokers)
        && serviceInstances.equals(another.serviceInstances)
        && serviceKeys.equals(another.serviceKeys)
        && servicePlanVisibilities.equals(another.servicePlanVisibilities)
        && servicePlans.equals(another.servicePlans)
        && serviceUsageEvents.equals(another.serviceUsageEvents)
        && services.equals(another.services)
        && sharedDomains.equals(another.sharedDomains)
        && spaceQuotaDefinitions.equals(another.spaceQuotaDefinitions)
        && spaces.equals(another.spaces)
        && stacks.equals(another.stacks)
        && tasks.equals(another.tasks)
        && userProvidedServiceInstances.equals(another.userProvidedServiceInstances)
        && users.equals(another.users)
        && Objects.equals(connectionContext, another.connectionContext)
        && httpClient.equals(another.httpClient)
        && objectMapper.equals(another.objectMapper)
        && root.equals(another.root)
        && tokenProvider.equals(another.tokenProvider);
  }

  /**
   * Computes a hash code from attributes: {@code applicationUsageEvents}, {@code applicationsV2}, {@code applicationsV3}, {@code buildpacks}, {@code domains}, {@code droplets}, {@code environmentVariableGroups}, {@code events}, {@code featureFlags}, {@code info}, {@code jobs}, {@code organizationQuotaDefinitions}, {@code organizations}, {@code packages}, {@code privateDomains}, {@code processes}, {@code resourceMatch}, {@code routeMappings}, {@code routes}, {@code securityGroups}, {@code serviceBindingsV2}, {@code serviceBindingsV3}, {@code serviceBrokers}, {@code serviceInstances}, {@code serviceKeys}, {@code servicePlanVisibilities}, {@code servicePlans}, {@code serviceUsageEvents}, {@code services}, {@code sharedDomains}, {@code spaceQuotaDefinitions}, {@code spaces}, {@code stacks}, {@code tasks}, {@code userProvidedServiceInstances}, {@code users}, {@code connectionContext}, {@code httpClient}, {@code objectMapper}, {@code root}, {@code tokenProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationUsageEvents.hashCode();
    h = h * 17 + applicationsV2.hashCode();
    h = h * 17 + applicationsV3.hashCode();
    h = h * 17 + buildpacks.hashCode();
    h = h * 17 + domains.hashCode();
    h = h * 17 + droplets.hashCode();
    h = h * 17 + environmentVariableGroups.hashCode();
    h = h * 17 + events.hashCode();
    h = h * 17 + featureFlags.hashCode();
    h = h * 17 + info.hashCode();
    h = h * 17 + jobs.hashCode();
    h = h * 17 + organizationQuotaDefinitions.hashCode();
    h = h * 17 + organizations.hashCode();
    h = h * 17 + packages.hashCode();
    h = h * 17 + privateDomains.hashCode();
    h = h * 17 + processes.hashCode();
    h = h * 17 + resourceMatch.hashCode();
    h = h * 17 + routeMappings.hashCode();
    h = h * 17 + routes.hashCode();
    h = h * 17 + securityGroups.hashCode();
    h = h * 17 + serviceBindingsV2.hashCode();
    h = h * 17 + serviceBindingsV3.hashCode();
    h = h * 17 + serviceBrokers.hashCode();
    h = h * 17 + serviceInstances.hashCode();
    h = h * 17 + serviceKeys.hashCode();
    h = h * 17 + servicePlanVisibilities.hashCode();
    h = h * 17 + servicePlans.hashCode();
    h = h * 17 + serviceUsageEvents.hashCode();
    h = h * 17 + services.hashCode();
    h = h * 17 + sharedDomains.hashCode();
    h = h * 17 + spaceQuotaDefinitions.hashCode();
    h = h * 17 + spaces.hashCode();
    h = h * 17 + stacks.hashCode();
    h = h * 17 + tasks.hashCode();
    h = h * 17 + userProvidedServiceInstances.hashCode();
    h = h * 17 + users.hashCode();
    h = h * 17 + Objects.hashCode(connectionContext);
    h = h * 17 + httpClient.hashCode();
    h = h * 17 + objectMapper.hashCode();
    h = h * 17 + root.hashCode();
    h = h * 17 + tokenProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorCloudFoundryClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorCloudFoundryClient{"
        + "applicationUsageEvents=" + applicationUsageEvents
        + ", applicationsV2=" + applicationsV2
        + ", applicationsV3=" + applicationsV3
        + ", buildpacks=" + buildpacks
        + ", domains=" + domains
        + ", droplets=" + droplets
        + ", environmentVariableGroups=" + environmentVariableGroups
        + ", events=" + events
        + ", featureFlags=" + featureFlags
        + ", info=" + info
        + ", jobs=" + jobs
        + ", organizationQuotaDefinitions=" + organizationQuotaDefinitions
        + ", organizations=" + organizations
        + ", packages=" + packages
        + ", privateDomains=" + privateDomains
        + ", processes=" + processes
        + ", resourceMatch=" + resourceMatch
        + ", routeMappings=" + routeMappings
        + ", routes=" + routes
        + ", securityGroups=" + securityGroups
        + ", serviceBindingsV2=" + serviceBindingsV2
        + ", serviceBindingsV3=" + serviceBindingsV3
        + ", serviceBrokers=" + serviceBrokers
        + ", serviceInstances=" + serviceInstances
        + ", serviceKeys=" + serviceKeys
        + ", servicePlanVisibilities=" + servicePlanVisibilities
        + ", servicePlans=" + servicePlans
        + ", serviceUsageEvents=" + serviceUsageEvents
        + ", services=" + services
        + ", sharedDomains=" + sharedDomains
        + ", spaceQuotaDefinitions=" + spaceQuotaDefinitions
        + ", spaces=" + spaces
        + ", stacks=" + stacks
        + ", tasks=" + tasks
        + ", userProvidedServiceInstances=" + userProvidedServiceInstances
        + ", users=" + users
        + ", connectionContext=" + connectionContext
        + ", httpClient=" + httpClient
        + ", objectMapper=" + objectMapper
        + ", root=" + root
        + ", tokenProvider=" + tokenProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
   * @return A new ReactorCloudFoundryClient builder
   */
  public static ReactorCloudFoundryClient.Builder builder() {
    return new ReactorCloudFoundryClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x1L;
    private long initBits = 0x1L;

    private ConnectionContext connectionContext;
    private HttpClient httpClient;
    private ObjectMapper objectMapper;
    private Mono<String> root;
    private TokenProvider tokenProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorCloudFoundryClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorCloudFoundryClient instance) {
      return from((_ReactorCloudFoundryClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorCloudFoundryClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorCloudFoundryClient instance) {
      Objects.requireNonNull(instance, "instance");
      ConnectionContext connectionContextValue = instance.getConnectionContext();
      if (connectionContextValue != null) {
        connectionContext(connectionContextValue);
      }
      httpClient(instance.getHttpClient());
      objectMapper(instance.getObjectMapper());
      root(instance.getRoot());
      tokenProvider(instance.getTokenProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(@Nullable ConnectionContext connectionContext) {
      this.connectionContext = connectionContext;
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getHttpClient() httpClient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorCloudFoundryClient#getHttpClient() httpClient}.</em>
     * @param httpClient The value for httpClient 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpClient(HttpClient httpClient) {
      this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getObjectMapper() objectMapper} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorCloudFoundryClient#getObjectMapper() objectMapper}.</em>
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getRoot() root} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorCloudFoundryClient#getRoot() root}.</em>
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Mono<String> root) {
      this.root = Objects.requireNonNull(root, "root");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
     * @return An immutable instance of ReactorCloudFoundryClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorCloudFoundryClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorCloudFoundryClient(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorCloudFoundryClient, some of required attributes are not set " + attributes;
    }
  }
}
