package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _ClientCredentialsGrantTokenProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ClientCredentialsGrantTokenProvider.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ClientCredentialsGrantTokenProvider"})
public final class ClientCredentialsGrantTokenProvider
    extends org.cloudfoundry.reactor.tokenprovider._ClientCredentialsGrantTokenProvider {
  private final String clientId;
  private final String clientSecret;

  private ClientCredentialsGrantTokenProvider(ClientCredentialsGrantTokenProvider.Builder builder) {
    if (builder.clientId != null) {
      initShim.clientId(builder.clientId);
    }
    if (builder.clientSecret != null) {
      initShim.clientSecret(builder.clientSecret);
    }
    this.clientId = initShim.getClientId();
    this.clientSecret = initShim.getClientSecret();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String clientId;
    private int clientIdStage;

    String getClientId() {
      if (clientIdStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientIdStage == STAGE_UNINITIALIZED) {
        clientIdStage = STAGE_INITIALIZING;
        this.clientId = Objects.requireNonNull(ClientCredentialsGrantTokenProvider.super.getClientId(), "clientId");
        clientIdStage = STAGE_INITIALIZED;
      }
      return this.clientId;
    }

    void clientId(String clientId) {
      this.clientId = clientId;
      clientIdStage = STAGE_INITIALIZED;
    }
    private String clientSecret;
    private int clientSecretStage;

    String getClientSecret() {
      if (clientSecretStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientSecretStage == STAGE_UNINITIALIZED) {
        clientSecretStage = STAGE_INITIALIZING;
        this.clientSecret = Objects.requireNonNull(ClientCredentialsGrantTokenProvider.super.getClientSecret(), "clientSecret");
        clientSecretStage = STAGE_INITIALIZED;
      }
      return this.clientSecret;
    }

    void clientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      clientSecretStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (clientIdStage == STAGE_INITIALIZING) attributes.add("clientId");
      if (clientSecretStage == STAGE_INITIALIZING) attributes.add("clientSecret");
      return "Cannot build ClientCredentialsGrantTokenProvider, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * The client id.  Defaults to {@code cf}.
   */
  @Override
  public String getClientId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientId()
        : this.clientId;
  }

  /**
   * The client secret Defaults to {@code ""}.
   */
  @Override
  public String getClientSecret() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientSecret()
        : this.clientSecret;
  }

  /**
   * This instance is equal to all instances of {@code ClientCredentialsGrantTokenProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ClientCredentialsGrantTokenProvider
        && equalTo((ClientCredentialsGrantTokenProvider) another);
  }

  private boolean equalTo(ClientCredentialsGrantTokenProvider another) {
    return clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code clientSecret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + clientId.hashCode();
    h = h * 17 + clientSecret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ClientCredentialsGrantTokenProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ClientCredentialsGrantTokenProvider{"
        + "clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + "}";
  }

  /**
   * Creates a builder for {@link ClientCredentialsGrantTokenProvider ClientCredentialsGrantTokenProvider}.
   * @return A new ClientCredentialsGrantTokenProvider builder
   */
  public static ClientCredentialsGrantTokenProvider.Builder builder() {
    return new ClientCredentialsGrantTokenProvider.Builder();
  }

  /**
   * Builds instances of type {@link ClientCredentialsGrantTokenProvider ClientCredentialsGrantTokenProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String clientId;
    private String clientSecret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUaaTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClientCredentialsGrantTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ClientCredentialsGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ClientCredentialsGrantTokenProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ClientCredentialsGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractUaaTokenProvider) {
        AbstractUaaTokenProvider instance = (AbstractUaaTokenProvider) object;
        clientSecret(instance.getClientSecret());
        clientId(instance.getClientId());
      }
    }

    /**
     * Initializes the value for the {@link _ClientCredentialsGrantTokenProvider#getClientId() clientId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ClientCredentialsGrantTokenProvider#getClientId() clientId}.</em>
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      return this;
    }

    /**
     * Initializes the value for the {@link _ClientCredentialsGrantTokenProvider#getClientSecret() clientSecret} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ClientCredentialsGrantTokenProvider#getClientSecret() clientSecret}.</em>
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      return this;
    }

    /**
     * Builds a new {@link ClientCredentialsGrantTokenProvider ClientCredentialsGrantTokenProvider}.
     * @return An immutable instance of ClientCredentialsGrantTokenProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ClientCredentialsGrantTokenProvider build() {
      return new ClientCredentialsGrantTokenProvider(this);
    }
  }
}
