package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _PasswordGrantTokenProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PasswordGrantTokenProvider.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_PasswordGrantTokenProvider"})
public final class PasswordGrantTokenProvider
    extends org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider {
  private final String password;
  private final String username;
  private final String clientId;
  private final String clientSecret;

  private PasswordGrantTokenProvider(PasswordGrantTokenProvider.Builder builder) {
    this.password = builder.password;
    this.username = builder.username;
    if (builder.clientId != null) {
      initShim.clientId(builder.clientId);
    }
    if (builder.clientSecret != null) {
      initShim.clientSecret(builder.clientSecret);
    }
    this.clientId = initShim.getClientId();
    this.clientSecret = initShim.getClientSecret();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String clientId;
    private int clientIdStage;

    String getClientId() {
      if (clientIdStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientIdStage == STAGE_UNINITIALIZED) {
        clientIdStage = STAGE_INITIALIZING;
        this.clientId = Objects.requireNonNull(PasswordGrantTokenProvider.super.getClientId(), "clientId");
        clientIdStage = STAGE_INITIALIZED;
      }
      return this.clientId;
    }

    void clientId(String clientId) {
      this.clientId = clientId;
      clientIdStage = STAGE_INITIALIZED;
    }
    private String clientSecret;
    private int clientSecretStage;

    String getClientSecret() {
      if (clientSecretStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientSecretStage == STAGE_UNINITIALIZED) {
        clientSecretStage = STAGE_INITIALIZING;
        this.clientSecret = Objects.requireNonNull(PasswordGrantTokenProvider.super.getClientSecret(), "clientSecret");
        clientSecretStage = STAGE_INITIALIZED;
      }
      return this.clientSecret;
    }

    void clientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      clientSecretStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (clientIdStage == STAGE_INITIALIZING) attributes.add("clientId");
      if (clientSecretStage == STAGE_INITIALIZING) attributes.add("clientSecret");
      return "Cannot build PasswordGrantTokenProvider, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * The password
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * The client id.  Defaults to {@code cf}.
   */
  @Override
  public String getClientId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientId()
        : this.clientId;
  }

  /**
   * The client secret Defaults to {@code ""}.
   */
  @Override
  public String getClientSecret() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientSecret()
        : this.clientSecret;
  }

  /**
   * This instance is equal to all instances of {@code PasswordGrantTokenProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PasswordGrantTokenProvider
        && equalTo((PasswordGrantTokenProvider) another);
  }

  private boolean equalTo(PasswordGrantTokenProvider another) {
    return password.equals(another.password)
        && username.equals(another.username)
        && clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret);
  }

  /**
   * Computes a hash code from attributes: {@code password}, {@code username}, {@code clientId}, {@code clientSecret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + password.hashCode();
    h = h * 17 + username.hashCode();
    h = h * 17 + clientId.hashCode();
    h = h * 17 + clientSecret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PasswordGrantTokenProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PasswordGrantTokenProvider{"
        + "password=" + password
        + ", username=" + username
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + "}";
  }

  /**
   * Creates a builder for {@link PasswordGrantTokenProvider PasswordGrantTokenProvider}.
   * @return A new PasswordGrantTokenProvider builder
   */
  public static PasswordGrantTokenProvider.Builder builder() {
    return new PasswordGrantTokenProvider.Builder();
  }

  /**
   * Builds instances of type {@link PasswordGrantTokenProvider PasswordGrantTokenProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PASSWORD = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String password;
    private String username;
    private String clientId;
    private String clientSecret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PasswordGrantTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PasswordGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _PasswordGrantTokenProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PasswordGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUaaTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider) {
        org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider instance = (org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider) object;
        password(instance.getPassword());
        username(instance.getUsername());
      }
      if (object instanceof AbstractUaaTokenProvider) {
        AbstractUaaTokenProvider instance = (AbstractUaaTokenProvider) object;
        clientSecret(instance.getClientSecret());
        clientId(instance.getClientId());
      }
    }

    /**
     * Initializes the value for the {@link _PasswordGrantTokenProvider#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordGrantTokenProvider#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordGrantTokenProvider#getClientId() clientId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _PasswordGrantTokenProvider#getClientId() clientId}.</em>
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordGrantTokenProvider#getClientSecret() clientSecret} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _PasswordGrantTokenProvider#getClientSecret() clientSecret}.</em>
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      return this;
    }

    /**
     * Builds a new {@link PasswordGrantTokenProvider PasswordGrantTokenProvider}.
     * @return An immutable instance of PasswordGrantTokenProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PasswordGrantTokenProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PasswordGrantTokenProvider(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build PasswordGrantTokenProvider, some of required attributes are not set " + attributes;
    }
  }
}
