package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import org.cloudfoundry.reactor.util.SslCertificateTruster;
import org.cloudfoundry.util.test.FailingDeserializationProblemHandler;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.HttpClient;

/**
 * Immutable implementation of {@link _DefaultConnectionContext}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DefaultConnectionContext.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DefaultConnectionContext"})
public final class DefaultConnectionContext extends org.cloudfoundry.reactor._DefaultConnectionContext {
  private final HttpClient httpClient;
  private final ObjectMapper objectMapper;
  private final Integer port;
  private final Mono<String> root;
  private final String apiHost;
  private final Mono<Map<String, String>> info;
  private final Boolean keepAlive;
  private final List<FailingDeserializationProblemHandler> problemHandlers;
  private final ProxyConfiguration proxyConfiguration;
  private final Boolean skipSslValidation;
  private final Duration socketTimeout;
  private final Optional<SslCertificateTruster> sslCertificateTruster;
  private final Duration sslHandshakeTimeout;

  private DefaultConnectionContext(DefaultConnectionContext.Builder builder) {
    this.apiHost = builder.apiHost;
    this.keepAlive = builder.keepAlive;
    this.problemHandlers = createUnmodifiableList(true, builder.problemHandlers);
    this.proxyConfiguration = builder.proxyConfiguration;
    this.skipSslValidation = builder.skipSslValidation;
    this.socketTimeout = builder.socketTimeout;
    this.sslHandshakeTimeout = builder.sslHandshakeTimeout;
    if (builder.httpClient != null) {
      initShim.httpClient(builder.httpClient);
    }
    if (builder.objectMapper != null) {
      initShim.objectMapper(builder.objectMapper);
    }
    if (builder.port != null) {
      initShim.port(builder.port);
    }
    this.httpClient = initShim.getHttpClient();
    this.objectMapper = initShim.getObjectMapper();
    this.port = initShim.getPort();
    this.root = initShim.getRoot();
    this.info = initShim.getInfo();
    this.sslCertificateTruster = initShim.getSslCertificateTruster();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private HttpClient httpClient;
    private int httpClientStage;

    HttpClient getHttpClient() {
      if (httpClientStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (httpClientStage == STAGE_UNINITIALIZED) {
        httpClientStage = STAGE_INITIALIZING;
        this.httpClient = Objects.requireNonNull(DefaultConnectionContext.super.getHttpClient(), "httpClient");
        httpClientStage = STAGE_INITIALIZED;
      }
      return this.httpClient;
    }

    void httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      httpClientStage = STAGE_INITIALIZED;
    }
    private ObjectMapper objectMapper;
    private int objectMapperStage;

    ObjectMapper getObjectMapper() {
      if (objectMapperStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMapperStage == STAGE_UNINITIALIZED) {
        objectMapperStage = STAGE_INITIALIZING;
        this.objectMapper = Objects.requireNonNull(DefaultConnectionContext.super.getObjectMapper(), "objectMapper");
        objectMapperStage = STAGE_INITIALIZED;
      }
      return this.objectMapper;
    }

    void objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = objectMapper;
      objectMapperStage = STAGE_INITIALIZED;
    }
    private Integer port;
    private int portStage;

    Integer getPort() {
      if (portStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (portStage == STAGE_UNINITIALIZED) {
        portStage = STAGE_INITIALIZING;
        this.port = Objects.requireNonNull(DefaultConnectionContext.super.getPort(), "port");
        portStage = STAGE_INITIALIZED;
      }
      return this.port;
    }

    void port(Integer port) {
      this.port = port;
      portStage = STAGE_INITIALIZED;
    }
    private Mono<String> root;
    private int rootStage;

    Mono<String> getRoot() {
      if (rootStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootStage == STAGE_UNINITIALIZED) {
        rootStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(DefaultConnectionContext.super.getRoot(), "root");
        rootStage = STAGE_INITIALIZED;
      }
      return this.root;
    }
    private Mono<Map<String, String>> info;
    private int infoStage;

    Mono<Map<String, String>> getInfo() {
      if (infoStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (infoStage == STAGE_UNINITIALIZED) {
        infoStage = STAGE_INITIALIZING;
        this.info = Objects.requireNonNull(DefaultConnectionContext.super.getInfo(), "info");
        infoStage = STAGE_INITIALIZED;
      }
      return this.info;
    }
    private Optional<SslCertificateTruster> sslCertificateTruster;
    private int sslCertificateTrusterStage;

    Optional<SslCertificateTruster> getSslCertificateTruster() {
      if (sslCertificateTrusterStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sslCertificateTrusterStage == STAGE_UNINITIALIZED) {
        sslCertificateTrusterStage = STAGE_INITIALIZING;
        this.sslCertificateTruster = Objects.requireNonNull(DefaultConnectionContext.super.getSslCertificateTruster(), "sslCertificateTruster");
        sslCertificateTrusterStage = STAGE_INITIALIZED;
      }
      return this.sslCertificateTruster;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (httpClientStage == STAGE_INITIALIZING) attributes.add("httpClient");
      if (objectMapperStage == STAGE_INITIALIZING) attributes.add("objectMapper");
      if (portStage == STAGE_INITIALIZING) attributes.add("port");
      if (rootStage == STAGE_INITIALIZING) attributes.add("root");
      if (infoStage == STAGE_INITIALIZING) attributes.add("info");
      if (sslCertificateTrusterStage == STAGE_INITIALIZING) attributes.add("sslCertificateTruster");
      return "Cannot build DefaultConnectionContext, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code httpClient} attribute
   */
  @Override
  public HttpClient getHttpClient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHttpClient()
        : this.httpClient;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMapper()
        : this.objectMapper;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @Override
  public Integer getPort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPort()
        : this.port;
  }

  /**
   * @return The computed-at-construction value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * The hostname of the API root.  Typically something like {@code api.run.pivotal.io}.
   */
  @Override
  public String getApiHost() {
    return apiHost;
  }

  /**
   * @return The computed-at-construction value of the {@code info} attribute
   */
  @Override
  public Mono<Map<String, String>> getInfo() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInfo()
        : this.info;
  }

  /**
   * The {@code SO_KEEPALIVE} value
   */
  @Override
  public Optional<Boolean> getKeepAlive() {
    return Optional.ofNullable(keepAlive);
  }

  /**
   * Jackson deserialization problem handlers.  Typically only used for testing.
   */
  @Override
  public List<FailingDeserializationProblemHandler> getProblemHandlers() {
    return problemHandlers;
  }

  /**
   * The (optional) proxy configuration
   */
  @Override
  public Optional<ProxyConfiguration> getProxyConfiguration() {
    return Optional.ofNullable(proxyConfiguration);
  }

  /**
   * Whether to skip SSL certificate validation for all hosts reachable from the API host.  Defaults to {@code false}.
   */
  @Override
  public Optional<Boolean> getSkipSslValidation() {
    return Optional.ofNullable(skipSslValidation);
  }

  /**
   * The {@code SO_TIMEOUT} value
   */
  @Override
  public Optional<Duration> getSocketTimeout() {
    return Optional.ofNullable(socketTimeout);
  }

  /**
   * @return The computed-at-construction value of the {@code sslCertificateTruster} attribute
   */
  @Override
  public Optional<SslCertificateTruster> getSslCertificateTruster() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSslCertificateTruster()
        : this.sslCertificateTruster;
  }

  /**
   * The timeout for the SSL handshake negotiation
   */
  @Override
  public Optional<Duration> getSslHandshakeTimeout() {
    return Optional.ofNullable(sslHandshakeTimeout);
  }

  /**
   * This instance is equal to all instances of {@code DefaultConnectionContext} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DefaultConnectionContext
        && equalTo((DefaultConnectionContext) another);
  }

  private boolean equalTo(DefaultConnectionContext another) {
    return httpClient.equals(another.httpClient)
        && objectMapper.equals(another.objectMapper)
        && port.equals(another.port)
        && root.equals(another.root)
        && apiHost.equals(another.apiHost)
        && info.equals(another.info)
        && Objects.equals(keepAlive, another.keepAlive)
        && problemHandlers.equals(another.problemHandlers)
        && Objects.equals(proxyConfiguration, another.proxyConfiguration)
        && Objects.equals(skipSslValidation, another.skipSslValidation)
        && Objects.equals(socketTimeout, another.socketTimeout)
        && sslCertificateTruster.equals(another.sslCertificateTruster)
        && Objects.equals(sslHandshakeTimeout, another.sslHandshakeTimeout);
  }

  /**
   * Computes a hash code from attributes: {@code httpClient}, {@code objectMapper}, {@code port}, {@code root}, {@code apiHost}, {@code info}, {@code keepAlive}, {@code problemHandlers}, {@code proxyConfiguration}, {@code skipSslValidation}, {@code socketTimeout}, {@code sslCertificateTruster}, {@code sslHandshakeTimeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + httpClient.hashCode();
    h = h * 17 + objectMapper.hashCode();
    h = h * 17 + port.hashCode();
    h = h * 17 + root.hashCode();
    h = h * 17 + apiHost.hashCode();
    h = h * 17 + info.hashCode();
    h = h * 17 + Objects.hashCode(keepAlive);
    h = h * 17 + problemHandlers.hashCode();
    h = h * 17 + Objects.hashCode(proxyConfiguration);
    h = h * 17 + Objects.hashCode(skipSslValidation);
    h = h * 17 + Objects.hashCode(socketTimeout);
    h = h * 17 + sslCertificateTruster.hashCode();
    h = h * 17 + Objects.hashCode(sslHandshakeTimeout);
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultConnectionContext} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DefaultConnectionContext{");
    builder.append("httpClient=").append(httpClient);
    builder.append(", ");
    builder.append("objectMapper=").append(objectMapper);
    builder.append(", ");
    builder.append("port=").append(port);
    builder.append(", ");
    builder.append("root=").append(root);
    builder.append(", ");
    builder.append("apiHost=").append(apiHost);
    builder.append(", ");
    builder.append("info=").append(info);
    if (keepAlive != null) {
      builder.append(", ");
      builder.append("keepAlive=").append(keepAlive);
    }
    builder.append(", ");
    builder.append("problemHandlers=").append(problemHandlers);
    if (proxyConfiguration != null) {
      builder.append(", ");
      builder.append("proxyConfiguration=").append(proxyConfiguration);
    }
    if (skipSslValidation != null) {
      builder.append(", ");
      builder.append("skipSslValidation=").append(skipSslValidation);
    }
    if (socketTimeout != null) {
      builder.append(", ");
      builder.append("socketTimeout=").append(socketTimeout);
    }
    builder.append(", ");
    builder.append("sslCertificateTruster=").append(sslCertificateTruster);
    if (sslHandshakeTimeout != null) {
      builder.append(", ");
      builder.append("sslHandshakeTimeout=").append(sslHandshakeTimeout);
    }
    return builder.append("}").toString();
  }

  private static DefaultConnectionContext validate(DefaultConnectionContext instance) {
    instance.checkForValidApiHost();
    return instance;
  }

  /**
   * Creates a builder for {@link DefaultConnectionContext DefaultConnectionContext}.
   * @return A new DefaultConnectionContext builder
   */
  public static DefaultConnectionContext.Builder builder() {
    return new DefaultConnectionContext.Builder();
  }

  /**
   * Builds instances of type {@link DefaultConnectionContext DefaultConnectionContext}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_API_HOST = 0x1L;
    private long initBits = 0x1L;

    private HttpClient httpClient;
    private ObjectMapper objectMapper;
    private Integer port;
    private String apiHost;
    private Boolean keepAlive;
    private List<FailingDeserializationProblemHandler> problemHandlers = new ArrayList<FailingDeserializationProblemHandler>();
    private ProxyConfiguration proxyConfiguration;
    private Boolean skipSslValidation;
    private Duration socketTimeout;
    private Duration sslHandshakeTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultConnectionContext} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultConnectionContext instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DefaultConnectionContext} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DefaultConnectionContext instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.ConnectionContext} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConnectionContext instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.reactor._DefaultConnectionContext) {
        org.cloudfoundry.reactor._DefaultConnectionContext instance = (org.cloudfoundry.reactor._DefaultConnectionContext) object;
        if ((bits & 0x1L) == 0) {
          httpClient(instance.getHttpClient());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          objectMapper(instance.getObjectMapper());
          bits |= 0x2L;
        }
        Optional<Boolean> keepAliveOptional = instance.getKeepAlive();
        if (keepAliveOptional.isPresent()) {
          keepAlive(keepAliveOptional);
        }
        port(instance.getPort());
        Optional<Duration> sslHandshakeTimeoutOptional = instance.getSslHandshakeTimeout();
        if (sslHandshakeTimeoutOptional.isPresent()) {
          sslHandshakeTimeout(sslHandshakeTimeoutOptional);
        }
        apiHost(instance.getApiHost());
        Optional<Duration> socketTimeoutOptional = instance.getSocketTimeout();
        if (socketTimeoutOptional.isPresent()) {
          socketTimeout(socketTimeoutOptional);
        }
        Optional<Boolean> skipSslValidationOptional = instance.getSkipSslValidation();
        if (skipSslValidationOptional.isPresent()) {
          skipSslValidation(skipSslValidationOptional);
        }
        addAllProblemHandlers(instance.getProblemHandlers());
        Optional<ProxyConfiguration> proxyConfigurationOptional = instance.getProxyConfiguration();
        if (proxyConfigurationOptional.isPresent()) {
          proxyConfiguration(proxyConfigurationOptional);
        }
      }
      if (object instanceof ConnectionContext) {
        ConnectionContext instance = (ConnectionContext) object;
        if ((bits & 0x1L) == 0) {
          httpClient(instance.getHttpClient());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          objectMapper(instance.getObjectMapper());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link _DefaultConnectionContext#getHttpClient() httpClient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _DefaultConnectionContext#getHttpClient() httpClient}.</em>
     * @param httpClient The value for httpClient 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpClient(HttpClient httpClient) {
      this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultConnectionContext#getObjectMapper() objectMapper} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _DefaultConnectionContext#getObjectMapper() objectMapper}.</em>
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultConnectionContext#getPort() port} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _DefaultConnectionContext#getPort() port}.</em>
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Integer port) {
      this.port = Objects.requireNonNull(port, "port");
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultConnectionContext#getApiHost() apiHost} attribute.
     * @param apiHost The value for apiHost 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apiHost(String apiHost) {
      this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
      initBits &= ~INIT_BIT_API_HOST;
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getKeepAlive() keepAlive} to keepAlive.
     * @param keepAlive The value for keepAlive
     * @return {@code this} builder for chained invocation
     */
    public final Builder keepAlive(boolean keepAlive) {
      this.keepAlive = keepAlive;
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getKeepAlive() keepAlive} to keepAlive.
     * @param keepAlive The value for keepAlive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keepAlive(Optional<Boolean> keepAlive) {
      this.keepAlive = keepAlive.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link _DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param element A problemHandlers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder problemHandler(FailingDeserializationProblemHandler element) {
      this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
      return this;
    }

    /**
     * Adds elements to {@link _DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param elements An array of problemHandlers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder problemHandler(FailingDeserializationProblemHandler... elements) {
      for (FailingDeserializationProblemHandler element : elements) {
        this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param elements An iterable of problemHandlers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder problemHandlers(Iterable<? extends FailingDeserializationProblemHandler> elements) {
      this.problemHandlers.clear();
      return addAllProblemHandlers(elements);
    }

    /**
     * Adds elements to {@link _DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param elements An iterable of problemHandlers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProblemHandlers(Iterable<? extends FailingDeserializationProblemHandler> elements) {
      for (FailingDeserializationProblemHandler element : elements) {
        this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getProxyConfiguration() proxyConfiguration} to proxyConfiguration.
     * @param proxyConfiguration The value for proxyConfiguration
     * @return {@code this} builder for chained invocation
     */
    public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
      this.proxyConfiguration = Objects.requireNonNull(proxyConfiguration, "proxyConfiguration");
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getProxyConfiguration() proxyConfiguration} to proxyConfiguration.
     * @param proxyConfiguration The value for proxyConfiguration
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder proxyConfiguration(Optional<ProxyConfiguration> proxyConfiguration) {
      this.proxyConfiguration = proxyConfiguration.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getSkipSslValidation() skipSslValidation} to skipSslValidation.
     * @param skipSslValidation The value for skipSslValidation
     * @return {@code this} builder for chained invocation
     */
    public final Builder skipSslValidation(boolean skipSslValidation) {
      this.skipSslValidation = skipSslValidation;
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getSkipSslValidation() skipSslValidation} to skipSslValidation.
     * @param skipSslValidation The value for skipSslValidation
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder skipSslValidation(Optional<Boolean> skipSslValidation) {
      this.skipSslValidation = skipSslValidation.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getSocketTimeout() socketTimeout} to socketTimeout.
     * @param socketTimeout The value for socketTimeout
     * @return {@code this} builder for chained invocation
     */
    public final Builder socketTimeout(Duration socketTimeout) {
      this.socketTimeout = Objects.requireNonNull(socketTimeout, "socketTimeout");
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getSocketTimeout() socketTimeout} to socketTimeout.
     * @param socketTimeout The value for socketTimeout
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder socketTimeout(Optional<Duration> socketTimeout) {
      this.socketTimeout = socketTimeout.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getSslHandshakeTimeout() sslHandshakeTimeout} to sslHandshakeTimeout.
     * @param sslHandshakeTimeout The value for sslHandshakeTimeout
     * @return {@code this} builder for chained invocation
     */
    public final Builder sslHandshakeTimeout(Duration sslHandshakeTimeout) {
      this.sslHandshakeTimeout = Objects.requireNonNull(sslHandshakeTimeout, "sslHandshakeTimeout");
      return this;
    }

    /**
     * Initializes the optional value {@link _DefaultConnectionContext#getSslHandshakeTimeout() sslHandshakeTimeout} to sslHandshakeTimeout.
     * @param sslHandshakeTimeout The value for sslHandshakeTimeout
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sslHandshakeTimeout(Optional<Duration> sslHandshakeTimeout) {
      this.sslHandshakeTimeout = sslHandshakeTimeout.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link DefaultConnectionContext DefaultConnectionContext}.
     * @return An immutable instance of DefaultConnectionContext
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DefaultConnectionContext build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return DefaultConnectionContext.validate(new DefaultConnectionContext(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_API_HOST) != 0) attributes.add("apiHost");
      return "Cannot build DefaultConnectionContext, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
