package org.cloudfoundry.reactor.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications.ApplicationsV2;
import org.cloudfoundry.client.v2.applicationusageevents.ApplicationUsageEvents;
import org.cloudfoundry.client.v2.buildpacks.Buildpacks;
import org.cloudfoundry.client.v2.domains.Domains;
import org.cloudfoundry.client.v2.environmentvariablegroups.EnvironmentVariableGroups;
import org.cloudfoundry.client.v2.events.Events;
import org.cloudfoundry.client.v2.featureflags.FeatureFlags;
import org.cloudfoundry.client.v2.info.Info;
import org.cloudfoundry.client.v2.jobs.Jobs;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitions;
import org.cloudfoundry.client.v2.organizations.Organizations;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomains;
import org.cloudfoundry.client.v2.resourcematch.ResourceMatch;
import org.cloudfoundry.client.v2.routemappings.RouteMappings;
import org.cloudfoundry.client.v2.routes.Routes;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroups;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingsV2;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokers;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstances;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeys;
import org.cloudfoundry.client.v2.serviceplans.ServicePlans;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilities;
import org.cloudfoundry.client.v2.services.Services;
import org.cloudfoundry.client.v2.serviceusageevents.ServiceUsageEvents;
import org.cloudfoundry.client.v2.shareddomains.SharedDomains;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitions;
import org.cloudfoundry.client.v2.spaces.Spaces;
import org.cloudfoundry.client.v2.stacks.Stacks;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.UserProvidedServiceInstances;
import org.cloudfoundry.client.v2.users.Users;
import org.cloudfoundry.client.v3.applications.ApplicationsV3;
import org.cloudfoundry.client.v3.droplets.Droplets;
import org.cloudfoundry.client.v3.packages.Packages;
import org.cloudfoundry.client.v3.processes.Processes;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingsV3;
import org.cloudfoundry.client.v3.tasks.Tasks;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;

/**
 * The Reactor-based implementation of {@link CloudFoundryClient}
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ReactorCloudFoundryClient"})
public final class ReactorCloudFoundryClient
    extends org.cloudfoundry.reactor.client._ReactorCloudFoundryClient {
  private final ApplicationUsageEvents applicationUsageEvents;
  private final ApplicationsV2 applicationsV2;
  private final ApplicationsV3 applicationsV3;
  private final Buildpacks buildpacks;
  private final Domains domains;
  private final Droplets droplets;
  private final EnvironmentVariableGroups environmentVariableGroups;
  private final Events events;
  private final FeatureFlags featureFlags;
  private final Info info;
  private final Jobs jobs;
  private final OrganizationQuotaDefinitions organizationQuotaDefinitions;
  private final Organizations organizations;
  private final Packages packages;
  private final PrivateDomains privateDomains;
  private final Processes processes;
  private final ResourceMatch resourceMatch;
  private final RouteMappings routeMappings;
  private final Routes routes;
  private final SecurityGroups securityGroups;
  private final ServiceBindingsV2 serviceBindingsV2;
  private final ServiceBindingsV3 serviceBindingsV3;
  private final ServiceBrokers serviceBrokers;
  private final ServiceInstances serviceInstances;
  private final ServiceKeys serviceKeys;
  private final ServicePlanVisibilities servicePlanVisibilities;
  private final ServicePlans servicePlans;
  private final ServiceUsageEvents serviceUsageEvents;
  private final Services services;
  private final SharedDomains sharedDomains;
  private final SpaceQuotaDefinitions spaceQuotaDefinitions;
  private final Spaces spaces;
  private final Stacks stacks;
  private final Tasks tasks;
  private final UserProvidedServiceInstances userProvidedServiceInstances;
  private final Users users;
  private final @Nullable ConnectionContext connectionContext;
  private final HttpClient httpClient;
  private final ObjectMapper objectMapper;
  private final Mono<String> root;
  private final TokenProvider tokenProvider;

  private ReactorCloudFoundryClient(ReactorCloudFoundryClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.tokenProvider = builder.tokenProvider;
    if (builder.httpClient != null) {
      initShim.httpClient(builder.httpClient);
    }
    if (builder.objectMapper != null) {
      initShim.objectMapper(builder.objectMapper);
    }
    if (builder.root != null) {
      initShim.root(builder.root);
    }
    this.httpClient = initShim.getHttpClient();
    this.objectMapper = initShim.getObjectMapper();
    this.root = initShim.getRoot();
    this.applicationUsageEvents = initShim.applicationUsageEvents();
    this.applicationsV2 = initShim.applicationsV2();
    this.applicationsV3 = initShim.applicationsV3();
    this.buildpacks = initShim.buildpacks();
    this.domains = initShim.domains();
    this.droplets = initShim.droplets();
    this.environmentVariableGroups = initShim.environmentVariableGroups();
    this.events = initShim.events();
    this.featureFlags = initShim.featureFlags();
    this.info = initShim.info();
    this.jobs = initShim.jobs();
    this.organizationQuotaDefinitions = initShim.organizationQuotaDefinitions();
    this.organizations = initShim.organizations();
    this.packages = initShim.packages();
    this.privateDomains = initShim.privateDomains();
    this.processes = initShim.processes();
    this.resourceMatch = initShim.resourceMatch();
    this.routeMappings = initShim.routeMappings();
    this.routes = initShim.routes();
    this.securityGroups = initShim.securityGroups();
    this.serviceBindingsV2 = initShim.serviceBindingsV2();
    this.serviceBindingsV3 = initShim.serviceBindingsV3();
    this.serviceBrokers = initShim.serviceBrokers();
    this.serviceInstances = initShim.serviceInstances();
    this.serviceKeys = initShim.serviceKeys();
    this.servicePlanVisibilities = initShim.servicePlanVisibilities();
    this.servicePlans = initShim.servicePlans();
    this.serviceUsageEvents = initShim.serviceUsageEvents();
    this.services = initShim.services();
    this.sharedDomains = initShim.sharedDomains();
    this.spaceQuotaDefinitions = initShim.spaceQuotaDefinitions();
    this.spaces = initShim.spaces();
    this.stacks = initShim.stacks();
    this.tasks = initShim.tasks();
    this.userProvidedServiceInstances = initShim.userProvidedServiceInstances();
    this.users = initShim.users();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private ApplicationUsageEvents applicationUsageEvents;
    private int applicationUsageEventsBuildStage;

    ApplicationUsageEvents applicationUsageEvents() {
      if (applicationUsageEventsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationUsageEventsBuildStage == STAGE_UNINITIALIZED) {
        applicationUsageEventsBuildStage = STAGE_INITIALIZING;
        this.applicationUsageEvents = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationUsageEvents(), "applicationUsageEvents");
        applicationUsageEventsBuildStage = STAGE_INITIALIZED;
      }
      return this.applicationUsageEvents;
    }
    private ApplicationsV2 applicationsV2;
    private int applicationsV2BuildStage;

    ApplicationsV2 applicationsV2() {
      if (applicationsV2BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsV2BuildStage == STAGE_UNINITIALIZED) {
        applicationsV2BuildStage = STAGE_INITIALIZING;
        this.applicationsV2 = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationsV2(), "applicationsV2");
        applicationsV2BuildStage = STAGE_INITIALIZED;
      }
      return this.applicationsV2;
    }
    private ApplicationsV3 applicationsV3;
    private int applicationsV3BuildStage;

    ApplicationsV3 applicationsV3() {
      if (applicationsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsV3BuildStage == STAGE_UNINITIALIZED) {
        applicationsV3BuildStage = STAGE_INITIALIZING;
        this.applicationsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.applicationsV3(), "applicationsV3");
        applicationsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.applicationsV3;
    }
    private Buildpacks buildpacks;
    private int buildpacksBuildStage;

    Buildpacks buildpacks() {
      if (buildpacksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildpacksBuildStage == STAGE_UNINITIALIZED) {
        buildpacksBuildStage = STAGE_INITIALIZING;
        this.buildpacks = Objects.requireNonNull(ReactorCloudFoundryClient.super.buildpacks(), "buildpacks");
        buildpacksBuildStage = STAGE_INITIALIZED;
      }
      return this.buildpacks;
    }
    private Domains domains;
    private int domainsBuildStage;

    Domains domains() {
      if (domainsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (domainsBuildStage == STAGE_UNINITIALIZED) {
        domainsBuildStage = STAGE_INITIALIZING;
        this.domains = Objects.requireNonNull(ReactorCloudFoundryClient.super.domains(), "domains");
        domainsBuildStage = STAGE_INITIALIZED;
      }
      return this.domains;
    }
    private Droplets droplets;
    private int dropletsBuildStage;

    Droplets droplets() {
      if (dropletsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dropletsBuildStage == STAGE_UNINITIALIZED) {
        dropletsBuildStage = STAGE_INITIALIZING;
        this.droplets = Objects.requireNonNull(ReactorCloudFoundryClient.super.droplets(), "droplets");
        dropletsBuildStage = STAGE_INITIALIZED;
      }
      return this.droplets;
    }
    private EnvironmentVariableGroups environmentVariableGroups;
    private int environmentVariableGroupsBuildStage;

    EnvironmentVariableGroups environmentVariableGroups() {
      if (environmentVariableGroupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (environmentVariableGroupsBuildStage == STAGE_UNINITIALIZED) {
        environmentVariableGroupsBuildStage = STAGE_INITIALIZING;
        this.environmentVariableGroups = Objects.requireNonNull(ReactorCloudFoundryClient.super.environmentVariableGroups(), "environmentVariableGroups");
        environmentVariableGroupsBuildStage = STAGE_INITIALIZED;
      }
      return this.environmentVariableGroups;
    }
    private Events events;
    private int eventsBuildStage;

    Events events() {
      if (eventsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (eventsBuildStage == STAGE_UNINITIALIZED) {
        eventsBuildStage = STAGE_INITIALIZING;
        this.events = Objects.requireNonNull(ReactorCloudFoundryClient.super.events(), "events");
        eventsBuildStage = STAGE_INITIALIZED;
      }
      return this.events;
    }
    private FeatureFlags featureFlags;
    private int featureFlagsBuildStage;

    FeatureFlags featureFlags() {
      if (featureFlagsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (featureFlagsBuildStage == STAGE_UNINITIALIZED) {
        featureFlagsBuildStage = STAGE_INITIALIZING;
        this.featureFlags = Objects.requireNonNull(ReactorCloudFoundryClient.super.featureFlags(), "featureFlags");
        featureFlagsBuildStage = STAGE_INITIALIZED;
      }
      return this.featureFlags;
    }
    private Info info;
    private int infoBuildStage;

    Info info() {
      if (infoBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (infoBuildStage == STAGE_UNINITIALIZED) {
        infoBuildStage = STAGE_INITIALIZING;
        this.info = Objects.requireNonNull(ReactorCloudFoundryClient.super.info(), "info");
        infoBuildStage = STAGE_INITIALIZED;
      }
      return this.info;
    }
    private Jobs jobs;
    private int jobsBuildStage;

    Jobs jobs() {
      if (jobsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (jobsBuildStage == STAGE_UNINITIALIZED) {
        jobsBuildStage = STAGE_INITIALIZING;
        this.jobs = Objects.requireNonNull(ReactorCloudFoundryClient.super.jobs(), "jobs");
        jobsBuildStage = STAGE_INITIALIZED;
      }
      return this.jobs;
    }
    private OrganizationQuotaDefinitions organizationQuotaDefinitions;
    private int organizationQuotaDefinitionsBuildStage;

    OrganizationQuotaDefinitions organizationQuotaDefinitions() {
      if (organizationQuotaDefinitionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationQuotaDefinitionsBuildStage == STAGE_UNINITIALIZED) {
        organizationQuotaDefinitionsBuildStage = STAGE_INITIALIZING;
        this.organizationQuotaDefinitions = Objects.requireNonNull(ReactorCloudFoundryClient.super.organizationQuotaDefinitions(), "organizationQuotaDefinitions");
        organizationQuotaDefinitionsBuildStage = STAGE_INITIALIZED;
      }
      return this.organizationQuotaDefinitions;
    }
    private Organizations organizations;
    private int organizationsBuildStage;

    Organizations organizations() {
      if (organizationsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationsBuildStage == STAGE_UNINITIALIZED) {
        organizationsBuildStage = STAGE_INITIALIZING;
        this.organizations = Objects.requireNonNull(ReactorCloudFoundryClient.super.organizations(), "organizations");
        organizationsBuildStage = STAGE_INITIALIZED;
      }
      return this.organizations;
    }
    private Packages packages;
    private int packagesBuildStage;

    Packages packages() {
      if (packagesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (packagesBuildStage == STAGE_UNINITIALIZED) {
        packagesBuildStage = STAGE_INITIALIZING;
        this.packages = Objects.requireNonNull(ReactorCloudFoundryClient.super.packages(), "packages");
        packagesBuildStage = STAGE_INITIALIZED;
      }
      return this.packages;
    }
    private PrivateDomains privateDomains;
    private int privateDomainsBuildStage;

    PrivateDomains privateDomains() {
      if (privateDomainsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (privateDomainsBuildStage == STAGE_UNINITIALIZED) {
        privateDomainsBuildStage = STAGE_INITIALIZING;
        this.privateDomains = Objects.requireNonNull(ReactorCloudFoundryClient.super.privateDomains(), "privateDomains");
        privateDomainsBuildStage = STAGE_INITIALIZED;
      }
      return this.privateDomains;
    }
    private Processes processes;
    private int processesBuildStage;

    Processes processes() {
      if (processesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processesBuildStage == STAGE_UNINITIALIZED) {
        processesBuildStage = STAGE_INITIALIZING;
        this.processes = Objects.requireNonNull(ReactorCloudFoundryClient.super.processes(), "processes");
        processesBuildStage = STAGE_INITIALIZED;
      }
      return this.processes;
    }
    private ResourceMatch resourceMatch;
    private int resourceMatchBuildStage;

    ResourceMatch resourceMatch() {
      if (resourceMatchBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (resourceMatchBuildStage == STAGE_UNINITIALIZED) {
        resourceMatchBuildStage = STAGE_INITIALIZING;
        this.resourceMatch = Objects.requireNonNull(ReactorCloudFoundryClient.super.resourceMatch(), "resourceMatch");
        resourceMatchBuildStage = STAGE_INITIALIZED;
      }
      return this.resourceMatch;
    }
    private RouteMappings routeMappings;
    private int routeMappingsBuildStage;

    RouteMappings routeMappings() {
      if (routeMappingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routeMappingsBuildStage == STAGE_UNINITIALIZED) {
        routeMappingsBuildStage = STAGE_INITIALIZING;
        this.routeMappings = Objects.requireNonNull(ReactorCloudFoundryClient.super.routeMappings(), "routeMappings");
        routeMappingsBuildStage = STAGE_INITIALIZED;
      }
      return this.routeMappings;
    }
    private Routes routes;
    private int routesBuildStage;

    Routes routes() {
      if (routesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routesBuildStage == STAGE_UNINITIALIZED) {
        routesBuildStage = STAGE_INITIALIZING;
        this.routes = Objects.requireNonNull(ReactorCloudFoundryClient.super.routes(), "routes");
        routesBuildStage = STAGE_INITIALIZED;
      }
      return this.routes;
    }
    private SecurityGroups securityGroups;
    private int securityGroupsBuildStage;

    SecurityGroups securityGroups() {
      if (securityGroupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (securityGroupsBuildStage == STAGE_UNINITIALIZED) {
        securityGroupsBuildStage = STAGE_INITIALIZING;
        this.securityGroups = Objects.requireNonNull(ReactorCloudFoundryClient.super.securityGroups(), "securityGroups");
        securityGroupsBuildStage = STAGE_INITIALIZED;
      }
      return this.securityGroups;
    }
    private ServiceBindingsV2 serviceBindingsV2;
    private int serviceBindingsV2BuildStage;

    ServiceBindingsV2 serviceBindingsV2() {
      if (serviceBindingsV2BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBindingsV2BuildStage == STAGE_UNINITIALIZED) {
        serviceBindingsV2BuildStage = STAGE_INITIALIZING;
        this.serviceBindingsV2 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBindingsV2(), "serviceBindingsV2");
        serviceBindingsV2BuildStage = STAGE_INITIALIZED;
      }
      return this.serviceBindingsV2;
    }
    private ServiceBindingsV3 serviceBindingsV3;
    private int serviceBindingsV3BuildStage;

    ServiceBindingsV3 serviceBindingsV3() {
      if (serviceBindingsV3BuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBindingsV3BuildStage == STAGE_UNINITIALIZED) {
        serviceBindingsV3BuildStage = STAGE_INITIALIZING;
        this.serviceBindingsV3 = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBindingsV3(), "serviceBindingsV3");
        serviceBindingsV3BuildStage = STAGE_INITIALIZED;
      }
      return this.serviceBindingsV3;
    }
    private ServiceBrokers serviceBrokers;
    private int serviceBrokersBuildStage;

    ServiceBrokers serviceBrokers() {
      if (serviceBrokersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceBrokersBuildStage == STAGE_UNINITIALIZED) {
        serviceBrokersBuildStage = STAGE_INITIALIZING;
        this.serviceBrokers = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceBrokers(), "serviceBrokers");
        serviceBrokersBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceBrokers;
    }
    private ServiceInstances serviceInstances;
    private int serviceInstancesBuildStage;

    ServiceInstances serviceInstances() {
      if (serviceInstancesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceInstancesBuildStage == STAGE_UNINITIALIZED) {
        serviceInstancesBuildStage = STAGE_INITIALIZING;
        this.serviceInstances = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceInstances(), "serviceInstances");
        serviceInstancesBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceInstances;
    }
    private ServiceKeys serviceKeys;
    private int serviceKeysBuildStage;

    ServiceKeys serviceKeys() {
      if (serviceKeysBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceKeysBuildStage == STAGE_UNINITIALIZED) {
        serviceKeysBuildStage = STAGE_INITIALIZING;
        this.serviceKeys = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceKeys(), "serviceKeys");
        serviceKeysBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceKeys;
    }
    private ServicePlanVisibilities servicePlanVisibilities;
    private int servicePlanVisibilitiesBuildStage;

    ServicePlanVisibilities servicePlanVisibilities() {
      if (servicePlanVisibilitiesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicePlanVisibilitiesBuildStage == STAGE_UNINITIALIZED) {
        servicePlanVisibilitiesBuildStage = STAGE_INITIALIZING;
        this.servicePlanVisibilities = Objects.requireNonNull(ReactorCloudFoundryClient.super.servicePlanVisibilities(), "servicePlanVisibilities");
        servicePlanVisibilitiesBuildStage = STAGE_INITIALIZED;
      }
      return this.servicePlanVisibilities;
    }
    private ServicePlans servicePlans;
    private int servicePlansBuildStage;

    ServicePlans servicePlans() {
      if (servicePlansBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicePlansBuildStage == STAGE_UNINITIALIZED) {
        servicePlansBuildStage = STAGE_INITIALIZING;
        this.servicePlans = Objects.requireNonNull(ReactorCloudFoundryClient.super.servicePlans(), "servicePlans");
        servicePlansBuildStage = STAGE_INITIALIZED;
      }
      return this.servicePlans;
    }
    private ServiceUsageEvents serviceUsageEvents;
    private int serviceUsageEventsBuildStage;

    ServiceUsageEvents serviceUsageEvents() {
      if (serviceUsageEventsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceUsageEventsBuildStage == STAGE_UNINITIALIZED) {
        serviceUsageEventsBuildStage = STAGE_INITIALIZING;
        this.serviceUsageEvents = Objects.requireNonNull(ReactorCloudFoundryClient.super.serviceUsageEvents(), "serviceUsageEvents");
        serviceUsageEventsBuildStage = STAGE_INITIALIZED;
      }
      return this.serviceUsageEvents;
    }
    private Services services;
    private int servicesBuildStage;

    Services services() {
      if (servicesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicesBuildStage == STAGE_UNINITIALIZED) {
        servicesBuildStage = STAGE_INITIALIZING;
        this.services = Objects.requireNonNull(ReactorCloudFoundryClient.super.services(), "services");
        servicesBuildStage = STAGE_INITIALIZED;
      }
      return this.services;
    }
    private SharedDomains sharedDomains;
    private int sharedDomainsBuildStage;

    SharedDomains sharedDomains() {
      if (sharedDomainsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sharedDomainsBuildStage == STAGE_UNINITIALIZED) {
        sharedDomainsBuildStage = STAGE_INITIALIZING;
        this.sharedDomains = Objects.requireNonNull(ReactorCloudFoundryClient.super.sharedDomains(), "sharedDomains");
        sharedDomainsBuildStage = STAGE_INITIALIZED;
      }
      return this.sharedDomains;
    }
    private SpaceQuotaDefinitions spaceQuotaDefinitions;
    private int spaceQuotaDefinitionsBuildStage;

    SpaceQuotaDefinitions spaceQuotaDefinitions() {
      if (spaceQuotaDefinitionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spaceQuotaDefinitionsBuildStage == STAGE_UNINITIALIZED) {
        spaceQuotaDefinitionsBuildStage = STAGE_INITIALIZING;
        this.spaceQuotaDefinitions = Objects.requireNonNull(ReactorCloudFoundryClient.super.spaceQuotaDefinitions(), "spaceQuotaDefinitions");
        spaceQuotaDefinitionsBuildStage = STAGE_INITIALIZED;
      }
      return this.spaceQuotaDefinitions;
    }
    private Spaces spaces;
    private int spacesBuildStage;

    Spaces spaces() {
      if (spacesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spacesBuildStage == STAGE_UNINITIALIZED) {
        spacesBuildStage = STAGE_INITIALIZING;
        this.spaces = Objects.requireNonNull(ReactorCloudFoundryClient.super.spaces(), "spaces");
        spacesBuildStage = STAGE_INITIALIZED;
      }
      return this.spaces;
    }
    private Stacks stacks;
    private int stacksBuildStage;

    Stacks stacks() {
      if (stacksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stacksBuildStage == STAGE_UNINITIALIZED) {
        stacksBuildStage = STAGE_INITIALIZING;
        this.stacks = Objects.requireNonNull(ReactorCloudFoundryClient.super.stacks(), "stacks");
        stacksBuildStage = STAGE_INITIALIZED;
      }
      return this.stacks;
    }
    private Tasks tasks;
    private int tasksBuildStage;

    Tasks tasks() {
      if (tasksBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tasksBuildStage == STAGE_UNINITIALIZED) {
        tasksBuildStage = STAGE_INITIALIZING;
        this.tasks = Objects.requireNonNull(ReactorCloudFoundryClient.super.tasks(), "tasks");
        tasksBuildStage = STAGE_INITIALIZED;
      }
      return this.tasks;
    }
    private UserProvidedServiceInstances userProvidedServiceInstances;
    private int userProvidedServiceInstancesBuildStage;

    UserProvidedServiceInstances userProvidedServiceInstances() {
      if (userProvidedServiceInstancesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userProvidedServiceInstancesBuildStage == STAGE_UNINITIALIZED) {
        userProvidedServiceInstancesBuildStage = STAGE_INITIALIZING;
        this.userProvidedServiceInstances = Objects.requireNonNull(ReactorCloudFoundryClient.super.userProvidedServiceInstances(), "userProvidedServiceInstances");
        userProvidedServiceInstancesBuildStage = STAGE_INITIALIZED;
      }
      return this.userProvidedServiceInstances;
    }
    private Users users;
    private int usersBuildStage;

    Users users() {
      if (usersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usersBuildStage == STAGE_UNINITIALIZED) {
        usersBuildStage = STAGE_INITIALIZING;
        this.users = Objects.requireNonNull(ReactorCloudFoundryClient.super.users(), "users");
        usersBuildStage = STAGE_INITIALIZED;
      }
      return this.users;
    }
    private HttpClient httpClient;
    private int httpClientBuildStage;

    HttpClient getHttpClient() {
      if (httpClientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (httpClientBuildStage == STAGE_UNINITIALIZED) {
        httpClientBuildStage = STAGE_INITIALIZING;
        this.httpClient = Objects.requireNonNull(ReactorCloudFoundryClient.super.getHttpClient(), "httpClient");
        httpClientBuildStage = STAGE_INITIALIZED;
      }
      return this.httpClient;
    }

    void httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      httpClientBuildStage = STAGE_INITIALIZED;
    }
    private ObjectMapper objectMapper;
    private int objectMapperBuildStage;

    ObjectMapper getObjectMapper() {
      if (objectMapperBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMapperBuildStage == STAGE_UNINITIALIZED) {
        objectMapperBuildStage = STAGE_INITIALIZING;
        this.objectMapper = Objects.requireNonNull(ReactorCloudFoundryClient.super.getObjectMapper(), "objectMapper");
        objectMapperBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMapper;
    }

    void objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = objectMapper;
      objectMapperBuildStage = STAGE_INITIALIZED;
    }
    private Mono<String> root;
    private int rootBuildStage;

    Mono<String> getRoot() {
      if (rootBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootBuildStage == STAGE_UNINITIALIZED) {
        rootBuildStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(ReactorCloudFoundryClient.super.getRoot(), "root");
        rootBuildStage = STAGE_INITIALIZED;
      }
      return this.root;
    }

    void root(Mono<String> root) {
      this.root = root;
      rootBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (applicationUsageEventsBuildStage == STAGE_INITIALIZING) attributes.add("applicationUsageEvents");
      if (applicationsV2BuildStage == STAGE_INITIALIZING) attributes.add("applicationsV2");
      if (applicationsV3BuildStage == STAGE_INITIALIZING) attributes.add("applicationsV3");
      if (buildpacksBuildStage == STAGE_INITIALIZING) attributes.add("buildpacks");
      if (domainsBuildStage == STAGE_INITIALIZING) attributes.add("domains");
      if (dropletsBuildStage == STAGE_INITIALIZING) attributes.add("droplets");
      if (environmentVariableGroupsBuildStage == STAGE_INITIALIZING) attributes.add("environmentVariableGroups");
      if (eventsBuildStage == STAGE_INITIALIZING) attributes.add("events");
      if (featureFlagsBuildStage == STAGE_INITIALIZING) attributes.add("featureFlags");
      if (infoBuildStage == STAGE_INITIALIZING) attributes.add("info");
      if (jobsBuildStage == STAGE_INITIALIZING) attributes.add("jobs");
      if (organizationQuotaDefinitionsBuildStage == STAGE_INITIALIZING) attributes.add("organizationQuotaDefinitions");
      if (organizationsBuildStage == STAGE_INITIALIZING) attributes.add("organizations");
      if (packagesBuildStage == STAGE_INITIALIZING) attributes.add("packages");
      if (privateDomainsBuildStage == STAGE_INITIALIZING) attributes.add("privateDomains");
      if (processesBuildStage == STAGE_INITIALIZING) attributes.add("processes");
      if (resourceMatchBuildStage == STAGE_INITIALIZING) attributes.add("resourceMatch");
      if (routeMappingsBuildStage == STAGE_INITIALIZING) attributes.add("routeMappings");
      if (routesBuildStage == STAGE_INITIALIZING) attributes.add("routes");
      if (securityGroupsBuildStage == STAGE_INITIALIZING) attributes.add("securityGroups");
      if (serviceBindingsV2BuildStage == STAGE_INITIALIZING) attributes.add("serviceBindingsV2");
      if (serviceBindingsV3BuildStage == STAGE_INITIALIZING) attributes.add("serviceBindingsV3");
      if (serviceBrokersBuildStage == STAGE_INITIALIZING) attributes.add("serviceBrokers");
      if (serviceInstancesBuildStage == STAGE_INITIALIZING) attributes.add("serviceInstances");
      if (serviceKeysBuildStage == STAGE_INITIALIZING) attributes.add("serviceKeys");
      if (servicePlanVisibilitiesBuildStage == STAGE_INITIALIZING) attributes.add("servicePlanVisibilities");
      if (servicePlansBuildStage == STAGE_INITIALIZING) attributes.add("servicePlans");
      if (serviceUsageEventsBuildStage == STAGE_INITIALIZING) attributes.add("serviceUsageEvents");
      if (servicesBuildStage == STAGE_INITIALIZING) attributes.add("services");
      if (sharedDomainsBuildStage == STAGE_INITIALIZING) attributes.add("sharedDomains");
      if (spaceQuotaDefinitionsBuildStage == STAGE_INITIALIZING) attributes.add("spaceQuotaDefinitions");
      if (spacesBuildStage == STAGE_INITIALIZING) attributes.add("spaces");
      if (stacksBuildStage == STAGE_INITIALIZING) attributes.add("stacks");
      if (tasksBuildStage == STAGE_INITIALIZING) attributes.add("tasks");
      if (userProvidedServiceInstancesBuildStage == STAGE_INITIALIZING) attributes.add("userProvidedServiceInstances");
      if (usersBuildStage == STAGE_INITIALIZING) attributes.add("users");
      if (httpClientBuildStage == STAGE_INITIALIZING) attributes.add("httpClient");
      if (objectMapperBuildStage == STAGE_INITIALIZING) attributes.add("objectMapper");
      if (rootBuildStage == STAGE_INITIALIZING) attributes.add("root");
      return "Cannot build ReactorCloudFoundryClient, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code applicationUsageEvents} attribute
   */
  @Override
  public ApplicationUsageEvents applicationUsageEvents() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationUsageEvents()
        : this.applicationUsageEvents;
  }

  /**
   * @return The computed-at-construction value of the {@code applicationsV2} attribute
   */
  @Override
  public ApplicationsV2 applicationsV2() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationsV2()
        : this.applicationsV2;
  }

  /**
   * @return The computed-at-construction value of the {@code applicationsV3} attribute
   */
  @Override
  public ApplicationsV3 applicationsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applicationsV3()
        : this.applicationsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code buildpacks} attribute
   */
  @Override
  public Buildpacks buildpacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.buildpacks()
        : this.buildpacks;
  }

  /**
   * @return The computed-at-construction value of the {@code domains} attribute
   */
  @Override
  public Domains domains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.domains()
        : this.domains;
  }

  /**
   * @return The computed-at-construction value of the {@code droplets} attribute
   */
  @Override
  public Droplets droplets() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.droplets()
        : this.droplets;
  }

  /**
   * @return The computed-at-construction value of the {@code environmentVariableGroups} attribute
   */
  @Override
  public EnvironmentVariableGroups environmentVariableGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.environmentVariableGroups()
        : this.environmentVariableGroups;
  }

  /**
   * @return The computed-at-construction value of the {@code events} attribute
   */
  @Override
  public Events events() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.events()
        : this.events;
  }

  /**
   * @return The computed-at-construction value of the {@code featureFlags} attribute
   */
  @Override
  public FeatureFlags featureFlags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.featureFlags()
        : this.featureFlags;
  }

  /**
   * @return The computed-at-construction value of the {@code info} attribute
   */
  @Override
  public Info info() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.info()
        : this.info;
  }

  /**
   * @return The computed-at-construction value of the {@code jobs} attribute
   */
  @Override
  public Jobs jobs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.jobs()
        : this.jobs;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationQuotaDefinitions} attribute
   */
  @Override
  public OrganizationQuotaDefinitions organizationQuotaDefinitions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizationQuotaDefinitions()
        : this.organizationQuotaDefinitions;
  }

  /**
   * @return The computed-at-construction value of the {@code organizations} attribute
   */
  @Override
  public Organizations organizations() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizations()
        : this.organizations;
  }

  /**
   * @return The computed-at-construction value of the {@code packages} attribute
   */
  @Override
  public Packages packages() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.packages()
        : this.packages;
  }

  /**
   * @return The computed-at-construction value of the {@code privateDomains} attribute
   */
  @Override
  public PrivateDomains privateDomains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.privateDomains()
        : this.privateDomains;
  }

  /**
   * @return The computed-at-construction value of the {@code processes} attribute
   */
  @Override
  public Processes processes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processes()
        : this.processes;
  }

  /**
   * @return The computed-at-construction value of the {@code resourceMatch} attribute
   */
  @Override
  public ResourceMatch resourceMatch() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.resourceMatch()
        : this.resourceMatch;
  }

  /**
   * @return The computed-at-construction value of the {@code routeMappings} attribute
   */
  @Override
  public RouteMappings routeMappings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routeMappings()
        : this.routeMappings;
  }

  /**
   * @return The computed-at-construction value of the {@code routes} attribute
   */
  @Override
  public Routes routes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routes()
        : this.routes;
  }

  /**
   * @return The computed-at-construction value of the {@code securityGroups} attribute
   */
  @Override
  public SecurityGroups securityGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.securityGroups()
        : this.securityGroups;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBindingsV2} attribute
   */
  @Override
  public ServiceBindingsV2 serviceBindingsV2() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBindingsV2()
        : this.serviceBindingsV2;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBindingsV3} attribute
   */
  @Override
  public ServiceBindingsV3 serviceBindingsV3() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBindingsV3()
        : this.serviceBindingsV3;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceBrokers} attribute
   */
  @Override
  public ServiceBrokers serviceBrokers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceBrokers()
        : this.serviceBrokers;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceInstances} attribute
   */
  @Override
  public ServiceInstances serviceInstances() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceInstances()
        : this.serviceInstances;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceKeys} attribute
   */
  @Override
  public ServiceKeys serviceKeys() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceKeys()
        : this.serviceKeys;
  }

  /**
   * @return The computed-at-construction value of the {@code servicePlanVisibilities} attribute
   */
  @Override
  public ServicePlanVisibilities servicePlanVisibilities() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.servicePlanVisibilities()
        : this.servicePlanVisibilities;
  }

  /**
   * @return The computed-at-construction value of the {@code servicePlans} attribute
   */
  @Override
  public ServicePlans servicePlans() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.servicePlans()
        : this.servicePlans;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceUsageEvents} attribute
   */
  @Override
  public ServiceUsageEvents serviceUsageEvents() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceUsageEvents()
        : this.serviceUsageEvents;
  }

  /**
   * @return The computed-at-construction value of the {@code services} attribute
   */
  @Override
  public Services services() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.services()
        : this.services;
  }

  /**
   * @return The computed-at-construction value of the {@code sharedDomains} attribute
   */
  @Override
  public SharedDomains sharedDomains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.sharedDomains()
        : this.sharedDomains;
  }

  /**
   * @return The computed-at-construction value of the {@code spaceQuotaDefinitions} attribute
   */
  @Override
  public SpaceQuotaDefinitions spaceQuotaDefinitions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaceQuotaDefinitions()
        : this.spaceQuotaDefinitions;
  }

  /**
   * @return The computed-at-construction value of the {@code spaces} attribute
   */
  @Override
  public Spaces spaces() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaces()
        : this.spaces;
  }

  /**
   * @return The computed-at-construction value of the {@code stacks} attribute
   */
  @Override
  public Stacks stacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stacks()
        : this.stacks;
  }

  /**
   * @return The computed-at-construction value of the {@code tasks} attribute
   */
  @Override
  public Tasks tasks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tasks()
        : this.tasks;
  }

  /**
   * @return The computed-at-construction value of the {@code userProvidedServiceInstances} attribute
   */
  @Override
  public UserProvidedServiceInstances userProvidedServiceInstances() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userProvidedServiceInstances()
        : this.userProvidedServiceInstances;
  }

  /**
   * @return The computed-at-construction value of the {@code users} attribute
   */
  @Override
  public Users users() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.users()
        : this.users;
  }

  /**
   * @return The value of the {@code connectionContext} attribute
   */
  @Override
  public @Nullable ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * @return The value of the {@code httpClient} attribute
   */
  @Override
  public HttpClient getHttpClient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHttpClient()
        : this.httpClient;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMapper()
        : this.objectMapper;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * @return The value of the {@code tokenProvider} attribute
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorCloudFoundryClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorCloudFoundryClient
        && equalTo((ReactorCloudFoundryClient) another);
  }

  private boolean equalTo(ReactorCloudFoundryClient another) {
    return applicationUsageEvents.equals(another.applicationUsageEvents)
        && applicationsV2.equals(another.applicationsV2)
        && applicationsV3.equals(another.applicationsV3)
        && buildpacks.equals(another.buildpacks)
        && domains.equals(another.domains)
        && droplets.equals(another.droplets)
        && environmentVariableGroups.equals(another.environmentVariableGroups)
        && events.equals(another.events)
        && featureFlags.equals(another.featureFlags)
        && info.equals(another.info)
        && jobs.equals(another.jobs)
        && organizationQuotaDefinitions.equals(another.organizationQuotaDefinitions)
        && organizations.equals(another.organizations)
        && packages.equals(another.packages)
        && privateDomains.equals(another.privateDomains)
        && processes.equals(another.processes)
        && resourceMatch.equals(another.resourceMatch)
        && routeMappings.equals(another.routeMappings)
        && routes.equals(another.routes)
        && securityGroups.equals(another.securityGroups)
        && serviceBindingsV2.equals(another.serviceBindingsV2)
        && serviceBindingsV3.equals(another.serviceBindingsV3)
        && serviceBrokers.equals(another.serviceBrokers)
        && serviceInstances.equals(another.serviceInstances)
        && serviceKeys.equals(another.serviceKeys)
        && servicePlanVisibilities.equals(another.servicePlanVisibilities)
        && servicePlans.equals(another.servicePlans)
        && serviceUsageEvents.equals(another.serviceUsageEvents)
        && services.equals(another.services)
        && sharedDomains.equals(another.sharedDomains)
        && spaceQuotaDefinitions.equals(another.spaceQuotaDefinitions)
        && spaces.equals(another.spaces)
        && stacks.equals(another.stacks)
        && tasks.equals(another.tasks)
        && userProvidedServiceInstances.equals(another.userProvidedServiceInstances)
        && users.equals(another.users)
        && Objects.equals(connectionContext, another.connectionContext)
        && httpClient.equals(another.httpClient)
        && objectMapper.equals(another.objectMapper)
        && root.equals(another.root)
        && tokenProvider.equals(another.tokenProvider);
  }

  /**
   * Computes a hash code from attributes: {@code applicationUsageEvents}, {@code applicationsV2}, {@code applicationsV3}, {@code buildpacks}, {@code domains}, {@code droplets}, {@code environmentVariableGroups}, {@code events}, {@code featureFlags}, {@code info}, {@code jobs}, {@code organizationQuotaDefinitions}, {@code organizations}, {@code packages}, {@code privateDomains}, {@code processes}, {@code resourceMatch}, {@code routeMappings}, {@code routes}, {@code securityGroups}, {@code serviceBindingsV2}, {@code serviceBindingsV3}, {@code serviceBrokers}, {@code serviceInstances}, {@code serviceKeys}, {@code servicePlanVisibilities}, {@code servicePlans}, {@code serviceUsageEvents}, {@code services}, {@code sharedDomains}, {@code spaceQuotaDefinitions}, {@code spaces}, {@code stacks}, {@code tasks}, {@code userProvidedServiceInstances}, {@code users}, {@code connectionContext}, {@code httpClient}, {@code objectMapper}, {@code root}, {@code tokenProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationUsageEvents.hashCode();
    h = h * 17 + applicationsV2.hashCode();
    h = h * 17 + applicationsV3.hashCode();
    h = h * 17 + buildpacks.hashCode();
    h = h * 17 + domains.hashCode();
    h = h * 17 + droplets.hashCode();
    h = h * 17 + environmentVariableGroups.hashCode();
    h = h * 17 + events.hashCode();
    h = h * 17 + featureFlags.hashCode();
    h = h * 17 + info.hashCode();
    h = h * 17 + jobs.hashCode();
    h = h * 17 + organizationQuotaDefinitions.hashCode();
    h = h * 17 + organizations.hashCode();
    h = h * 17 + packages.hashCode();
    h = h * 17 + privateDomains.hashCode();
    h = h * 17 + processes.hashCode();
    h = h * 17 + resourceMatch.hashCode();
    h = h * 17 + routeMappings.hashCode();
    h = h * 17 + routes.hashCode();
    h = h * 17 + securityGroups.hashCode();
    h = h * 17 + serviceBindingsV2.hashCode();
    h = h * 17 + serviceBindingsV3.hashCode();
    h = h * 17 + serviceBrokers.hashCode();
    h = h * 17 + serviceInstances.hashCode();
    h = h * 17 + serviceKeys.hashCode();
    h = h * 17 + servicePlanVisibilities.hashCode();
    h = h * 17 + servicePlans.hashCode();
    h = h * 17 + serviceUsageEvents.hashCode();
    h = h * 17 + services.hashCode();
    h = h * 17 + sharedDomains.hashCode();
    h = h * 17 + spaceQuotaDefinitions.hashCode();
    h = h * 17 + spaces.hashCode();
    h = h * 17 + stacks.hashCode();
    h = h * 17 + tasks.hashCode();
    h = h * 17 + userProvidedServiceInstances.hashCode();
    h = h * 17 + users.hashCode();
    h = h * 17 + Objects.hashCode(connectionContext);
    h = h * 17 + httpClient.hashCode();
    h = h * 17 + objectMapper.hashCode();
    h = h * 17 + root.hashCode();
    h = h * 17 + tokenProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorCloudFoundryClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorCloudFoundryClient{"
        + "applicationUsageEvents=" + applicationUsageEvents
        + ", applicationsV2=" + applicationsV2
        + ", applicationsV3=" + applicationsV3
        + ", buildpacks=" + buildpacks
        + ", domains=" + domains
        + ", droplets=" + droplets
        + ", environmentVariableGroups=" + environmentVariableGroups
        + ", events=" + events
        + ", featureFlags=" + featureFlags
        + ", info=" + info
        + ", jobs=" + jobs
        + ", organizationQuotaDefinitions=" + organizationQuotaDefinitions
        + ", organizations=" + organizations
        + ", packages=" + packages
        + ", privateDomains=" + privateDomains
        + ", processes=" + processes
        + ", resourceMatch=" + resourceMatch
        + ", routeMappings=" + routeMappings
        + ", routes=" + routes
        + ", securityGroups=" + securityGroups
        + ", serviceBindingsV2=" + serviceBindingsV2
        + ", serviceBindingsV3=" + serviceBindingsV3
        + ", serviceBrokers=" + serviceBrokers
        + ", serviceInstances=" + serviceInstances
        + ", serviceKeys=" + serviceKeys
        + ", servicePlanVisibilities=" + servicePlanVisibilities
        + ", servicePlans=" + servicePlans
        + ", serviceUsageEvents=" + serviceUsageEvents
        + ", services=" + services
        + ", sharedDomains=" + sharedDomains
        + ", spaceQuotaDefinitions=" + spaceQuotaDefinitions
        + ", spaces=" + spaces
        + ", stacks=" + stacks
        + ", tasks=" + tasks
        + ", userProvidedServiceInstances=" + userProvidedServiceInstances
        + ", users=" + users
        + ", connectionContext=" + connectionContext
        + ", httpClient=" + httpClient
        + ", objectMapper=" + objectMapper
        + ", root=" + root
        + ", tokenProvider=" + tokenProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
   * @return A new ReactorCloudFoundryClient builder
   */
  public static ReactorCloudFoundryClient.Builder builder() {
    return new ReactorCloudFoundryClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x1L;
    private long initBits = 0x1L;

    private ConnectionContext connectionContext;
    private HttpClient httpClient;
    private ObjectMapper objectMapper;
    private Mono<String> root;
    private TokenProvider tokenProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorCloudFoundryClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorCloudFoundryClient instance) {
      return from((_ReactorCloudFoundryClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorCloudFoundryClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorCloudFoundryClient instance) {
      Objects.requireNonNull(instance, "instance");
      ConnectionContext connectionContextValue = instance.getConnectionContext();
      if (connectionContextValue != null) {
        connectionContext(connectionContextValue);
      }
      httpClient(instance.getHttpClient());
      objectMapper(instance.getObjectMapper());
      root(instance.getRoot());
      tokenProvider(instance.getTokenProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(@Nullable ConnectionContext connectionContext) {
      this.connectionContext = connectionContext;
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getHttpClient() httpClient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorCloudFoundryClient#getHttpClient() httpClient}.</em>
     * @param httpClient The value for httpClient 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpClient(HttpClient httpClient) {
      this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getObjectMapper() objectMapper} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorCloudFoundryClient#getObjectMapper() objectMapper}.</em>
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getRoot() root} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorCloudFoundryClient#getRoot() root}.</em>
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Mono<String> root) {
      this.root = Objects.requireNonNull(root, "root");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorCloudFoundryClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ReactorCloudFoundryClient ReactorCloudFoundryClient}.
     * @return An immutable instance of ReactorCloudFoundryClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorCloudFoundryClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorCloudFoundryClient(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorCloudFoundryClient, some of required attributes are not set " + attributes;
    }
  }
}
