package org.cloudfoundry.reactor.doppler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;

/**
 * The Reactor-based implementation of {@link DopplerClient}
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ReactorDopplerClient"})
public final class ReactorDopplerClient extends org.cloudfoundry.reactor.doppler._ReactorDopplerClient {
  private final @Nullable ConnectionContext connectionContext;
  private final ReactorDopplerEndpoints dopplerEndpoints;
  private final HttpClient httpClient;
  private final ObjectMapper objectMapper;
  private final Mono<String> root;
  private final TokenProvider tokenProvider;

  private ReactorDopplerClient(ReactorDopplerClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.tokenProvider = builder.tokenProvider;
    if (builder.httpClient != null) {
      initShim.httpClient(builder.httpClient);
    }
    if (builder.objectMapper != null) {
      initShim.objectMapper(builder.objectMapper);
    }
    if (builder.root != null) {
      initShim.root(builder.root);
    }
    this.httpClient = initShim.getHttpClient();
    this.objectMapper = initShim.getObjectMapper();
    this.root = initShim.getRoot();
    this.dopplerEndpoints = initShim.getDopplerEndpoints();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private ReactorDopplerEndpoints dopplerEndpoints;
    private int dopplerEndpointsBuildStage;

    ReactorDopplerEndpoints getDopplerEndpoints() {
      if (dopplerEndpointsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dopplerEndpointsBuildStage == STAGE_UNINITIALIZED) {
        dopplerEndpointsBuildStage = STAGE_INITIALIZING;
        this.dopplerEndpoints = Objects.requireNonNull(ReactorDopplerClient.super.getDopplerEndpoints(), "dopplerEndpoints");
        dopplerEndpointsBuildStage = STAGE_INITIALIZED;
      }
      return this.dopplerEndpoints;
    }
    private HttpClient httpClient;
    private int httpClientBuildStage;

    HttpClient getHttpClient() {
      if (httpClientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (httpClientBuildStage == STAGE_UNINITIALIZED) {
        httpClientBuildStage = STAGE_INITIALIZING;
        this.httpClient = Objects.requireNonNull(ReactorDopplerClient.super.getHttpClient(), "httpClient");
        httpClientBuildStage = STAGE_INITIALIZED;
      }
      return this.httpClient;
    }

    void httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      httpClientBuildStage = STAGE_INITIALIZED;
    }
    private ObjectMapper objectMapper;
    private int objectMapperBuildStage;

    ObjectMapper getObjectMapper() {
      if (objectMapperBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMapperBuildStage == STAGE_UNINITIALIZED) {
        objectMapperBuildStage = STAGE_INITIALIZING;
        this.objectMapper = Objects.requireNonNull(ReactorDopplerClient.super.getObjectMapper(), "objectMapper");
        objectMapperBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMapper;
    }

    void objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = objectMapper;
      objectMapperBuildStage = STAGE_INITIALIZED;
    }
    private Mono<String> root;
    private int rootBuildStage;

    Mono<String> getRoot() {
      if (rootBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootBuildStage == STAGE_UNINITIALIZED) {
        rootBuildStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(ReactorDopplerClient.super.getRoot(), "root");
        rootBuildStage = STAGE_INITIALIZED;
      }
      return this.root;
    }

    void root(Mono<String> root) {
      this.root = root;
      rootBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (dopplerEndpointsBuildStage == STAGE_INITIALIZING) attributes.add("dopplerEndpoints");
      if (httpClientBuildStage == STAGE_INITIALIZING) attributes.add("httpClient");
      if (objectMapperBuildStage == STAGE_INITIALIZING) attributes.add("objectMapper");
      if (rootBuildStage == STAGE_INITIALIZING) attributes.add("root");
      return "Cannot build ReactorDopplerClient, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code connectionContext} attribute
   */
  @Override
  public @Nullable ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * @return The computed-at-construction value of the {@code dopplerEndpoints} attribute
   */
  @Override
  public ReactorDopplerEndpoints getDopplerEndpoints() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDopplerEndpoints()
        : this.dopplerEndpoints;
  }

  /**
   * @return The value of the {@code httpClient} attribute
   */
  @Override
  public HttpClient getHttpClient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHttpClient()
        : this.httpClient;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMapper()
        : this.objectMapper;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * @return The value of the {@code tokenProvider} attribute
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorDopplerClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorDopplerClient
        && equalTo((ReactorDopplerClient) another);
  }

  private boolean equalTo(ReactorDopplerClient another) {
    return Objects.equals(connectionContext, another.connectionContext)
        && dopplerEndpoints.equals(another.dopplerEndpoints)
        && httpClient.equals(another.httpClient)
        && objectMapper.equals(another.objectMapper)
        && root.equals(another.root)
        && tokenProvider.equals(another.tokenProvider);
  }

  /**
   * Computes a hash code from attributes: {@code connectionContext}, {@code dopplerEndpoints}, {@code httpClient}, {@code objectMapper}, {@code root}, {@code tokenProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(connectionContext);
    h = h * 17 + dopplerEndpoints.hashCode();
    h = h * 17 + httpClient.hashCode();
    h = h * 17 + objectMapper.hashCode();
    h = h * 17 + root.hashCode();
    h = h * 17 + tokenProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorDopplerClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorDopplerClient{"
        + "connectionContext=" + connectionContext
        + ", dopplerEndpoints=" + dopplerEndpoints
        + ", httpClient=" + httpClient
        + ", objectMapper=" + objectMapper
        + ", root=" + root
        + ", tokenProvider=" + tokenProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorDopplerClient ReactorDopplerClient}.
   * @return A new ReactorDopplerClient builder
   */
  public static ReactorDopplerClient.Builder builder() {
    return new ReactorDopplerClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorDopplerClient ReactorDopplerClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x1L;
    private long initBits = 0x1L;

    private ConnectionContext connectionContext;
    private HttpClient httpClient;
    private ObjectMapper objectMapper;
    private Mono<String> root;
    private TokenProvider tokenProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorDopplerClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorDopplerClient instance) {
      return from((_ReactorDopplerClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorDopplerClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorDopplerClient instance) {
      Objects.requireNonNull(instance, "instance");
      ConnectionContext connectionContextValue = instance.getConnectionContext();
      if (connectionContextValue != null) {
        connectionContext(connectionContextValue);
      }
      httpClient(instance.getHttpClient());
      objectMapper(instance.getObjectMapper());
      root(instance.getRoot());
      tokenProvider(instance.getTokenProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorDopplerClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(@Nullable ConnectionContext connectionContext) {
      this.connectionContext = connectionContext;
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorDopplerClient#getHttpClient() httpClient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorDopplerClient#getHttpClient() httpClient}.</em>
     * @param httpClient The value for httpClient 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpClient(HttpClient httpClient) {
      this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorDopplerClient#getObjectMapper() objectMapper} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorDopplerClient#getObjectMapper() objectMapper}.</em>
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorDopplerClient#getRoot() root} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorDopplerClient#getRoot() root}.</em>
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Mono<String> root) {
      this.root = Objects.requireNonNull(root, "root");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorDopplerClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ReactorDopplerClient ReactorDopplerClient}.
     * @return An immutable instance of ReactorDopplerClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorDopplerClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorDopplerClient(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorDopplerClient, some of required attributes are not set " + attributes;
    }
  }
}
