package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The OAuth Refresh Token Grant implementation of {@link TokenProvider}
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RefreshTokenGrantTokenProvider"})
public final class RefreshTokenGrantTokenProvider
    extends org.cloudfoundry.reactor.tokenprovider._RefreshTokenGrantTokenProvider {
  private final String token;
  private final String clientId;
  private final String clientSecret;

  private RefreshTokenGrantTokenProvider(RefreshTokenGrantTokenProvider.Builder builder) {
    this.token = builder.token;
    if (builder.clientId != null) {
      initShim.clientId(builder.clientId);
    }
    if (builder.clientSecret != null) {
      initShim.clientSecret(builder.clientSecret);
    }
    this.clientId = initShim.getClientId();
    this.clientSecret = initShim.getClientSecret();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String clientId;
    private int clientIdBuildStage;

    String getClientId() {
      if (clientIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientIdBuildStage == STAGE_UNINITIALIZED) {
        clientIdBuildStage = STAGE_INITIALIZING;
        this.clientId = Objects.requireNonNull(RefreshTokenGrantTokenProvider.super.getClientId(), "clientId");
        clientIdBuildStage = STAGE_INITIALIZED;
      }
      return this.clientId;
    }

    void clientId(String clientId) {
      this.clientId = clientId;
      clientIdBuildStage = STAGE_INITIALIZED;
    }
    private String clientSecret;
    private int clientSecretBuildStage;

    String getClientSecret() {
      if (clientSecretBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientSecretBuildStage == STAGE_UNINITIALIZED) {
        clientSecretBuildStage = STAGE_INITIALIZING;
        this.clientSecret = Objects.requireNonNull(RefreshTokenGrantTokenProvider.super.getClientSecret(), "clientSecret");
        clientSecretBuildStage = STAGE_INITIALIZED;
      }
      return this.clientSecret;
    }

    void clientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      clientSecretBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (clientIdBuildStage == STAGE_INITIALIZING) attributes.add("clientId");
      if (clientSecretBuildStage == STAGE_INITIALIZING) attributes.add("clientSecret");
      return "Cannot build RefreshTokenGrantTokenProvider, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * The refresh token
   */
  @Override
  public String getToken() {
    return token;
  }

  /**
   * The client id.  Defaults to {@code cf}.
   */
  @Override
  public String getClientId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientId()
        : this.clientId;
  }

  /**
   * The client secret Defaults to {@code ""}.
   */
  @Override
  public String getClientSecret() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientSecret()
        : this.clientSecret;
  }

  /**
   * This instance is equal to all instances of {@code RefreshTokenGrantTokenProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RefreshTokenGrantTokenProvider
        && equalTo((RefreshTokenGrantTokenProvider) another);
  }

  private boolean equalTo(RefreshTokenGrantTokenProvider another) {
    return token.equals(another.token)
        && clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code clientId}, {@code clientSecret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + token.hashCode();
    h = h * 17 + clientId.hashCode();
    h = h * 17 + clientSecret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RefreshTokenGrantTokenProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RefreshTokenGrantTokenProvider{"
        + "token=" + token
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + "}";
  }

  /**
   * Creates a builder for {@link RefreshTokenGrantTokenProvider RefreshTokenGrantTokenProvider}.
   * @return A new RefreshTokenGrantTokenProvider builder
   */
  public static RefreshTokenGrantTokenProvider.Builder builder() {
    return new RefreshTokenGrantTokenProvider.Builder();
  }

  /**
   * Builds instances of type {@link RefreshTokenGrantTokenProvider RefreshTokenGrantTokenProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private long initBits = 0x1L;

    private String token;
    private String clientId;
    private String clientSecret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUaaTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code RefreshTokenGrantTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RefreshTokenGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _RefreshTokenGrantTokenProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RefreshTokenGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractUaaTokenProvider) {
        AbstractUaaTokenProvider instance = (AbstractUaaTokenProvider) object;
        clientSecret(instance.getClientSecret());
        clientId(instance.getClientId());
      }
      if (object instanceof org.cloudfoundry.reactor.tokenprovider._RefreshTokenGrantTokenProvider) {
        org.cloudfoundry.reactor.tokenprovider._RefreshTokenGrantTokenProvider instance = (org.cloudfoundry.reactor.tokenprovider._RefreshTokenGrantTokenProvider) object;
        token(instance.getToken());
      }
    }

    /**
     * Initializes the value for the {@link _RefreshTokenGrantTokenProvider#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link _RefreshTokenGrantTokenProvider#getClientId() clientId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _RefreshTokenGrantTokenProvider#getClientId() clientId}.</em>
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      return this;
    }

    /**
     * Initializes the value for the {@link _RefreshTokenGrantTokenProvider#getClientSecret() clientSecret} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _RefreshTokenGrantTokenProvider#getClientSecret() clientSecret}.</em>
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      return this;
    }

    /**
     * Builds a new {@link RefreshTokenGrantTokenProvider RefreshTokenGrantTokenProvider}.
     * @return An immutable instance of RefreshTokenGrantTokenProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RefreshTokenGrantTokenProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RefreshTokenGrantTokenProvider(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      return "Cannot build RefreshTokenGrantTokenProvider, some of required attributes are not set " + attributes;
    }
  }
}
