package org.cloudfoundry.reactor.uaa;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.uaa.authorizations.Authorizations;
import org.cloudfoundry.uaa.clients.Clients;
import org.cloudfoundry.uaa.groups.Groups;
import org.cloudfoundry.uaa.identityproviders.IdentityProviders;
import org.cloudfoundry.uaa.identityzones.IdentityZones;
import org.cloudfoundry.uaa.tokens.Tokens;
import org.cloudfoundry.uaa.users.Users;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;

/**
 * The Reactor-based implementation of {@link UaaClient}
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ReactorUaaClient"})
public final class ReactorUaaClient extends org.cloudfoundry.reactor.uaa._ReactorUaaClient {
  private final Authorizations authorizations;
  private final Clients clients;
  private final Mono<String> username;
  private final Groups groups;
  private final IdentityProviders identityProviders;
  private final IdentityZones identityZones;
  private final Tokens tokens;
  private final Users users;
  private final @Nullable ConnectionContext connectionContext;
  private final HttpClient httpClient;
  private final ObjectMapper objectMapper;
  private final Mono<String> root;
  private final TokenProvider tokenProvider;
  private final UsernameProvider usernameProvider;

  private ReactorUaaClient(ReactorUaaClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.tokenProvider = builder.tokenProvider;
    if (builder.httpClient != null) {
      initShim.httpClient(builder.httpClient);
    }
    if (builder.objectMapper != null) {
      initShim.objectMapper(builder.objectMapper);
    }
    if (builder.root != null) {
      initShim.root(builder.root);
    }
    if (builder.usernameProvider != null) {
      initShim.usernameProvider(builder.usernameProvider);
    }
    this.httpClient = initShim.getHttpClient();
    this.objectMapper = initShim.getObjectMapper();
    this.root = initShim.getRoot();
    this.usernameProvider = initShim.getUsernameProvider();
    this.authorizations = initShim.authorizations();
    this.clients = initShim.clients();
    this.username = initShim.getUsername();
    this.groups = initShim.groups();
    this.identityProviders = initShim.identityProviders();
    this.identityZones = initShim.identityZones();
    this.tokens = initShim.tokens();
    this.users = initShim.users();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private Authorizations authorizations;
    private int authorizationsBuildStage;

    Authorizations authorizations() {
      if (authorizationsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (authorizationsBuildStage == STAGE_UNINITIALIZED) {
        authorizationsBuildStage = STAGE_INITIALIZING;
        this.authorizations = Objects.requireNonNull(ReactorUaaClient.super.authorizations(), "authorizations");
        authorizationsBuildStage = STAGE_INITIALIZED;
      }
      return this.authorizations;
    }
    private Clients clients;
    private int clientsBuildStage;

    Clients clients() {
      if (clientsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientsBuildStage == STAGE_UNINITIALIZED) {
        clientsBuildStage = STAGE_INITIALIZING;
        this.clients = Objects.requireNonNull(ReactorUaaClient.super.clients(), "clients");
        clientsBuildStage = STAGE_INITIALIZED;
      }
      return this.clients;
    }
    private Mono<String> username;
    private int usernameBuildStage;

    Mono<String> getUsername() {
      if (usernameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usernameBuildStage == STAGE_UNINITIALIZED) {
        usernameBuildStage = STAGE_INITIALIZING;
        this.username = Objects.requireNonNull(ReactorUaaClient.super.getUsername(), "username");
        usernameBuildStage = STAGE_INITIALIZED;
      }
      return this.username;
    }
    private Groups groups;
    private int groupsBuildStage;

    Groups groups() {
      if (groupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (groupsBuildStage == STAGE_UNINITIALIZED) {
        groupsBuildStage = STAGE_INITIALIZING;
        this.groups = Objects.requireNonNull(ReactorUaaClient.super.groups(), "groups");
        groupsBuildStage = STAGE_INITIALIZED;
      }
      return this.groups;
    }
    private IdentityProviders identityProviders;
    private int identityProvidersBuildStage;

    IdentityProviders identityProviders() {
      if (identityProvidersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (identityProvidersBuildStage == STAGE_UNINITIALIZED) {
        identityProvidersBuildStage = STAGE_INITIALIZING;
        this.identityProviders = Objects.requireNonNull(ReactorUaaClient.super.identityProviders(), "identityProviders");
        identityProvidersBuildStage = STAGE_INITIALIZED;
      }
      return this.identityProviders;
    }
    private IdentityZones identityZones;
    private int identityZonesBuildStage;

    IdentityZones identityZones() {
      if (identityZonesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (identityZonesBuildStage == STAGE_UNINITIALIZED) {
        identityZonesBuildStage = STAGE_INITIALIZING;
        this.identityZones = Objects.requireNonNull(ReactorUaaClient.super.identityZones(), "identityZones");
        identityZonesBuildStage = STAGE_INITIALIZED;
      }
      return this.identityZones;
    }
    private Tokens tokens;
    private int tokensBuildStage;

    Tokens tokens() {
      if (tokensBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tokensBuildStage == STAGE_UNINITIALIZED) {
        tokensBuildStage = STAGE_INITIALIZING;
        this.tokens = Objects.requireNonNull(ReactorUaaClient.super.tokens(), "tokens");
        tokensBuildStage = STAGE_INITIALIZED;
      }
      return this.tokens;
    }
    private Users users;
    private int usersBuildStage;

    Users users() {
      if (usersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usersBuildStage == STAGE_UNINITIALIZED) {
        usersBuildStage = STAGE_INITIALIZING;
        this.users = Objects.requireNonNull(ReactorUaaClient.super.users(), "users");
        usersBuildStage = STAGE_INITIALIZED;
      }
      return this.users;
    }
    private HttpClient httpClient;
    private int httpClientBuildStage;

    HttpClient getHttpClient() {
      if (httpClientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (httpClientBuildStage == STAGE_UNINITIALIZED) {
        httpClientBuildStage = STAGE_INITIALIZING;
        this.httpClient = Objects.requireNonNull(ReactorUaaClient.super.getHttpClient(), "httpClient");
        httpClientBuildStage = STAGE_INITIALIZED;
      }
      return this.httpClient;
    }

    void httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      httpClientBuildStage = STAGE_INITIALIZED;
    }
    private ObjectMapper objectMapper;
    private int objectMapperBuildStage;

    ObjectMapper getObjectMapper() {
      if (objectMapperBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMapperBuildStage == STAGE_UNINITIALIZED) {
        objectMapperBuildStage = STAGE_INITIALIZING;
        this.objectMapper = Objects.requireNonNull(ReactorUaaClient.super.getObjectMapper(), "objectMapper");
        objectMapperBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMapper;
    }

    void objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = objectMapper;
      objectMapperBuildStage = STAGE_INITIALIZED;
    }
    private Mono<String> root;
    private int rootBuildStage;

    Mono<String> getRoot() {
      if (rootBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootBuildStage == STAGE_UNINITIALIZED) {
        rootBuildStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(ReactorUaaClient.super.getRoot(), "root");
        rootBuildStage = STAGE_INITIALIZED;
      }
      return this.root;
    }

    void root(Mono<String> root) {
      this.root = root;
      rootBuildStage = STAGE_INITIALIZED;
    }
    private UsernameProvider usernameProvider;
    private int usernameProviderBuildStage;

    UsernameProvider getUsernameProvider() {
      if (usernameProviderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usernameProviderBuildStage == STAGE_UNINITIALIZED) {
        usernameProviderBuildStage = STAGE_INITIALIZING;
        this.usernameProvider = Objects.requireNonNull(ReactorUaaClient.super.getUsernameProvider(), "usernameProvider");
        usernameProviderBuildStage = STAGE_INITIALIZED;
      }
      return this.usernameProvider;
    }

    void usernameProvider(UsernameProvider usernameProvider) {
      this.usernameProvider = usernameProvider;
      usernameProviderBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (authorizationsBuildStage == STAGE_INITIALIZING) attributes.add("authorizations");
      if (clientsBuildStage == STAGE_INITIALIZING) attributes.add("clients");
      if (usernameBuildStage == STAGE_INITIALIZING) attributes.add("username");
      if (groupsBuildStage == STAGE_INITIALIZING) attributes.add("groups");
      if (identityProvidersBuildStage == STAGE_INITIALIZING) attributes.add("identityProviders");
      if (identityZonesBuildStage == STAGE_INITIALIZING) attributes.add("identityZones");
      if (tokensBuildStage == STAGE_INITIALIZING) attributes.add("tokens");
      if (usersBuildStage == STAGE_INITIALIZING) attributes.add("users");
      if (httpClientBuildStage == STAGE_INITIALIZING) attributes.add("httpClient");
      if (objectMapperBuildStage == STAGE_INITIALIZING) attributes.add("objectMapper");
      if (rootBuildStage == STAGE_INITIALIZING) attributes.add("root");
      if (usernameProviderBuildStage == STAGE_INITIALIZING) attributes.add("usernameProvider");
      return "Cannot build ReactorUaaClient, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code authorizations} attribute
   */
  @Override
  public Authorizations authorizations() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.authorizations()
        : this.authorizations;
  }

  /**
   * @return The computed-at-construction value of the {@code clients} attribute
   */
  @Override
  public Clients clients() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.clients()
        : this.clients;
  }

  /**
   * @return The computed-at-construction value of the {@code username} attribute
   */
  @Override
  public Mono<String> getUsername() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsername()
        : this.username;
  }

  /**
   * @return The computed-at-construction value of the {@code groups} attribute
   */
  @Override
  public Groups groups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.groups()
        : this.groups;
  }

  /**
   * @return The computed-at-construction value of the {@code identityProviders} attribute
   */
  @Override
  public IdentityProviders identityProviders() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.identityProviders()
        : this.identityProviders;
  }

  /**
   * @return The computed-at-construction value of the {@code identityZones} attribute
   */
  @Override
  public IdentityZones identityZones() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.identityZones()
        : this.identityZones;
  }

  /**
   * @return The computed-at-construction value of the {@code tokens} attribute
   */
  @Override
  public Tokens tokens() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tokens()
        : this.tokens;
  }

  /**
   * @return The computed-at-construction value of the {@code users} attribute
   */
  @Override
  public Users users() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.users()
        : this.users;
  }

  /**
   * @return The value of the {@code connectionContext} attribute
   */
  @Override
  public @Nullable ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * @return The value of the {@code httpClient} attribute
   */
  @Override
  public HttpClient getHttpClient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHttpClient()
        : this.httpClient;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMapper()
        : this.objectMapper;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * @return The value of the {@code tokenProvider} attribute
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * @return The value of the {@code usernameProvider} attribute
   */
  @Override
  public UsernameProvider getUsernameProvider() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsernameProvider()
        : this.usernameProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorUaaClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorUaaClient
        && equalTo((ReactorUaaClient) another);
  }

  private boolean equalTo(ReactorUaaClient another) {
    return authorizations.equals(another.authorizations)
        && clients.equals(another.clients)
        && username.equals(another.username)
        && groups.equals(another.groups)
        && identityProviders.equals(another.identityProviders)
        && identityZones.equals(another.identityZones)
        && tokens.equals(another.tokens)
        && users.equals(another.users)
        && Objects.equals(connectionContext, another.connectionContext)
        && httpClient.equals(another.httpClient)
        && objectMapper.equals(another.objectMapper)
        && root.equals(another.root)
        && tokenProvider.equals(another.tokenProvider)
        && usernameProvider.equals(another.usernameProvider);
  }

  /**
   * Computes a hash code from attributes: {@code authorizations}, {@code clients}, {@code username}, {@code groups}, {@code identityProviders}, {@code identityZones}, {@code tokens}, {@code users}, {@code connectionContext}, {@code httpClient}, {@code objectMapper}, {@code root}, {@code tokenProvider}, {@code usernameProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + authorizations.hashCode();
    h = h * 17 + clients.hashCode();
    h = h * 17 + username.hashCode();
    h = h * 17 + groups.hashCode();
    h = h * 17 + identityProviders.hashCode();
    h = h * 17 + identityZones.hashCode();
    h = h * 17 + tokens.hashCode();
    h = h * 17 + users.hashCode();
    h = h * 17 + Objects.hashCode(connectionContext);
    h = h * 17 + httpClient.hashCode();
    h = h * 17 + objectMapper.hashCode();
    h = h * 17 + root.hashCode();
    h = h * 17 + tokenProvider.hashCode();
    h = h * 17 + usernameProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorUaaClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorUaaClient{"
        + "authorizations=" + authorizations
        + ", clients=" + clients
        + ", username=" + username
        + ", groups=" + groups
        + ", identityProviders=" + identityProviders
        + ", identityZones=" + identityZones
        + ", tokens=" + tokens
        + ", users=" + users
        + ", connectionContext=" + connectionContext
        + ", httpClient=" + httpClient
        + ", objectMapper=" + objectMapper
        + ", root=" + root
        + ", tokenProvider=" + tokenProvider
        + ", usernameProvider=" + usernameProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorUaaClient ReactorUaaClient}.
   * @return A new ReactorUaaClient builder
   */
  public static ReactorUaaClient.Builder builder() {
    return new ReactorUaaClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorUaaClient ReactorUaaClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x1L;
    private long initBits = 0x1L;

    private ConnectionContext connectionContext;
    private HttpClient httpClient;
    private ObjectMapper objectMapper;
    private Mono<String> root;
    private TokenProvider tokenProvider;
    private UsernameProvider usernameProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorUaaClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorUaaClient instance) {
      return from((_ReactorUaaClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorUaaClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorUaaClient instance) {
      Objects.requireNonNull(instance, "instance");
      ConnectionContext connectionContextValue = instance.getConnectionContext();
      if (connectionContextValue != null) {
        connectionContext(connectionContextValue);
      }
      httpClient(instance.getHttpClient());
      objectMapper(instance.getObjectMapper());
      root(instance.getRoot());
      tokenProvider(instance.getTokenProvider());
      usernameProvider(instance.getUsernameProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorUaaClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(@Nullable ConnectionContext connectionContext) {
      this.connectionContext = connectionContext;
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorUaaClient#getHttpClient() httpClient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorUaaClient#getHttpClient() httpClient}.</em>
     * @param httpClient The value for httpClient 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpClient(HttpClient httpClient) {
      this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorUaaClient#getObjectMapper() objectMapper} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorUaaClient#getObjectMapper() objectMapper}.</em>
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorUaaClient#getRoot() root} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorUaaClient#getRoot() root}.</em>
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Mono<String> root) {
      this.root = Objects.requireNonNull(root, "root");
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorUaaClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Initializes the value for the {@link _ReactorUaaClient#getUsernameProvider() usernameProvider} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link _ReactorUaaClient#getUsernameProvider() usernameProvider}.</em>
     * @param usernameProvider The value for usernameProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder usernameProvider(UsernameProvider usernameProvider) {
      this.usernameProvider = Objects.requireNonNull(usernameProvider, "usernameProvider");
      return this;
    }

    /**
     * Builds a new {@link ReactorUaaClient ReactorUaaClient}.
     * @return An immutable instance of ReactorUaaClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorUaaClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorUaaClient(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorUaaClient, some of required attributes are not set " + attributes;
    }
  }
}
