package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * A {@link RootProvider} that returns endpoints by delegating to an {@link RootPayloadRootProvider} and then an {@link InfoPayloadRootProvider}.
 */
@Generated(from = "_DelegatingRootProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DelegatingRootProvider extends org.cloudfoundry.reactor._DelegatingRootProvider {
  private transient final InfoPayloadRootProvider infoPayloadRootProvider;
  private final ObjectMapper objectMapper;
  private transient final RootPayloadRootProvider rootPayloadRootProvider;
  private final String apiHost;
  private final Integer port;
  private final Boolean secure;

  private DelegatingRootProvider(DelegatingRootProvider.Builder builder) {
    this.objectMapper = builder.objectMapper;
    this.apiHost = builder.apiHost;
    this.port = builder.port;
    this.secure = builder.secure;
    this.infoPayloadRootProvider = initShim.getInfoPayloadRootProvider();
    this.rootPayloadRootProvider = initShim.getRootPayloadRootProvider();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_DelegatingRootProvider", generator = "Immutables")
  private final class InitShim {
    private byte infoPayloadRootProviderBuildStage = STAGE_UNINITIALIZED;
    private InfoPayloadRootProvider infoPayloadRootProvider;

    InfoPayloadRootProvider getInfoPayloadRootProvider() {
      if (infoPayloadRootProviderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (infoPayloadRootProviderBuildStage == STAGE_UNINITIALIZED) {
        infoPayloadRootProviderBuildStage = STAGE_INITIALIZING;
        this.infoPayloadRootProvider = Objects.requireNonNull(DelegatingRootProvider.super.getInfoPayloadRootProvider(), "infoPayloadRootProvider");
        infoPayloadRootProviderBuildStage = STAGE_INITIALIZED;
      }
      return this.infoPayloadRootProvider;
    }

    private byte rootPayloadRootProviderBuildStage = STAGE_UNINITIALIZED;
    private RootPayloadRootProvider rootPayloadRootProvider;

    RootPayloadRootProvider getRootPayloadRootProvider() {
      if (rootPayloadRootProviderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootPayloadRootProviderBuildStage == STAGE_UNINITIALIZED) {
        rootPayloadRootProviderBuildStage = STAGE_INITIALIZING;
        this.rootPayloadRootProvider = Objects.requireNonNull(DelegatingRootProvider.super.getRootPayloadRootProvider(), "rootPayloadRootProvider");
        rootPayloadRootProviderBuildStage = STAGE_INITIALIZED;
      }
      return this.rootPayloadRootProvider;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (infoPayloadRootProviderBuildStage == STAGE_INITIALIZING) attributes.add("infoPayloadRootProvider");
      if (rootPayloadRootProviderBuildStage == STAGE_INITIALIZING) attributes.add("rootPayloadRootProvider");
      return "Cannot build DelegatingRootProvider, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code infoPayloadRootProvider} attribute
   */
  @Override
  public InfoPayloadRootProvider getInfoPayloadRootProvider() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInfoPayloadRootProvider()
        : this.infoPayloadRootProvider;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    return objectMapper;
  }

  /**
   * @return The computed-at-construction value of the {@code rootPayloadRootProvider} attribute
   */
  @Override
  public RootPayloadRootProvider getRootPayloadRootProvider() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRootPayloadRootProvider()
        : this.rootPayloadRootProvider;
  }

  /**
   * The hostname of the API root. Typically something like {@code api.run.pivotal.io}.
   */
  @Override
  public String getApiHost() {
    return apiHost;
  }

  /**
   * The port for the Cloud Foundry instance. Defaults to {@code 443}.
   */
  @Override
  public Optional<Integer> getPort() {
    return Optional.ofNullable(port);
  }

  /**
   * Whether the connection to the root API should be secure (i.e. using HTTPS). Defaults to {@code true}.
   */
  @Override
  public Optional<Boolean> getSecure() {
    return Optional.ofNullable(secure);
  }

  /**
   * This instance is equal to all instances of {@code DelegatingRootProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DelegatingRootProvider
        && equalTo((DelegatingRootProvider) another);
  }

  private boolean equalTo(DelegatingRootProvider another) {
    return infoPayloadRootProvider.equals(another.infoPayloadRootProvider)
        && objectMapper.equals(another.objectMapper)
        && rootPayloadRootProvider.equals(another.rootPayloadRootProvider)
        && apiHost.equals(another.apiHost)
        && Objects.equals(port, another.port)
        && Objects.equals(secure, another.secure);
  }

  /**
   * Computes a hash code from attributes: {@code infoPayloadRootProvider}, {@code objectMapper}, {@code rootPayloadRootProvider}, {@code apiHost}, {@code port}, {@code secure}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + infoPayloadRootProvider.hashCode();
    h += (h << 5) + objectMapper.hashCode();
    h += (h << 5) + rootPayloadRootProvider.hashCode();
    h += (h << 5) + apiHost.hashCode();
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(secure);
    return h;
  }

  /**
   * Prints the immutable value {@code DelegatingRootProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DelegatingRootProvider{");
    builder.append("infoPayloadRootProvider=").append(infoPayloadRootProvider);
    builder.append(", ");
    builder.append("objectMapper=").append(objectMapper);
    builder.append(", ");
    builder.append("rootPayloadRootProvider=").append(rootPayloadRootProvider);
    builder.append(", ");
    builder.append("apiHost=").append(apiHost);
    if (port != null) {
      builder.append(", ");
      builder.append("port=").append(port);
    }
    if (secure != null) {
      builder.append(", ");
      builder.append("secure=").append(secure);
    }
    return builder.append("}").toString();
  }

  private static DelegatingRootProvider validate(DelegatingRootProvider instance) {
    instance.checkForValidApiHost();
    return instance;
  }

  /**
   * Creates a builder for {@link DelegatingRootProvider DelegatingRootProvider}.
   * <pre>
   * DelegatingRootProvider.builder()
   *    .objectMapper(com.fasterxml.jackson.databind.ObjectMapper) // required {@link DelegatingRootProvider#getObjectMapper() objectMapper}
   *    .apiHost(String) // required {@link DelegatingRootProvider#getApiHost() apiHost}
   *    .port(Integer) // optional {@link DelegatingRootProvider#getPort() port}
   *    .secure(Boolean) // optional {@link DelegatingRootProvider#getSecure() secure}
   *    .build();
   * </pre>
   * @return A new DelegatingRootProvider builder
   */
  public static DelegatingRootProvider.Builder builder() {
    return new DelegatingRootProvider.Builder();
  }

  /**
   * Builds instances of type {@link DelegatingRootProvider DelegatingRootProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DelegatingRootProvider", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_OBJECT_MAPPER = 0x1L;
    private static final long INIT_BIT_API_HOST = 0x2L;
    private long initBits = 0x3L;

    private ObjectMapper objectMapper;
    private String apiHost;
    private Integer port;
    private Boolean secure;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.AbstractRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DelegatingRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DelegatingRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DelegatingRootProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_DelegatingRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractRootProvider) {
        AbstractRootProvider instance = (AbstractRootProvider) object;
        Optional<Boolean> secureOptional = instance.getSecure();
        if (secureOptional.isPresent()) {
          secure(secureOptional);
        }
        Optional<Integer> portOptional = instance.getPort();
        if (portOptional.isPresent()) {
          port(portOptional);
        }
        apiHost(instance.getApiHost());
      }
      if (object instanceof org.cloudfoundry.reactor._DelegatingRootProvider) {
        org.cloudfoundry.reactor._DelegatingRootProvider instance = (org.cloudfoundry.reactor._DelegatingRootProvider) object;
        objectMapper(instance.getObjectMapper());
      }
    }

    /**
     * Initializes the value for the {@link DelegatingRootProvider#getObjectMapper() objectMapper} attribute.
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      initBits &= ~INIT_BIT_OBJECT_MAPPER;
      return this;
    }

    /**
     * Initializes the value for the {@link DelegatingRootProvider#getApiHost() apiHost} attribute.
     * @param apiHost The value for apiHost 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apiHost(String apiHost) {
      this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
      initBits &= ~INIT_BIT_API_HOST;
      return this;
    }

    /**
     * Initializes the optional value {@link DelegatingRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the optional value {@link DelegatingRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = port.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DelegatingRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for chained invocation
     */
    public final Builder secure(boolean secure) {
      this.secure = secure;
      return this;
    }

    /**
     * Initializes the optional value {@link DelegatingRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secure(Optional<Boolean> secure) {
      this.secure = secure.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link DelegatingRootProvider DelegatingRootProvider}.
     * @return An immutable instance of DelegatingRootProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DelegatingRootProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return DelegatingRootProvider.validate(new DelegatingRootProvider(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OBJECT_MAPPER) != 0) attributes.add("objectMapper");
      if ((initBits & INIT_BIT_API_HOST) != 0) attributes.add("apiHost");
      return "Cannot build DelegatingRootProvider, some of required attributes are not set " + attributes;
    }
  }
}
