package org.cloudfoundry.reactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientResponse;

/**
 * Immutable implementation of {@link _HttpClientResponseWithBody}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code HttpClientResponseWithBody.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code HttpClientResponseWithBody.of()}.
 */
@Generated(from = "_HttpClientResponseWithBody", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class HttpClientResponseWithBody implements org.cloudfoundry.reactor._HttpClientResponseWithBody {
  private final ByteBufFlux body;
  private final HttpClientResponse response;

  private HttpClientResponseWithBody(ByteBufFlux body, HttpClientResponse response) {
    this.body = Objects.requireNonNull(body, "body");
    this.response = Objects.requireNonNull(response, "response");
  }

  private HttpClientResponseWithBody(HttpClientResponseWithBody.Builder builder) {
    this.body = builder.body;
    this.response = builder.response;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @Override
  public ByteBufFlux getBody() {
    return body;
  }

  /**
   * @return The value of the {@code response} attribute
   */
  @Override
  public HttpClientResponse getResponse() {
    return response;
  }

  /**
   * This instance is equal to all instances of {@code HttpClientResponseWithBody} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof HttpClientResponseWithBody
        && equalTo((HttpClientResponseWithBody) another);
  }

  private boolean equalTo(HttpClientResponseWithBody another) {
    return body.equals(another.body)
        && response.equals(another.response);
  }

  /**
   * Computes a hash code from attributes: {@code body}, {@code response}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + body.hashCode();
    h += (h << 5) + response.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpClientResponseWithBody} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HttpClientResponseWithBody{"
        + "body=" + body
        + ", response=" + response
        + "}";
  }

  /**
   * Construct a new immutable {@code HttpClientResponseWithBody} instance.
   * @param body The value for the {@code body} attribute
   * @param response The value for the {@code response} attribute
   * @return An immutable HttpClientResponseWithBody instance
   */
  public static HttpClientResponseWithBody of(ByteBufFlux body, HttpClientResponse response) {
    return new HttpClientResponseWithBody(body, response);
  }

  /**
   * Creates a builder for {@link HttpClientResponseWithBody HttpClientResponseWithBody}.
   * <pre>
   * HttpClientResponseWithBody.builder()
   *    .body(reactor.netty.ByteBufFlux) // required {@link _HttpClientResponseWithBody#getBody() body}
   *    .response(reactor.netty.http.client.HttpClientResponse) // required {@link _HttpClientResponseWithBody#getResponse() response}
   *    .build();
   * </pre>
   * @return A new HttpClientResponseWithBody builder
   */
  public static HttpClientResponseWithBody.Builder builder() {
    return new HttpClientResponseWithBody.Builder();
  }

  /**
   * Builds instances of type {@link HttpClientResponseWithBody HttpClientResponseWithBody}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_HttpClientResponseWithBody", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BODY = 0x1L;
    private static final long INIT_BIT_RESPONSE = 0x2L;
    private long initBits = 0x3L;

    private ByteBufFlux body;
    private HttpClientResponse response;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _HttpClientResponseWithBody} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_HttpClientResponseWithBody instance) {
      Objects.requireNonNull(instance, "instance");
      body(instance.getBody());
      response(instance.getResponse());
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpClientResponseWithBody#getBody() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder body(ByteBufFlux body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpClientResponseWithBody#getResponse() response} attribute.
     * @param response The value for response 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder response(HttpClientResponse response) {
      this.response = Objects.requireNonNull(response, "response");
      initBits &= ~INIT_BIT_RESPONSE;
      return this;
    }

    /**
     * Builds a new {@link HttpClientResponseWithBody HttpClientResponseWithBody}.
     * @return An immutable instance of HttpClientResponseWithBody
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HttpClientResponseWithBody build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new HttpClientResponseWithBody(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      if ((initBits & INIT_BIT_RESPONSE) != 0) attributes.add("response");
      return "Cannot build HttpClientResponseWithBody, some of required attributes are not set " + attributes;
    }
  }
}
