package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The One-time Passcode Password Grant implementation of {@link TokenProvider}
 */
@Generated(from = "_OneTimePasscodeTokenProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OneTimePasscodeTokenProvider
    extends org.cloudfoundry.reactor.tokenprovider._OneTimePasscodeTokenProvider {
  private final String passcode;
  private final String clientId;
  private final String clientSecret;
  private final @Nullable String identityZoneSubdomain;

  private OneTimePasscodeTokenProvider(OneTimePasscodeTokenProvider.Builder builder) {
    this.passcode = builder.passcode;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    if (builder.clientId != null) {
      initShim.clientId(builder.clientId);
    }
    if (builder.clientSecret != null) {
      initShim.clientSecret(builder.clientSecret);
    }
    this.clientId = initShim.getClientId();
    this.clientSecret = initShim.getClientSecret();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_OneTimePasscodeTokenProvider", generator = "Immutables")
  private final class InitShim {
    private byte clientIdBuildStage = STAGE_UNINITIALIZED;
    private String clientId;

    String getClientId() {
      if (clientIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientIdBuildStage == STAGE_UNINITIALIZED) {
        clientIdBuildStage = STAGE_INITIALIZING;
        this.clientId = Objects.requireNonNull(OneTimePasscodeTokenProvider.super.getClientId(), "clientId");
        clientIdBuildStage = STAGE_INITIALIZED;
      }
      return this.clientId;
    }

    void clientId(String clientId) {
      this.clientId = clientId;
      clientIdBuildStage = STAGE_INITIALIZED;
    }

    private byte clientSecretBuildStage = STAGE_UNINITIALIZED;
    private String clientSecret;

    String getClientSecret() {
      if (clientSecretBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientSecretBuildStage == STAGE_UNINITIALIZED) {
        clientSecretBuildStage = STAGE_INITIALIZING;
        this.clientSecret = Objects.requireNonNull(OneTimePasscodeTokenProvider.super.getClientSecret(), "clientSecret");
        clientSecretBuildStage = STAGE_INITIALIZED;
      }
      return this.clientSecret;
    }

    void clientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      clientSecretBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (clientIdBuildStage == STAGE_INITIALIZING) attributes.add("clientId");
      if (clientSecretBuildStage == STAGE_INITIALIZING) attributes.add("clientSecret");
      return "Cannot build OneTimePasscodeTokenProvider, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The passcode
   */
  @Override
  public String getPasscode() {
    return passcode;
  }

  /**
   * The client id. Defaults to {@code cf}.
   */
  @Override
  public String getClientId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientId()
        : this.clientId;
  }

  /**
   * The client secret. Defaults to {@code ""}.
   */
  @Override
  public String getClientSecret() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientSecret()
        : this.clientSecret;
  }

  /**
   * The identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code OneTimePasscodeTokenProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OneTimePasscodeTokenProvider
        && equalTo((OneTimePasscodeTokenProvider) another);
  }

  private boolean equalTo(OneTimePasscodeTokenProvider another) {
    return passcode.equals(another.passcode)
        && clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code passcode}, {@code clientId}, {@code clientSecret}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + passcode.hashCode();
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + clientSecret.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code OneTimePasscodeTokenProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OneTimePasscodeTokenProvider{"
        + "passcode=" + passcode
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Creates a builder for {@link OneTimePasscodeTokenProvider OneTimePasscodeTokenProvider}.
   * <pre>
   * OneTimePasscodeTokenProvider.builder()
   *    .passcode(String) // required {@link OneTimePasscodeTokenProvider#getPasscode() passcode}
   *    .clientId(String) // optional {@link OneTimePasscodeTokenProvider#getClientId() clientId}
   *    .clientSecret(String) // optional {@link OneTimePasscodeTokenProvider#getClientSecret() clientSecret}
   *    .identityZoneSubdomain(String | null) // nullable {@link OneTimePasscodeTokenProvider#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .build();
   * </pre>
   * @return A new OneTimePasscodeTokenProvider builder
   */
  public static OneTimePasscodeTokenProvider.Builder builder() {
    return new OneTimePasscodeTokenProvider.Builder();
  }

  /**
   * Builds instances of type {@link OneTimePasscodeTokenProvider OneTimePasscodeTokenProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OneTimePasscodeTokenProvider", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PASSCODE = 0x1L;
    private long initBits = 0x1L;

    private String passcode;
    private String clientId;
    private String clientSecret;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OneTimePasscodeTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OneTimePasscodeTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _OneTimePasscodeTokenProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_OneTimePasscodeTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUaaTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.reactor.tokenprovider._OneTimePasscodeTokenProvider) {
        org.cloudfoundry.reactor.tokenprovider._OneTimePasscodeTokenProvider instance = (org.cloudfoundry.reactor.tokenprovider._OneTimePasscodeTokenProvider) object;
        passcode(instance.getPasscode());
      }
      if (object instanceof AbstractUaaTokenProvider) {
        AbstractUaaTokenProvider instance = (AbstractUaaTokenProvider) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        clientSecret(instance.getClientSecret());
        clientId(instance.getClientId());
      }
    }

    /**
     * Initializes the value for the {@link OneTimePasscodeTokenProvider#getPasscode() passcode} attribute.
     * @param passcode The value for passcode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passcode(String passcode) {
      this.passcode = Objects.requireNonNull(passcode, "passcode");
      initBits &= ~INIT_BIT_PASSCODE;
      return this;
    }

    /**
     * Initializes the value for the {@link OneTimePasscodeTokenProvider#getClientId() clientId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OneTimePasscodeTokenProvider#getClientId() clientId}.</em>
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      return this;
    }

    /**
     * Initializes the value for the {@link OneTimePasscodeTokenProvider#getClientSecret() clientSecret} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OneTimePasscodeTokenProvider#getClientSecret() clientSecret}.</em>
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      return this;
    }

    /**
     * Initializes the value for the {@link OneTimePasscodeTokenProvider#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link OneTimePasscodeTokenProvider OneTimePasscodeTokenProvider}.
     * @return An immutable instance of OneTimePasscodeTokenProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OneTimePasscodeTokenProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OneTimePasscodeTokenProvider(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PASSCODE) != 0) attributes.add("passcode");
      return "Cannot build OneTimePasscodeTokenProvider, some of required attributes are not set " + attributes;
    }
  }
}
