package org.cloudfoundry.reactor.uaa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.uaa.authorizations.Authorizations;
import org.cloudfoundry.uaa.clients.Clients;
import org.cloudfoundry.uaa.groups.Groups;
import org.cloudfoundry.uaa.identityproviders.IdentityProviders;
import org.cloudfoundry.uaa.identityzones.IdentityZones;
import org.cloudfoundry.uaa.serverinformation.ServerInformation;
import org.cloudfoundry.uaa.tokens.Tokens;
import org.cloudfoundry.uaa.users.Users;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

/**
 * The Reactor-based implementation of {@link UaaClient}
 */
@Generated(from = "_ReactorUaaClient", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ReactorUaaClient extends org.cloudfoundry.reactor.uaa._ReactorUaaClient {
  private transient final Authorizations authorizations;
  private transient final Clients clients;
  private transient final Mono<String> username;
  private transient final Groups groups;
  private transient final IdentityProviders identityProviders;
  private transient final IdentityZones identityZones;
  private transient final ServerInformation serverInformation;
  private transient final Tokens tokens;
  private transient final Users users;
  private final ConnectionContext connectionContext;
  private final @Nullable String identityZoneSubdomain;
  private final Map<String, String> requestTags;
  private final Mono<String> root;
  private final TokenProvider tokenProvider;
  private final UsernameProvider usernameProvider;

  private ReactorUaaClient(ReactorUaaClient.Builder builder) {
    this.connectionContext = builder.connectionContext;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.tokenProvider = builder.tokenProvider;
    if (builder.requestTagsIsSet()) {
      initShim.requestTags(createUnmodifiableMap(false, false, builder.requestTags));
    }
    if (builder.root != null) {
      initShim.root(builder.root);
    }
    if (builder.usernameProvider != null) {
      initShim.usernameProvider(builder.usernameProvider);
    }
    this.authorizations = initShim.authorizations();
    this.clients = initShim.clients();
    this.username = initShim.getUsername();
    this.groups = initShim.groups();
    this.identityProviders = initShim.identityProviders();
    this.identityZones = initShim.identityZones();
    this.serverInformation = initShim.serverInformation();
    this.tokens = initShim.tokens();
    this.users = initShim.users();
    this.requestTags = initShim.getRequestTags();
    this.root = initShim.getRoot();
    this.usernameProvider = initShim.getUsernameProvider();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_ReactorUaaClient", generator = "Immutables")
  private final class InitShim {
    private byte authorizationsBuildStage = STAGE_UNINITIALIZED;
    private Authorizations authorizations;

    Authorizations authorizations() {
      if (authorizationsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (authorizationsBuildStage == STAGE_UNINITIALIZED) {
        authorizationsBuildStage = STAGE_INITIALIZING;
        this.authorizations = Objects.requireNonNull(ReactorUaaClient.super.authorizations(), "authorizations");
        authorizationsBuildStage = STAGE_INITIALIZED;
      }
      return this.authorizations;
    }

    private byte clientsBuildStage = STAGE_UNINITIALIZED;
    private Clients clients;

    Clients clients() {
      if (clientsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientsBuildStage == STAGE_UNINITIALIZED) {
        clientsBuildStage = STAGE_INITIALIZING;
        this.clients = Objects.requireNonNull(ReactorUaaClient.super.clients(), "clients");
        clientsBuildStage = STAGE_INITIALIZED;
      }
      return this.clients;
    }

    private byte usernameBuildStage = STAGE_UNINITIALIZED;
    private Mono<String> username;

    Mono<String> getUsername() {
      if (usernameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usernameBuildStage == STAGE_UNINITIALIZED) {
        usernameBuildStage = STAGE_INITIALIZING;
        this.username = Objects.requireNonNull(ReactorUaaClient.super.getUsername(), "username");
        usernameBuildStage = STAGE_INITIALIZED;
      }
      return this.username;
    }

    private byte groupsBuildStage = STAGE_UNINITIALIZED;
    private Groups groups;

    Groups groups() {
      if (groupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (groupsBuildStage == STAGE_UNINITIALIZED) {
        groupsBuildStage = STAGE_INITIALIZING;
        this.groups = Objects.requireNonNull(ReactorUaaClient.super.groups(), "groups");
        groupsBuildStage = STAGE_INITIALIZED;
      }
      return this.groups;
    }

    private byte identityProvidersBuildStage = STAGE_UNINITIALIZED;
    private IdentityProviders identityProviders;

    IdentityProviders identityProviders() {
      if (identityProvidersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (identityProvidersBuildStage == STAGE_UNINITIALIZED) {
        identityProvidersBuildStage = STAGE_INITIALIZING;
        this.identityProviders = Objects.requireNonNull(ReactorUaaClient.super.identityProviders(), "identityProviders");
        identityProvidersBuildStage = STAGE_INITIALIZED;
      }
      return this.identityProviders;
    }

    private byte identityZonesBuildStage = STAGE_UNINITIALIZED;
    private IdentityZones identityZones;

    IdentityZones identityZones() {
      if (identityZonesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (identityZonesBuildStage == STAGE_UNINITIALIZED) {
        identityZonesBuildStage = STAGE_INITIALIZING;
        this.identityZones = Objects.requireNonNull(ReactorUaaClient.super.identityZones(), "identityZones");
        identityZonesBuildStage = STAGE_INITIALIZED;
      }
      return this.identityZones;
    }

    private byte serverInformationBuildStage = STAGE_UNINITIALIZED;
    private ServerInformation serverInformation;

    ServerInformation serverInformation() {
      if (serverInformationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serverInformationBuildStage == STAGE_UNINITIALIZED) {
        serverInformationBuildStage = STAGE_INITIALIZING;
        this.serverInformation = Objects.requireNonNull(ReactorUaaClient.super.serverInformation(), "serverInformation");
        serverInformationBuildStage = STAGE_INITIALIZED;
      }
      return this.serverInformation;
    }

    private byte tokensBuildStage = STAGE_UNINITIALIZED;
    private Tokens tokens;

    Tokens tokens() {
      if (tokensBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tokensBuildStage == STAGE_UNINITIALIZED) {
        tokensBuildStage = STAGE_INITIALIZING;
        this.tokens = Objects.requireNonNull(ReactorUaaClient.super.tokens(), "tokens");
        tokensBuildStage = STAGE_INITIALIZED;
      }
      return this.tokens;
    }

    private byte usersBuildStage = STAGE_UNINITIALIZED;
    private Users users;

    Users users() {
      if (usersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usersBuildStage == STAGE_UNINITIALIZED) {
        usersBuildStage = STAGE_INITIALIZING;
        this.users = Objects.requireNonNull(ReactorUaaClient.super.users(), "users");
        usersBuildStage = STAGE_INITIALIZED;
      }
      return this.users;
    }

    private byte requestTagsBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> requestTags;

    Map<String, String> getRequestTags() {
      if (requestTagsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (requestTagsBuildStage == STAGE_UNINITIALIZED) {
        requestTagsBuildStage = STAGE_INITIALIZING;
        this.requestTags = createUnmodifiableMap(true, false, ReactorUaaClient.super.getRequestTags());
        requestTagsBuildStage = STAGE_INITIALIZED;
      }
      return this.requestTags;
    }

    void requestTags(Map<String, String> requestTags) {
      this.requestTags = requestTags;
      requestTagsBuildStage = STAGE_INITIALIZED;
    }

    private byte rootBuildStage = STAGE_UNINITIALIZED;
    private Mono<String> root;

    Mono<String> getRoot() {
      if (rootBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootBuildStage == STAGE_UNINITIALIZED) {
        rootBuildStage = STAGE_INITIALIZING;
        this.root = Objects.requireNonNull(ReactorUaaClient.super.getRoot(), "root");
        rootBuildStage = STAGE_INITIALIZED;
      }
      return this.root;
    }

    void root(Mono<String> root) {
      this.root = root;
      rootBuildStage = STAGE_INITIALIZED;
    }

    private byte usernameProviderBuildStage = STAGE_UNINITIALIZED;
    private UsernameProvider usernameProvider;

    UsernameProvider getUsernameProvider() {
      if (usernameProviderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usernameProviderBuildStage == STAGE_UNINITIALIZED) {
        usernameProviderBuildStage = STAGE_INITIALIZING;
        this.usernameProvider = Objects.requireNonNull(ReactorUaaClient.super.getUsernameProvider(), "usernameProvider");
        usernameProviderBuildStage = STAGE_INITIALIZED;
      }
      return this.usernameProvider;
    }

    void usernameProvider(UsernameProvider usernameProvider) {
      this.usernameProvider = usernameProvider;
      usernameProviderBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (authorizationsBuildStage == STAGE_INITIALIZING) attributes.add("authorizations");
      if (clientsBuildStage == STAGE_INITIALIZING) attributes.add("clients");
      if (usernameBuildStage == STAGE_INITIALIZING) attributes.add("username");
      if (groupsBuildStage == STAGE_INITIALIZING) attributes.add("groups");
      if (identityProvidersBuildStage == STAGE_INITIALIZING) attributes.add("identityProviders");
      if (identityZonesBuildStage == STAGE_INITIALIZING) attributes.add("identityZones");
      if (serverInformationBuildStage == STAGE_INITIALIZING) attributes.add("serverInformation");
      if (tokensBuildStage == STAGE_INITIALIZING) attributes.add("tokens");
      if (usersBuildStage == STAGE_INITIALIZING) attributes.add("users");
      if (requestTagsBuildStage == STAGE_INITIALIZING) attributes.add("requestTags");
      if (rootBuildStage == STAGE_INITIALIZING) attributes.add("root");
      if (usernameProviderBuildStage == STAGE_INITIALIZING) attributes.add("usernameProvider");
      return "Cannot build ReactorUaaClient, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code authorizations} attribute
   */
  @Override
  public Authorizations authorizations() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.authorizations()
        : this.authorizations;
  }

  /**
   * @return The computed-at-construction value of the {@code clients} attribute
   */
  @Override
  public Clients clients() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.clients()
        : this.clients;
  }

  /**
   * @return The computed-at-construction value of the {@code username} attribute
   */
  @Override
  public Mono<String> getUsername() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsername()
        : this.username;
  }

  /**
   * @return The computed-at-construction value of the {@code groups} attribute
   */
  @Override
  public Groups groups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.groups()
        : this.groups;
  }

  /**
   * @return The computed-at-construction value of the {@code identityProviders} attribute
   */
  @Override
  public IdentityProviders identityProviders() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.identityProviders()
        : this.identityProviders;
  }

  /**
   * @return The computed-at-construction value of the {@code identityZones} attribute
   */
  @Override
  public IdentityZones identityZones() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.identityZones()
        : this.identityZones;
  }

  /**
   * @return The computed-at-construction value of the {@code serverInformation} attribute
   */
  @Override
  public ServerInformation serverInformation() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serverInformation()
        : this.serverInformation;
  }

  /**
   * @return The computed-at-construction value of the {@code tokens} attribute
   */
  @Override
  public Tokens tokens() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tokens()
        : this.tokens;
  }

  /**
   * @return The computed-at-construction value of the {@code users} attribute
   */
  @Override
  public Users users() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.users()
        : this.users;
  }

  /**
   * The connection context
   */
  @Override
  public ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * The identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * @return The value of the {@code requestTags} attribute
   */
  @Override
  public Map<String, String> getRequestTags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRequestTags()
        : this.requestTags;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Mono<String> getRoot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoot()
        : this.root;
  }

  /**
   * The token provider
   */
  @Override
  public TokenProvider getTokenProvider() {
    return tokenProvider;
  }

  /**
   * @return The value of the {@code usernameProvider} attribute
   */
  @Override
  public UsernameProvider getUsernameProvider() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsernameProvider()
        : this.usernameProvider;
  }

  /**
   * This instance is equal to all instances of {@code ReactorUaaClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReactorUaaClient
        && equalTo((ReactorUaaClient) another);
  }

  private boolean equalTo(ReactorUaaClient another) {
    return authorizations.equals(another.authorizations)
        && clients.equals(another.clients)
        && username.equals(another.username)
        && groups.equals(another.groups)
        && identityProviders.equals(another.identityProviders)
        && identityZones.equals(another.identityZones)
        && serverInformation.equals(another.serverInformation)
        && tokens.equals(another.tokens)
        && users.equals(another.users)
        && connectionContext.equals(another.connectionContext)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && requestTags.equals(another.requestTags)
        && root.equals(another.root)
        && tokenProvider.equals(another.tokenProvider)
        && usernameProvider.equals(another.usernameProvider);
  }

  /**
   * Computes a hash code from attributes: {@code authorizations}, {@code clients}, {@code username}, {@code groups}, {@code identityProviders}, {@code identityZones}, {@code serverInformation}, {@code tokens}, {@code users}, {@code connectionContext}, {@code identityZoneSubdomain}, {@code requestTags}, {@code root}, {@code tokenProvider}, {@code usernameProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + authorizations.hashCode();
    h += (h << 5) + clients.hashCode();
    h += (h << 5) + username.hashCode();
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + identityProviders.hashCode();
    h += (h << 5) + identityZones.hashCode();
    h += (h << 5) + serverInformation.hashCode();
    h += (h << 5) + tokens.hashCode();
    h += (h << 5) + users.hashCode();
    h += (h << 5) + connectionContext.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + requestTags.hashCode();
    h += (h << 5) + root.hashCode();
    h += (h << 5) + tokenProvider.hashCode();
    h += (h << 5) + usernameProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReactorUaaClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReactorUaaClient{"
        + "authorizations=" + authorizations
        + ", clients=" + clients
        + ", username=" + username
        + ", groups=" + groups
        + ", identityProviders=" + identityProviders
        + ", identityZones=" + identityZones
        + ", serverInformation=" + serverInformation
        + ", tokens=" + tokens
        + ", users=" + users
        + ", connectionContext=" + connectionContext
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", requestTags=" + requestTags
        + ", root=" + root
        + ", tokenProvider=" + tokenProvider
        + ", usernameProvider=" + usernameProvider
        + "}";
  }

  /**
   * Creates a builder for {@link ReactorUaaClient ReactorUaaClient}.
   * <pre>
   * ReactorUaaClient.builder()
   *    .connectionContext(org.cloudfoundry.reactor.ConnectionContext) // required {@link ReactorUaaClient#getConnectionContext() connectionContext}
   *    .identityZoneSubdomain(String | null) // nullable {@link ReactorUaaClient#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .requestTag|putAllRequestTags(String =&gt; String) // {@link ReactorUaaClient#getRequestTags() requestTags} mappings
   *    .root(reactor.core.publisher.Mono&amp;lt;String&amp;gt;) // optional {@link ReactorUaaClient#getRoot() root}
   *    .tokenProvider(org.cloudfoundry.reactor.TokenProvider) // required {@link ReactorUaaClient#getTokenProvider() tokenProvider}
   *    .usernameProvider(org.cloudfoundry.reactor.uaa.UsernameProvider) // optional {@link ReactorUaaClient#getUsernameProvider() usernameProvider}
   *    .build();
   * </pre>
   * @return A new ReactorUaaClient builder
   */
  public static ReactorUaaClient.Builder builder() {
    return new ReactorUaaClient.Builder();
  }

  /**
   * Builds instances of type {@link ReactorUaaClient ReactorUaaClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ReactorUaaClient", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_CONTEXT = 0x1L;
    private static final long INIT_BIT_TOKEN_PROVIDER = 0x2L;
    private static final long OPT_BIT_REQUEST_TAGS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private ConnectionContext connectionContext;
    private String identityZoneSubdomain;
    private Map<String, String> requestTags = new LinkedHashMap<String, String>();
    private Mono<String> root;
    private TokenProvider tokenProvider;
    private UsernameProvider usernameProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactorUaaClient} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactorUaaClient instance) {
      return from((_ReactorUaaClient) instance);
    }

    /**
     * Copy abstract value type {@code _ReactorUaaClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReactorUaaClient instance) {
      Objects.requireNonNull(instance, "instance");
      connectionContext(instance.getConnectionContext());
      String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
      if (identityZoneSubdomainValue != null) {
        identityZoneSubdomain(identityZoneSubdomainValue);
      }
      putAllRequestTags(instance.getRequestTags());
      root(instance.getRoot());
      tokenProvider(instance.getTokenProvider());
      usernameProvider(instance.getUsernameProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorUaaClient#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(ConnectionContext connectionContext) {
      this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
      initBits &= ~INIT_BIT_CONNECTION_CONTEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorUaaClient#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Put one entry to the {@link ReactorUaaClient#getRequestTags() requestTags} map.
     * @param key The key in the requestTags map
     * @param value The associated value in the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTag(String key, String value) {
      this.requestTags.put(
          Objects.requireNonNull(key, "requestTags key"),
          Objects.requireNonNull(value, "requestTags value"));
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Put one entry to the {@link ReactorUaaClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTag(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.requestTags.put(
          Objects.requireNonNull(k, "requestTags key"),
          Objects.requireNonNull(v, "requestTags value"));
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReactorUaaClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestTags(Map<String, ? extends String> entries) {
      this.requestTags.clear();
      optBits |= OPT_BIT_REQUEST_TAGS;
      return putAllRequestTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReactorUaaClient#getRequestTags() requestTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestTags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRequestTags(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.requestTags.put(
            Objects.requireNonNull(k, "requestTags key"),
            Objects.requireNonNull(v, "requestTags value"));
      }
      optBits |= OPT_BIT_REQUEST_TAGS;
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorUaaClient#getRoot() root} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReactorUaaClient#getRoot() root}.</em>
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Mono<String> root) {
      this.root = Objects.requireNonNull(root, "root");
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorUaaClient#getTokenProvider() tokenProvider} attribute.
     * @param tokenProvider The value for tokenProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      initBits &= ~INIT_BIT_TOKEN_PROVIDER;
      return this;
    }

    /**
     * Initializes the value for the {@link ReactorUaaClient#getUsernameProvider() usernameProvider} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReactorUaaClient#getUsernameProvider() usernameProvider}.</em>
     * @param usernameProvider The value for usernameProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder usernameProvider(UsernameProvider usernameProvider) {
      this.usernameProvider = Objects.requireNonNull(usernameProvider, "usernameProvider");
      return this;
    }

    /**
     * Builds a new {@link ReactorUaaClient ReactorUaaClient}.
     * @return An immutable instance of ReactorUaaClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReactorUaaClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReactorUaaClient(this);
    }

    private boolean requestTagsIsSet() {
      return (optBits & OPT_BIT_REQUEST_TAGS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_CONTEXT) != 0) attributes.add("connectionContext");
      if ((initBits & INIT_BIT_TOKEN_PROVIDER) != 0) attributes.add("tokenProvider");
      return "Cannot build ReactorUaaClient, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
