/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor._RootPayloadRootProvider;
import org.immutables.value.Generated;

@Generated(from="_RootPayloadRootProvider", generator="Immutables")
public final class RootPayloadRootProvider
extends _RootPayloadRootProvider {
    private final String apiHost;
    private final Integer port;
    private final Boolean secure;
    private final ObjectMapper objectMapper;

    private RootPayloadRootProvider(Builder builder) {
        this.apiHost = builder.apiHost;
        this.port = builder.port;
        this.secure = builder.secure;
        this.objectMapper = builder.objectMapper;
    }

    @Override
    public String getApiHost() {
        return this.apiHost;
    }

    @Override
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    public Optional<Boolean> getSecure() {
        return Optional.ofNullable(this.secure);
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RootPayloadRootProvider && this.equalTo((RootPayloadRootProvider)another);
    }

    private boolean equalTo(RootPayloadRootProvider another) {
        return this.apiHost.equals(another.apiHost) && Objects.equals(this.port, another.port) && Objects.equals(this.secure, another.secure) && this.objectMapper.equals(another.objectMapper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.apiHost.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.secure);
        h += (h << 5) + this.objectMapper.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RootPayloadRootProvider{");
        builder.append("apiHost=").append(this.apiHost);
        if (this.port != null) {
            builder.append(", ");
            builder.append("port=").append(this.port);
        }
        if (this.secure != null) {
            builder.append(", ");
            builder.append("secure=").append(this.secure);
        }
        builder.append(", ");
        builder.append("objectMapper=").append(this.objectMapper);
        return builder.append("}").toString();
    }

    private static RootPayloadRootProvider validate(RootPayloadRootProvider instance) {
        instance.checkForValidApiHost();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_RootPayloadRootProvider", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_API_HOST = 1L;
        private static final long INIT_BIT_OBJECT_MAPPER = 2L;
        private long initBits = 3L;
        private String apiHost;
        private Integer port;
        private Boolean secure;
        private ObjectMapper objectMapper;

        private Builder() {
        }

        public final Builder from(AbstractRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RootPayloadRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_RootPayloadRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractRootProvider instance;
            if (object instanceof AbstractRootProvider) {
                Optional<Integer> portOptional;
                instance = (AbstractRootProvider)object;
                Optional<Boolean> secureOptional = instance.getSecure();
                if (secureOptional.isPresent()) {
                    this.secure(secureOptional);
                }
                if ((portOptional = instance.getPort()).isPresent()) {
                    this.port(portOptional);
                }
                this.apiHost(instance.getApiHost());
            }
            if (object instanceof _RootPayloadRootProvider) {
                instance = (_RootPayloadRootProvider)object;
                this.objectMapper(((_RootPayloadRootProvider)instance).getObjectMapper());
            }
        }

        public final Builder apiHost(String apiHost) {
            this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        public final Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public final Builder secure(Optional<Boolean> secure) {
            this.secure = secure.orElse(null);
            return this;
        }

        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public RootPayloadRootProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return RootPayloadRootProvider.validate(new RootPayloadRootProvider(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiHost");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("objectMapper");
            }
            return "Cannot build RootPayloadRootProvider, some of required attributes are not set " + attributes;
        }
    }
}

