/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.cloudfoundry.client.v2.CloudFoundryException;
import org.springframework.web.client.HttpStatusCodeException;
import reactor.core.publisher.Mono;
import reactor.core.util.Exceptions;
import reactor.io.netty.http.HttpException;

public final class CloudFoundryExceptionBuilder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private CloudFoundryExceptionBuilder() {
    }

    public static CloudFoundryException build(HttpStatusCodeException cause) {
        try {
            Map response = (Map)OBJECT_MAPPER.readValue(cause.getResponseBodyAsString(), Map.class);
            Integer code = (Integer)response.get("code");
            String description = (String)response.get("description");
            String errorCode = (String)response.get("error_code");
            return new CloudFoundryException(code, description, errorCode, (Throwable)cause);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> Mono<T> build(HttpException cause) {
        return cause.getChannel().receive().aggregate().toInputStream().then(in -> {
            try {
                Map response = (Map)OBJECT_MAPPER.readValue(in, Map.class);
                Integer code = (Integer)response.get("code");
                String description = (String)response.get("description");
                String errorCode = (String)response.get("error_code");
                return Mono.error((Throwable)new CloudFoundryException(code, description, errorCode, (Throwable)cause));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }
}

