/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.reactor.client.MethodNameComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class QueryBuilder {
    private QueryBuilder() {
    }

    public static void augment(UriComponentsBuilder builder, Object instance) {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(instance.getClass());
        Arrays.sort(methods, MethodNameComparator.INSTANCE);
        for (Method method : methods) {
            QueryParameter queryParameter = (QueryParameter)AnnotationUtils.getAnnotation((Method)method, QueryParameter.class);
            if (queryParameter == null) continue;
            ReflectionUtils.makeAccessible((Method)method);
            Object value = ReflectionUtils.invokeMethod((Method)method, (Object)instance);
            if (value == null) continue;
            if (value instanceof Collection) {
                builder.queryParam(queryParameter.value(), new Object[]{((Collection)value).stream().map(Object::toString).collect(Collectors.joining(queryParameter.delimiter()))});
                continue;
            }
            builder.queryParam(queryParameter.value(), new Object[]{value});
        }
    }
}

