/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.cloudfoundry.reactor.client.CloudFoundryExceptionBuilder;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.client.v2.FilterBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;
import reactor.io.netty.http.HttpClientRequest;
import reactor.io.netty.http.HttpClientResponse;
import reactor.io.netty.http.HttpException;

public abstract class AbstractClientV2Operations
extends AbstractReactorOperations {
    private final ObjectMapper objectMapper;

    protected AbstractClientV2Operations(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
        this.objectMapper = objectMapper;
    }

    protected final <T> Mono<T> delete(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doDelete(request, responseType, AbstractClientV2Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> get(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(responseType, AbstractClientV2Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final Mono<HttpClientResponse> get(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.get(request, uriTransformer, (HttpClientRequest outbound) -> outbound);
    }

    protected final Mono<HttpClientResponse> get(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<HttpClientRequest, HttpClientRequest> requestTransformer) {
        return this.doGet(AbstractClientV2Operations.getUriAugmenter(request, uriTransformer), requestTransformer).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPost(request, responseType, AbstractClientV2Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<MultipartHttpClientRequest, Mono<Void>> requestTransformer) {
        return this.doPost(responseType, AbstractClientV2Operations.getUriAugmenter(request, uriTransformer), outbound -> (Mono)requestTransformer.apply(new MultipartHttpClientRequest(this.objectMapper, (HttpClientRequest)outbound))).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> put(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPut(request, responseType, AbstractClientV2Operations.getUriAugmenter(request, uriTransformer), outbound -> outbound).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    protected final <T> Mono<T> put(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<MultipartHttpClientRequest, Mono<Void>> requestTransformer) {
        return this.doPut(responseType, AbstractClientV2Operations.getUriAugmenter(request, uriTransformer), outbound -> (Mono)requestTransformer.apply(new MultipartHttpClientRequest(this.objectMapper, (HttpClientRequest)outbound))).otherwise(HttpException.class, CloudFoundryExceptionBuilder::build);
    }

    private static Function<UriComponentsBuilder, UriComponentsBuilder> getUriAugmenter(Object request, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return builder -> {
            FilterBuilder.augment(builder, request);
            QueryBuilder.augment(builder, request);
            return (UriComponentsBuilder)uriTransformer.apply((UriComponentsBuilder)builder);
        };
    }
}

