/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.cloudfoundry.client.v2.FilterParameter;
import org.cloudfoundry.reactor.client.MethodNameComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

final class FilterBuilder {
    private FilterBuilder() {
    }

    public static void augment(UriComponentsBuilder builder, Object instance) {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(instance.getClass());
        Arrays.sort(methods, MethodNameComparator.INSTANCE);
        block0: for (Method method : methods) {
            for (Annotation annotation : AnnotationUtils.getAnnotations((Method)method)) {
                if (!AnnotationUtils.isAnnotationMetaPresent(annotation.getClass(), FilterParameter.class)) continue;
                Object value = FilterBuilder.getValue(method, instance);
                if (value == null) continue block0;
                FilterParameter filterParameter = (FilterParameter)AnnotationUtils.getAnnotation((Annotation)annotation, FilterParameter.class);
                Object name = AnnotationUtils.getValue((Annotation)annotation);
                String operation = filterParameter.operator();
                builder.queryParam("q", new Object[]{String.format("%s%s%s", name, operation, value)});
                continue block0;
            }
        }
    }

    private static Object getValue(Method method, Object instance) {
        ReflectionUtils.makeAccessible((Method)method);
        Object value = ReflectionUtils.invokeMethod((Method)method, (Object)instance);
        if (!(value instanceof Collection)) {
            return value;
        }
        List collection = ((Collection)value).stream().filter(o -> !ObjectUtils.isEmpty((Object)o)).collect(Collectors.toList());
        if (collection.isEmpty()) {
            return null;
        }
        return StringUtils.collectionToCommaDelimitedString(collection);
    }
}

