/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.applications;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentRequest;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentResponse;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesRequest;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesResponse;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsRequest;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsResponse;
import org.cloudfoundry.client.v2.applications.ApplicationsV2;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteResponse;
import org.cloudfoundry.client.v2.applications.CopyApplicationRequest;
import org.cloudfoundry.client.v2.applications.CopyApplicationResponse;
import org.cloudfoundry.client.v2.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v2.applications.CreateApplicationResponse;
import org.cloudfoundry.client.v2.applications.DeleteApplicationRequest;
import org.cloudfoundry.client.v2.applications.DownloadApplicationDropletRequest;
import org.cloudfoundry.client.v2.applications.DownloadApplicationRequest;
import org.cloudfoundry.client.v2.applications.GetApplicationRequest;
import org.cloudfoundry.client.v2.applications.GetApplicationResponse;
import org.cloudfoundry.client.v2.applications.ListApplicationRoutesRequest;
import org.cloudfoundry.client.v2.applications.ListApplicationRoutesResponse;
import org.cloudfoundry.client.v2.applications.ListApplicationServiceBindingsRequest;
import org.cloudfoundry.client.v2.applications.ListApplicationServiceBindingsResponse;
import org.cloudfoundry.client.v2.applications.ListApplicationsRequest;
import org.cloudfoundry.client.v2.applications.ListApplicationsResponse;
import org.cloudfoundry.client.v2.applications.RemoveApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.RemoveApplicationServiceBindingRequest;
import org.cloudfoundry.client.v2.applications.RestageApplicationRequest;
import org.cloudfoundry.client.v2.applications.RestageApplicationResponse;
import org.cloudfoundry.client.v2.applications.SummaryApplicationRequest;
import org.cloudfoundry.client.v2.applications.SummaryApplicationResponse;
import org.cloudfoundry.client.v2.applications.TerminateApplicationInstanceRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationResponse;
import org.cloudfoundry.client.v2.applications.UploadApplicationRequest;
import org.cloudfoundry.client.v2.applications.UploadApplicationResponse;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.io.netty.common.NettyInbound;
import reactor.io.netty.http.HttpClient;
import reactor.io.netty.http.HttpClientRequest;

public final class ReactorApplicationsV2
extends AbstractClientV2Operations
implements ApplicationsV2 {
    public ReactorApplicationsV2(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<AssociateApplicationRouteResponse> associateRoute(AssociateApplicationRouteRequest request) {
        return this.put(request, AssociateApplicationRouteResponse.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "routes", request.getRouteId()}));
    }

    public Mono<CopyApplicationResponse> copy(CopyApplicationRequest request) {
        return this.post(request, CopyApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "copy_bits"}));
    }

    public Mono<CreateApplicationResponse> create(CreateApplicationRequest request) {
        return this.post(request, CreateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "apps"}));
    }

    public Mono<Void> delete(DeleteApplicationRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId()}));
    }

    public Flux<byte[]> download(DownloadApplicationRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "download"}), HttpClientRequest::followRedirect).flatMap(NettyInbound::receiveByteArray);
    }

    public Flux<byte[]> downloadDroplet(DownloadApplicationDropletRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "droplet", "download"}), HttpClientRequest::followRedirect).flatMap(NettyInbound::receiveByteArray);
    }

    public Mono<ApplicationEnvironmentResponse> environment(ApplicationEnvironmentRequest request) {
        return this.get((Object)request, ApplicationEnvironmentResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "env"}));
    }

    public Mono<GetApplicationResponse> get(GetApplicationRequest request) {
        return this.get((Object)request, GetApplicationResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId()}));
    }

    public Mono<ApplicationInstancesResponse> instances(ApplicationInstancesRequest request) {
        return this.get((Object)request, ApplicationInstancesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "instances"}));
    }

    public Mono<ListApplicationsResponse> list(ListApplicationsRequest request) {
        return this.get((Object)request, ListApplicationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps"}));
    }

    public Mono<ListApplicationRoutesResponse> listRoutes(ListApplicationRoutesRequest request) {
        return this.get((Object)request, ListApplicationRoutesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "routes"}));
    }

    public Mono<ListApplicationServiceBindingsResponse> listServiceBindings(ListApplicationServiceBindingsRequest request) {
        return this.get((Object)request, ListApplicationServiceBindingsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "service_bindings"}));
    }

    public Mono<Void> removeRoute(RemoveApplicationRouteRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "routes", request.getRouteId()}));
    }

    public Mono<Void> removeServiceBinding(RemoveApplicationServiceBindingRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "service_bindings", request.getServiceBindingId()}));
    }

    public Mono<RestageApplicationResponse> restage(RestageApplicationRequest request) {
        return this.post(request, RestageApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "restage"}));
    }

    public Mono<ApplicationStatisticsResponse> statistics(ApplicationStatisticsRequest request) {
        return this.get((Object)request, ApplicationStatisticsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "stats"}));
    }

    public Mono<SummaryApplicationResponse> summary(SummaryApplicationRequest request) {
        return this.get((Object)request, SummaryApplicationResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "summary"}));
    }

    public Mono<Void> terminateInstance(TerminateApplicationInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "instances", request.getIndex()}));
    }

    public Mono<UpdateApplicationResponse> update(UpdateApplicationRequest request) {
        return this.put(request, UpdateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId()}));
    }

    public Mono<UploadApplicationResponse> upload(UploadApplicationRequest request) {
        return this.put(request, UploadApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "apps", request.getApplicationId(), "bits"}), outbound -> outbound.addPart(part -> part.setContentDispositionFormData("resources").addHeader((CharSequence)CONTENT_TYPE, (CharSequence)APPLICATION_JSON).send(request.getResources())).addPart(part -> part.setContentDispositionFormData("application", "application.zip").addHeader((CharSequence)CONTENT_TYPE, (CharSequence)APPLICATION_ZIP).sendInputStream(request.getApplication())).done());
    }
}

