/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.buildpacks;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.buildpacks.Buildpacks;
import org.cloudfoundry.client.v2.buildpacks.CreateBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.CreateBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.DeleteBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.DeleteBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.GetBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.GetBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.ListBuildpacksRequest;
import org.cloudfoundry.client.v2.buildpacks.ListBuildpacksResponse;
import org.cloudfoundry.client.v2.buildpacks.UpdateBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.UpdateBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.UploadBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.UploadBuildpackResponse;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorBuildpacks
extends AbstractClientV2Operations
implements Buildpacks {
    public ReactorBuildpacks(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CreateBuildpackResponse> create(CreateBuildpackRequest request) {
        return this.post(request, CreateBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"v2", "buildpacks"}));
    }

    public Mono<DeleteBuildpackResponse> delete(DeleteBuildpackRequest request) {
        return this.delete(request, DeleteBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"v2", "buildpacks", request.getBuildpackId()}));
    }

    public Mono<GetBuildpackResponse> get(GetBuildpackRequest request) {
        return this.get((Object)request, GetBuildpackResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "buildpacks", request.getBuildpackId()}));
    }

    public Mono<ListBuildpacksResponse> list(ListBuildpacksRequest request) {
        return this.get((Object)request, ListBuildpacksResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "buildpacks"}));
    }

    public Mono<UpdateBuildpackResponse> update(UpdateBuildpackRequest request) {
        return this.put(request, UpdateBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"v2", "buildpacks", request.getBuildpackId()}));
    }

    public Mono<UploadBuildpackResponse> upload(UploadBuildpackRequest request) {
        return this.put(request, UploadBuildpackResponse.class, builder -> builder.pathSegment(new String[]{"v2", "buildpacks", request.getBuildpackId(), "bits"}), outbound -> outbound.addPart(part -> part.setContentDispositionFormData("buildpack", request.getFilename()).addHeader((CharSequence)CONTENT_TYPE, (CharSequence)APPLICATION_ZIP).sendInputStream(request.getBuildpack())).done());
    }
}

