/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.domains;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.domains.CreateDomainRequest;
import org.cloudfoundry.client.v2.domains.CreateDomainResponse;
import org.cloudfoundry.client.v2.domains.DeleteDomainRequest;
import org.cloudfoundry.client.v2.domains.DeleteDomainResponse;
import org.cloudfoundry.client.v2.domains.Domains;
import org.cloudfoundry.client.v2.domains.GetDomainRequest;
import org.cloudfoundry.client.v2.domains.GetDomainResponse;
import org.cloudfoundry.client.v2.domains.ListDomainSpacesRequest;
import org.cloudfoundry.client.v2.domains.ListDomainSpacesResponse;
import org.cloudfoundry.client.v2.domains.ListDomainsRequest;
import org.cloudfoundry.client.v2.domains.ListDomainsResponse;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorDomains
extends AbstractClientV2Operations
implements Domains {
    public ReactorDomains(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CreateDomainResponse> create(CreateDomainRequest request) {
        return this.post(request, CreateDomainResponse.class, builder -> builder.pathSegment(new String[]{"v2", "domains"}));
    }

    public Mono<DeleteDomainResponse> delete(DeleteDomainRequest request) {
        return this.delete(request, DeleteDomainResponse.class, builder -> builder.pathSegment(new String[]{"v2", "domains", request.getDomainId()}));
    }

    public Mono<GetDomainResponse> get(GetDomainRequest request) {
        return this.get((Object)request, GetDomainResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "domains", request.getDomainId()}));
    }

    public Mono<ListDomainsResponse> list(ListDomainsRequest request) {
        return this.get((Object)request, ListDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "domains"}));
    }

    public Mono<ListDomainSpacesResponse> listSpaces(ListDomainSpacesRequest request) {
        return this.get((Object)request, ListDomainSpacesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "domains", request.getDomainId(), "spaces"}));
    }
}

