/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.organizations;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationAuditorByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationAuditorByUsernameResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationAuditorRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationAuditorResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationBillingManagerByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationBillingManagerByUsernameResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationBillingManagerRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationBillingManagerResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationManagerByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationManagerByUsernameResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationManagerRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationManagerResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationPrivateDomainRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationPrivateDomainResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserByUsernameResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserResponse;
import org.cloudfoundry.client.v2.organizations.CreateOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.CreateOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.DeleteOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.DeleteOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.GetOrganizationInstanceUsageRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationInstanceUsageResponse;
import org.cloudfoundry.client.v2.organizations.GetOrganizationMemoryUsageRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationMemoryUsageResponse;
import org.cloudfoundry.client.v2.organizations.GetOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.GetOrganizationUserRolesRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationUserRolesResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationAuditorsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationAuditorsResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationBillingManagersRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationBillingManagersResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationDomainsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationDomainsResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationManagersRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationManagersResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationServicesRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationServicesResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpaceQuotaDefinitionsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpaceQuotaDefinitionsResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationUsersRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationUsersResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsResponse;
import org.cloudfoundry.client.v2.organizations.Organizations;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationAuditorByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationAuditorRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationBillingManagerByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationBillingManagerRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationManagerByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationManagerRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationPrivateDomainRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationUserByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationUserRequest;
import org.cloudfoundry.client.v2.organizations.SummaryOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.SummaryOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.UpdateOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.UpdateOrganizationResponse;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorOrganizations
extends AbstractClientV2Operations
implements Organizations {
    public ReactorOrganizations(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<AssociateOrganizationAuditorResponse> associateAuditor(AssociateOrganizationAuditorRequest request) {
        return this.put(request, AssociateOrganizationAuditorResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "auditors", request.getAuditorId()}));
    }

    public Mono<AssociateOrganizationAuditorByUsernameResponse> associateAuditorByUsername(AssociateOrganizationAuditorByUsernameRequest request) {
        return this.put(request, AssociateOrganizationAuditorByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "auditors"}));
    }

    public Mono<AssociateOrganizationBillingManagerResponse> associateBillingManager(AssociateOrganizationBillingManagerRequest request) {
        return this.put(request, AssociateOrganizationBillingManagerResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "billing_managers", request.getBillingManagerId()}));
    }

    public Mono<AssociateOrganizationBillingManagerByUsernameResponse> associateBillingManagerByUsername(AssociateOrganizationBillingManagerByUsernameRequest request) {
        return this.put(request, AssociateOrganizationBillingManagerByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "billing_managers"}));
    }

    public Mono<AssociateOrganizationManagerResponse> associateManager(AssociateOrganizationManagerRequest request) {
        return this.put(request, AssociateOrganizationManagerResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "managers", request.getManagerId()}));
    }

    public Mono<AssociateOrganizationManagerByUsernameResponse> associateManagerByUsername(AssociateOrganizationManagerByUsernameRequest request) {
        return this.put(request, AssociateOrganizationManagerByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "managers"}));
    }

    public Mono<AssociateOrganizationPrivateDomainResponse> associatePrivateDomain(AssociateOrganizationPrivateDomainRequest request) {
        return this.put(request, AssociateOrganizationPrivateDomainResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "private_domains", request.getPrivateDomainId()}));
    }

    public Mono<AssociateOrganizationUserResponse> associateUser(AssociateOrganizationUserRequest request) {
        return this.put(request, AssociateOrganizationUserResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "users", request.getUserId()}));
    }

    public Mono<AssociateOrganizationUserByUsernameResponse> associateUserByUsername(AssociateOrganizationUserByUsernameRequest request) {
        return this.put(request, AssociateOrganizationUserByUsernameResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "users"}));
    }

    public Mono<CreateOrganizationResponse> create(CreateOrganizationRequest request) {
        return this.post(request, CreateOrganizationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations"}));
    }

    public Mono<DeleteOrganizationResponse> delete(DeleteOrganizationRequest request) {
        return this.delete(request, DeleteOrganizationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId()}));
    }

    public Mono<GetOrganizationResponse> get(GetOrganizationRequest request) {
        return this.get((Object)request, GetOrganizationResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId()}));
    }

    public Mono<GetOrganizationInstanceUsageResponse> getInstanceUsage(GetOrganizationInstanceUsageRequest request) {
        return this.get((Object)request, GetOrganizationInstanceUsageResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "instance_usage"}));
    }

    public Mono<GetOrganizationMemoryUsageResponse> getMemoryUsage(GetOrganizationMemoryUsageRequest request) {
        return this.get((Object)request, GetOrganizationMemoryUsageResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "memory_usage"}));
    }

    public Mono<GetOrganizationUserRolesResponse> getUserRoles(GetOrganizationUserRolesRequest request) {
        return this.get((Object)request, GetOrganizationUserRolesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "user_roles"}));
    }

    public Mono<ListOrganizationsResponse> list(ListOrganizationsRequest request) {
        return this.get((Object)request, ListOrganizationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations"}));
    }

    public Mono<ListOrganizationAuditorsResponse> listAuditors(ListOrganizationAuditorsRequest request) {
        return this.get((Object)request, ListOrganizationAuditorsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "auditors"}));
    }

    public Mono<ListOrganizationBillingManagersResponse> listBillingManagers(ListOrganizationBillingManagersRequest request) {
        return this.get((Object)request, ListOrganizationBillingManagersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "billing_managers"}));
    }

    public Mono<ListOrganizationDomainsResponse> listDomains(ListOrganizationDomainsRequest request) {
        return this.get((Object)request, ListOrganizationDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "domains"}));
    }

    public Mono<ListOrganizationManagersResponse> listManagers(ListOrganizationManagersRequest request) {
        return this.get((Object)request, ListOrganizationManagersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "managers"}));
    }

    public Mono<ListOrganizationPrivateDomainsResponse> listPrivateDomains(ListOrganizationPrivateDomainsRequest request) {
        return this.get((Object)request, ListOrganizationPrivateDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "private_domains"}));
    }

    public Mono<ListOrganizationServicesResponse> listServices(ListOrganizationServicesRequest request) {
        return this.get((Object)request, ListOrganizationServicesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "services"}));
    }

    public Mono<ListOrganizationSpaceQuotaDefinitionsResponse> listSpaceQuotaDefinitions(ListOrganizationSpaceQuotaDefinitionsRequest request) {
        return this.get((Object)request, ListOrganizationSpaceQuotaDefinitionsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "space_quota_definitions"}));
    }

    public Mono<ListOrganizationSpacesResponse> listSpaces(ListOrganizationSpacesRequest request) {
        return this.get((Object)request, ListOrganizationSpacesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "spaces"}));
    }

    public Mono<ListOrganizationUsersResponse> listUsers(ListOrganizationUsersRequest request) {
        return this.get((Object)request, ListOrganizationUsersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "users"}));
    }

    public Mono<Void> removeAuditor(RemoveOrganizationAuditorRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "auditors", request.getAuditorId()}));
    }

    public Mono<Void> removeAuditorByUsername(RemoveOrganizationAuditorByUsernameRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "auditors"}));
    }

    public Mono<Void> removeBillingManager(RemoveOrganizationBillingManagerRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "billing_managers", request.getBillingManagerId()}));
    }

    public Mono<Void> removeBillingManagerByUsername(RemoveOrganizationBillingManagerByUsernameRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "billing_managers"}));
    }

    public Mono<Void> removeManager(RemoveOrganizationManagerRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "managers", request.getManagerId()}));
    }

    public Mono<Void> removeManagerByUsername(RemoveOrganizationManagerByUsernameRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "managers"}));
    }

    public Mono<Void> removePrivateDomain(RemoveOrganizationPrivateDomainRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "private_domains", request.getPrivateDomainId()}));
    }

    public Mono<Void> removeUser(RemoveOrganizationUserRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "users", request.getUserId()}));
    }

    public Mono<Void> removeUserByUsername(RemoveOrganizationUserByUsernameRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "users"}));
    }

    public Mono<SummaryOrganizationResponse> summary(SummaryOrganizationRequest request) {
        return this.get((Object)request, SummaryOrganizationResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId(), "summary"}));
    }

    public Mono<UpdateOrganizationResponse> update(UpdateOrganizationRequest request) {
        return this.put(request, UpdateOrganizationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "organizations", request.getOrganizationId()}));
    }
}

