/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.privatedomains;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.privatedomains.CreatePrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.CreatePrivateDomainResponse;
import org.cloudfoundry.client.v2.privatedomains.DeletePrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.DeletePrivateDomainResponse;
import org.cloudfoundry.client.v2.privatedomains.GetPrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.GetPrivateDomainResponse;
import org.cloudfoundry.client.v2.privatedomains.ListPrivateDomainsRequest;
import org.cloudfoundry.client.v2.privatedomains.ListPrivateDomainsResponse;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomains;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorPrivateDomains
extends AbstractClientV2Operations
implements PrivateDomains {
    public ReactorPrivateDomains(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CreatePrivateDomainResponse> create(CreatePrivateDomainRequest request) {
        return this.post(request, CreatePrivateDomainResponse.class, builder -> builder.pathSegment(new String[]{"v2", "private_domains"}));
    }

    public Mono<DeletePrivateDomainResponse> delete(DeletePrivateDomainRequest request) {
        return this.delete(request, DeletePrivateDomainResponse.class, builder -> builder.pathSegment(new String[]{"v2", "private_domains", request.getPrivateDomainId()}));
    }

    public Mono<GetPrivateDomainResponse> get(GetPrivateDomainRequest request) {
        return this.get((Object)request, GetPrivateDomainResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "private_domains", request.getPrivateDomainId()}));
    }

    public Mono<ListPrivateDomainsResponse> list(ListPrivateDomainsRequest request) {
        return this.get((Object)request, ListPrivateDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "private_domains"}));
    }
}

