/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.routes;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.routes.AssociateRouteApplicationRequest;
import org.cloudfoundry.client.v2.routes.AssociateRouteApplicationResponse;
import org.cloudfoundry.client.v2.routes.CreateRouteRequest;
import org.cloudfoundry.client.v2.routes.CreateRouteResponse;
import org.cloudfoundry.client.v2.routes.DeleteRouteRequest;
import org.cloudfoundry.client.v2.routes.DeleteRouteResponse;
import org.cloudfoundry.client.v2.routes.GetRouteRequest;
import org.cloudfoundry.client.v2.routes.GetRouteResponse;
import org.cloudfoundry.client.v2.routes.ListRouteApplicationsRequest;
import org.cloudfoundry.client.v2.routes.ListRouteApplicationsResponse;
import org.cloudfoundry.client.v2.routes.ListRoutesRequest;
import org.cloudfoundry.client.v2.routes.ListRoutesResponse;
import org.cloudfoundry.client.v2.routes.RemoveRouteApplicationRequest;
import org.cloudfoundry.client.v2.routes.RouteExistsRequest;
import org.cloudfoundry.client.v2.routes.Routes;
import org.cloudfoundry.client.v2.routes.UpdateRouteRequest;
import org.cloudfoundry.client.v2.routes.UpdateRouteResponse;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.cloudfoundry.util.ExceptionUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public final class ReactorRoutes
extends AbstractClientV2Operations
implements Routes {
    private static final int CF_NOT_FOUND = 10000;

    public ReactorRoutes(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<AssociateRouteApplicationResponse> associateApplication(AssociateRouteApplicationRequest request) {
        return this.put(request, AssociateRouteApplicationResponse.class, builder -> builder.pathSegment(new String[]{"v2", "routes", request.getRouteId(), "apps", request.getApplicationId()}));
    }

    public Mono<CreateRouteResponse> create(CreateRouteRequest request) {
        return this.post(request, CreateRouteResponse.class, builder -> builder.pathSegment(new String[]{"v2", "routes"}));
    }

    public Mono<DeleteRouteResponse> delete(DeleteRouteRequest request) {
        return this.delete(request, DeleteRouteResponse.class, builder -> builder.pathSegment(new String[]{"v2", "routes", request.getRouteId()}));
    }

    public Mono<Boolean> exists(RouteExistsRequest request) {
        return this.get((Object)request, Boolean.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "routes", "reserved", "domain", request.getDomainId(), "host", request.getHost()})).defaultIfEmpty((Object)true).otherwise(ExceptionUtils.statusCode((int)10000), t -> Mono.just((Object)false));
    }

    public Mono<GetRouteResponse> get(GetRouteRequest request) {
        return this.get((Object)request, GetRouteResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "routes", request.getRouteId()}));
    }

    public Mono<ListRoutesResponse> list(ListRoutesRequest request) {
        return this.get((Object)request, ListRoutesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "routes"}));
    }

    public Mono<ListRouteApplicationsResponse> listApplications(ListRouteApplicationsRequest request) {
        return this.get((Object)request, ListRouteApplicationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "routes", request.getRouteId(), "apps"}));
    }

    public Mono<Void> removeApplication(RemoveRouteApplicationRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "routes", request.getRouteId(), "apps", request.getApplicationId()}));
    }

    public Mono<UpdateRouteResponse> update(UpdateRouteRequest request) {
        return this.put(request, UpdateRouteResponse.class, builder -> builder.pathSegment(new String[]{"v2", "routes", request.getRouteId()}));
    }
}

