/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.securitygroups;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.client.v2.securitygroups.CreateSecurityGroupRequest;
import org.cloudfoundry.client.v2.securitygroups.CreateSecurityGroupResponse;
import org.cloudfoundry.client.v2.securitygroups.DeleteSecurityGroupRequest;
import org.cloudfoundry.client.v2.securitygroups.DeleteSecurityGroupResponse;
import org.cloudfoundry.client.v2.securitygroups.DeleteSecurityGroupRunningDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.DeleteSecurityGroupStagingDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupRunningDefaultsRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupRunningDefaultsResponse;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupStagingDefaultsRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupStagingDefaultsResponse;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupsRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupsResponse;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroups;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupRunningDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupRunningDefaultResponse;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupStagingDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupStagingDefaultResponse;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.reactor.util.AuthorizationProvider;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.io.netty.http.HttpClient;

public class ReactorSecurityGroups
extends AbstractClientV2Operations
implements SecurityGroups {
    public ReactorSecurityGroups(AuthorizationProvider authorizationProvider, HttpClient httpClient, ObjectMapper objectMapper, Mono<String> root) {
        super(authorizationProvider, httpClient, objectMapper, root);
    }

    public Mono<CreateSecurityGroupResponse> create(CreateSecurityGroupRequest request) {
        return this.post(request, CreateSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"v2", "security_groups"}));
    }

    public Mono<DeleteSecurityGroupResponse> delete(DeleteSecurityGroupRequest request) {
        return this.delete(request, DeleteSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"v2", "security_groups", request.getSecurityGroupId()}));
    }

    public Mono<Void> deleteRunningDefault(DeleteSecurityGroupRunningDefaultRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "config", "running_security_groups", request.getSecurityGroupRunningDefaultId()}));
    }

    public Mono<Void> deleteStagingDefault(DeleteSecurityGroupStagingDefaultRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"v2", "config", "staging_security_groups", request.getSecurityGroupStagingDefaultId()}));
    }

    public Mono<ListSecurityGroupsResponse> list(ListSecurityGroupsRequest request) {
        return this.get((Object)request, ListSecurityGroupsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "security_groups"}));
    }

    public Mono<ListSecurityGroupRunningDefaultsResponse> listRunningDefaults(ListSecurityGroupRunningDefaultsRequest request) {
        return this.get((Object)request, ListSecurityGroupRunningDefaultsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "config", "running_security_groups"}));
    }

    public Mono<ListSecurityGroupStagingDefaultsResponse> listStagingDefaults(ListSecurityGroupStagingDefaultsRequest request) {
        return this.get((Object)request, ListSecurityGroupStagingDefaultsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"v2", "config", "staging_security_groups"}));
    }

    public Mono<SetSecurityGroupRunningDefaultResponse> setRunningDefault(SetSecurityGroupRunningDefaultRequest request) {
        return this.put(request, SetSecurityGroupRunningDefaultResponse.class, builder -> builder.pathSegment(new String[]{"v2", "config", "running_security_groups", request.getSecurityGroupRunningDefaultId()}));
    }

    public Mono<SetSecurityGroupStagingDefaultResponse> setStagingDefault(SetSecurityGroupStagingDefaultRequest request) {
        return this.put(request, SetSecurityGroupStagingDefaultResponse.class, builder -> builder.pathSegment(new String[]{"v2", "config", "staging_security_groups", request.getSecurityGroupStagingDefaultId()}));
    }
}

